/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

@JsonData
@PublicApi
public abstract class PromptValue
implements Serializable {
    private static final long serialVersionUID = 1414213562373095L;
    public static NumberFormat NUMBERFORMAT = NumberFormat.getInstance();
    public static NumberFormat NUMBERFORMAT_ENGLISH = NumberFormat.getInstance(Locale.ENGLISH);
    public static final Format DATEFORMAT = new h(new Format[]{DateFormat.getDateInstance(3), PromptValue.fourDigitYear(DateFormat.getDateInstance(3)), DateFormat.getDateInstance(2)}, PromptValue.fourDigitYear(DateFormat.getDateInstance(3)));
    public static final Format DATETIME_FOUR_DIGIT_YEAR_WITH_SECONDS = PromptValue.fourDigitYear(DateFormat.getDateTimeInstance(3, 2));
    public static final Format DATETIME_FOUR_DIGIT_YEAR_NO_SECONDS = PromptValue.fourDigitYear(DateFormat.getDateTimeInstance(3, 3));
    public static final Format DATETIMEFORMAT = new h(new Format[]{DateFormat.getDateTimeInstance(3, 2), DATETIME_FOUR_DIGIT_YEAR_WITH_SECONDS, DateFormat.getDateTimeInstance(3, 3), DATETIME_FOUR_DIGIT_YEAR_NO_SECONDS, DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateInstance(3), PromptValue.fourDigitYear(DateFormat.getDateInstance(3)), DateFormat.getDateInstance(2)}, DATETIME_FOUR_DIGIT_YEAR_WITH_SECONDS);
    public static final Format TIMEFORMAT = new h(new Format[]{DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(3)}, DateFormat.getTimeInstance(2));
    private String description = "";
    private int type;
    private boolean onlyDescription;

    public PromptValue(int type) {
        this.type = type;
        this.initValue();
        PromptValue.initFormats();
    }

    public PromptValue(String description, int type) {
        this.description = description;
        this.type = type;
        PromptValue.initFormats();
    }

    static DateFormat fourDigitYear(DateFormat dateFormat) {
        int n2;
        Object object;
        if (dateFormat instanceof SimpleDateFormat && ((String)(object = ((SimpleDateFormat)dateFormat).toPattern())).indexOf("yyyy") == -1 && (n2 = ((String)object).indexOf("yy")) != -1) {
            object = ((String)object).substring(0, n2) + "yy" + ((String)object).substring(n2);
            ((SimpleDateFormat)dateFormat).applyPattern((String)object);
        }
        return dateFormat;
    }

    private static void initFormats() {
        NUMBERFORMAT.setMaximumFractionDigits(99);
        NUMBERFORMAT.setMaximumIntegerDigits(99);
    }

    abstract String getValueString();

    static String getValueString(PromptValue promptValue) {
        if (promptValue == null) {
            return a.getMsg("prompt.none");
        }
        return promptValue.getValueString();
    }

    public abstract String getStringRepresentation();

    public abstract Object getValue();

    abstract void initValue();

    public String toString() {
        String string = this.getValueString();
        Object object = "";
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            if (!this.isOnlyDescription()) {
                object = string + " - ";
            }
        } else {
            return string;
        }
        object = (String)object + this.getDescription();
        return object;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public boolean isOnlyDescription() {
        return this.onlyDescription;
    }

    public void setOnlyDescription(boolean onlyDescription) {
        this.onlyDescription = onlyDescription;
    }

    public abstract Object getSQLTypedValue();
}

