/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.rowsource;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.list.DatabaseFieldList;
import com.inet.report.rowsource.RowSource;
import com.inet.report.rowsource.RowSourceAccessor;
import com.inet.report.rowsource.b;
import com.inet.report.rowsource.k;
import com.inet.report.statistic.Accumulator;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

@InternalApi
public class TableRowSource
implements RowSource,
Serializable {
    private RowSourceAccessor bsr;
    private b bss;
    private boolean Jy;
    private final DatabaseFieldList adL;

    public TableRowSource(ResultSet rs, Statement statement, RowSourceAccessor report, DatabaseFieldList requiredColumns) throws SQLException, ReportException {
        this.adL = requiredColumns;
        this.bsr = report;
        this.Jy = report.getExecuteLocalFilter();
        this.bss = new b(this.a(rs, statement), report);
        BaseUtils.debugMemory("TableRowSource afterFetchingData");
    }

    @Override
    public boolean isFirst() {
        return this.bss.isFirst();
    }

    @Override
    public boolean isLast() {
        return this.bss.isLast();
    }

    @Override
    public boolean next() {
        return this.bss.next();
    }

    @Override
    public boolean previous() {
        return this.bss.previous();
    }

    @Override
    public void last() {
        this.bss.last();
    }

    @Override
    public void setRowPosition(int row) {
        this.bss.setRowPosition(row);
    }

    @Override
    public int getRowPosition() {
        return this.bss.getRowPosition();
    }

    @Override
    public int getRowLength() {
        return this.bss.getRowLength();
    }

    @Override
    public int getRowCount() {
        return this.bss.getRowCount();
    }

    @Override
    public Object getObject(int i2) {
        return this.bss.getObject(i2);
    }

    @Override
    public boolean sort() throws ReportException {
        if (this.bsr == null) {
            BaseUtils.warning("Renderer may not have been initialized");
            return false;
        }
        return this.bss.sort();
    }

    @Override
    public void removeRows(int[] removedRows) {
        this.bss.removeRows(removedRows);
    }

    private Object[][] a(ResultSet resultSet, Statement statement) throws SQLException, ReportException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 0;
        int n3 = 0;
        try {
            k k2 = new k(resultSet, this.bsr, this.adL);
            Object[][] objectArray = new Object[1][];
            int n4 = this.bsr.getRowLimit();
            int n5 = n4 = n4 <= 0 ? Integer.MAX_VALUE : n4;
            while (resultSet.next()) {
                objectArray[0] = k2.b(resultSet);
                ++n3;
                if (this.Jy) {
                    this.bss = new b(objectArray, this.bsr);
                    this.bsr.setRowSource(this.bss);
                    this.bsr.setRowPosition(1);
                    if (this.bsr.filterRecordSelection()) {
                        ++n2;
                        continue;
                    }
                }
                arrayList.add(objectArray[0]);
                if (arrayList.size() <= n4) continue;
                throw ReportExceptionFactory.createReportException(ReportErrorCode.rowLimitReached, n4);
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
            BaseUtils.info("Data fetched. Records:" + n3 + " Discarded:" + n2);
            Accumulator.countRecords(n3, n2);
            Object[][] objectArray2 = (Object[][])arrayList.toArray((T[])new Object[0][0]);
            return objectArray2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            BaseUtils.error(ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("ReadResultSetData. Fetched records: " + n3 + " discarded:" + n2, outOfMemoryError));
            throw outOfMemoryError;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
        }
    }

    @Override
    public byte getGroupChangeMarksElement(int i2) {
        return this.bss.getGroupChangeMarksElement(i2);
    }

    @Override
    public int getGroupChangeMarksLength() {
        return this.bss.getGroupChangeMarksLength();
    }

    @Override
    public void handleSortedData() throws ReportException {
        this.bss.handleSortedData();
    }

    @Override
    public DatabaseFieldList getRequiredColumns() {
        return this.adL;
    }

    @Override
    public void close() {
    }
}

