/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.api.commands;

import com.inet.annotations.InternalApi;
import com.inet.report.PropertiesChecker;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.util.SupplierWithException;
import com.inet.report.util.WebUtils;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public abstract class ExportAllCmd
implements ToClientCmd,
ToClientCmd.Extension {
    @Override
    public void handle(@Nonnull Cache cache, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull SupplierWithException<ReportCacheKey> keySupplier, @Nonnull Properties props, @Nullable String page, @Nullable PropertiesChecker checker) throws Exception {
        this.toClientExport(request, response, out, keySupplier.get(), null, props);
    }

    @Override
    @Nonnull
    public ToClientCmd getToClientCmd(@Nonnull String exportFormat) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toClientExport(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull ReportCacheKey key, String page, Properties props) throws Exception {
        Cache cache = Cache.getCache();
        try {
            cache.lock(key);
            String string = props.getProperty("content", this.getMimeType());
            if (page == null) {
                int n2 = cache.getTotalPageSizeAndWait(key, 600000);
                if (WebUtils.isEncodedError(request, response, key)) {
                    return;
                }
                int n3 = cache.getPageCountAndWait(key, 600000);
                String string2 = props.getProperty("export_fmt");
                Objects.requireNonNull(string2);
                RendererFactoryManager.getInstance().getDocumentRenderer(string2).exportPageToClient(cache, n2, n3, request, response, out, key, string, page, props);
            } else {
                int n4 = Integer.parseInt(page);
                byte[] byArray = cache.getPageAndWait(key, n4, 600000);
                if (WebUtils.isEncodedError(request, response, key)) {
                    return;
                }
                WebUtils.sendHeader(request, response, props, 200, byArray.length, string);
                out.write(byArray);
            }
        }
        finally {
            cache.unlock(key);
        }
    }
}

