/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.layout;

import com.inet.annotations.InternalApi;
import com.inet.font.layout.FontContext;
import com.inet.font.layout.FontLayout;
import com.inet.report.layout.Chunk;

@InternalApi
public class TextChunk
extends Chunk {
    private String mp;
    private FontContext bU;

    public TextChunk(String text, FontContext fontContext) {
        this.chunkType = 1;
        this.mp = text;
        this.bU = fontContext;
    }

    @Override
    public String toString() {
        return this.mp + "(" + this.getWidth() + ")";
    }

    public String getText() {
        return this.mp;
    }

    public void append(TextChunk chunk) {
        this.mp = this.mp.concat(chunk.mp);
        this.width += chunk.getWidth();
    }

    public void appendTextIgnoreFont(String textToAppend) {
        this.mp = this.mp.concat(textToAppend);
    }

    public FontLayout getFontLayout() {
        return this.bU.getFontLayout();
    }

    public int getColor() {
        return this.bU.getColor();
    }

    public void setText(String text) {
        this.mp = text;
        this.width = this.bU.getFontLayout().stringWidth(text);
    }

    public FontContext getFontContext() {
        return this.bU;
    }

    void uy() {
        if (this.mp.length() > 0 && this.mp.charAt(0) == ' ') {
            this.mp = this.mp.substring(1) + " ";
        }
    }

    public TextChunk convertToTextChunkWithHyperlinkStyle(int fontColor) {
        if (this.bU.isUnderline() && this.bU.getColor() == fontColor) {
            return this;
        }
        int n2 = this.bU.getCcStyle();
        if (!this.bU.isUnderline()) {
            n2 += 4;
        }
        FontContext fontContext = new FontContext(this.bU.getFontLayout(), fontColor, n2);
        TextChunk textChunk = new TextChunk("", fontContext);
        textChunk.setText(this.mp);
        return textChunk;
    }
}

