/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.AbstractMarker;
import com.inet.report.chart.f;
import com.inet.report.j;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class IntervalMarker
extends AbstractMarker {
    private double Xw = 0.0;
    private FormulaField Xx;
    private boolean Xy;
    private double Xz = 0.0;
    private FormulaField XA;
    private boolean XB;

    public double getFirstValue() {
        return this.Xw;
    }

    public void setFirstValue(double firstValue) {
        this.Xw = firstValue;
    }

    public double getSecondValue() {
        return this.Xz;
    }

    public void setSecondValue(double secondValue) {
        this.Xz = secondValue;
    }

    @Override
    protected StringBuilder cl(int n2) {
        StringBuilder stringBuilder = super.cl(n2);
        f.b(stringBuilder, n2, "FirstValue", String.valueOf(this.getFirstValue()));
        f.b(stringBuilder, n2, "SecondValue", String.valueOf(this.getSecondValue()));
        if (this.Xx != null) {
            j.a(stringBuilder, n2, this.Xx, this.Xy ? "markerFromDate" : "markerFrom");
        }
        if (this.XA != null) {
            j.a(stringBuilder, n2, this.XA, this.XB ? "markerToDate" : "markerTo");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        FormulaField formulaField = j.a(nodeList, chart, "markerFrom");
        if (formulaField != null) {
            this.setFirstValueFormula(formulaField, false);
            chart.updateReferences();
        } else {
            formulaField = j.a(nodeList, chart, "markerFromDate");
            if (formulaField != null) {
                this.setFirstValueFormula(formulaField, true);
                chart.updateReferences();
            }
        }
        FormulaField formulaField2 = j.a(nodeList, chart, "markerTo");
        if (formulaField2 != null) {
            this.setSecondValueFormula(formulaField2, false);
            chart.updateReferences();
        } else {
            formulaField2 = j.a(nodeList, chart, "markerToDate");
            if (formulaField2 != null) {
                this.setSecondValueFormula(formulaField2, true);
                chart.updateReferences();
            }
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            double d2;
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("FirstValue")) {
                string = element2.getAttribute("value");
                if (string.length() <= 0) continue;
                d2 = Double.parseDouble(string);
                this.setFirstValue(d2);
                continue;
            }
            if (!element2.getNodeName().equals("SecondValue") || (string = element2.getAttribute("value")).length() <= 0) continue;
            d2 = Double.parseDouble(string);
            this.setSecondValue(d2);
        }
    }

    public FormulaField getFirstValueFormula() {
        return this.Xx;
    }

    public void setFirstValueFormula(FormulaField firstValueFormula, boolean isDate) {
        if (firstValueFormula != null && firstValueFormula.getFormulaType() != 3) {
            throw new IllegalArgumentException("This formula is not from type FormulaField.FORMULA_PROPERTY");
        }
        if (this.Xx != null) {
            this.Xx.resetReferences();
        }
        this.Xx = firstValueFormula;
        this.Xy = isDate;
    }

    public FormulaField getSecondValueFormula() {
        return this.XA;
    }

    public void setSecondValueFormula(FormulaField secondValueFormula, boolean isDate) {
        if (secondValueFormula != null && secondValueFormula.getFormulaType() != 3) {
            throw new IllegalArgumentException("This formula is not from type FormulaField.FORMULA_PROPERTY");
        }
        if (this.XA != null) {
            this.XA.resetReferences();
        }
        this.XA = secondValueFormula;
        this.XB = isDate;
    }

    public boolean isFirstValueFormulaDate() {
        return this.Xy;
    }

    public boolean isSecondValueFormulaDate() {
        return this.XB;
    }
}

