/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.authentication.LoginProcessor;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.report.Field;
import com.inet.report.RendererBase;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.as;
import com.inet.report.bv;
import com.inet.report.k;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Locale;
import java.util.TimeZone;

@PublicApi
public class SpecialField
extends Field {
    public static final int PRINT_DATE = 0;
    public static final int PRINT_TIME = 1;
    public static final int MODIFICATION_DATE = 2;
    public static final int MODIFICATION_TIME = 3;
    public static final int DATA_DATE = 4;
    public static final int DATA_TIME = 5;
    public static final int RECORD_NUMBER = 6;
    public static final int PAGE_NUMBER = 7;
    public static final int GROUP_NUMBER = 8;
    public static final int TOTAL_PAGE_COUNT = 9;
    public static final int REPORT_TITLE = 10;
    public static final int REPORT_COMMENTS = 11;
    public static final int RECORD_SELECTION_FORMULA = 12;
    public static final int GROUP_SELECTION_FORMULA = 13;
    public static final int REPORT_FILE = 14;
    public static final int REPORT_AUTHOR = 15;
    public static final int CREATION_DATE = 16;
    public static final int PAGE_N_OF_M = 17;
    public static final int RECORD_COUNT = 18;
    public static final int HORIZONTAL_PAGE_NUMBER = 19;
    public static final int CURRENT_USER_NAME = 20;
    public static final int CURRENT_USER_ID = 21;
    public static final int CURRENT_USER_TIME_ZONE = 22;
    public static final int PRINT_TIME_ZONE = 23;
    public static final int DATA_TIME_ZONE = 24;
    public static final int CONTENT_LOCALE = 25;
    public static final int SELECTION_LOCALE = 26;
    int MT;

    SpecialField(RendererBase renderer) {
        this.type = 10;
        this.bB = renderer;
    }

    @Override
    public void setName(String newValue) {
        throw new IllegalStateException("A special field does not have a name.");
    }

    public String getOperationName() {
        switch (this.MT) {
            case 0: {
                return "PrintDate";
            }
            case 1: {
                return "PrintTime";
            }
            case 23: {
                return "PrintTimeZone";
            }
            case 2: {
                return "ModificationDate";
            }
            case 3: {
                return "ModificationTime";
            }
            case 4: {
                return "DataDate";
            }
            case 5: {
                return "DataTime";
            }
            case 24: {
                return "DataTimeZone";
            }
            case 6: {
                return "RecordNumber";
            }
            case 18: {
                return "RecordCount";
            }
            case 7: {
                return "PageNumber";
            }
            case 8: {
                return "GroupNumber";
            }
            case 9: {
                return "TotalPageCount";
            }
            case 10: {
                return "ReportTitle";
            }
            case 11: {
                return "ReportComments";
            }
            case 12: {
                return "RecordSelection";
            }
            case 13: {
                return "GroupSelection";
            }
            case 14: {
                return "Filename";
            }
            case 15: {
                return "FileAuthor";
            }
            case 16: {
                return "FileCreationDate";
            }
            case 17: {
                return "PageNOfM";
            }
            case 19: {
                return "HorizontalPageNumber";
            }
            case 20: {
                return "CurrentUserName";
            }
            case 22: {
                return "CurrentUserTimeZone";
            }
            case 25: {
                return "ContentLocale";
            }
            case 26: {
                return "SelectionLocale";
            }
        }
        return "";
    }

    public void setSpecialType(int type) {
        this.MT = type;
    }

    public int getSpecialType() {
        return this.MT;
    }

    @Override
    Field[] D(int n2) {
        return new SpecialField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "Operation", k.z(this.MT));
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    final void a(int n2, String string, as as2) {
        switch (n2) {
            case 176: {
                this.MT = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, as2);
            }
        }
    }

    @Override
    public String getRefName() {
        return "Specialfield:" + this.MT;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SpecialField && super.equals(obj) && this.MT == ((SpecialField)obj).MT;
    }

    @Override
    public String getName() {
        return this.getOperationName();
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.getDataProvider();
        switch (this.MT) {
            case 2: {
                return new Date(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 3: {
                return new Time(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 0: 
            case 4: {
                return new Date(this.bB.getCurrentDate().getTime());
            }
            case 1: 
            case 5: {
                return new Time(this.bB.getCurrentDate().getTime());
            }
            case 23: 
            case 24: {
                TimeZone timeZone = TimeZone.getDefault();
                boolean bl2 = timeZone.inDaylightTime(this.bB.getCurrentDate());
                StringBuilder stringBuilder = new StringBuilder(timeZone.getDisplayName(bl2, 0, this.bB.ressourceLocale));
                stringBuilder.append(", ").append(timeZone.getDisplayName(bl2, 1, this.bB.ressourceLocale));
                stringBuilder.append(", ").append(timeZone.getID());
                return stringBuilder.toString();
            }
            case 6: {
                return new Integer(reportDataHandler.getRowPosition());
            }
            case 18: {
                return new Integer(reportDataHandler.getRowCount());
            }
            case 7: {
                return new Integer(this.bB.currentPage - this.bB.pageOffset);
            }
            case 8: {
                return new Integer(reportDataHandler.getCurrentGroupNumber());
            }
            case 9: {
                if (!this.bB.gc()) {
                    throw new bv(this.bB);
                }
                return new Integer(this.bB.gd());
            }
            case 10: {
                return this.bB.getSummaryInfo().getReportTitle();
            }
            case 11: {
                return this.bB.getSummaryInfo().getComments();
            }
            case 12: {
                return this.bB.getRecordSelectionFormula() != null ? this.bB.getRecordSelectionFormula().getFormula() : null;
            }
            case 13: {
                return this.bB.getGroupSelection() != null ? this.bB.getGroupSelection().getFormula() : null;
            }
            case 14: {
                switch (this.bB.IO.getProtocol()) {
                    case "file": {
                        return IOFunctions.getFileName((URL)this.bB.IO);
                    }
                    case "repo": 
                    case "drive": 
                    case "jndi": {
                        return EncodingFunctions.decodeUrlPath((String)this.bB.IO.getPath());
                    }
                }
                return this.bB.IO.getFile();
            }
            case 15: {
                return this.bB.getSummaryInfo().getAuthor();
            }
            case 16: {
                return new Date(this.bB.getSummaryInfo().getCreated().getTime());
            }
            case 17: {
                return this.bB.getPageNofM();
            }
            case 20: {
                LoginProcessor loginProcessor = LoginProcessor.getCurrent();
                if (loginProcessor != null) {
                    return loginProcessor.getLoginID();
                }
                return "";
            }
            case 22: {
                return "";
            }
            case 19: {
                return new Integer(1);
            }
            case 25: {
                return this.bB.ressourceLocale;
            }
            case 26: {
                if (this.bB.serverLocale == null) {
                    return Locale.getDefault();
                }
                return this.bB.serverLocale;
            }
        }
        return "Unknown SpecialField: " + this.MT;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a Nd = new a(0);
        public static final /* enum */ a Ne = new a(1);
        public static final /* enum */ a Nf = new a(2);
        public static final /* enum */ a Ng = new a(3);
        public static final /* enum */ a Nh = new a(4);
        public static final /* enum */ a Ni = new a(5);
        public static final /* enum */ a Nj = new a(6);
        public static final /* enum */ a Nk = new a(7);
        public static final /* enum */ a Nl = new a(8);
        public static final /* enum */ a Nm = new a(9);
        public static final /* enum */ a Nn = new a(10);
        public static final /* enum */ a No = new a(11);
        public static final /* enum */ a Np = new a(12);
        public static final /* enum */ a Nq = new a(13);
        public static final /* enum */ a Nr = new a(14);
        public static final /* enum */ a Ns = new a(15);
        public static final /* enum */ a Nt = new a(16);
        public static final /* enum */ a Nu = new a(17);
        public static final /* enum */ a Nv = new a(17);
        public static final /* enum */ a Nw = new a(18);
        public static final /* enum */ a Nx = new a(19);
        public static final /* enum */ a Ny = new a(20);
        public static final /* enum */ a Nz = new a(22);
        public static final /* enum */ a NA = new a(23);
        public static final /* enum */ a NB = new a(24);
        public static final /* enum */ a NC = new a(25);
        public static final /* enum */ a ND = new a(26);
        private int gE;
        private static final /* synthetic */ a[] NE;

        public static a[] values() {
            return (a[])NE.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(int n3) {
            this.gE = n3;
        }

        int iY() {
            return this.gE;
        }

        private static /* synthetic */ a[] iZ() {
            return new a[]{Nd, Ne, Nf, Ng, Nh, Ni, Nj, Nk, Nl, Nm, Nn, No, Np, Nq, Nr, Ns, Nt, Nu, Nv, Nw, Nx, Ny, Nz, NA, NB, NC, ND};
        }

        static {
            NE = a.iZ();
        }
    }
}

