/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.StringIntMap;
import com.inet.lib.list.StringList;
import com.inet.report.AbstractLineElement;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.HasCascadingParent;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.RDC;
import com.inet.report.ReferenceHolder;
import com.inet.report.RendererBase;
import com.inet.report.ReportComponent;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.SpecialField;
import com.inet.report.Subreport;
import com.inet.report.SubreportLink;
import com.inet.report.SummaryField;
import com.inet.report.TableSource;
import com.inet.report.bg;
import com.inet.report.bx;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.q;
import com.inet.report.formula.userfunctions.UserFunction;
import com.inet.report.formula.userfunctions.b;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.list.DatabaseFieldList;
import com.inet.report.parser.NodeParser;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.xml.sax.Attributes;

@PublicApi
public class Fields
implements Serializable {
    private RendererBase<?> bB;
    private transient EventListenerList qZ;
    List<Element> ra;
    List<Field> rb = null;
    private boolean rc = true;

    Fields(RendererBase renderer) {
        this.bB = renderer;
    }

    static void a(StringIntMap stringIntMap) {
        stringIntMap.put("DatabaseFields", 142);
        stringIntMap.put("FormulaFields", 143);
        stringIntMap.put("SQLFields", 144);
        stringIntMap.put("PromptFields", 145);
        stringIntMap.put("GroupNameFields", 146);
        stringIntMap.put("SummaryFields", 147);
        stringIntMap.put("SortFields", 148);
    }

    public DatabaseField getDatabaseField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.getDbFields());
        return this.bB.getDbFields().elementAt(idx);
    }

    public int getDatabaseFieldsCount() {
        if (this.bB.getDbFields() != null) {
            return this.bB.getDbFields().size();
        }
        return 0;
    }

    public void removeDatabaseField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.getDbFields() == null) {
            return;
        }
        this.a(idx, this.bB.getDbFields());
        this.a(this.bB.getDbFields(), idx);
    }

    public DatabaseField getDatabaseField(String dbColName) {
        if (this.bB.getDbFields() == null) {
            return null;
        }
        return this.bB.getDbFields().get(dbColName);
    }

    public FormulaField getFormulaField(String fieldName) {
        if (this.bB.Ir == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Ir.length; ++i2) {
            FormulaField formulaField = this.bB.Ir[i2];
            if (formulaField == null) {
                return null;
            }
            if (!formulaField.name.equalsIgnoreCase(fieldName)) continue;
            return formulaField;
        }
        return null;
    }

    public SummaryField getSummaryField(String fieldName) {
        if (this.bB.Iw == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iw.length; ++i2) {
            SummaryField summaryField = this.bB.Iw[i2];
            if (summaryField == null) {
                return null;
            }
            if (!summaryField.name.equalsIgnoreCase(fieldName)) continue;
            return summaryField;
        }
        return null;
    }

    public GroupField getGroupNameField(String fieldName) {
        if (this.bB.Iv == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iv.length; ++i2) {
            GroupField groupField = this.bB.Iv[i2];
            if (groupField == null) {
                return null;
            }
            try {
                String string = groupField.getName();
                if (string == null || !string.equalsIgnoreCase(fieldName)) continue;
                return groupField;
            }
            catch (Exception exception) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("problems checking group name in Fields.getGroupNameField...");
                }
                BaseUtils.printStackTrace(exception);
            }
        }
        return null;
    }

    public PromptField getPromptField(String fieldName) {
        PromptField[] promptFieldArray = this.bB.id();
        if (promptFieldArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
            PromptField promptField = promptFieldArray[i2];
            if (promptField == null) {
                return null;
            }
            if (!promptField.name.equalsIgnoreCase(fieldName)) continue;
            return promptField;
        }
        return null;
    }

    public SQLField getSQLExpressionField(String fieldName) {
        if (this.bB.Ix == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Ix.length; ++i2) {
            SQLField sQLField = this.bB.Ix[i2];
            if (sQLField == null) {
                return null;
            }
            if (!sQLField.name.equalsIgnoreCase(fieldName)) continue;
            return sQLField;
        }
        return null;
    }

    public FormulaField getFormulaField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.Ir);
        return this.bB.Ir[idx];
    }

    public int getFormulaFieldsCount() {
        if (this.bB.Ir != null) {
            return this.bB.Ir.length;
        }
        return 0;
    }

    public FormulaField addFormulaField(String name, String formula, int type) {
        if (type == 0 && (name == null || name.trim().length() == 0)) {
            throw new IllegalArgumentException(Msg.getMsg(ReportErrorCode.EmptyFieldNameForbidden.name(), new Object[0]));
        }
        if (type != 0 && type != 3) {
            throw new IllegalArgumentException("Illegal type of formula: " + type);
        }
        FormulaField formulaField = new FormulaField(this.bB);
        formulaField.setFormulaType(type);
        if (name != null) {
            formulaField.setName(name.trim());
        }
        formulaField.setFormula(formula);
        formulaField.valueType = -1;
        if (type != 3) {
            this.bB.Ir = (FormulaField[])Fields.a((Field[])this.bB.Ir, formulaField);
        }
        this.a(formulaField, 0);
        this.b(formulaField);
        return formulaField;
    }

    private void b(FormulaField formulaField) {
        Object object;
        if (!this.rc) {
            return;
        }
        if (this.bB.Ir != null) {
            object = this.bB.Ir;
            int n2 = ((FormulaField[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                if (object2 == null || object2 == formulaField || ((FormulaField)object2).getFormulaTree() == null || ((FormulaField)object2).valueType != -1) continue;
                int n3 = ((Field)object2).getReferenceHolderCount();
                int n4 = ((FormulaField)object2).getReferencedObjectCount();
                ((FormulaField)object2).resetReferences();
                ((FormulaField)object2).setReferences();
                if (n3 == ((Field)object2).getReferenceHolderCount() && n4 == ((FormulaField)object2).getReferencedObjectCount()) continue;
                this.a((Field)object2, 2);
            }
        }
        if ((object = this.bB.getRecordSelectionFormula()) != null) {
            ((FormulaField)object).resetReferences();
            ((FormulaField)object).setReferences();
        }
    }

    public void removeFormulaField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.Ir == null) {
            return;
        }
        this.a(idx, this.bB.Ir);
        FormulaField formulaField = this.bB.Ir[idx];
        this.bB.Ir = (FormulaField[])this.a(this.bB.Ir, idx);
        this.a(formulaField, 1);
        if (this.bB.oE != null) {
            this.a(this.bB.oE.qa(), formulaField);
            this.a(this.bB.oE.qb(), formulaField);
            this.a(this.bB.oE.qc(), formulaField);
        }
    }

    private void a(q q2, FormulaField formulaField) {
        Collection collection = q2.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            y y2 = (y)iterator.next();
            ArrayList<FormulaField> arrayList = y2.rA();
            arrayList.remove(formulaField);
            if (arrayList.size() != 0) continue;
            iterator.remove();
        }
    }

    public PromptField getPromptField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.id());
        return this.bB.id()[idx];
    }

    public int getPromptFieldsCount() {
        if (this.bB.id() != null) {
            return this.bB.id().length;
        }
        return 0;
    }

    public void movePromptField(int from, int to) throws ReportException {
        this.a(from, to, this.bB.id());
    }

    private void a(int n2, int n3, Field[] fieldArray) throws ReportException {
        if (n2 == n3) {
            return;
        }
        this.bB.getEngine().cl();
        this.a(n2, fieldArray);
        this.a(n3, fieldArray);
        Field field = fieldArray[n2];
        int n4 = Math.min(n2 + 1, n3);
        int n5 = Math.min(n2, n3 + 1);
        int n6 = Math.abs(n2 - n3);
        System.arraycopy(fieldArray, n4, fieldArray, n5, n6);
        fieldArray[n3] = field;
        this.a(field, 3);
    }

    public PromptField addPromptField(String name, String text, int type) throws ReportException {
        PromptField promptField = new PromptField(this.bB);
        promptField.setName(name.trim());
        promptField.promptText = text;
        promptField.setValueType(type);
        this.bB.a((PromptField[])Fields.a((Field[])this.bB.id(), promptField));
        this.b(null);
        this.a(promptField, 0);
        return promptField;
    }

    public void removePromptField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.id() == null) {
            return;
        }
        this.a(idx, this.bB.id());
        PromptField promptField = this.bB.id()[idx];
        if (promptField.isParameterOfStoredProcedure()) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDeletePromptField, objectArray);
        }
        ReferenceHolder[] referenceHolderArray = promptField.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            CascadingValueProvider cascadingValueProvider;
            PromptField promptField2;
            DynamicValueProvider dynamicValueProvider;
            ReferenceHolder referenceHolder = referenceHolderArray[i2];
            if (!(referenceHolder instanceof PromptField) || !((dynamicValueProvider = (promptField2 = (PromptField)referenceHolder).getDefaultValueProvider()) instanceof CascadingValueProvider) || !(cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider).getParent().equals(promptField)) continue;
            promptField2.setDefaultValueProvider(new FieldValueProvider(cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
        }
        this.bB.a((PromptField[])this.a(this.bB.id(), idx));
        this.a(promptField, 1);
    }

    public GroupField getGroupNameField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.Iv);
        return this.bB.Iv[idx];
    }

    public int getGroupNameFieldsCount() {
        if (this.bB.Iv != null) {
            return this.bB.Iv.length;
        }
        return 0;
    }

    public SummaryField getSummaryField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.Iw);
        return this.bB.Iw[idx];
    }

    public int getSummaryFieldsCount() {
        if (this.bB.Iw != null) {
            return this.bB.Iw.length;
        }
        return 0;
    }

    public SummaryField addSummaryField(Field field, int operation, String name) throws ReportException {
        SummaryField summaryField = new SummaryField(this.bB);
        summaryField.setName(name.trim());
        summaryField.setField(field);
        summaryField.setSummaryFieldType(0);
        summaryField.ib = 1;
        if (operation < 0 || operation > 20) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongSummaryType, objectArray);
        }
        summaryField.MT = operation;
        this.bB.Iw = (SummaryField[])Fields.a((Field[])this.bB.Iw, summaryField);
        this.a(summaryField, 0);
        this.b(null);
        return summaryField;
    }

    public SummaryField addSummaryField(Field field, Field field2nd, int operation, String name) throws ReportException {
        SummaryField summaryField = this.addSummaryField(field, operation, name);
        summaryField.setField2nd(field2nd);
        return summaryField;
    }

    public void removeSummaryField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.Iw == null) {
            return;
        }
        this.a(idx, this.bB.Iw);
        SummaryField summaryField = this.bB.Iw[idx];
        this.bB.Iw = (SummaryField[])this.a(this.bB.Iw, idx);
        this.a(summaryField, 1);
    }

    public SpecialField getSpecialField(int type) {
        if (type >= RDC.Ae.length) {
            if (type >= this.bB.Is.length) {
                throw new IndexOutOfBoundsException("Arrayindex out of Bounds:" + type);
            }
            return this.bB.Is[type];
        }
        return this.bB.Is[RDC.Ae[type]];
    }

    public int getSpecialFieldsCount() {
        if (this.bB.Is == null) {
            return 0;
        }
        return this.bB.Is.length;
    }

    public SQLField getSQLExpressionField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        this.a(idx, this.bB.Ix);
        return this.bB.Ix[idx];
    }

    public int getSQLExpressionFieldsCount() {
        if (this.bB.Ix == null) {
            return 0;
        }
        return this.bB.Ix.length;
    }

    public SQLField addSQLField(String name, String sqlExpression) throws ReportException {
        if (!this.onlyTablesAndOneConnection()) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noNewSQLs, objectArray);
        }
        return this.addSQLField(name, -1, sqlExpression, this.bB.getDbTables().getDatasource(0));
    }

    public SQLField addSQLField(String name, int valueType, String sqlExpression, Datasource datasource) throws ReportException {
        if (!this.e(datasource)) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noNewSQLs2, objectArray);
        }
        SQLField sQLField = new SQLField(this.bB, datasource);
        sQLField.setValueType(valueType);
        sQLField.LE = sqlExpression;
        sQLField.setName(name.trim());
        this.bB.Ix = (SQLField[])Fields.a((Field[])this.bB.Ix, sQLField);
        if (sqlExpression != null) {
            if (valueType == -1) {
                sQLField.setSQLExpression(sqlExpression);
            } else {
                sQLField.ak(sqlExpression);
            }
        }
        this.a(sQLField, 0);
        this.b(null);
        return sQLField;
    }

    public void removeSQLField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.Ix == null) {
            return;
        }
        this.a(idx, this.bB.Ix);
        SQLField sQLField = this.bB.Ix[idx];
        this.bB.Ix = (SQLField[])this.a(this.bB.Ix, idx);
        this.a(sQLField, 1);
    }

    public SortField getSortField(String fieldName) {
        if (this.bB.Iy == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iy.length; ++i2) {
            SortField sortField = this.bB.Iy[i2];
            if (sortField == null) {
                return null;
            }
            if (!sortField.name.equalsIgnoreCase(fieldName)) continue;
            return sortField;
        }
        return null;
    }

    public SortField getSortField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.Iy != null && this.a(idx, this.bB.Iy)) {
            return this.bB.Iy[idx];
        }
        return null;
    }

    public int getSortFieldsCount() {
        int n2 = 0;
        if (this.bB.Iy != null) {
            n2 = this.bB.Iy.length;
        }
        return n2;
    }

    public SortField addSortField(String name, int type) throws ReportException {
        Field field = this.bB.getFieldByRefName(true, name);
        return this.addSortField(field, type);
    }

    public SortField addSortField(Field field, int type) throws ReportException {
        if (field == null) {
            throw new IllegalArgumentException("Fields.addSortField null is not a valid field");
        }
        Group group = field.getGroup();
        if (group == null) {
            for (int i2 = 0; i2 < this.bB.getAreaPairs().length; ++i2) {
                if (this.bB.getAreaPairs()[i2].getField() == null || this.bB.getAreaPairs()[i2].getField() != field) continue;
                group = this.bB.getAreaPairs()[i2];
                break;
            }
        }
        if (group != null && group.getGroupType() == 0) {
            Object[] objectArray = new Object[]{field.getName(), field.getTypeAsString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.groupAlreadyExists, objectArray);
        }
        if (field instanceof ReferenceHolder && bx.a((ReferenceHolder)((Object)field), SummaryField.class, false)) {
            Object[] objectArray = new Object[]{field.getName()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.summaryInSortField, objectArray);
        }
        SortField sortField = new SortField(this.bB);
        sortField.setName(field.getRefName());
        sortField.setSort(type);
        this.bB.Iy = (SortField[])Fields.a((Field[])this.bB.Iy, sortField);
        this.a(sortField, 0);
        return sortField;
    }

    public SortField addSortField(Field field, FormulaField formula) throws ReportException {
        SortField sortField = this.addSortField(field, 0);
        sortField.setSortDirectionFormula(formula);
        return sortField;
    }

    public void removeSortField(int idx) throws ReportException {
        this.bB.getEngine().cl();
        if (this.bB.Iy == null) {
            return;
        }
        this.a(idx, this.bB.Iy);
        SortField sortField = this.bB.Iy[idx];
        this.bB.Iy = (SortField[])this.a(this.bB.Iy, idx);
        this.a(sortField, 1);
    }

    public void moveSortField(int from, int to) throws IndexOutOfBoundsException, ReportException {
        this.a(from, to, this.bB.Iy);
    }

    static final Field[] a(Field[] fieldArray, Field field) {
        Field[] fieldArray2;
        int n2 = 0;
        if (fieldArray != null) {
            n2 = fieldArray.length;
        }
        if ((fieldArray2 = field.D(n2 + 1)).length == 1) {
            fieldArray2[0] = field;
        } else {
            System.arraycopy(fieldArray, 0, fieldArray2, 0, n2);
            fieldArray2[fieldArray2.length - 1] = field;
        }
        return fieldArray2;
    }

    private static boolean d(Field field) {
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] instanceof Element || referenceHolderArray[i2] instanceof Join) continue;
            return false;
        }
        return true;
    }

    private static void e(Field field) {
        if (field instanceof ReferenceHolder) {
            ((ReferenceHolder)((Object)field)).resetReferences();
        }
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            Element element;
            Section section;
            referenceHolderArray[i2].resetReferences();
            if (!(referenceHolderArray[i2] instanceof Element) || !(section = (Section)(element = (Element)referenceHolderArray[i2]).getParent()).contains(element)) continue;
            section.remove(element);
        }
    }

    private final Field[] a(Field[] fieldArray, int n2) throws ReportException {
        if (fieldArray == null) {
            return null;
        }
        this.a(n2, fieldArray);
        Field field = fieldArray[n2];
        BaseUtils.info(Msg.getMsg("removing", fieldArray[n2].paramString()));
        if (!Fields.d(fieldArray[n2])) {
            StringBuilder stringBuilder = new StringBuilder();
            ReferenceHolder referenceHolder = field.getReferenceHolders()[0];
            if (referenceHolder instanceof Field) {
                stringBuilder.append(((Field)((Object)referenceHolder)).getName());
            } else if (referenceHolder instanceof ReportComponent) {
                stringBuilder.append(((ReportComponent)referenceHolder).paramString());
            } else {
                stringBuilder.append(referenceHolder);
            }
            throw ReportExceptionFactory.createReportException(ReportErrorCode.cantRemove, field.getName(), stringBuilder);
        }
        Fields.e(fieldArray[n2]);
        Field[] fieldArray2 = fieldArray[n2].D(fieldArray.length - 1);
        System.arraycopy(fieldArray, 0, fieldArray2, 0, n2);
        System.arraycopy(fieldArray, n2 + 1, fieldArray2, n2, fieldArray2.length - n2);
        return fieldArray2;
    }

    private final void a(DatabaseFieldList databaseFieldList, int n2) throws ReportException {
        if (databaseFieldList == null) {
            return;
        }
        this.a(n2, databaseFieldList);
        DatabaseField databaseField = databaseFieldList.elementAt(n2);
        databaseField.kV.removeColumn(databaseField.getShortName());
    }

    public SummaryField sumFieldExists(int sumTyp, String field, String field2, String group, int nth, int condition) {
        if (this.bB.Iw == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iw.length; ++i2) {
            SummaryField summaryField = this.bB.Iw[i2];
            if (summaryField == null || summaryField.getField() == null || summaryField.MT != sumTyp || summaryField.Ov != nth || !summaryField.getField().name.equalsIgnoreCase(field) || (summaryField.Ox == null || field2 == null ? summaryField.Ox != null || field2 != null : !summaryField.Ox.name.equalsIgnoreCase(field2))) continue;
            if (group == null && summaryField.getGroup() == null) {
                return summaryField;
            }
            if (group == null || this.bB.Iw[i2].getGroup() == null || summaryField.getGroup().getField() == null || !summaryField.getGroup().getField().name.equalsIgnoreCase(group) || summaryField.getGroup().getSectionWillBePrinted() != condition) continue;
            return summaryField;
        }
        return null;
    }

    void cZ() {
        int n2;
        int n3;
        NodeParser nodeParser;
        int n4;
        if (this.bB.Ir == null) {
            this.bB.Ir = new FormulaField[0];
        }
        if (this.bB.Iw == null) {
            this.bB.Iw = new SummaryField[0];
        }
        if (this.bB.Iv == null) {
            this.bB.Iv = new GroupField[0];
        }
        if (this.bB.id() == null) {
            this.bB.a(new PromptField[0]);
        }
        if (this.bB.Ix == null) {
            this.bB.Ix = new SQLField[0];
        }
        block0: for (n4 = 0; n4 < this.rb.size(); ++n4) {
            nodeParser = (GroupField)this.rb.get(n4);
            if (((GroupField)nodeParser).getGroupNumber() < 0) continue;
            if (((GroupField)nodeParser).getGroup() == null) {
                for (n3 = 0; n3 < this.bB.getAreaPairs().length; ++n3) {
                    Group group = this.bB.getAreaPairs()[n3];
                    if (group.getField() == null) continue;
                    n2 = ((GroupField)nodeParser).getGroupNumber();
                    ((GroupField)nodeParser).ae(n2 - 1);
                    if (n2 != 0) continue;
                    ((Field)nodeParser).setGroup(group);
                    if (((GroupField)nodeParser).type != 12) continue block0;
                    group.sB = nodeParser;
                    continue block0;
                }
                continue;
            }
            Group group = ((GroupField)nodeParser).getGroup();
            if (group.getGroupType() != 2) continue;
            group.sB = nodeParser;
        }
        bx.Q(this.bB);
        for (n4 = 0; n4 < this.ra.size(); ++n4) {
            nodeParser = (AbstractLineElement)this.ra.get(n4);
            n3 = ((AbstractLineElement)nodeParser).mr;
            if (n3 == -1) continue;
            for (int i2 = 0; i2 < this.bB.getAreaPairs().length; ++i2) {
                if (this.bB.getAreaPairs()[i2].sn.gh != null) {
                    for (n2 = 0; n2 < this.bB.getAreaPairs()[i2].sn.gh.length; ++n2) {
                        if (this.bB.getAreaPairs()[i2].sn.gh[n2].iH() != n3) continue;
                        ((AbstractLineElement)nodeParser).setEndSection(this.bB.getAreaPairs()[i2].sn.gh[n2]);
                    }
                }
                if (this.bB.getAreaPairs()[i2].so == null) continue;
                for (n2 = 0; n2 < this.bB.getAreaPairs()[i2].so.gh.length; ++n2) {
                    if (this.bB.getAreaPairs()[i2].so.gh[n2].iH() != n3) continue;
                    ((AbstractLineElement)nodeParser).setEndSection(this.bB.getAreaPairs()[i2].so.gh[n2]);
                }
            }
        }
    }

    static void a(PrintWriter printWriter, Engine engine, int n2, Field[] fieldArray, String string) throws ReportException {
        String string2 = BaseUtils.getIndent(n2);
        if (fieldArray != null) {
            printWriter.print(string2 + "<" + string + ">\n");
            ArrayList<SummaryField> arrayList = engine.bB.getFormula().pM();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (arrayList.contains(fieldArray[i2])) continue;
                fieldArray[i2].k(printWriter, n2 + 1);
            }
            printWriter.print(string2 + "</" + string + ">\n");
        }
    }

    static final void b(PrintWriter printWriter, Engine engine, int n2) throws ReportException {
        int n3;
        String string = BaseUtils.getIndent(n2);
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        if (engine.bB.Ir != null) {
            FormulaField[] formulaFieldArray = engine.bB.Ir;
            block8: for (n3 = 0; n3 < formulaFieldArray.length; ++n3) {
                FormulaField formulaField = formulaFieldArray[n3];
                switch (formulaField.getFormulaType()) {
                    case 0: {
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 1: {
                        if (formulaField == engine.bB.getRecordSelectionFormula()) continue block8;
                        formulaField.setFormulaType(0);
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 2: {
                        if (formulaField == engine.bB.getGroupSelection()) continue block8;
                        formulaField.setFormulaType(0);
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 3: {
                        continue block8;
                    }
                    default: {
                        formulaField.setFormulaType(0);
                        arrayList.add(formulaField);
                    }
                }
            }
        }
        engine.bB.Ir = new FormulaField[arrayList.size()];
        arrayList.toArray(engine.bB.Ir);
        Fields.a(printWriter, engine, n2, engine.bB.Ir, "FormulaFields");
        Fields.x(engine.bB);
        Fields.a(printWriter, engine, n2, engine.bB.id(), "PromptFields");
        Fields.a(printWriter, engine, n2, engine.bB.Ix, "SQLFields");
        if (engine.bB.Ix == null) {
            printWriter.print(string + "<SQLFields>");
            printWriter.print(string + "</SQLFields>");
        }
        Fields.a(printWriter, engine, n2, engine.bB.Iw, "SummaryFields");
        Fields.a(printWriter, engine, n2, engine.bB.Iy, "SortFields");
        Fields.a(printWriter, engine.bB.getFields(), n2);
        if (engine.bB.Iv != null) {
            int n4 = engine.bB.Iv.length;
            for (n3 = 0; n3 < engine.bB.Iv.length; ++n3) {
                if (engine.bB.Iv[n3].qo <= 0) continue;
                --n4;
            }
            printWriter.print(string + "<GroupNameFields>\n");
            for (n3 = 0; n3 < engine.bB.Iv.length; ++n3) {
                if (engine.bB.Iv[n3].qo > 0) continue;
                try {
                    engine.bB.Iv[n3].k(printWriter, n2 + 1);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    BaseUtils.warning("issues saving group field " + engine.bB.Iv[n3].name + "...");
                    BaseUtils.printStackTrace(illegalArgumentException);
                }
            }
            printWriter.print(string + "</GroupNameFields>\n");
        }
    }

    private static void a(PrintWriter printWriter, Fields fields, int n2) {
        String string = BaseUtils.getIndent(n2);
        if (fields != null) {
            printWriter.print(string + "<UserFunctions>\n");
            for (int i2 = 0; i2 < fields.getFunctionsCount(); ++i2) {
                Fields.a(fields.getFunction(i2), n2 + 1, printWriter);
            }
            printWriter.print(string + "</UserFunctions>\n");
        }
    }

    private static void a(UserFunction userFunction, int n2, PrintWriter printWriter) {
        String string = BaseUtils.getIndent(n2);
        ++n2;
        StringBuilder stringBuilder = new StringBuilder();
        printWriter.print(string + "<Field" + k.l("type", "UserFunction") + k.l("valueType", k.z(userFunction.getValueType())) + ">\n");
        if (userFunction.getName() != null) {
            k.a(stringBuilder, n2, b.a.aqD.name(), userFunction.getName());
        }
        if (userFunction.getDescription() != null) {
            k.a(stringBuilder, n2, b.a.aqC.name(), userFunction.getDescription());
        }
        k.a(stringBuilder, n2, b.a.aqE.name(), k.z(userFunction.getSyntax()));
        stringBuilder.append(BaseUtils.getIndent(n2));
        stringBuilder.append(k.h(userFunction.getFormula()));
        stringBuilder.append('\n');
        printWriter.write(stringBuilder.toString());
        printWriter.print(string + "</Field>\n");
    }

    private static void x(RendererBase rendererBase) {
        boolean bl2;
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        PromptField[] promptFieldArray = rendererBase.id();
        Collections.addAll(arrayList, promptFieldArray);
        block0: do {
            bl2 = false;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n2;
                PromptField promptField = (PromptField)arrayList.get(i2);
                DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
                if (!(dynamicValueProvider instanceof HasCascadingParent)) continue;
                PromptField promptField2 = ((HasCascadingParent)((Object)dynamicValueProvider)).getParent();
                int n3 = n2 = promptField2 == null ? -1 : arrayList.indexOf(promptField2);
                if (n2 <= i2) continue;
                arrayList.remove(i2);
                arrayList.add(n2, promptField);
                bl2 = true;
                continue block0;
            }
        } while (bl2);
        rendererBase.a(arrayList.toArray(rendererBase.id()));
    }

    public boolean checkIfNameExists(int type, String name) {
        Field[] fieldArray = null;
        switch (type) {
            case 14: {
                return this.bB.getDbFields().contains(name);
            }
            case 13: {
                fieldArray = this.bB.Ir;
                break;
            }
            case 16: {
                fieldArray = this.bB.id();
                break;
            }
            case 11: {
                fieldArray = this.bB.Iw;
                break;
            }
            case 12: {
                fieldArray = this.bB.Iv;
                break;
            }
            case 17: {
                fieldArray = this.bB.Ix;
                break;
            }
            case 10: {
                fieldArray = this.bB.Is;
                break;
            }
            case 15: {
                fieldArray = this.bB.Iy;
                break;
            }
            default: {
                throw com.inet.report.y.a(type, "type", null);
            }
        }
        return Fields.a(fieldArray, name);
    }

    static boolean a(Field[] fieldArray, String string) {
        if (fieldArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            if (!fieldArray[i2].checkNameExists(string)) continue;
            return true;
        }
        return false;
    }

    public void addListener(RDC.FieldsRefreshListener frl) {
        if (this.qZ == null) {
            this.qZ = new EventListenerList();
        }
        this.qZ.add(RDC.FieldsRefreshListener.class, frl);
    }

    public void removeListener(RDC.FieldsRefreshListener frl) {
        if (this.qZ == null) {
            return;
        }
        this.qZ.remove(RDC.FieldsRefreshListener.class, frl);
    }

    void a(Field field, int n2) {
        if (field == null && n2 != 3) {
            throw new RuntimeException("Field is null");
        }
        if (this.qZ == null) {
            return;
        }
        Object[] objectArray = this.qZ.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != RDC.FieldsRefreshListener.class) continue;
            ((RDC.FieldsRefreshListener)objectArray[i2 + 1]).refresh(new RDC.FieldsRefreshEvent(this.bB.getEngine(), field, n2));
        }
    }

    static void a(bg bg2, Field field, int n2) {
        try {
            bg2.getFields().a(field, n2);
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            BaseUtils.info("Problems occurred while submit refresh event.");
        }
    }

    private boolean a(int n2, Field[] fieldArray) {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index less than zero (" + n2 + ") is impossible.");
        }
        int n4 = n3 = fieldArray == null ? 0 : fieldArray.length;
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index " + n2 + " of " + n3 + " field(s) is impossible.");
        }
        return true;
    }

    private boolean a(int n2, DatabaseFieldList databaseFieldList) {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index less than zero (" + n2 + ") is impossible.");
        }
        int n4 = n3 = databaseFieldList == null ? 0 : databaseFieldList.size();
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index " + n2 + " of " + n3 + " field(s) is impossible.");
        }
        return true;
    }

    GroupField a(Group group) {
        GroupField groupField = new GroupField(this.bB, group);
        this.bB.Iv = (GroupField[])Fields.a((Field[])this.bB.Iv, groupField);
        this.a(groupField, 0);
        return groupField;
    }

    void W(int n2) throws ReportException {
        GroupField groupField = this.bB.Iv[n2];
        this.bB.Iv = (GroupField[])this.a(this.bB.Iv, n2);
        this.a(groupField, 1);
    }

    public void changeAllAliases(String newAlias, Datasource dc) throws ReportException {
        this.b("", newAlias, dc, true);
    }

    public void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        this.b(oldAlias, newAlias, dc, false);
    }

    /*
     * WARNING - void declaration
     */
    private void b(String string, String string2, Datasource datasource, boolean bl2) throws ReportException {
        if (this.bB == null) {
            return;
        }
        if (this.bB.getAreaPairs() == null) {
            return;
        }
        RendererBase<?> rendererBase = this.bB;
        int n2 = this.getDatabaseFieldsCount();
        StringList stringList = new StringList(datasource.getAliasList());
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getDatabaseField(i2).getName();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            TableSource tableSource = datasource.getTableSource(string2);
            String object = tableSource.getSql();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3;
                Object object2;
                Object object3;
                int n3;
                Object object4;
                DatabaseField databaseField = this.getDatabaseField(i2);
                if (bl2 && databaseField.getReferenceHolderCount() <= 0) continue;
                if (bl2) {
                    ReportProperties reportProperties;
                    boolean bl3 = true;
                    object4 = databaseField.getReferenceHolders();
                    for (int i3 = 0; i3 < ((ReferenceHolder[])object4).length; ++i3) {
                        if (object4[i3] instanceof Join) continue;
                        bl3 = false;
                        break;
                    }
                    if (bl3 || (reportProperties = rendererBase.getReportProperties()).isIgnoreFiltering() && Database.a((Field)databaseField, rendererBase.getRecordSelectionFormula())) continue;
                }
                String string4 = databaseField.getName();
                object4 = new StringBuilder();
                if (object != null && object.toLowerCase().contains(string4.toLowerCase())) {
                    StringTokenizer stringTokenizer = new StringTokenizer(object, " \"'`\n\r\t,", true);
                    n3 = 0;
                    boolean bl4 = false;
                    object3 = null;
                    block24: while (stringTokenizer.hasMoreTokens()) {
                        object2 = stringTokenizer.nextToken();
                        switch (((String)object2).toLowerCase()) {
                            case " ": 
                            case "\n": 
                            case "\r": 
                            case "\t": {
                                continue block24;
                            }
                            case "\"": 
                            case "'": 
                            case "\u00b4": {
                                if (!bl4) continue block24;
                                object3 = object2;
                                break;
                            }
                            case ",": {
                                n3 = 0;
                                bl4 = false;
                                continue block24;
                            }
                            case "as": {
                                if (n3 == 0) continue block24;
                                bl4 = true;
                                n3 = 0;
                                continue block24;
                            }
                            default: {
                                if (!((String)object2).equalsIgnoreCase(string4)) break;
                                n3 = 1;
                                continue block24;
                            }
                        }
                        if (!bl4) continue;
                        ((StringBuilder)object4).setLength(0);
                        if (object3 != null) {
                            while (stringTokenizer.hasMoreTokens() && !((String)(object2 = stringTokenizer.nextToken())).equals(object3)) {
                                ((StringBuilder)object4).append((String)object2);
                            }
                            object3 = null;
                        } else {
                            ((StringBuilder)object4).append((String)object2);
                        }
                        bl4 = false;
                        break;
                    }
                }
                if ((n3 = (string3 = string4).indexOf(46)) >= 0) {
                    string3 = string3.substring(0, n3);
                }
                if ((n3 = string3.lastIndexOf(46)) >= 0) {
                    string3 = string3.substring(n3 + 1);
                }
                if ((string.length() != 0 || !stringList.contains(string3)) && !string3.equals(string)) continue;
                try {
                    if (((StringBuilder)object4).length() == 0) {
                        ((StringBuilder)object4).append(databaseField.getShortName());
                    }
                    String string5 = ((StringBuilder)object4).toString();
                    object3 = string2 + "." + string5;
                    if (this.bB.getDbFields().contains((String)object3)) {
                        object2 = this.getDatabaseField((String)object3);
                        if (!arrayList.contains(object2) && ((Field)object2).getReferenceHolderCount() == 0 && object2 != databaseField) {
                            arrayList.add(object2);
                            tableSource.a(databaseField);
                        }
                        databaseField.setColumnLabel(((DatabaseField)object2).getColumnLabel());
                    }
                    if (string.length() == 0 && !string5.equals(databaseField.getShortName())) {
                        hashMap.put(string4, object3);
                    }
                    databaseField.setName((String)object3);
                    continue;
                }
                catch (ReportException reportException) {
                    if (!databaseField.isUsed()) {
                        tableSource.addColumn(databaseField.getShortName(), databaseField.getValueType());
                        databaseField.setName(string2 + "." + databaseField.getShortName());
                        continue;
                    }
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.FieldReferenced, databaseField.getName(), string2);
                }
            }
            for (DatabaseField databaseField : arrayList) {
                tableSource.b(databaseField);
            }
        }
        catch (ReportException reportException) {
            void var12_16;
            n2 = this.getDatabaseFieldsCount();
            boolean i5 = false;
            while (var12_16 < n2) {
                this.getDatabaseField((int)var12_16).setName(stringArray[var12_16]);
                ++var12_16;
            }
            throw reportException;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.a((String)entry.getKey(), (String)entry.getValue(), datasource);
        }
        this.a(string, string2, datasource);
        this.a((Field)null, 3);
    }

    private void a(String string, String string2, Datasource datasource) throws ReportException {
        block16: {
            int n2;
            int n3;
            RendererBase<?> rendererBase = this.bB;
            for (n3 = 0; rendererBase.Iw != null && n3 < rendererBase.Iw.length; ++n3) {
                rendererBase.Iw[n3].changeAliasName(string, string2);
            }
            if (rendererBase.getRecordSelectionFormula() != null) {
                rendererBase.getRecordSelectionFormula().b(string, string2, datasource);
            }
            if (rendererBase.getGroupSelection() != null) {
                rendererBase.getGroupSelection().b(string, string2, datasource);
            }
            for (n3 = 0; n3 < rendererBase.getAreaPairs().length; ++n3) {
                if (rendererBase.getAreaPairs()[n3] == null) continue;
                rendererBase.getAreaPairs()[n3].changeAllAliases(string, string2, datasource);
            }
            if (this.bB.Ir != null) {
                n3 = this.bB.Ir.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.bB.Ir[n2].b(string, string2, datasource);
                }
            }
            if (this.bB.Ix != null) {
                if (string.length() == 0) {
                    for (n3 = this.bB.Ix.length - 1; n3 >= 0; --n3) {
                        this.removeSQLField(n3);
                    }
                } else {
                    for (n3 = this.bB.Ix.length - 1; n3 >= 0; --n3) {
                        this.bB.Ix[n3].changeAliasName(string, string2);
                    }
                }
            }
            for (n3 = 0; n3 < this.bB.Iy.length; ++n3) {
                this.bB.Iy[n3].updateName();
            }
            try {
                Subreport subreport = rendererBase.getEngine().getSubReportElement();
                if (subreport != null) {
                    for (n2 = 0; n2 < subreport.NY.length; ++n2) {
                        SubreportLink subreportLink = subreport.NY[n2];
                        subreportLink.c(string, string2, datasource);
                    }
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block16;
                BaseUtils.debug(exception);
            }
        }
    }

    public boolean onlyTablesAndOneConnection() {
        DatabaseTables databaseTables = this.bB.getDbTables();
        int n2 = databaseTables.getDatasourceCount();
        if (n2 > 1 || n2 == 0) {
            return false;
        }
        Datasource datasource = databaseTables.getDatasource(0);
        return this.e(datasource);
    }

    private boolean e(Datasource datasource) {
        int n2;
        if (datasource == null) {
            throw new IllegalArgumentException("Parameter 'datasource' is null");
        }
        for (n2 = 0; n2 < datasource.getTableSourceCount(); ++n2) {
            TableSource tableSource = datasource.getTableSource(n2);
            if (tableSource.getSql() != null) {
                return false;
            }
            if (tableSource.jw() == 3 || tableSource.jw() == 2) {
                return false;
            }
            try {
                if (tableSource.getType() == 1) continue;
                return false;
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) continue;
                BaseUtils.debug(exception);
            }
        }
        if (this.bB.id() != null) {
            for (n2 = 0; n2 < this.bB.id().length; ++n2) {
                if (this.bB.id()[n2].yW == null) continue;
                return false;
            }
        }
        return true;
    }

    void da() {
        int n2 = 0;
        if (this.bB.Ir != null) {
            for (int i2 = 0; i2 < this.bB.Ir.length; ++i2) {
                if (this.bB.Ir[i2].getFormulaType() != 0) continue;
                ++n2;
            }
            FormulaField[] formulaFieldArray = new FormulaField[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < this.bB.Ir.length; ++i3) {
                if (this.bB.Ir[i3].getFormulaType() != 0) continue;
                formulaFieldArray[n3] = this.bB.Ir[i3];
                ++n3;
            }
            this.bB.Ir = formulaFieldArray;
        }
    }

    static Field a(int n2, RendererBase rendererBase) throws ArrayIndexOutOfBoundsException {
        return rendererBase.Iv[n2 - 1];
    }

    static Field a(Attributes attributes, RendererBase rendererBase) {
        String string = attributes.getValue("refname");
        if (string == null) {
            string = attributes.getValue("value");
        }
        return Fields.a(string, Group.c(attributes), rendererBase);
    }

    static Field a(String string, RendererBase rendererBase) {
        return Fields.a(string, -1, rendererBase);
    }

    static Field a(String string, int n2, int n3, RendererBase rendererBase) {
        Field[] fieldArray;
        switch (n2) {
            case 14: {
                return rendererBase.getDbFields().get(string);
            }
            case 13: {
                fieldArray = rendererBase.Ir;
                break;
            }
            case 11: {
                fieldArray = rendererBase.Iw;
                break;
            }
            case 12: {
                return Fields.a(n3, rendererBase);
            }
            case 16: {
                fieldArray = rendererBase.id();
                break;
            }
            case 15: {
                fieldArray = rendererBase.Iy;
                break;
            }
            case 17: {
                fieldArray = rendererBase.Ix;
                break;
            }
            case 10: {
                fieldArray = rendererBase.Is;
                break;
            }
            default: {
                return null;
            }
        }
        if (fieldArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            if (!string.equalsIgnoreCase(field.name)) continue;
            return field;
        }
        return null;
    }

    static Field a(String string, int n2, RendererBase rendererBase) {
        if (rendererBase == null || string == null) {
            return null;
        }
        int n3 = RendererBase.getFieldTypeByName(string = Fields.F(string));
        String string2 = n3 == 14 ? string : string.substring(1);
        return Fields.a(string2, n3, n2, rendererBase);
    }

    static Field b(String string, RendererBase rendererBase) {
        if (string != null) {
            try {
                int n2 = SpecialField.a.valueOf(string).iY();
                Fields fields = rendererBase.getFields();
                return fields.getSpecialField(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static String F(String string) {
        if (string.charAt(0) == '{') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static Field b(Attributes attributes, RendererBase rendererBase) {
        String string = attributes.getValue("type");
        int n2 = k.symbols.get(string);
        String string2 = attributes.getValue("value");
        Field field = null;
        switch (n2) {
            case 10: {
                field = Fields.b(string2, rendererBase);
                break;
            }
            case 12: {
                String string3 = attributes.getValue("id");
                int n3 = Integer.valueOf(string3);
                field = Fields.a(n3, rendererBase);
                break;
            }
            case 11: {
                if (string2.startsWith("{#") || string2.startsWith("#")) {
                    field = Fields.a(attributes, rendererBase);
                    break;
                }
                int n4 = string2.indexOf(" ");
                String string4 = string2.substring(0, n4);
                String string5 = string2.substring(n4 + 1);
                String[] stringArray = string5.split("[(),{}]");
                field = Fields.a(rendererBase, string4, stringArray, string2);
                break;
            }
            case 15: {
                field = rendererBase.getFields().getSortField(string2);
                break;
            }
            default: {
                try {
                    field = Fields.a(attributes, rendererBase);
                    break;
                }
                catch (Exception exception) {
                    BaseUtils.error(exception);
                }
            }
        }
        if (field == null) {
            field = new a();
        }
        return field;
    }

    static Field a(RendererBase rendererBase, String string, String[] stringArray, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : stringArray) {
            if (object2.trim().length() <= 0) continue;
            arrayList.add(object2);
        }
        int n2 = SummaryField.getSummaryOperation(string);
        Field field = Fields.a((String)arrayList.get(0), rendererBase);
        if (field == null) {
            BaseUtils.error("field unknown while parsing summary field definition: " + (String)arrayList.get(0));
            return null;
        }
        Field field2 = null;
        if (arrayList.size() > 1) {
            field2 = Fields.a((String)arrayList.get(1), rendererBase);
        }
        SummaryField summaryField = new SummaryField(rendererBase);
        summaryField.setSummaryOperation(n2);
        summaryField.setField(field);
        if (field2 != null) {
            summaryField.setField2nd(field2);
        }
        try {
            Fields reportException = rendererBase.getFields();
            int n3 = reportException.getSummaryFieldsCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                SummaryField summaryField2 = reportException.getSummaryField(i2);
                if (!summaryField2.getField().equals(field) || summaryField2.getSummaryOperation() != n2) continue;
                Field field3 = summaryField2.getField2nd();
                if (!summaryField2.getName().equals(string2)) continue;
                if (field3 == null && field2 == null) {
                    return summaryField2;
                }
                if (field3 != null && field3.equals(field2)) {
                    return summaryField2;
                }
                return summaryField2;
            }
            summaryField.setName(SummaryField.generateName(field.getName(), null, n2, field2 != null ? field2.getName() : null));
            return reportException.addSummaryField(field, field2, n2, summaryField.getName());
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    void s(boolean bl2) {
        this.rc = bl2;
    }

    public int getFunctionsCount() {
        return this.bB.Iu.getFunctionsCount();
    }

    public UserFunction getFunction(int index) {
        return this.bB.Iu.getFunction(index);
    }

    public UserFunction getFunction(String name) {
        return this.bB.Iu.getFunction(name);
    }

    public UserFunction addFunction(String name, String formula, int syntax) {
        b b2 = this.bB.Iu.l(name, syntax);
        b2.setFormula(formula);
        return b2;
    }

    private int getFieldIndex(Field field) throws ReportException {
        switch (field.getType()) {
            case 13: {
                for (int i2 = 0; i2 < this.getFormulaFieldsCount(); ++i2) {
                    if (this.getFormulaField(i2) != field) continue;
                    return i2;
                }
                break;
            }
            case 14: {
                for (int i3 = 0; i3 < this.getDatabaseFieldsCount(); ++i3) {
                    if (this.getDatabaseField(i3) != field) continue;
                    return i3;
                }
                break;
            }
            case 16: {
                for (int i4 = 0; i4 < this.getPromptFieldsCount(); ++i4) {
                    if (this.getPromptField(i4) != field) continue;
                    return i4;
                }
                break;
            }
            case 15: {
                for (int i5 = 0; i5 < this.getSortFieldsCount(); ++i5) {
                    if (this.getSortField(i5) != field) continue;
                    return i5;
                }
                break;
            }
            case 17: {
                for (int i6 = 0; i6 < this.getSQLExpressionFieldsCount(); ++i6) {
                    if (this.getSQLExpressionField(i6) != field) continue;
                    return i6;
                }
                break;
            }
            case 11: {
                for (int i7 = 0; i7 < this.getSummaryFieldsCount(); ++i7) {
                    if (this.getSummaryField(i7) != field) continue;
                    return i7;
                }
                break;
            }
        }
        return -1;
    }

    public boolean removeField(Field field) throws ReportException {
        int n2 = this.getFieldIndex(field);
        if (n2 != -1) {
            switch (field.getType()) {
                case 13: {
                    this.removeFormulaField(n2);
                    break;
                }
                case 14: {
                    this.removeDatabaseField(n2);
                    break;
                }
                case 16: {
                    this.removePromptField(n2);
                    break;
                }
                case 15: {
                    this.removeSortField(n2);
                    break;
                }
                case 17: {
                    this.removeSQLField(n2);
                    break;
                }
                case 11: {
                    this.removeSummaryField(n2);
                }
            }
        }
        return n2 != -1;
    }

    protected static class a
    extends Field {
        public a() {
            this.name = "Unknown";
            this.setValueType(-1);
        }

        @Override
        Field[] D(int n2) {
            return new a[n2];
        }

        @Override
        protected void p(PrintWriter printWriter, int n2) {
        }

        @Override
        public void setName(String newValue) throws ReportException {
            this.name = newValue;
        }

        @Override
        public String getName() {
            return super.getName();
        }

        @Override
        Object getValue() throws ReportException {
            return null;
        }
    }
}

