/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer.client;

import com.inet.annotations.InternalApi;
import com.inet.viewer.ViewerUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class InetCookieHandler
extends CookieHandler {
    private static List<a> a;
    private List<a> b = new LinkedList<a>();

    public InetCookieHandler() {
        this(a);
    }

    private InetCookieHandler(@Nullable List<a> initial) {
        if (initial != null) {
            this.b.addAll(initial);
        }
    }

    @Nonnull
    public static InetCookieHandler create(@Nonnull URL url, String cookies) {
        ArrayList<a> arrayList;
        try {
            URI uRI = url.toURI();
            arrayList = InetCookieHandler.a(uRI, cookies);
        }
        catch (URISyntaxException uRISyntaxException) {
            ViewerUtils.error("Invalid url: " + url + '\n' + uRISyntaxException);
            arrayList = null;
        }
        return new InetCookieHandler(arrayList);
    }

    public static void setInitialCookie(URI uri, String cookies) {
        a = InetCookieHandler.a(uri, cookies);
    }

    @Nonnull
    private static ArrayList<a> a(URI uRI, String string) {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (string != null) {
            for (String string2 : string.split(";")) {
                string2 = string2.trim();
                try {
                    arrayList.add(new a(uRI, string2));
                }
                catch (RuntimeException runtimeException) {
                    ViewerUtils.error("Invalid cookie: " + string2 + '\n' + runtimeException);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<a> list = this.b;
        synchronized (list) {
            this.b.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<a> list;
        List list2 = null;
        if (responseHeaders != null) {
            for (Map.Entry object : responseHeaders.entrySet()) {
                if (!"Set-Cookie".equalsIgnoreCase((String)object.getKey())) continue;
                list2 = (List)object.getValue();
                break;
            }
        } else {
            list = this.b;
            synchronized (list) {
                Iterator<a> iterator = this.b.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!uri.getHost().equals(((a)object).c().getHost()) || !uri.getScheme().equals(((a)object).c().getScheme())) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        if (list2 != null) {
            list = this.b;
            synchronized (list) {
                for (Object object : list2) {
                    a a2;
                    try {
                        a2 = new a(uri, (String)object);
                    }
                    catch (RuntimeException runtimeException) {
                        ViewerUtils.error("Invalid cookie: " + (String)object + '\n' + runtimeException);
                        continue;
                    }
                    Iterator<a> iterator = this.b.iterator();
                    while (iterator.hasNext()) {
                        a a3 = iterator.next();
                        if (!a2.d().equals(a3.d()) || !a2.b().equals(a3.b()) || !a2.c().getHost().equals(a3.c().getHost()) || !a2.c().getScheme().equals(a3.c().getScheme()) || a2.c().getPort() != a3.c().getPort()) continue;
                        iterator.remove();
                        break;
                    }
                    this.b.add(a2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        Collection<Object> collection;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.b;
        synchronized (object) {
            collection = new HashSet();
            Iterator<a> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                String string;
                a a2 = iterator.next();
                if (a2 == null) continue;
                if (a2.a()) {
                    iterator.remove();
                    continue;
                }
                if (!a2.a(uri) || ((HashSet)collection).contains(string = a2.toString())) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
                ((HashSet)collection).add(string);
            }
        }
        object = new HashMap<String, List<String>>(requestHeaders);
        if (stringBuilder.length() > 0) {
            collection = Collections.singletonList(stringBuilder.toString());
            object.put("Cookie", collection);
        }
        return Collections.unmodifiableMap(object);
    }

    static {
        try {
            URI uRI = new URI("http://localhost/");
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            new a(uRI, "a=b;path=b").toString();
            InetCookieHandler inetCookieHandler = new InetCookieHandler();
            inetCookieHandler.get(uRI, hashMap);
            inetCookieHandler.put(uRI, hashMap);
        }
        catch (Exception exception) {
            ViewerUtils.printStackTrace(exception);
        }
    }

    private static class a {
        private String a;
        private String b;
        private URI c;
        private Date d;
        private String e;
        private static DateFormat f = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);
        private static DateFormat g = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);

        public a(URI uRI, String string) {
            String[] stringArray = string.split(";");
            String string2 = stringArray[0].trim();
            this.c = uRI;
            int n2 = string2.indexOf(61);
            this.a = string2.substring(0, n2);
            this.b = string2.substring(n2 + 1);
            this.e = "/";
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                string2 = stringArray[i2].trim();
                int n3 = string2.indexOf(61);
                if (n3 == -1) continue;
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                if (string3.equalsIgnoreCase("domain")) {
                    String string5 = uRI.getHost();
                    if (string5.equals(string4)) continue;
                    if (!string4.startsWith(".")) {
                        string4 = "." + string4;
                    }
                    if ((string5 = string5.substring(string5.indexOf(46))).equals(string4)) continue;
                    throw new IllegalArgumentException("Trying to set foreign cookie");
                }
                if (string3.equalsIgnoreCase("path")) {
                    this.e = string4;
                    continue;
                }
                if (!string3.equalsIgnoreCase("expires")) continue;
                try {
                    this.d = f.parse(string4);
                    continue;
                }
                catch (ParseException parseException) {
                    try {
                        this.d = g.parse(string4);
                        continue;
                    }
                    catch (ParseException parseException2) {
                        throw new IllegalArgumentException("Bad date format in header: " + string4);
                    }
                }
            }
        }

        public boolean a() {
            if (this.d == null) {
                return false;
            }
            Date date = new Date();
            return date.after(this.d);
        }

        public String b() {
            return this.a;
        }

        public URI c() {
            return this.c;
        }

        public String d() {
            return this.e;
        }

        public boolean a(URI uRI) {
            int n2;
            if (this.a()) {
                return false;
            }
            String string = uRI.getHost();
            if (string == null ? this.c.getHost() != null : !string.equals(this.c.getHost())) {
                return false;
            }
            int n3 = this.b(this.c);
            if (n3 != (n2 = this.b(uRI))) {
                return false;
            }
            String string2 = uRI.getPath();
            if (string2 == null) {
                string2 = "/";
            }
            return string2.startsWith(this.e);
        }

        private int b(URI uRI) {
            int n2 = uRI.getPort();
            if (n2 == -1) {
                if ("https".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 443;
                } else if ("http".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 80;
                }
            }
            return n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.a);
            stringBuilder.append("=");
            stringBuilder.append(this.b);
            return stringBuilder.toString();
        }
    }
}

