/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int b = -1;
    protected final PropertyChangeSupport propertySupporter = new PropertyChangeSupport(this);
    private int c;
    private int d;
    private int e;
    private boolean f = false;
    private String g;
    private ReportView h;
    private ViewerContext i;
    private Component j;
    Thread a;

    public Progress(ReportView reportView, int type) {
        this.c = type;
        this.h = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.j = reportView.getComponent();
            this.i = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.c = type;
        this.i = viewerContext;
        this.j = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.a != null && this.a.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.a = new Thread((Runnable)this, this.getName());
        this.a.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.f) {
            this.a.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.a.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.f;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl = this.f;
        this.f = indeterminate;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.b;
        this.b = status;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.b);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl = this.b == 3 || this.b == 2 || this.b == 4;
        return bl;
    }

    public boolean isCanceled() {
        return this.b == 3;
    }

    public boolean isErrored() {
        return this.b == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.d;
        this.d = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.d;
    }

    public void setProgress(int step) {
        int n2 = this.e;
        this.e = step;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_STEP, n2, this.e);
    }

    public int getProgress() {
        return this.e;
    }

    public ReportView getReportView() {
        return this.h;
    }

    public int getStatus() {
        return this.b;
    }

    public String getErrorMessage() {
        return this.g;
    }

    public void setErrorMessage(String msg) {
        this.g = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.i == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.i.showError(th, this.j);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.propertySupporter.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.propertySupporter.removePropertyChangeListener(l2);
    }

    protected void cleanUp() {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertySupporter.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.propertySupporter.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

