/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bBy;
    private int bBs;
    private boolean bBz;
    private Timer bBA;
    private Popup bBB;
    private JLabel bBC;
    private JPanel bBD;
    private boolean bBE;
    private Point bBF;
    private JComboBox bBG;
    private boolean bBH;
    private boolean bBI;
    private Class bBJ;
    private Constructor bBK;
    private Class[] bBL = new Class[]{String.class};
    private Color bBM;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bBN;

    private RealtimeValidationPopup(int promptType) {
        this.bBs = promptType;
        this.bBC = new JLabel();
        this.bBD = new JPanel();
        this.bBD.setOpaque(true);
        this.bBD.add(this.bBC);
        this.bBD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bBD.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bBA = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bBN == null) {
            return;
        }
        this.bBH = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bBG = surroundingBox;
        }
        this.bBy = textcomponent;
        this.bBy.addFocusListener(this);
        this.bBM = this.bBy.getBackground();
    }

    private void initFormats() {
        this.bBN = null;
        switch (this.bBs % 128) {
            case 6: 
            case 7: {
                this.bBN = this.bBH ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bBN = this.bBH ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bBN = this.bBH ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bBN = this.bBH ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Oy() {
        if (this.bBy instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bBy.isEnabled() || !this.bBy.isShowing() || object.toString().length() == 0 || this.bBy instanceof JComboBox && ((JComboBox)this.bBy).isPopupVisible() || (this.bBs % 128 == 6 || this.bBs % 128 == 7) && string.equals("-")) {
            if (!this.bBy.isEnabled()) {
                this.bBy.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bBy.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bBN.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bBI && this.bBJ != null) {
                if (this.bBJ == Object.class) {
                    this.bBJ = String.class;
                }
                this.bBK = this.bBJ.getConstructor(this.bBL);
                this.bBK.newInstance(string);
            }
            this.bBz = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bBy.getLocationOnScreen();
                point.y += this.bBy.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bBy.invalidate();
            this.bBy.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bBN, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bBN.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).Nu();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bBy.getLocationOnScreen();
        point.y += this.bBy.getHeight();
        this.bBz = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Oz();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bBy.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bBy.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bBy.getLocationOnScreen();
        point.y += this.bBy.getHeight();
        this.bBz = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Oz();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bBy.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bBy.invalidate();
    }

    private String Oz() {
        Format format;
        switch (this.bBs) {
            case 9: {
                format = PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                format = PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                format = PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                format = null;
            }
        }
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bBs == 6 || this.bBs == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ed(string);
        this.bBC.setText(string);
        this.bBD.setBackground(color);
        if (!this.bBE) {
            this.bBF = point;
        } else {
            point = this.bBF;
        }
        if (this.bBB != null) {
            this.hidePopup();
        }
        this.bBB = PopupFactory.getSharedInstance().getPopup(this.bBy, this.bBD, point.x, point.y);
        this.bBB.show();
        this.bBE = true;
        if (this.bBA.isRunning()) {
            this.bBA.restart();
        } else {
            this.bBA.start();
        }
    }

    private String ed(String object) {
        object = this.bBz ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bBy instanceof JPasswordField) {
            return new String(((JPasswordField)this.bBy).getPassword());
        }
        if (this.bBy instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bBy).getText();
            if (this.bBG == null) {
                return string2;
            }
            Object object = this.bBG.getSelectedItem();
            if (this.bBy != null && this.bBG.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bBy instanceof JComboBox) {
            return ((JComboBox)this.bBy).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bBB != null) {
            this.bBB.hide();
        }
        this.bBE = false;
        if (this.bBA.isRunning()) {
            this.bBA.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bBI = checkClassType;
        this.bBJ = classtype;
    }

    public void setPromptType(int promptType) {
        this.bBs = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bBy == null) {
            return;
        }
        if (this.bBy instanceof JTextField) {
            ((JTextField)this.bBy).getDocument().removeDocumentListener(this);
        } else if (this.bBy instanceof JComboBox) {
            ((JComboBox)this.bBy).removeActionListener(this);
            ((JComboBox)this.bBy).removePopupMenuListener(this);
        }
        this.bBy.removeFocusListener(this);
        if (this.bBG != null) {
            this.bBG.removeActionListener(this);
            this.bBG.removePopupMenuListener(this);
        }
        this.bBy.setBackground(this.bBM);
    }

    public boolean isPopupError() {
        return this.bBz;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Oy();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Oy();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Oy();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Oy();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Oy();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bBN = format;
    }
}

