/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bvo = -1;
    protected final PropertyChangeSupport bBf = new PropertyChangeSupport(this);
    private int type;
    private int bBg;
    private int progress;
    private boolean bBh = false;
    private String afY;
    private ReportView bBi;
    private ViewerContext bxy;
    private Component bzz;
    Thread bBj;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bBi = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bzz = reportView.getComponent();
            this.bxy = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.bxy = viewerContext;
        this.bzz = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bBj != null && this.bBj.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bBj = new Thread((Runnable)this, this.getName());
        this.bBj.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bBh) {
            this.bBj.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bBj.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bBh;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bBh;
        this.bBh = indeterminate;
        this.bBf.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bvo;
        this.bvo = status;
        this.bBf.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bvo);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bvo == 3 || this.bvo == 2 || this.bvo == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bvo == 3;
    }

    public boolean isErrored() {
        return this.bvo == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bBg;
        this.bBg = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bBf.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bBg;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bBf.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bBi;
    }

    public int getStatus() {
        return this.bvo;
    }

    public String getErrorMessage() {
        return this.afY;
    }

    public void setErrorMessage(String msg) {
        this.afY = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.bxy == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.bxy.showError(th, this.bzz);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bBf.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bBf.removePropertyChangeListener(l2);
    }

    protected void Or() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bBf.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bBf.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

