/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.xml;

import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.af;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.RelativePathDataFactory;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.xml.c;
import com.inet.report.database.xml.d;
import com.inet.report.database.xml.e;
import com.inet.report.database.xml.f;
import com.inet.report.database.xml.g;
import com.inet.report.i18n.ReportErrorCode;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public abstract class TreeDataFactory
extends RelativePathDataFactory {
    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        d d2 = this.a(ds, new c());
        this.a(d2.getName(), d2, hashMap);
        return hashMap;
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull Datasource ds, String catalog, String schema, String name, int type) throws ReportException {
        d d2 = this.a(ds, new c());
        if (schema != null && !schema.equalsIgnoreCase(d2.getName())) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.TableNotFound, schema + "." + name);
        }
        ArrayList<ColumnInfo> arrayList = this.a(d2, name);
        if (arrayList == null) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.TableNotFound, name);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts, List<DatabaseField> columns) throws ReportException {
        int n2 = columns.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = columns.get(i2).getShortName();
        }
        String[] stringArray2 = DatabaseUtils.parseSourceName(this.getConfiguration(), ts.getDatabaseIdentifier());
        Datasource datasource = ts.getDatasource();
        f f2 = new f(stringArray2, stringArray);
        this.a(datasource, f2);
        try {
            return new TableData(f2.getResultSet());
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL created internally and not from user input")
    private d a(@Nonnull Datasource datasource, @Nonnull e e2) throws ReportException {
        List<String> list = this.j(datasource);
        e2.setLocale(af.getEngine(datasource).getLocale());
        Exception exception = null;
        for (String string : list) {
            try {
                URL uRL;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = new URL("file:" + string);
                }
                e2.a(this.a(uRL.openConnection()));
                return e2.oW();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception != null) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
        throw new IllegalStateException("No data file found.");
    }

    @Nonnull
    abstract g a(URLConnection var1) throws Exception;

    @Nonnull
    private List<String> j(Datasource datasource) throws ReportException {
        DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
        if (dataSourceConfiguration == null) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoDataFile, datasource.getDataSourceConfigurationName());
        }
        String string = dataSourceConfiguration.getProperty("file");
        if (string == null || string.isEmpty()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoDataFile, dataSourceConfiguration.getConfigurationName());
        }
        return super.getPathNames(datasource, string);
    }

    private void a(String string, d d2, @Nonnull HashMap<String, TableSourceInfo> hashMap) {
        TableSourceInfo tableSourceInfo = null;
        for (d d3 : d2.oQ()) {
            if (d3.oR() == 0) {
                if (tableSourceInfo != null) continue;
                tableSourceInfo = new TableSourceInfo(null, string, d2.getName(), 0);
                hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                continue;
            }
            this.a(string, d3, hashMap);
        }
    }

    @Nullable
    private ArrayList<ColumnInfo> a(d d2, String string) {
        if (string.equals(d2.getName())) {
            ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
            for (d d3 : d2.oQ()) {
                if (d3.oR() != 0) continue;
                int n2 = d3.getType();
                ColumnInfo columnInfo = new ColumnInfo(d3.getName(), n2);
                arrayList.add(columnInfo);
            }
            return arrayList;
        }
        for (d d4 : d2.oQ()) {
            ArrayList<ColumnInfo> arrayList;
            if (d4.oR() <= 0 || (arrayList = this.a(d4, string)) == null) continue;
            return arrayList;
        }
        return null;
    }
}

