/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public final class LicenseKeyInfo {
    private static LicenseKeyInfo aag;
    private LicenseInfo aah;

    public LicenseKeyInfo(String licenseKey) {
        if (licenseKey == null) {
            this.aah = ConfigKeyParser.getCurrent();
            return;
        }
        this.aah = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
    }

    LicenseKeyInfo(@Nonnull LicenseInfo license) {
        Objects.requireNonNull(license);
        this.aah = license;
    }

    @Nonnull
    public static final LicenseKeyInfo getCurrent() {
        if (aag == null) {
            try {
                if (aag == null && ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                    Class.forName("com.inet.report.Engine").getConstructor(String.class).newInstance("java");
                }
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
            aag = new LicenseKeyInfo(ConfigKeyParser.getCurrent());
        }
        return aag;
    }

    public final boolean isPlus() {
        return this.aah.isValid() && Boolean.parseBoolean((String)this.aah.getAttributes().get("crplus"));
    }

    public final String getLicenseText() {
        return this.aah.getDisplayName();
    }

    public final String getLicensee() {
        return this.aah.getLicensee();
    }

    public final boolean isValid() {
        return this.aah.isValid();
    }

    public final String getErrorMessage() {
        return this.aah.getErrorMessage();
    }

    public final boolean hasExpiredDate() {
        return this.aah.hasExpiredDate();
    }

    public final String getWaterMark() {
        return (String)this.aah.getAttributes().get("watermark");
    }

    public final boolean isSite() {
        return this.aah.isValid() && this.aah.getAttributes().get("ip") == null;
    }

    public final LicenseInfo getLicenseInfo() {
        return this.aah;
    }

    static {
        LicenseManager.getInstance().addLicenseListener(licenseInfo -> {
            aag = new LicenseKeyInfo(licenseInfo);
        });
    }
}

