/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache.store;

import com.inet.cache.CacheManager;
import com.inet.cache.CacheStrategy;
import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.ConnectionFactory;
import com.inet.cache.DataMapEntry;
import com.inet.cache.DatabaseStoreMap;
import com.inet.cache.HardDiskStoreMap;
import com.inet.cache.MemoryListener;
import com.inet.cache.MemoryStoreMap;
import com.inet.cache.StoreMap;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigValues;
import com.inet.lib.core.OS;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.CacheRenderData;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.store.CachedOutput;
import com.inet.report.cache.store.a;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.util.ClearReportsUtils;
import com.inet.report.util.DesignerCCBridge;
import com.inet.report.util.EngineUtils;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadPool;
import com.inet.thread.ThreadUtils;
import java.io.File;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class b
extends Cache {
    private static final StoreMap<ReportCacheKey, CachedOutput> VY = new MemoryStoreMap();
    private static final ConfigValue<Double> VZ = new ConfigValue<Double>(ConfigKey.ENGINE_CACHE_TIMEOUT){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            VY.setTimeout((int)Math.round((Double)this.get() * 60.0), false);
        }
    };
    private static int Wa;
    static StoreMap<a, byte[]> Wb;
    private static final ConfigValues Wc;

    public static <K, V> StoreMap<K, V> a(CacheStrategy cacheStrategy) {
        try {
            switch (Wa) {
                case 1: {
                    ConnectionFactory connectionFactory = new ConnectionFactory(){
                        private String Wd = (String)Wc.get(ConfigKey.CACHE_DB_DRIVERCLASS);
                        private Driver We = this.Wd != null && !this.Wd.isEmpty() ? (Driver)LoaderUtils.classForName((String)this.Wd, (Object)this).newInstance() : null;

                        @Nonnull
                        public String getKey() {
                            return (String)Wc.get(ConfigKey.CACHE_DB_URL);
                        }

                        @Nonnull
                        public Connection create() throws SQLException {
                            String string;
                            Properties properties = new Properties();
                            String string2 = (String)Wc.get(ConfigKey.CACHE_DB_USERNAME);
                            if (string2 != null) {
                                properties.put("user", string2);
                            }
                            if ((string = (String)Wc.get(ConfigKey.CACHE_DB_PASSWORD)) != null) {
                                properties.put("password", string);
                            }
                            if (this.We != null) {
                                return this.We.connect(this.getKey(), properties);
                            }
                            return DriverManager.getConnection(this.getKey(), properties);
                        }
                    };
                    return new DatabaseStoreMap(connectionFactory, cacheStrategy);
                }
                case 2: {
                    return new HardDiskStoreMap(b.mi(), cacheStrategy);
                }
            }
            Wa = 0;
            return new MemoryStoreMap();
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
            Wa = 0;
            return new MemoryStoreMap();
        }
    }

    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="admin config it")
    public static File mi() {
        if (Wa == 2) {
            String string = (String)Wc.get(ConfigKey.CACHE_HD_ROOT_DIRECTORY);
            return string != null && !string.trim().isEmpty() ? new File(string.trim()) : null;
        }
        return null;
    }

    public static int mj() {
        return Math.max(0, 60000 * ((Double)VZ.get()).intValue());
    }

    @Override
    public int getType() {
        return Wa;
    }

    public static int mk() {
        return Wa;
    }

    @Override
    public ReportCacheKey getKey(Properties props, PropertiesChecker checker, EngineFactory factory, Object req) throws ReportException {
        ReportCacheKey reportCacheKey = this.createKey(props, checker, factory, req);
        try (ServerLock serverLock = ThreadUtils.getLock((Object)reportCacheKey);){
            if (this.exists(reportCacheKey)) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[Report Cache] GetKey: Found Key in store: " + String.valueOf(reportCacheKey));
                }
                VY.resetTimeout((Object)reportCacheKey);
                ReportCacheKey reportCacheKey2 = reportCacheKey;
                return reportCacheKey2;
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[Report Cache] GetKey: Start Engine: " + String.valueOf(reportCacheKey));
            }
            this.a(reportCacheKey, props, checker, factory, req);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[Report Cache] GetKey: Engine started");
            }
        }
        return reportCacheKey;
    }

    private void a(ReportCacheKey reportCacheKey, Properties properties, PropertiesChecker propertiesChecker, EngineFactory engineFactory, Object object) throws ReportException {
        switch (reportCacheKey.getFormat()) {
            case "jar": 
            case "jra": {
                this.b(reportCacheKey, properties, propertiesChecker, engineFactory, object);
                return;
            }
        }
        if (BaseUtils.isInfo()) {
            BaseUtils.info("[Report Cache] startEngine req: " + String.valueOf(object));
        }
        if (BaseUtils.isInfo()) {
            BaseUtils.info("[Report Cache] PropertiesChecker: " + String.valueOf(propertiesChecker));
        }
        properties.put("export_fmt", reportCacheKey.getFormat());
        Object object2 = EngineUtils.createReportGenerator(properties, propertiesChecker, engineFactory, object);
        CachedOutput cachedOutput = new CachedOutput(reportCacheKey, (ReportGenerator)object2);
        try {
            object2.setDocumentOutput(cachedOutput);
            object2.execute();
            VY.put((Object)reportCacheKey, (Object)cachedOutput);
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    private void b(final ReportCacheKey reportCacheKey, Properties properties, PropertiesChecker propertiesChecker, EngineFactory engineFactory, Object object) throws ReportException {
        final Properties properties2 = (Properties)properties.clone();
        properties2.put("export_fmt", "java");
        final ReportCacheKey reportCacheKey2 = this.getKey(properties2, propertiesChecker, engineFactory, object);
        final CachedOutput cachedOutput = new CachedOutput(reportCacheKey, null);
        VY.put((Object)reportCacheKey, (Object)cachedOutput);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CacheRenderData cacheRenderData = new CacheRenderData(properties2, null, null){

                    @Override
                    protected ReportCacheKey getKey(Properties props) throws ReportException {
                        return reportCacheKey2;
                    }
                };
                FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                try {
                    if (reportCacheKey.getFormat().equals("jra")) {
                        com.inet.viewer.archive.b.a((OutputStream)fastByteArrayOutputStream, cacheRenderData);
                    } else {
                        com.inet.viewer.archive.b.b((OutputStream)fastByteArrayOutputStream, cacheRenderData);
                    }
                    cachedOutput.addPage(fastByteArrayOutputStream.toByteArray());
                    cachedOutput.setGroupTree(new byte[0]);
                }
                catch (Throwable throwable) {
                    BaseUtils.printStackTrace(throwable);
                    cachedOutput.setErrorData(IOFunctions.serialize((Throwable)throwable));
                }
            }
        };
        ThreadPool.DEFAULT.startMainThread(runnable, (RunnableSession)new BaseRunnableSession());
    }

    @Nonnull
    private static CachedOutput a(@Nonnull ReportCacheKey reportCacheKey) throws KeyNotFoundException {
        CachedOutput cachedOutput = (CachedOutput)VY.get((Object)reportCacheKey);
        if (cachedOutput == null) {
            throw new KeyNotFoundException(reportCacheKey);
        }
        return cachedOutput;
    }

    @Override
    public byte[] getPageAndWait(ReportCacheKey key, int page, int timeout) throws PageOutOfRangeException, KeyNotFoundException, ReportException {
        return b.a(key).H(page, timeout);
    }

    @Override
    public int getPageCountAndWait(ReportCacheKey key, int timeout) throws KeyNotFoundException, ReportException {
        CachedOutput cachedOutput = b.a(key);
        try {
            cachedOutput.H(0, timeout);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            // empty catch block
        }
        return cachedOutput.getPageCount();
    }

    @Override
    public int getTotalPageSizeAndWait(ReportCacheKey key, int timeout) throws KeyNotFoundException, ReportException {
        CachedOutput cachedOutput = b.a(key);
        try {
            cachedOutput.H(0, timeout);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            // empty catch block
        }
        return cachedOutput.mf();
    }

    @Override
    public boolean isPageLimitExceeded(ReportCacheKey key) throws KeyNotFoundException, ReportException {
        return b.a(key).isPageLimitExceeded();
    }

    @Override
    public void lock(ReportCacheKey key) throws KeyNotFoundException, ReportException {
        ThreadUtils.getLock((Object)key);
    }

    @Override
    public void unlock(ReportCacheKey key) throws KeyNotFoundException, ReportException {
        ServerLock serverLock = ThreadUtils.getLock((Object)key);
        serverLock.close();
        serverLock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws ReportException {
        StoreMap<ReportCacheKey, CachedOutput> storeMap = VY;
        synchronized (storeMap) {
            Iterator iterator = VY.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                CachedOutput cachedOutput = (CachedOutput)entry.getValue();
                iterator.remove();
                if (cachedOutput == null) continue;
                cachedOutput.clear();
            }
        }
    }

    @Override
    public void addEngine(Engine engine, ReportCacheKey key) throws ReportException {
        if (this.exists(key)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.engExistsAlready, new Object[0]);
        }
        try {
            byte[] byArray;
            int n2;
            CachedOutput cachedOutput = new CachedOutput(key, engine);
            try {
                n2 = engine.getPageCount();
            }
            catch (ReportException reportException) {
                if (reportException.getErrorCode() == ReportErrorCode.EngineNotExecuted.getErrorCodeNumber()) {
                    engine.setDocumentOutput(cachedOutput);
                    engine.execute();
                    VY.put((Object)key, (Object)cachedOutput);
                    return;
                }
                throw reportException;
            }
            VY.put((Object)key, (Object)cachedOutput);
            for (int i2 = 1; i2 <= n2; ++i2) {
                cachedOutput.addPage(engine.getPageData(i2));
            }
            n2 = 1;
            byte[] byArray2 = null;
            while ((byArray = engine.getFontData(n2)) != null && byArray != byArray2) {
                cachedOutput.addFontData(byArray);
                byArray2 = byArray;
                ++n2;
            }
            cachedOutput.setGroupTree(engine.getGroupTree());
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @Override
    public boolean exists(ReportCacheKey key) {
        return VY.containsKey((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String report) throws ReportException {
        if (OS.isWindows()) {
            report = report.toLowerCase();
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Report Cache] start delete report: " + report);
        }
        ArrayList<ReportCacheKey> arrayList = null;
        StoreMap<ReportCacheKey, CachedOutput> storeMap = VY;
        synchronized (storeMap) {
            for (ReportCacheKey reportCacheKey : VY.keySet()) {
                if (!reportCacheKey.getReport().equals(report)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ReportCacheKey>();
                }
                arrayList.add(reportCacheKey);
            }
        }
        if (arrayList != null) {
            for (ReportCacheKey reportCacheKey : arrayList) {
                this.delete(reportCacheKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ReportCacheKey key) throws ReportException {
        CachedOutput cachedOutput = (CachedOutput)VY.get((Object)key);
        if (cachedOutput != null) {
            try (ServerLock serverLock = ThreadUtils.getLock((Object)key);){
                ReportGenerator reportGenerator = cachedOutput.getEngine();
                if (reportGenerator != null) {
                    reportGenerator.stop("Cache.deleteReport");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                StoreMap<ReportCacheKey, CachedOutput> storeMap = VY;
                synchronized (storeMap) {
                    VY.remove((Object)key);
                    cachedOutput.aH("Cache.deleteReport");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ReportCacheKey[] getReports() throws ReportException {
        StoreMap<ReportCacheKey, CachedOutput> storeMap = VY;
        synchronized (storeMap) {
            ArrayList arrayList = new ArrayList(VY.keySet());
            return arrayList.toArray(new ReportCacheKey[arrayList.size()]);
        }
    }

    @Override
    public boolean isFailedReport(ReportCacheKey key) throws ReportException {
        return b.a(key).mg() == 3;
    }

    @Override
    public int getMemoryUsage(ReportCacheKey key) {
        int n2 = 0;
        for (a a2 : Wb.keySet()) {
            byte[] byArray;
            if (!key.equals(a2.mh()) || (byArray = (byte[])Wb.getIfInMemeory((Object)a2)) == null) continue;
            n2 += byArray.length;
        }
        return n2;
    }

    @Override
    public int getMemoryUsage() {
        int n2 = 0;
        for (a a2 : Wb.keySet()) {
            byte[] byArray = (byte[])Wb.getIfInMemeory((Object)a2);
            if (byArray == null) continue;
            n2 += byArray.length;
        }
        return n2;
    }

    @Override
    public long getSwapSize(ReportCacheKey key) {
        long l2 = 0L;
        for (a a2 : Wb.keySet()) {
            if (!key.equals(a2.mh())) continue;
            l2 += Wb.getSwapSize((Object)a2);
        }
        return l2;
    }

    @Override
    public long getSwapSize() {
        return Wb.getSwapSize();
    }

    @Override
    public void resetCacheTimeout(ReportCacheKey key) {
        VY.resetTimeout((Object)key);
    }

    @Override
    public boolean isFinished(ReportCacheKey key) throws ReportException {
        CachedOutput cachedOutput = (CachedOutput)VY.get((Object)key);
        if (cachedOutput == null) {
            return true;
        }
        return cachedOutput.mg() != 0;
    }

    @Override
    @Deprecated
    public boolean containsInRAM(ReportCacheKey key) {
        return this.getType() == 0;
    }

    @Override
    @Deprecated
    public boolean isFinishWrittenToStore(ReportCacheKey key) throws ReportException, KeyNotFoundException {
        return this.isFinished(key);
    }

    @Override
    @Nullable
    public ReportGenerator getEngine(ReportCacheKey key) {
        CachedOutput cachedOutput = (CachedOutput)VY.get((Object)key);
        return cachedOutput == null ? null : cachedOutput.getEngine();
    }

    static {
        Wb = b.a(CacheStrategy.Normal);
        Wc = new ConfigValues(){

            protected void changed() {
                ForkJoinPool.commonPool().execute(() -> {
                    StoreMap<a, byte[]> storeMap = Wb;
                    synchronized (storeMap) {
                        StoreMap<a, byte[]> storeMap2 = Wb;
                        Wa = (Integer)Wc.get(ConfigKey.CACHE_TYPE);
                        if (!DesignerCCBridge.isPlusVersion()) {
                            Wa = 0;
                        }
                        Wb = b.a(CacheStrategy.Normal);
                        ClearReportsUtils.jF(Wa);
                        VY.clear();
                        if (storeMap2 != null) {
                            storeMap2.clear();
                        }
                    }
                });
            }
        };
        Wc.init(new ConfigKey[]{ConfigKey.CACHE_DB_DRIVERCLASS, ConfigKey.CACHE_DB_PASSWORD, ConfigKey.CACHE_DB_URL, ConfigKey.CACHE_DB_USERNAME, ConfigKey.CACHE_HD_ROOT_DIRECTORY, ConfigKey.CACHE_TYPE});
        VY.addTimeoutListener((CacheTimeoutListener)new CacheTimeoutListener<ReportCacheKey, CachedOutput>(){

            public void a(ReportCacheKey reportCacheKey, CachedOutput cachedOutput) {
                ReportGenerator reportGenerator;
                Object object = "Engine cache timeout or out of memory.";
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug((String)object + " for report: " + String.valueOf(reportCacheKey));
                }
                if ((reportGenerator = cachedOutput.getEngine()) != null) {
                    Runtime runtime = Runtime.getRuntime();
                    long l2 = runtime.totalMemory() - runtime.freeMemory();
                    long l3 = runtime.maxMemory();
                    object = (String)object + " Memory used: " + (long)(100.0 * (double)l2 / (double)l3) + "%";
                }
                cachedOutput.aH((String)object);
                if (reportGenerator != null) {
                    reportGenerator.stop((String)object);
                }
            }

            public /* synthetic */ void timeout(Object object, Object object2) {
                this.a((ReportCacheKey)object, (CachedOutput)object2);
            }
        });
        CacheManager.addMemoryListener((MemoryListener)new MemoryListener(){

            public void onLowMemory(long exceeding) {
                if (Wa != 0) {
                    return;
                }
                Set set = VY.entrySet();
                ArrayList<CachedOutput> arrayList = new ArrayList<CachedOutput>(set.size());
                for (Object object : set) {
                    CachedOutput cachedOutput = (CachedOutput)object.getValue();
                    if (cachedOutput == null || cachedOutput.mg() == 0) continue;
                    cachedOutput.a(((DataMapEntry)object).timeout());
                    arrayList.add(cachedOutput);
                }
                if (arrayList.size() > 0) {
                    Collections.sort(arrayList);
                    Cache cache = Cache.getCache();
                    for (CachedOutput cachedOutput : arrayList) {
                        try (ServerLock serverLock = ThreadUtils.tryLock((Object)cachedOutput.getKey());){
                            if (serverLock != null) {
                                exceeding -= (long)cachedOutput.mf();
                                cache.delete(cachedOutput.getKey());
                                if (BaseUtils.isWarning()) {
                                    BaseUtils.warning("Delete report from cache because low memory: " + String.valueOf(cachedOutput.getKey()));
                                }
                            }
                        }
                        catch (ReportException reportException) {
                            BaseUtils.error(reportException);
                        }
                        if (exceeding >= 0L) continue;
                        return;
                    }
                }
            }

            public void onGoodMemory() {
            }
        });
    }
}

