/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.annotations.PublicApi;
import com.inet.report.ReportException;
import java.io.Serializable;

@PublicApi
public final class ReportCacheKey
implements Serializable {
    private final String VM;
    private final String VN;
    private final String format;
    private final long VO;

    public ReportCacheKey(String report, String parameter, String format, long vgen) throws ReportException {
        if (report == null) {
            report = "";
        }
        this.VM = report;
        this.VN = parameter != null ? parameter : "";
        this.format = format != null ? format : "";
        this.VO = vgen;
    }

    public int hashCode() {
        return this.VM.hashCode() + this.VN.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (this.hashCode() == o2.hashCode() && o2 instanceof ReportCacheKey) {
            ReportCacheKey reportCacheKey = (ReportCacheKey)o2;
            if (this.VM.equals(reportCacheKey.VM) && this.VN.equals(reportCacheKey.VN) && this.format.equals(reportCacheKey.format)) {
                return true;
            }
        }
        return false;
    }

    public String getReport() {
        return this.VM;
    }

    public String getParameter() {
        return this.VN;
    }

    public long getVGen() {
        return this.VO;
    }

    public String getFormat() {
        return this.format;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("ReportCacheKey:\n report: " + this.VM);
        stringBuilder.append("\n format: " + this.format);
        stringBuilder.append("\n parameter: " + this.VN);
        stringBuilder.append("\n vgen: " + this.VO);
        return stringBuilder.toString();
    }
}

