/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.ast.q;
import com.inet.report.formula.j;
import com.inet.report.formula.number.c;
import com.inet.report.i18n.ReportErrorCode;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@PublicApi
public class FormulaRange
implements Evaluable,
Serializable {
    public Object from;
    public Object to;
    private String sj = "d";
    private boolean sk = true;
    private boolean sl = true;

    public final boolean isLowLimitIncluded() {
        return this.sk;
    }

    public final void setLowLimitIncluded(boolean includeFrom) {
        this.sk = includeFrom;
    }

    public final boolean isHighLimitIncluded() {
        return this.sl;
    }

    public final void setHighLimitIncluded(boolean includeTo) {
        this.sl = includeTo;
    }

    private void dj() {
        if (this.to instanceof String && !(this.from instanceof String)) {
            if (this.to.equals(">")) {
                this.to = this.from;
                this.sl = true;
                this.from = null;
            } else if (this.to.equals("[")) {
                this.to = this.from;
                this.sl = false;
                this.from = null;
            } else if (this.to.equals("<")) {
                this.to = null;
                this.sk = true;
            } else if (this.to.equals("]")) {
                this.to = null;
                this.sk = false;
            }
        }
    }

    public FormulaRange(Object from, Object to, boolean includeFrom, boolean includeTo) {
        this.sk = includeFrom;
        this.sl = includeTo;
        this.from = from;
        this.to = to;
        this.dj();
    }

    public FormulaRange(Object from, Object to, String intervalType, boolean includeFrom, boolean includeTo) {
        this.sk = includeFrom;
        this.sl = includeTo;
        this.from = from;
        this.to = to;
        this.sj = intervalType;
        this.dj();
    }

    public FormulaRange(Object from, Object to) {
        this.from = from;
        this.to = to;
        this.dj();
    }

    public FormulaRange(Object from, Object to, Object intervalType) {
        this.from = from;
        this.to = to;
        this.sj = (String)intervalType;
        this.dj();
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public Object getFrom() {
        return this.from;
    }

    public void setTo(Object to) {
        this.to = to;
    }

    public Object getTo() {
        return this.to;
    }

    public void setIntervalType(String intervalType) {
        this.sj = intervalType;
    }

    public String getIntervalType() {
        return this.sj;
    }

    @Override
    public Object eval(j formula) {
        return this;
    }

    @Override
    public int getValueType(j formula) throws ReportException {
        Object[] objectArray;
        if (this.from == null && this.isLowLimitIncluded()) {
            Object[] objectArray2 = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.MissingStartValue, objectArray2);
        }
        if (this.to == null && this.isHighLimitIncluded()) {
            Object[] objectArray3 = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.MissingEndValue, objectArray3);
        }
        if (this.from != null && this.to != null && this.from.getClass() != this.to.getClass()) {
            objectArray = new Object[]{};
            if (!(this.from instanceof Date) && !(this.to instanceof Date)) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.DifferentTypes, objectArray);
            }
        }
        if (c.aD(this.from) || c.aD(this.to)) {
            return 135;
        }
        if (this.from instanceof Number || this.to instanceof Number) {
            return 134;
        }
        if (this.from instanceof String || this.to instanceof String) {
            return 139;
        }
        if (this.from instanceof Boolean || this.to instanceof Boolean) {
            objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.BooleanRangeForbidden, objectArray);
        }
        if (this.from instanceof java.sql.Date || this.to instanceof java.sql.Date) {
            return 137;
        }
        if (this.from instanceof Time || this.to instanceof Time) {
            return 138;
        }
        if (this.from instanceof Timestamp || this.to instanceof Timestamp || this.from instanceof Date || this.to instanceof Date) {
            return 143;
        }
        objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.RangeValueTypeUnknown, objectArray);
    }

    @Override
    public void checkContext(j formula, int formulaType) {
    }

    @Override
    public int getEvaluateTime(j formula) {
        return 0;
    }

    public String toString() {
        String string = (this.isLowLimitIncluded() ? " " : " _") + "to" + (this.isHighLimitIncluded() ? " " : "_ ");
        if (this.from instanceof String && this.to instanceof String) {
            String string2 = (String)this.from;
            String string3 = (String)this.to;
            String string4 = string;
            string2 = this.G(string2);
            string3 = this.G(string3);
            return string2 + string4 + string3;
        }
        if (this.from instanceof Date || this.to instanceof Date) {
            DateFormat dateFormat = null;
            if (this.from instanceof java.sql.Date && this.to instanceof java.sql.Date) {
                dateFormat = SimpleDateFormat.getDateInstance(3);
            } else if (this.from instanceof Time && this.to instanceof Time) {
                dateFormat = SimpleDateFormat.getTimeInstance(2);
            } else if (this.from instanceof Timestamp && this.to instanceof Timestamp) {
                dateFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
            }
            if (dateFormat != null) {
                return dateFormat.format((Date)this.from) + string + dateFormat.format((Date)this.to);
            }
        }
        return String.valueOf(this.from) + string + String.valueOf(this.to);
    }

    private String G(String object) {
        for (int i2 = 0; i2 < ((String)object).length(); ++i2) {
            if (((String)object).charAt(i2) != '\'') continue;
            object = ((String)object).substring(0, i2) + "'" + ((String)object).substring(i2++);
        }
        object = "'" + (String)object + "'";
        return object;
    }

    @Override
    public String toSql(j formula, SqlSyntax syntax, boolean isPlaceholder, boolean isTopLevel) throws ReportException {
        Object object = this.to;
        if (this.to instanceof java.sql.Date) {
            object = new java.sql.Date(((Date)this.to).getTime() + 86400000L);
        }
        return q.a(this.from, formula, syntax) + " AND " + q.a(object, formula, syntax);
    }

    @Override
    public Evaluable optimize(j formula) throws ReportException {
        return this;
    }

    @Override
    public void setReferencing(j formula) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FormulaRange)) {
            return false;
        }
        FormulaRange formulaRange = (FormulaRange)obj;
        if (this.to != null ? !this.to.equals(formulaRange.to) : formulaRange.to != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(formulaRange.from) : formulaRange.from != null) {
            return false;
        }
        return !(this.sl != formulaRange.sl || this.sk != formulaRange.sk || this.sj != null ? !this.sj.equals(formulaRange.sj) : formulaRange.sj != null);
    }
}

