/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.lib.list.StringList;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.bi;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfigurationXMLFileStore;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcConnectionFactory;
import com.inet.report.database.base.DatabaseFactory;
import com.inet.report.database.fetch.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.NodeParser;
import com.inet.report.pool.PoolConnection;
import com.inet.report.pool.PoolManager;
import com.inet.report.util.EngineUtils;
import java.awt.EventQueue;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

@PublicApi
public class Datasource
implements Serializable {
    private static List<DataFactory> lv;
    private final Properties lw = new Properties();
    private DataSourceConfiguration lx;
    private transient PoolConnection ly;
    private transient boolean lz;
    private DataFactory lA;
    private final TablesourceList lB = new TablesourceList();
    @Nonnull
    private Engine lC;
    private boolean lD = false;
    private boolean lE = false;
    private boolean lF = true;
    private boolean lG;

    Datasource(String dsDll, String dsHost, String dsSchema, String dsCatalog, String dsUsername, String dsPassword, Engine engine) {
        this(dsDll, engine);
        if (dsHost != null) {
            this.lw.put("datasource_host", dsHost);
        }
        if (dsSchema != null) {
            this.lw.put("datasource_schema", dsSchema);
        }
        if (dsCatalog != null) {
            this.lw.put("datasource_catalog", dsCatalog);
        }
        if (dsUsername != null) {
            this.lw.put("user", dsUsername);
        }
        if (dsPassword != null) {
            this.lw.put("password", dsPassword);
        }
        this.lG = true;
        if (dsHost == null && dsCatalog == null && dsUsername == null && dsPassword == null) {
            return;
        }
        if (EngineUtils.isDesigner()) {
            this.ce();
        }
    }

    Datasource(String dataSourceConfigurationName, @Nonnull Engine engine) {
        this.lC = engine;
        this.setDataSourceConfigurationName(dataSourceConfigurationName);
    }

    public String toString() {
        DatabaseTables databaseTables = this.lC.bB.iY();
        int n2 = databaseTables.getDatasourceCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            n3 = i2;
            break;
        }
        return "#" + n3 + " (" + this.getDataSourceConfigurationName() + ")";
    }

    @Nonnull
    Engine getEngine() {
        return this.lC;
    }

    @SuppressFBWarnings(value={"EXTERNAL_CONFIG_CONTROL"}, justification="the catalog must be set")
    public synchronized Connection getConnection() throws ReportException {
        if (!this.hasValidConnection()) {
            block15: {
                Object object;
                if (!this.ci() && !DatabaseUtils.useJdbcDriver(this.lA)) {
                    return null;
                }
                Object t2 = this.lC.bB.gz();
                if (t2 != null) {
                    object = ((bi)t2).iY();
                    int n2 = ((DatabaseTables)object).getDatasourceCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Datasource datasource = ((DatabaseTables)object).getDatasource(i2);
                        if (datasource.ly == null || !this.equals(datasource) || !datasource.hasValidConnection()) continue;
                        this.ly = datasource.ly;
                        datasource.lz = true;
                        this.ly.incUseCount();
                    }
                }
                if (this.ly == null) {
                    if (this.lx == null) {
                        object = null;
                        object = this.getDataSourceConfigurationName();
                        if (object != null && ((String)object).length() > 0) {
                            this.a((String)object, this.lG);
                            if (this.lx == null) {
                                throw ReportExceptionFactory.createReportException(ReportErrorCode.dscNotDefined, object);
                            }
                        }
                        if (this.lx == null) {
                            throw new ReportException("No connection created for datasource: " + String.valueOf(this), 0);
                        }
                    }
                    this.ly = this.cb();
                    this.ly.incUseCount();
                }
                try {
                    if (this.getCatalog().length() > 0 && !this.getCatalog().equals(this.ly.getCatalog())) {
                        this.ly.setCatalog(this.getCatalog());
                    }
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isParanoid()) {
                        BaseUtils.paranoid("[Datasource#" + this.ch() + "] set catalog to " + this.getCatalog() + " failed.");
                    }
                    if (!BaseUtils.isParanoid()) break block15;
                    BaseUtils.paranoid(throwable);
                }
            }
            if (this.lF) {
                this.cc();
            }
            this.bZ();
        } else {
            this.ly.incUseCount();
        }
        return this.ly;
    }

    private void bZ() {
        try {
            if (this.lx == null || this.lx.getIdentifierQuoteString() == null || this.lx.getIdentifierQuoteString().length() == 0) {
                ((Database)this.lA).scanIdentifierQuoteString(this);
                BaseUtils.info("IdentifierQuoteString: >" + this.lA.getConfiguration().getIdentifierQuoteString() + "<");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties ca() {
        String string;
        String string2;
        Properties properties = new Properties();
        String[] stringArray = this.lx.getDriverSpecificProperties();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = stringArray[i2];
            string = this.lx.getProperty(string2);
            properties.put(string2, string);
        }
        String string3 = this.getUsername();
        if (string3 != null && !string3.isEmpty()) {
            properties.put("user", string3);
        }
        if ((string2 = this.getPassword()) != null && !string2.isEmpty()) {
            properties.put("password", string2);
        }
        if ((string = this.getCatalog()) != null && string.length() > 0) {
            properties.put("catalog", string);
        }
        return properties;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="admin configured SQL")
    private PoolConnection cb() throws ReportException {
        if (EventQueue.isDispatchThread()) {
            BaseUtils.printStackTrace(new Throwable("WARNING: connecting to the DB on the event dispatch thread!"));
        }
        this.lC.cr();
        if (ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getCurrent().equals(Boolean.FALSE) && !DataSourceConfigurationManager.exists(this.getDataSourceConfigurationName())) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.AccessDeniedUnknownDatasource, this.getDataSourceConfigurationName());
        }
        try {
            String string;
            Map.Entry<Object, Object> entry;
            if (this.lA instanceof JdbcConnectionFactory) {
                Connection connection = ((JdbcConnectionFactory)((Object)this.lA)).getConnection(this);
                return new PoolConnection(connection);
            }
            String string2 = this.getUrl();
            Properties properties = this.ca();
            string2 = Datasource.a(string2, properties, this);
            Object object = properties.entrySet().iterator();
            while (object.hasNext()) {
                entry = object.next();
                string = (String)entry.getValue();
                if (string != null && !string.isEmpty()) continue;
                object.remove();
            }
            BaseUtils.info("try connection: " + this.lx.getConfigurationName() + " / " + string2);
            properties.remove("initSQL");
            object = PoolManager.getDefault().getConnection(this.lx.getDriverClassname(), string2, properties);
            if (BaseUtils.isInfo()) {
                BaseUtils.info("creating connection:" + String.valueOf(object) + " for engine: " + this.lC.bB.gH);
            }
            entry = this.lx.getProperty("initSQL");
            string = "initSQL";
            if (((String)((Object)entry)).isEmpty()) {
                entry = this.lx.getValidationQuery();
                string = "validationQuery";
            }
            if (entry != null && !((String)((Object)entry)).isEmpty()) {
                try {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("executing " + string + " command: " + (String)((Object)entry));
                    }
                    ((PoolConnection)object).createStatement().execute((String)((Object)entry));
                }
                catch (SQLException sQLException) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("executing " + string + " failed");
                        BaseUtils.debug(sQLException);
                    }
                    ((PoolConnection)object).closeNativeConnection();
                    object = this.cb();
                }
            }
            return object;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    private static String a(String object, Properties properties, Datasource datasource) {
        int n2 = 0;
        while (((String)object).indexOf(123, n2) != -1) {
            int n3;
            int n4;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. " + (String)object);
            }
            if ((n4 = ((String)object).indexOf(123, n2)) > (n3 = ((String)object).indexOf(125, n2))) break;
            String string = ((String)object).substring(n4 + 1, n3);
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                try {
                    int n5 = Integer.parseInt(string);
                    switch (n5) {
                        case 0: {
                            string2 = datasource.getHost();
                            break;
                        }
                        case 1: {
                            string2 = datasource.getCatalog();
                            break;
                        }
                        case 2: {
                            string2 = datasource.getUsername();
                            break;
                        }
                        case 3: {
                            string2 = datasource.getPassword();
                            break;
                        }
                        case 4: {
                            string2 = datasource.getSchema();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. replace \"{" + string + "}\" with \"" + string2 + "\"");
                }
                properties.remove(string);
                object = ((String)object).substring(0, n4) + string2 + ((String)object).substring(n3 + 1, ((String)object).length());
                continue;
            }
            n2 = n3 + 1;
        }
        return object;
    }

    public void closeConnection() {
        if (this.lz) {
            return;
        }
        PoolConnection poolConnection = this.ly;
        this.ly = null;
        if (poolConnection != null) {
            poolConnection.closeAll();
        }
    }

    public boolean hasValidConnection() {
        if (this.ly != null) {
            if (this.ly.isClosed()) {
                this.ly = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setConnection(@Nonnull Connection newConnection) {
        block4: {
            try {
                if (this.hasValidConnection() && this.ly != newConnection && this.ly.unwrap(Connection.class) != newConnection) {
                    this.ly.close();
                }
            }
            catch (SQLException sQLException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug(sQLException);
            }
        }
        this.ly = newConnection instanceof PoolConnection ? (PoolConnection)newConnection : new PoolConnection(newConnection);
        this.ly.incUseCount();
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "] Used connection " + String.valueOf(this.ly) + "  is valid:" + this.hasValidConnection());
        }
        this.cc();
        this.bZ();
    }

    private void cc() {
        Database database = DatabaseFactory.getInstance().createDatabaseClass(this.ly);
        if (this.lA == null || database != null && this.lA.getClass() != database.getClass()) {
            this.lA = database;
            DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
            if (dataSourceConfiguration != null) {
                this.lA.setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
        }
        this.lF = false;
    }

    public String getCatalog() {
        String string = this.lw.getProperty("datasource_catalog", "");
        if (string.length() == 0 && this.lx != null && (string = this.lx.getProperty("datasource_catalog")).length() == 0) {
            string = this.lx.getCatalog();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setCatalog(String dsCatalog) {
        this.t(dsCatalog);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setCatalog " + this.getCatalog());
        }
        this.lD = true;
    }

    void t(String string) {
        if (string == null) {
            string = "";
        }
        this.lw.put("datasource_catalog", string);
    }

    public DataSourceConfiguration getDataSourceConfiguration() {
        if (DataSourceConfigurationManager.exists(this.getDataSourceConfigurationName())) {
            return DataSourceConfigurationManager.getDataSourceConfiguration(this.getDataSourceConfigurationName(), 3);
        }
        return this.lx;
    }

    public String getDataSourceConfigurationName() {
        String string;
        if (this.lx != null && !(string = this.lx.getConfigurationName()).isEmpty()) {
            return string;
        }
        return this.lw.getProperty("datasource_name", "");
    }

    @Deprecated
    void u(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.getUsername();
        String string3 = this.getPassword();
        this.a(string, true);
        this.setUsername(string2);
        this.setPassword(string3);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setDll " + string);
        }
    }

    public String getHost() {
        return this.lw.getProperty("datasource_host", "");
    }

    public void setHost(String dsHost) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setHost " + dsHost);
        }
        if (dsHost == null) {
            dsHost = "";
        }
        this.lw.put("datasource_host", dsHost);
    }

    public String getPassword() {
        String string;
        String string2 = this.lw.getProperty("password");
        if (string2 == null && this.getEngine() != null && (string = this.getEngine().getMetaProperties().getProperty("designer." + this.getDataSourceConfigurationName())) != null) {
            string2 = this.v(string);
        }
        if (string2 == null && this.lx != null) {
            return this.lx.getPassword();
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "HARD_CODE_KEY", "ECB_MODE"}, justification="leagacy code")
    private String v(String string) {
        if (string.startsWith("N")) {
            return string.substring(1);
        }
        try {
            byte[] byArray = Datasource.w(string.substring(1));
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec("KEY_DATA_SOURCE_".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            return new String(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(exception);
            }
            return null;
        }
    }

    private static byte[] w(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            byte by2;
            String string2 = string.substring(i2, i2 + 2);
            byArray[i2 / 2] = by2 = (byte)(Integer.parseInt(string2, 16) - 128);
        }
        return byArray;
    }

    public void setPassword(String dsPassword) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setPassword *****");
        }
        if (dsPassword == null) {
            this.lw.remove("password");
        } else {
            this.lw.put("password", dsPassword);
        }
    }

    public String getSchema() {
        if (this.lE) {
            return this.lw.getProperty("datasource_schema", "");
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration.getProperty("datasource_schema");
        }
        return this.lw.getProperty("datasource_schema", "");
    }

    public void setSchema(String dsSchema) {
        this.x(dsSchema);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setSchema" + this.getSchema());
        }
        this.lE = true;
    }

    void x(String string) {
        if (string == null) {
            string = "";
        }
        this.lw.put("datasource_schema", string);
    }

    public String getUsername() {
        String string = this.lw.getProperty("user");
        if (string == null && this.lx != null) {
            return this.lx.getUser();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUsername(String dsUsername) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setUserName " + dsUsername);
        }
        if (dsUsername == null) {
            this.lw.remove("user");
        } else {
            this.lw.put("user", dsUsername);
        }
    }

    void b(TableSource tableSource) {
        if (this.lB.contains(tableSource)) {
            return;
        }
        tableSource.setDatasource(this);
        this.lB.addWithRefreshEvent(tableSource);
    }

    public TableSource getTableSource(int idx) {
        return (TableSource)this.lB.get(idx);
    }

    public String getUrl() {
        String string = this.lw.getProperty("datasource_url");
        if (string == null && this.lx != null) {
            return this.lx.getUrl();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUrl(String dsUrl) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "]setUrl " + dsUrl);
        }
        if (dsUrl == null) {
            dsUrl = "";
        }
        this.lw.put("datasource_url", dsUrl);
    }

    public TableSource getTableSource(String alias) throws ReportException {
        TableSource tableSource = this.getTableSourceIfExist(alias);
        if (tableSource == null) {
            throw new ReportException("There is no table source defined with alias \"" + alias + "\"", -1058);
        }
        return tableSource;
    }

    public TableSource getTableSourceIfExist(String alias) {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            if (!tableSource.toString().equals(alias)) continue;
            return tableSource;
        }
        return null;
    }

    public String[] getAliasList() {
        StringList stringList = new StringList(this.getTableSourceCount());
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            stringList.addElement(tableSource.getAlias());
        }
        return stringList.toArray();
    }

    public boolean containsOnlyTables() {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            try {
                if (this.getTableSource(i2).getType() == 1) continue;
                return false;
            }
            catch (ReportException reportException) {
                return false;
            }
        }
        return true;
    }

    public void removeTableSource(TableSource ts) throws ReportException {
        this.c(ts);
        this.lB.removeWithRefreshEvent(ts);
    }

    public TableSource removeTableSourceAt(int idx) throws ReportException {
        TableSource tableSource = (TableSource)this.lB.get(idx);
        this.removeTableSource(tableSource);
        return tableSource;
    }

    void a(TableSource tableSource, Datasource datasource) {
        this.lB.removeWithRefreshEvent(tableSource);
        datasource.b(tableSource);
    }

    private void c(TableSource tableSource) throws ReportException {
        NodeParser nodeParser;
        int n2;
        int n3;
        Fields fields = this.lC.bB.getFields();
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.canRemoveColumn(tableSource.getColumnName(n3));
        }
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.removeColumn(tableSource.getColumnName(n3));
        }
        List<Join> list = this.lC.bB.iY().bV();
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            nodeParser = list.get(n2);
            if (((Join)nodeParser).getSourceTableSource() != tableSource && ((Join)nodeParser).getTargetTableSource() != tableSource) continue;
            list.remove(n2);
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            nodeParser = fields.getPromptField(n2);
            if (((PromptField)nodeParser).za != tableSource) continue;
            ((PromptField)nodeParser).yZ = null;
            ((Field)nodeParser).removeReferenceHolder(tableSource);
            ((PromptField)nodeParser).za = null;
            if (((Field)nodeParser).getRealReferenceCount() != 0) continue;
            fields.removePromptField(n2);
            --n2;
        }
        for (n2 = 0; n2 < fields.getDatabaseFieldsCount(); ++n2) {
            nodeParser = fields.getDatabaseField(n2);
            if (((DatabaseField)nodeParser).kX != tableSource) continue;
            fields.removeDatabaseField(n2);
            --n2;
        }
        tableSource.resetReferences();
        this.lC.bB.getFields().a((Field)null, 3);
    }

    public int getTableSourceCount() {
        return this.lB.size();
    }

    public DataFactory getDataFactory() {
        return this.l(true);
    }

    DataFactory l(boolean bl2) {
        if (bl2) {
            try {
                Connection connection;
                if (this.lC.cE() == 2 && this.ci() && (connection = this.getConnection()) != null) {
                    connection.close();
                }
            }
            catch (ReportException reportException) {
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
        }
        if (this.lA == null) {
            this.lA = new Database();
        }
        return this.lA;
    }

    @Deprecated
    public void setDatabase(Database newDatabase) {
        this.setDataFactory(newDatabase);
    }

    public void setDataFactory(DataFactory newFactory) {
        if (this.getDataSourceConfigurationName().length() == 0) {
            this.lw.put("datasource_name", "database directly");
        }
        this.lA = newFactory;
        this.lF = false;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.ch() + "] used DataFactory " + String.valueOf(newFactory));
        }
    }

    TablesourceList cd() {
        return this.lB;
    }

    void d(StringBuilder stringBuilder, int n2) {
        if (this.lx != null || this.lB.size() > 0 || this.getDataSourceConfigurationName().length() > 0) {
            this.ce();
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Datasource").append(">\n").append("\n");
            ++n2;
            if (this.lx != null && this.lC.bB.getReportProperties().isSaveDatasource()) {
                DataSourceConfigurationXMLFileStore.saveToReportXMLFile(this.lx, stringBuilder, n2);
            } else {
                String string = this.getDataSourceConfigurationName();
                if (string.length() > 0) {
                    stringBuilder.append(BaseUtils.getIndent(n2));
                    stringBuilder.append("<").append("DataSourceConfiguration").append(k.l("name", string)).append(">\n").append("\n");
                    stringBuilder.append(BaseUtils.getIndent(n2));
                    stringBuilder.append("<").append("/").append("DataSourceConfiguration").append(">\n").append("\n");
                }
            }
            for (int i2 = 0; i2 < this.lB.size(); ++i2) {
                ((TableSource)this.lB.get(i2)).d(stringBuilder, n2);
            }
            stringBuilder.append(BaseUtils.getIndent(--n2));
            stringBuilder.append("<").append("/").append("Datasource").append(">\n").append("\n");
        }
    }

    void ce() {
        block33: {
            if (!this.lG || this.lx == null) {
                return;
            }
            String string = Datasource.y(this.getHost());
            String string2 = this.getCatalog();
            String string3 = this.getUsername();
            String string4 = this.getPassword();
            boolean bl2 = this.lC.bB.iY().isSavePassword();
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this.getDataSourceConfigurationName();
            if ("pdsodbc.dll".equals(string5)) {
                stringBuilder.append(string);
                if (string3.length() > 0) {
                    stringBuilder.append('(').append(Datasource.y(string3)).append(')');
                }
            } else if ("pdssql.dll".equals(string5)) {
                stringBuilder.append("MS SQL(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.y(string2)).append(',');
                stringBuilder.append(Datasource.y(string3)).append(')');
            } else if ("pdsora7.dll".equals(string5)) {
                stringBuilder.append("Oracle(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.y(string3)).append(')');
            } else if ("core.dll".equals(string5)) {
                stringBuilder.append("Core");
            } else {
                if (string5.endsWith(".dll")) {
                    string5 = string5.substring(0, string5.length() - 4);
                    string5 = Datasource.y(string5);
                }
                stringBuilder.append(string5).append('(');
                stringBuilder.append(string).append(',');
                stringBuilder.append(string2).append(',');
                stringBuilder.append(string3).append(')');
            }
            if (stringBuilder.length() > 80) {
                stringBuilder.setLength(80);
            }
            String string6 = stringBuilder.toString();
            try {
                DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string6, 3);
                if (dataSourceConfiguration == null) {
                    dataSourceConfiguration = DataSourceConfigurationManager.createDataSourceConfiguration(string6, 4);
                    dataSourceConfiguration.addProperties(this.lx.getProperties());
                    Properties properties = this.ca();
                    String string7 = this.getUrl();
                    String string8 = this.lx.getDriverClassname();
                    if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(string8) && "jdbc:odbc:{0}".equals(string7)) {
                        string7 = "jdbc:odbc:{datasource}";
                        dataSourceConfiguration.addProperty("datasource", string);
                    } else if ("com.inet.tds.TdsDriver".equals(string8) && "jdbc:inetdae7:{0}?database={1}".equals(string7)) {
                        string7 = "jdbc:inetdae7";
                        dataSourceConfiguration.addProperty("host", string);
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("com.inet.ora.OraDriver".equals(string8) && "jdbc:inetora:{0}".equals(string7)) {
                        string7 = "jdbc:inetora";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("sid", stringTokenizer.nextToken());
                        }
                    } else if ("com.mysql.jdbc.Driver".equals(string8) && "jdbc:mysql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:mysql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("org.postgresql.Driver".equals(string8) && "jdbc:postgresql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:postgresql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else {
                        string7 = Datasource.a(string7, properties, this);
                    }
                    dataSourceConfiguration.setUrl(string7);
                    dataSourceConfiguration.setCatalog(string2);
                    dataSourceConfiguration.setUser(string3);
                    dataSourceConfiguration.setPassword(string4);
                    dataSourceConfiguration.setSavePassword(bl2);
                    dataSourceConfiguration.save();
                }
                boolean bl3 = this.lF;
                this.a(dataSourceConfiguration, false);
                this.lF = bl3;
                this.lG = false;
                if (!bl2) {
                    this.setPassword(string4);
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isWarning()) break block33;
                BaseUtils.warning(throwable);
            }
        }
    }

    private static String y(String string) {
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public TableSource createTableSource(String databaseIdentifier, String aliasName) throws ReportException {
        if (aliasName == null) {
            return this.createTableSource(databaseIdentifier);
        }
        TableSource tableSource = new TableSource(databaseIdentifier, aliasName, this.lC, this);
        if (this.lB.contains(tableSource)) {
            return this.getTableSource(aliasName);
        }
        this.b(tableSource);
        return tableSource;
    }

    public TableSource createTableSourceCommand(String aliasName, String sql) throws ReportException {
        return this.createTableSourceCommand(aliasName, sql, true);
    }

    public TableSource createTableSourceCommand(String aliasName, String sql, boolean quoteStringPrompts) throws ReportException {
        if (this.lC.bB.iY().r(aliasName)) {
            throw new ReportException("There already exists a TableSource with the alias name >" + aliasName + "<", 1111);
        }
        TableSource tableSource = new TableSource(aliasName, aliasName, this.lC, this);
        tableSource.setSql(sql);
        tableSource.setQuoteStringPrompts(quoteStringPrompts);
        tableSource.setDatasource(this);
        try {
            tableSource.refresh();
        }
        catch (ReportException reportException) {
            tableSource.resetReferences();
            throw reportException;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        this.b(tableSource);
        return tableSource;
    }

    public TableSource createTableSource(String databaseIdentifier) throws ReportException {
        String string = this.lC.bB.iY().a(databaseIdentifier, this.getDataFactory());
        if (DatabaseUtils.useJdbcDriver(this.lA)) {
            return this.createTableSource(databaseIdentifier, string);
        }
        TableSource tableSource = new TableSource(this.lC, this);
        tableSource.setDatabaseIdentifierName(databaseIdentifier);
        tableSource.av(string);
        if (this.lB.contains(tableSource)) {
            return this.getTableSource(string);
        }
        this.b(tableSource);
        return tableSource;
    }

    TableSource m(String string, String string2) {
        TableSource tableSource;
        try {
            tableSource = this.getTableSource(string2);
            if (tableSource != null) {
                return tableSource;
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        tableSource = new TableSource(this.lC, this);
        tableSource.ax(string);
        tableSource.av(string2);
        this.b(tableSource);
        return tableSource;
    }

    boolean cf() {
        if (this.lE) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_schema").length() > 0;
    }

    boolean cg() {
        if (this.lD) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_catalog").length() > 0;
    }

    public List<String> getSql(boolean keepPromptNames) throws ReportException, SQLException {
        return new b(this.lC.bU()).aM(keepPromptNames).h(this);
    }

    int ch() {
        DatabaseTables databaseTables = this.lC.bB.iY();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            return i2;
        }
        return 0;
    }

    boolean ci() {
        if (this.lA == null) {
            this.lF = true;
        }
        return this.lF;
    }

    public void addConnectionProperty(String property, String value) {
        this.lw.put(property, value);
    }

    public void removeConnectionProperty(String property) {
        this.lw.remove(property);
    }

    public Properties getConnectionProperties() {
        return (Properties)this.lw.clone();
    }

    public void setDataSourceConfigurationName(String dataSourceConfigurationName) {
        this.a(dataSourceConfigurationName, false);
    }

    private void a(String string, boolean bl2) {
        if (string == null) {
            string = "";
        }
        if (DataSourceConfigurationManager.exists(string)) {
            this.a(DataSourceConfigurationManager.getDataSourceConfiguration(string, 3), bl2);
        } else {
            this.lx = null;
        }
        this.lw.put("datasource_name", string);
    }

    public void setDataSourceConfiguration(DataSourceConfiguration dsc) {
        this.a(dsc, false);
    }

    private void a(DataSourceConfiguration dataSourceConfiguration, boolean bl2) {
        block13: {
            String string;
            block12: {
                if (!bl2) {
                    this.lG = false;
                    this.lD = false;
                    this.lE = false;
                    this.lw.clear();
                }
                string = dataSourceConfiguration.getDatabaseClassname();
                String string2 = dataSourceConfiguration.getDriverClassname();
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        LoaderUtils.classForName((String)string2, (Object)this);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ClassNotFoundException && throwable.getMessage() != null && throwable.getMessage().endsWith("com.inet.designer.layout.jdbc.LayoutDriver")) break block12;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("load Driver class from DataSourceConfiguration failed.");
                    }
                    if (!BaseUtils.isDebug()) break block12;
                    BaseUtils.debug(throwable);
                }
            }
            try {
                this.lA = null;
                this.lF = true;
                if (string.length() > 0) {
                    if (lv == null) {
                        lv = ServerPluginManager.getInstance().get(DataFactory.class);
                    }
                    for (DataFactory dataFactory : lv) {
                        if (!dataFactory.getClass().getName().equals(string)) continue;
                        this.lA = dataFactory;
                        this.lF = false;
                        break;
                    }
                    if (this.lA == null) {
                        Class clazz = LoaderUtils.classForName((String)string, (Object)this);
                        this.lA = (DataFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        this.lF = false;
                    }
                }
                if (this.lF) {
                    this.lA = new Database();
                }
                this.lA.setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isDebug()) break block13;
                BaseUtils.debug("load Database class from DataSourceConfiguration failed.");
                BaseUtils.debug(throwable);
            }
        }
        this.lx = dataSourceConfiguration;
    }

    void m(boolean bl2) {
        this.lD = bl2;
    }

    void n(boolean bl2) {
        this.lE = bl2;
    }

    public boolean isUsed() throws ReportException {
        for (TableSource tableSource : this.lB) {
            if (!tableSource.isUsed()) continue;
            return true;
        }
        Fields fields = this.getEngine().getFields();
        for (int i2 = 0; i2 < fields.getSQLExpressionFieldsCount(); ++i2) {
            SQLField sQLField = fields.getSQLExpressionField(i2);
            if (sQLField.getDatasource() != this) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datasource datasource = (Datasource)obj;
        if (this.lw.equals(datasource.lw)) {
            if (this.lx == null) {
                return datasource.lx == null;
            }
            return this.lx.equals(datasource.lx);
        }
        return false;
    }
}

