/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.Progress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class ExportProgress
extends Progress {
    private RenderData byp;
    private final RenderData byq;
    private Properties hu;
    private byte[] byr;
    private int bys;
    private int byt;
    private ArrayList<String> byu;

    public ExportProgress(ReportView parent, RenderData data, Properties exportProps) {
        super(parent, 2);
        this.setIndeterminate(true);
        this.setStatusMessage(null, false);
        this.byq = data;
        this.hu = exportProps;
    }

    ExportProgress(Component parent, ViewerContext viewerContext, RenderData data, Properties exportProps) {
        super(parent, viewerContext, 2);
        this.setStatusMessage(null, false);
        this.byq = data;
        this.hu = exportProps;
    }

    private void setStatusMessage(String message, boolean isError) {
        ReportView reportView = this.getReportView();
        if (reportView != null) {
            reportView.getReportViewer().getViewerContext().showStatusMessage(reportView, message, isError);
        }
    }

    @Override
    public final String getName() {
        return "Export Progress";
    }

    @Override
    public void cancel() {
        this.Nt().stop();
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only used on client side")
    public void run() {
        this.byu = new ArrayList();
        try {
            File file;
            RenderData renderData = this.Nt();
            String string = this.hu.getProperty("export_fmt");
            int n2 = renderData.getExportChunkCount(this.hu);
            this.setIndeterminate(false);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            this.setTotalProgress(n2);
            String string2 = this.hu.getProperty("file");
            if (string.startsWith("htm")) {
                file = this.U(string, string2);
            } else if (string.startsWith("svg")) {
                file = this.U(string, string2);
            } else if (string.equals("jpg") || string.equals("gif") || string.equals("png") || string.equals("bmp")) {
                file = this.y(string2, n2);
            } else {
                byte[] byArray;
                file = new File(string2);
                this.byu.add(file.getPath());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                for (int i2 = 1; i2 <= n2 && (byArray = renderData.getNextExportChunk()) != null; ++i2) {
                    fileOutputStream.write(byArray);
                    this.setProgress(i2);
                }
                fileOutputStream.close();
            }
            this.setStatusMessage(a.getMsg("export.finished"), false);
            this.setStatus(2);
            if (this.hu.getProperty("exportInApplication", "false").equals("true") && file != null) {
                this.h(file);
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.printStackTrace(throwable);
            if (this.getStatus() == 3) {
                ViewerUtils.log("Export: Export canceled by user");
                this.setStatusMessage(a.getMsg("export.canceled"), false);
            } else {
                this.showError(throwable);
                this.setStatusMessage(a.getMsg("export.failed"), true);
                this.setStatus(4);
            }
        }
        finally {
            this.Or();
        }
    }

    public ArrayList<String> getFileNames() {
        return this.byu;
    }

    private final void h(File file) {
        try {
            if (ViewerUtils.useDesktopMethod("open", file)) {
                return;
            }
            ViewerUtils.showDocumentOldMethod(file);
        }
        catch (Throwable throwable) {
            this.showError(new ViewerException(a.getMsg("export.inApplicationFailed"), throwable));
        }
    }

    private int h(byte[] byArray, int n2) {
        return (byArray[n2 + 0] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + (byArray[n2 + 3] << 24);
    }

    private boolean H(int n2, boolean bl2) throws ViewerException {
        int n3 = this.byt - this.bys;
        if (n3 < n2) {
            byte[] byArray = this.Nt().getNextExportChunk();
            this.setProgress(this.getProgress() + 1);
            if (byArray == null) {
                if (bl2) {
                    throw new ViewerException(a.getMsg("error.export.unexpected_end"));
                }
                return false;
            }
            if (this.byr == null) {
                this.byr = byArray;
                this.bys = 0;
                this.byt = byArray.length;
            } else {
                if (this.byr.length - n3 < byArray.length) {
                    byte[] byArray2 = new byte[n3 + byArray.length];
                    System.arraycopy(this.byr, this.bys, byArray2, 0, n3);
                    this.byr = byArray2;
                } else {
                    System.arraycopy(this.byr, this.bys, this.byr, 0, n3);
                }
                this.bys = 0;
                this.byt = n3;
                System.arraycopy(byArray, 0, this.byr, this.byt, byArray.length);
                this.byt += byArray.length;
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT"}, justification="Caller must check it")
    private File U(String string, String object) throws IOException {
        this.bys = 0;
        File file = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.byt > this.bys || this.getTotalProgress() > this.getProgress()) {
            int n2;
            FileOutputStream fileOutputStream;
            String string3;
            this.H(4, true);
            int n3 = this.h(this.byr, this.bys);
            if (n3 == -1) break;
            if (n3 > 512) {
                throw new ViewerException(0, a.getMsg("error.export.data_wrong"), string, null, null, null, 0, new String(this.byr, 0, this.byt));
            }
            this.bys += 4;
            this.H(n3, true);
            Object object2 = new String(this.byr, this.bys, n3, "UTF8");
            if (!bl3) {
                string3 = this.hu.getProperty("layout");
                if (string3 == null) {
                    if (!((String)object).substring(((String)object).lastIndexOf(46)).equals(((String)object2).substring(((String)object2).lastIndexOf(46)))) {
                        object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46)) + ((String)object).substring(((String)object).lastIndexOf(46));
                    }
                    object = ((String)object).substring(0, ((String)object).lastIndexOf(47) + 1) + (String)object2;
                }
                file = new File((String)object);
                file.getParentFile().mkdirs();
                this.byu.add(file.getPath());
                fileOutputStream = new FileOutputStream(file);
                string2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
                bl3 = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(((String)object).substring(0, ((String)object).lastIndexOf(47) + 1));
                stringBuffer.append(string2);
                if (!bl2) {
                    this.dX(stringBuffer.toString());
                    bl2 = true;
                }
                stringBuffer.append('/');
                stringBuffer.append((String)object2);
                string3 = stringBuffer.toString();
                this.byu.add(string3);
                fileOutputStream = new FileOutputStream(string3);
            }
            this.bys += n3;
            this.H(4, true);
            this.bys += 4;
            for (n3 = this.h(this.byr, this.bys); n3 > 0; n3 -= n2) {
                this.H(1, true);
                n2 = Math.min(this.byt - this.bys, n3);
                fileOutputStream.write(this.byr, this.bys, n2);
                this.bys += n2;
            }
            fileOutputStream.close();
        }
        return file;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private File y(String object, int n2) throws IOException {
        Object object2;
        RenderData renderData = this.Nt();
        byte[] byArray = renderData.getNextExportChunk();
        if (byArray.length > 2 && byArray[0] == 80 && byArray[1] == 75 && !((String)object).endsWith(".zip")) {
            object2 = (String)object + ".zip";
            if (new File((String)object2).exists()) {
                int n3 = 1;
                while (new File((String)(object2 = (String)object + "(" + n3++ + ").zip")).exists()) {
                }
            }
            object = object2;
        }
        object2 = new File((String)object);
        this.byu.add(((File)object2).getPath());
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        for (int i2 = 1; i2 <= n2 && byArray != null; ++i2) {
            ((OutputStream)fileOutputStream).write(byArray);
            this.setProgress(1);
            if (i2 >= n2) break;
            byArray = renderData.getNextExportChunk();
        }
        ((OutputStream)fileOutputStream).close();
        return object2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private void dX(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException("\n" + a.getMsg("error.export.cannot_delete") + " " + string);
            }
            file.mkdirs();
        }
    }

    private synchronized RenderData Nt() {
        if (this.byp == null) {
            this.byp = this.byq.getCopy();
        }
        return this.byp;
    }
}

