/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.servlets;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigValue;
import com.inet.config.LicenseInfo;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportKeyFactory;
import com.inet.report.cb;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.servlets.a;
import com.inet.report.servlets.b;
import com.inet.report.statistic.Accumulator;
import com.inet.report.util.ServletUtils;
import com.inet.report.util.WebUtils;
import com.inet.report.util.i;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class ReportPluginServlet
extends HttpServlet
implements PluginServlet {
    private static CopyOnWriteArraySet<String> bsc;
    private static int bsd;
    private static ConfigValue<String> bse;

    @Nonnull
    public String getPathSpec() {
        return "/report";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        com.inet.shared.servlet.ServletUtils.setServletContext((ServletContext)config.getServletContext());
        LogManager.getLogger((String)"Reporting");
        if (bse == null) {
            Thread thread = new Thread("ReportPluginServlet.init"){

                @Override
                public void run() {
                    cb.kG();
                    bse = new ConfigValue<String>(ConfigKey.LICENSEKEY){

                        protected void setValue(@Nullable String value) throws IllegalArgumentException {
                            LicenseInfo licenseInfo = ConfigKeyParser.getCurrent();
                            if (licenseInfo.isValid()) {
                                String string = (String)licenseInfo.getAttributes().get("clientcount");
                                if (string != null) {
                                    bsc = new CopyOnWriteArraySet();
                                    bsd = Integer.parseInt(string);
                                } else {
                                    string = (String)licenseInfo.getAttributes().get("standalone");
                                    if (Boolean.parseBoolean(string)) {
                                        bsc = new CopyOnWriteArraySet();
                                        try {
                                            bsc.add("localhost");
                                            bsc.add("127.0.0.1");
                                            bsc.add("127.0.1.1");
                                            bsc.add(IOFunctions.normalizeIPv6((String)"::1"));
                                            InetAddress inetAddress = NetworkFunctions.getLocalHost();
                                            bsc.add(NetworkFunctions.getLocalHostName().toLowerCase());
                                            bsc.add(inetAddress.getHostAddress().toLowerCase());
                                            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                                            while (enumeration.hasMoreElements()) {
                                                NetworkInterface networkInterface = enumeration.nextElement();
                                                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                                                while (enumeration2.hasMoreElements()) {
                                                    InetAddress inetAddress2 = enumeration2.nextElement();
                                                    bsc.add(inetAddress2.getHostAddress().toLowerCase());
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        bsd = bsc.size();
                                    } else {
                                        bsc = null;
                                        bsd = 0;
                                    }
                                }
                                return;
                            }
                        }
                    };
                }
            };
            thread.start();
        }
    }

    public void destroy() {
        BaseUtils.info("Servlet destroy called");
        Engine.shutdown();
        super.destroy();
    }

    public void doExecRequest(Properties props, HttpServletRequest req, HttpServletResponse res) throws Exception {
        ServletOutputStream servletOutputStream = res.getOutputStream();
        WebUtils.a(req, res, (OutputStream)servletOutputStream, props, (PropertiesChecker)a.bsb.get());
    }

    public void doWriteHtmlPage(Properties props, HttpServletRequest req, HttpServletResponse res) throws IOException, ReportException, ServletException {
        PropertiesChecker propertiesChecker;
        res.setContentType("text/html");
        String string = ReportKeyFactory.getRelevantParamsNoSort(props);
        props.put("report", props.getProperty("http_server_port") + props.getProperty("application_context", "") + props.getProperty("context", "/") + "?" + string);
        try {
            propertiesChecker = (PropertiesChecker)a.bsb.get();
            if (propertiesChecker != null) {
                propertiesChecker.checkHtmlPageProperties(props);
            }
        }
        catch (Exception exception) {
            BaseUtils.warning("Could not check HTML properties:");
            BaseUtils.printStackTrace(exception);
            throw new ReportException(String.valueOf(exception.getMessage()), 0);
        }
        propertiesChecker = res.getOutputStream();
        WebUtils.a(req, res, (OutputStream)((Object)propertiesChecker), props);
    }

    private static final void dE(String string) throws ReportException {
        if (bsc != null) {
            if (string.indexOf(58) >= 0) {
                string = IOFunctions.normalizeIPv6((String)string);
            }
            if (!bsc.contains(string)) {
                bsc.add(string);
                if (bsc.size() > bsd) {
                    bsc.remove(string);
                    String string2 = bsc.toString();
                    String string3 = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getDefaultSupportAddress();
                    throw ReportExceptionFactory.createReportException((ErrorCode)BaseErrorCode.MaxClients, LicenseKeyInfo.getCurrent().getLicenseText(), string2, string, string3);
                }
            }
        }
    }

    public void afterPropertiesStoredHook(HttpServletRequest req, HttpServletResponse res, Properties props) throws ServletException, IOException {
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String string = req.getMethod();
        if (string.equals("HEAD") && req.getRequestURI().endsWith("/reportserver")) {
            res.setStatus(204);
            return;
        }
        Accumulator.incTotalRequest();
        Properties properties = com.inet.shared.servlet.ServletUtils.getAllParameters((HttpServletRequest)req);
        i.n(properties);
        try {
            ReportKeyFactory.decodeProps(properties);
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        String string2 = req.getHeader("Cookie");
        if (string2 != null && string2.length() > 0) {
            properties.put("cookie", string2);
        }
        ServletUtils.setContextProperties(req, properties);
        properties.put("locale", ClientLocale.getThreadLocale().toString());
        if (!properties.containsKey("timezone")) {
            properties.put("timezone", ClientTimezone.getTimeZone().getID());
        }
        try {
            this.afterPropertiesStoredHook(req, res, properties);
            b.a(properties, "after properties stored");
            b.m(properties);
            ReportPluginServlet.dE(SessionStore.getRemoteAddr());
            Accumulator.incReportRequest();
            boolean bl2 = cb.g(properties);
            if (bl2) {
                this.doExecRequest(properties, req, res);
            } else {
                String string3 = properties.getProperty("password", null);
                if (string3 != null) {
                    properties.put("password", RDC.encrypt(string3));
                }
                this.doWriteHtmlPage(properties, req, res);
            }
        }
        catch (Exception exception) {
            ServletErrorHandler.sendErrorPage((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)exception);
        }
    }
}

