/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository;

import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.url.PermissionUrlObject;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.Subreport;
import com.inet.report.SummaryInfo;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.report.translation.Translations;
import com.inet.report.translation.Translator;
import com.inet.repository.CCResource;
import com.inet.repository.RepositoryException;
import com.inet.repository.RepositoryResourceParser;
import com.inet.repository.RepositorySearchEngine;
import com.inet.repository.RepositoryServerPlugin;
import com.inet.repository.i18n.RepositoryErrorCode;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;

public class a
implements RepositoryResourceParser {
    public Map<String, Object> parseResource(CCResource resource) {
        HashMap<String, Object> hashMap = null;
        try (InputStream inputStream = resource.getDataStream(false);){
            URL uRL = null;
            try {
                uRL = new URL("repo", null, resource.getRelativePath());
            }
            catch (Throwable throwable) {
                try {
                    uRL = resource.getLocation().toURL();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            Engine engine = RDC.loadEngine(uRL, inputStream, null, null);
            SummaryInfo summaryInfo = engine.getSummaryInfo();
            hashMap = new HashMap<String, Object>(10);
            hashMap.put(RepositorySearchEngine.ItemKeys.TITLE.name(), summaryInfo.getReportTitle());
            hashMap.put(RepositorySearchEngine.ItemKeys.AUTHOR.name(), summaryInfo.getAuthor());
            hashMap.put(RepositorySearchEngine.ItemKeys.KEYWORDS.name(), summaryInfo.getKeywords());
            hashMap.put(RepositorySearchEngine.ItemKeys.SUBJECT.name(), summaryInfo.getSubject());
            hashMap.put(RepositorySearchEngine.ItemKeys.LASTSAVED.name(), summaryInfo.getLastSaved().getTime());
            hashMap.put(RepositorySearchEngine.ItemKeys.CREATED.name(), summaryInfo.getCreated().getTime());
            hashMap.put(RepositorySearchEngine.ItemKeys.TEXT.name(), this.t(engine).toString());
            HashSet<String> hashSet = this.u(engine);
            hashMap.put(RepositorySearchEngine.ItemKeys.COMMENTS.name(), summaryInfo.getComments());
            StringBuilder stringBuilder = new StringBuilder(100);
            for (String string : hashSet) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
            hashMap.put(RepositorySearchEngine.ItemKeys.ELEMENTS.name(), stringBuilder.toString().trim());
        }
        catch (FileNotFoundException fileNotFoundException) {
            BaseUtils.error(RepositoryServerPlugin.REPOSITORY_MSG.getMsg("RptNotIndexed", new Object[]{resource.getLocation()}));
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(new RepositoryException((Throwable)fileNotFoundException, RepositoryErrorCode.RptNotIndexed, resource.getLocation()));
            }
        }
        catch (ReportException reportException) {
            if (reportException.getErrorCode() == ReportErrorCode.InvalidRpt.getErrorCodeNumber() || reportException.getErrorCode() == ReportErrorCode.InvalidMimeType.getErrorCodeNumber()) {
                return hashMap;
            }
            BaseUtils.error(RepositoryServerPlugin.REPOSITORY_MSG.getMsg("RptNotIndexed", new Object[]{resource.getLocation()}));
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(new RepositoryException((Throwable)reportException, RepositoryErrorCode.RptNotIndexed, resource.getLocation()));
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            BaseUtils.error(new RepositoryException((Throwable)exception, RepositoryErrorCode.RptNotIndexed, resource.getLocation()));
        }
        catch (Throwable throwable) {
            BaseUtils.error(new RepositoryException(throwable, RepositoryErrorCode.RptNotIndexed, resource.getLocation()));
        }
        return hashMap;
    }

    public Image getPreview(CCResource resource) {
        BufferedImage bufferedImage = null;
        try {
            byte[] byArray = resource.getThumbnail();
            if (byArray != null) {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            }
        }
        catch (MalformedURLException malformedURLException) {
            BaseUtils.error(malformedURLException);
        }
        catch (IOException iOException) {
            BaseUtils.error(iOException);
        }
        return bufferedImage;
    }

    private StringBuilder t(Engine engine) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set<String> set = new Translator(engine).listLabels(false);
            for (String object2 : set) {
                stringBuilder.append(object2);
                stringBuilder.append(" ");
            }
            Translations translations = engine.getTranslations();
            List<Locale> list = translations.getAvailableLocales();
            for (Locale locale : list) {
                Properties properties = translations.getTranslation(locale);
                for (Object object : properties.values()) {
                    stringBuilder.append(object);
                    stringBuilder.append(" ");
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
        return stringBuilder;
    }

    private HashSet<String> u(Engine engine) {
        HashSet<String> hashSet = new HashSet<String>(5);
        try {
            List<Section> list = engine.getSections();
            for (Section section : list) {
                hashSet.addAll(this.t(section));
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
        return hashSet;
    }

    private HashSet<String> t(Section section) throws ReportException {
        HashSet<String> hashSet = new HashSet<String>(4);
        block12: for (Element element : section.getElements()) {
            switch (element.getType()) {
                case 36: {
                    hashSet.add("Field");
                    continue block12;
                }
                case 42: {
                    hashSet.add("Diagram");
                    continue block12;
                }
                case 48: {
                    hashSet.add("BlobField");
                    continue block12;
                }
                case 46: {
                    hashSet.add("Picture");
                    continue block12;
                }
                case 68: {
                    hashSet.add("JavaBean");
                    continue block12;
                }
                case 35: {
                    hashSet.add("Text");
                    continue block12;
                }
                case 49: {
                    hashSet.add("Crosstab");
                    continue block12;
                }
                case 37: {
                    hashSet.add("Line");
                    continue block12;
                }
                case 38: {
                    hashSet.add("Box");
                    continue block12;
                }
                case 39: {
                    hashSet.add("Subreport");
                    Subreport subreport = (Subreport)element;
                    hashSet.addAll(this.u(subreport.getEngine()));
                }
            }
        }
        return hashSet;
    }

    public void afterCreateNew(CCResource createdResource) {
        block4: {
            try {
                Cache cache = Cache.getCache();
                if (cache != null) {
                    for (ReportCacheKey reportCacheKey : cache.getReports()) {
                        String string = reportCacheKey.getReport();
                        String string2 = createdResource.getRelativePath();
                        if (string2 == null || !("repo:" + string2).equalsIgnoreCase(string)) continue;
                        cache.delete(reportCacheKey);
                    }
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug(reportException);
            }
        }
    }

    public PermissionUrlObject modifySystemPermissions(PermissionUrlObject systemPermissions) {
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID != null) {
            int n2 = systemPermissions.getUserPermission(gUID);
            boolean bl2 = SystemPermissionChecker.checkAccess((Permission)ReportingServerPlugin.PERMISSION_EXECUTE_ALL_REPORTS);
            if (n2 > 0) {
                if (!bl2) {
                    systemPermissions.removeUserPermission(gUID, 1);
                }
            } else if (bl2) {
                systemPermissions.addUserPermission(gUID, 1);
            }
        }
        return systemPermissions;
    }

    public int checkPermissionToAdd(String resourceName) {
        if (SystemPermissionChecker.checkAccess((Permission)ReportingServerPlugin.PERMISSION_EXECUTE_ALL_REPORTS) && (resourceName.endsWith(".rpt") || resourceName.endsWith(".dataview"))) {
            return 1;
        }
        return 0;
    }
}

