/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class LdapDataFactory
extends BaseDataFactory {
    private String url;
    private static final String[] abG = new String[]{"namingContexts"};

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="schema is internally created and not used from user input")
    public TableData getTableSourceData(@Nonnull TableSource ts, List<DatabaseField> columns) throws ReportException {
        int n2 = columns.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = columns.get(i2).getShortName();
        }
        String[] stringArray2 = DatabaseUtils.parseSourceName(this.getConfiguration(), ts.getDatabaseIdentifier());
        Datasource datasource = ts.getDatasource();
        DirContext dirContext = this.g(datasource);
        try {
            if (stringArray2[1] != null) {
                dirContext = (DirContext)dirContext.lookup(stringArray2[1]);
            }
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(stringArray2[2], null, stringArray);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Object[] objectArray = new Object[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Attribute attribute = attributes.get(stringArray[i3]);
                    if (attribute == null || attribute.size() != 1) continue;
                    objectArray[i3] = attribute.get(0);
                }
                arrayList.add(objectArray);
            }
            return new TableData(stringArray, arrayList);
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="schema is internally created and not used from user input")
    public List<ColumnInfo> getColumns(@Nonnull Datasource ds, String catalog, String schema, String name, int type) throws ReportException {
        ArrayList<ColumnInfo> arrayList;
        block7: {
            arrayList = new ArrayList<ColumnInfo>();
            DirContext dirContext = this.g(ds);
            try {
                NamingEnumeration<SearchResult> namingEnumeration;
                if (schema != null) {
                    dirContext = (DirContext)dirContext.lookup(schema);
                }
                if (!(namingEnumeration = dirContext.search(name, null)).hasMoreElements()) break block7;
                SearchResult searchResult = namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = searchResult.getAttributes().getAll();
                try {
                    while (namingEnumeration2.hasMoreElements()) {
                        Attribute attribute = namingEnumeration2.next();
                        ColumnInfo columnInfo = new ColumnInfo(attribute.getID(), 11);
                        arrayList.add(columnInfo);
                    }
                }
                catch (SizeLimitExceededException sizeLimitExceededException) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.printStackTrace(sizeLimitExceededException);
                    }
                }
            }
            catch (Exception exception) {
                throw ReportExceptionFactory.createReportExceptionWithCause(exception);
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        InitialLdapContext initialLdapContext = this.g(ds);
        try {
            Object object;
            Serializable serializable;
            URI uRI = new URI(this.url);
            String string = uRI.getPath();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string == null || string.isEmpty() || string.equals("/")) {
                serializable = initialLdapContext.getAttributes("", abG);
                Attribute attribute = serializable.get(abG[0]);
                int n2 = attribute.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = attribute.get(i2);
                    if (object == null) continue;
                    arrayList.add(object.toString());
                }
            } else {
                arrayList.add("");
            }
            serializable = null;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                String string2 = (String)arrayList.get(i3);
                NamingEnumeration<NameClassPair> namingEnumeration = initialLdapContext.list(string2);
                try {
                    while (namingEnumeration.hasMoreElements()) {
                        object = namingEnumeration.next();
                        TableSourceInfo tableSourceInfo = new TableSourceInfo(null, string2, ((NameClassPair)object).getName(), 0);
                        hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                    }
                    continue;
                }
                catch (ClassCastException | NamingException exception) {
                    serializable = exception;
                    if (!BaseUtils.isDebug()) continue;
                    BaseUtils.printStackTrace((Throwable)serializable);
                }
            }
            if (hashMap.size() == 0 && serializable != null) {
                throw serializable;
            }
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
        return hashMap;
    }

    @Nonnull
    private InitialLdapContext g(@Nonnull Datasource datasource) throws ReportException {
        Object object;
        DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
        if (dataSourceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        this.url = dataSourceConfiguration.getProperty("ldapurl");
        if (this.url.isEmpty()) {
            object = System.getenv("LOGONSERVER");
            this.url = object != null ? "ldap:" + ((String)object).replace('\\', '/') : "ldap://localhost:389";
        }
        object = new Hashtable();
        ((Hashtable)object).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Hashtable)object).put("java.naming.provider.url", this.url);
        ((Hashtable)object).put("java.naming.security.authentication", "simple");
        ((Hashtable)object).put("java.naming.security.principal", dataSourceConfiguration.getUser());
        ((Hashtable)object).put("java.naming.security.credentials", dataSourceConfiguration.getPassword());
        try {
            return new InitialLdapContext((Hashtable<?, ?>)object, null);
        }
        catch (NamingException namingException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(namingException);
        }
    }
}

