/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.annotations.PublicApi;
import com.inet.classloader.LoaderUtils;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.database.DataSourceValidator;
import com.inet.report.i18n.ReportErrorCode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@PublicApi
@SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="empty string is not a password")
public class DataSourceConfiguration
implements Serializable,
Comparable {
    private final String aai;
    private final int aaj;
    private final GUID aak;
    private String aal = "";
    private String aam = "";
    private String url = "";
    private String aan = "";
    private boolean lm = true;
    private String aao = "";
    private DatabaseConfiguration aap = DatabaseConfiguration.getDefault();
    public static final String PROPERTY_CATALOG = "catalog";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_SAVE_PASSWORD = "savePassword";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_SUPPORTS_SQL92 = "supportsSQL92";
    public static final String PROPERTY_SUPPORTS_ORDERBY = "supportsOrderBy";
    public static final String PROPERTY_SUPPORTS_WHERE = "supportsWhere";
    public static final String PROPERTY_DRIVER_CLASSNAME = "driverClassName";
    public static final String PROPERTY_DATABASE_CLASSNAME = "databaseClassName";
    public static final String PROPERTY_QUOTES_LOWER_CASE = "quotesLowerCase";
    public static final String PROPERTY_USE_PARENTHESES_FOR_JOIN = "supportsParenthesesForJoin";
    public static final String PROPERTY_IDENTIFIER_QUOTE_STRING = "identifierQuoteString";
    public static final String PROPERTY_ALIASTOKEN = "aliasToken";
    public static final String PROPERTY_ESCAPE_EVERYTHING = "escapeEverything";
    public static final String PROPERTY_VALIDATION_QUERY = "validationQuery";
    public static final String PROPERTY_INITSQL = "initSQL";
    public static final String PROPERTY_ALLOWED_USERGROUPS = "allowedUserGroups";
    private Properties aaq = new Properties();

    @Deprecated
    public DataSourceConfiguration(String configurationName) {
        this(configurationName, 0);
        LogManager.deprecatedMessage();
    }

    public DataSourceConfiguration(String configurationName, int scope) {
        this(configurationName, scope, null);
    }

    DataSourceConfiguration(String configurationName, int scope, @Nullable GUID uid) {
        this.aaq.put(PROPERTY_USER, "");
        this.aaq.put(PROPERTY_PASSWORD, "");
        this.aai = configurationName == null ? "" : configurationName;
        this.aaj = scope;
        if (scope == 3) {
            throw new IllegalArgumentException("Invalid value for parameter 'preferenceScope'");
        }
        this.aak = uid == null ? GUID.generateNew() : uid;
    }

    public int getScope() {
        return this.aaj;
    }

    public GUID getUID() {
        return this.aak;
    }

    @Nonnull
    public DatabaseConfiguration getDatabaseConfiguration() {
        return (DatabaseConfiguration)this.aap.clone();
    }

    public int hashCode() {
        return this.aai.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSourceConfiguration dataSourceConfiguration = (DataSourceConfiguration)obj;
        return Objects.equals(this.aai, dataSourceConfiguration.aai) && Objects.equals(this.aan, dataSourceConfiguration.aan) && Objects.equals(this.aam, dataSourceConfiguration.aam) && Objects.equals(this.aap, dataSourceConfiguration.aap) && Objects.equals(this.aal, dataSourceConfiguration.aal) && Objects.equals(this.aaq, dataSourceConfiguration.aaq) && Objects.equals(this.url, dataSourceConfiguration.url) && Objects.equals(this.aao, dataSourceConfiguration.aao) && this.lm == dataSourceConfiguration.lm;
    }

    public void putStylesheetDefaultValues(DriverStyleSheet dss) {
        this.addProperty(PROPERTY_URL, dss.getUrl());
        this.addProperty(PROPERTY_DRIVER_CLASSNAME, dss.getDriverClassName());
        for (int i2 = 0; i2 < dss.getPropertyCount(); ++i2) {
            DriverProperty driverProperty = dss.getDriverProperty(i2);
            this.addProperty(driverProperty.getName(), driverProperty.getDefaultValue());
        }
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("The DataSource configuration property must not be null.");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("The DataSource configuration property must not be empty.");
        }
        DataSourceConfigurationManager.a(this, key, this.getProperty(key), value);
        if (key.equals(PROPERTY_SUPPORTS_SQL92)) {
            this.setUseSQL92syntax("true".equals(value));
        } else if (key.equals(PROPERTY_SUPPORTS_ORDERBY)) {
            this.setUseOrderBy("true".equals(value));
        } else if (key.equals(PROPERTY_SUPPORTS_WHERE)) {
            this.setUseWhereClause("true".equals(value));
        } else if (key.equals(PROPERTY_QUOTES_LOWER_CASE)) {
            this.setUseQuoteLowerCase("true".equals(value));
        } else if (key.equals(PROPERTY_USE_PARENTHESES_FOR_JOIN)) {
            this.setUseParenthesiseForJoin("true".equals(value));
        } else if (key.equals(PROPERTY_DRIVER_CLASSNAME)) {
            this.aal = value;
        } else if (key.equals(PROPERTY_DATABASE_CLASSNAME)) {
            this.aam = value;
        } else if (key.equals(PROPERTY_IDENTIFIER_QUOTE_STRING)) {
            this.setIdentifierQuoteString(value);
        } else if (key.equals(PROPERTY_ALIASTOKEN)) {
            this.setAliasToken(value);
        } else if (key.equals(PROPERTY_URL)) {
            this.url = value;
        } else if (key.equals(PROPERTY_CATALOG)) {
            this.aan = value;
        } else if (key.equals(PROPERTY_ESCAPE_EVERYTHING)) {
            this.setUseEscapeEverything("true".equals(value));
        } else if (key.equals(PROPERTY_SAVE_PASSWORD)) {
            this.setSavePassword("true".equals(value));
        } else if (key.equals(PROPERTY_ALLOWED_USERGROUPS)) {
            this.aao = value;
        } else {
            this.aaq.put(key, value);
        }
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Object[] objectArray = properties.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = (String)objectArray[i2];
            if (string.length() <= 0) continue;
            this.addProperty(string, (String)properties.get(objectArray[i2]));
        }
    }

    public void removeProperties(Set<String> keys) {
        HashSet<String> hashSet = new HashSet<String>(){
            {
                this.add(DataSourceConfiguration.PROPERTY_SUPPORTS_SQL92);
                this.add(DataSourceConfiguration.PROPERTY_SUPPORTS_ORDERBY);
                this.add(DataSourceConfiguration.PROPERTY_SUPPORTS_WHERE);
                this.add(DataSourceConfiguration.PROPERTY_QUOTES_LOWER_CASE);
                this.add(DataSourceConfiguration.PROPERTY_USE_PARENTHESES_FOR_JOIN);
                this.add(DataSourceConfiguration.PROPERTY_DRIVER_CLASSNAME);
                this.add(DataSourceConfiguration.PROPERTY_DATABASE_CLASSNAME);
                this.add(DataSourceConfiguration.PROPERTY_IDENTIFIER_QUOTE_STRING);
                this.add(DataSourceConfiguration.PROPERTY_ALIASTOKEN);
                this.add(DataSourceConfiguration.PROPERTY_URL);
                this.add(DataSourceConfiguration.PROPERTY_CATALOG);
                this.add(DataSourceConfiguration.PROPERTY_ESCAPE_EVERYTHING);
                this.add(DataSourceConfiguration.PROPERTY_SAVE_PASSWORD);
            }
        };
        keys.forEach(string -> {
            DataSourceConfigurationManager.a(this, string, this.getProperty((String)string), null);
            if (hashSet.contains(string)) {
                this.addProperty((String)string, "");
            } else {
                this.aaq.remove(string);
            }
        });
    }

    public boolean isUseOrderBy() {
        return this.aap.isUseOrderBy();
    }

    public void setUseOrderBy(boolean useOrderBy) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_ORDERBY, Boolean.toString(this.isUseOrderBy()), Boolean.toString(useOrderBy));
        this.aap.setUseOrderBy(useOrderBy, true);
    }

    public boolean isUseParenthesiseForJoin() {
        return this.aap.isUseParenthesiseForJoin();
    }

    public void setUseParenthesiseForJoin(boolean useParenthesiseForJoin) {
        DataSourceConfigurationManager.a(this, PROPERTY_USE_PARENTHESES_FOR_JOIN, Boolean.toString(this.isUseParenthesiseForJoin()), Boolean.toString(useParenthesiseForJoin));
        this.aap.setUseParenthesiseForJoin(useParenthesiseForJoin, true);
    }

    public boolean isUseQuoteLowerCase() {
        return this.aap.isUseQuoteLowerCase();
    }

    public void setUseQuoteLowerCase(boolean useQuoteLowerCase) {
        DataSourceConfigurationManager.a(this, PROPERTY_QUOTES_LOWER_CASE, Boolean.toString(this.isUseQuoteLowerCase()), Boolean.toString(useQuoteLowerCase));
        this.aap.setUseQuoteLowerCase(useQuoteLowerCase, true);
    }

    public boolean isUseSQL92syntax() {
        return this.aap.isUseSQL92syntax();
    }

    public void setUseSQL92syntax(boolean useSQL92syntax) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_SQL92, Boolean.toString(this.isUseSQL92syntax()), Boolean.toString(useSQL92syntax));
        this.aap.setUseSQL92syntax(useSQL92syntax, false, true);
    }

    public boolean isUseWhereClause() {
        return this.aap.isUseWhereClause();
    }

    public void setUseWhereClause(boolean useWhereClause) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_WHERE, Boolean.toString(this.isUseWhereClause()), Boolean.toString(useWhereClause));
        this.aap.setUseWhereClause(useWhereClause, true);
    }

    public String getAliasToken() {
        return this.aap.getAliasToken();
    }

    public void setAliasToken(String aliasToken) {
        DataSourceConfigurationManager.a(this, PROPERTY_ALIASTOKEN, this.getAliasToken(), aliasToken);
        this.aap.setAliasToken(aliasToken, true);
    }

    public boolean isUseEscapeEverything() {
        return this.aap.isUseEscapeEverything();
    }

    public void setUseEscapeEverything(boolean escapeEverything) {
        DataSourceConfigurationManager.a(this, PROPERTY_ESCAPE_EVERYTHING, Boolean.toString(this.isUseEscapeEverything()), Boolean.toString(escapeEverything));
        this.aap.setUseEscapeEverything(escapeEverything, true);
    }

    public String getIdentifierQuoteString() {
        return this.aap.getIdentifierQuoteString();
    }

    public void setIdentifierQuoteString(String identifierQuoteString) {
        DataSourceConfigurationManager.a(this, PROPERTY_IDENTIFIER_QUOTE_STRING, this.getIdentifierQuoteString(), identifierQuoteString);
        this.aap.setIdentifierQuoteString(identifierQuoteString, true);
    }

    public String getDriverClassname() {
        return this.aal;
    }

    public String getDatabaseClassname() {
        return this.aam;
    }

    public void setDriverClassname(String classname) {
        DataSourceConfigurationManager.a(this, PROPERTY_DRIVER_CLASSNAME, this.getDriverClassname(), classname);
        this.aal = classname;
    }

    public void setDatabaseClassname(String classname) {
        DataSourceConfigurationManager.a(this, PROPERTY_DATABASE_CLASSNAME, this.getDatabaseClassname(), classname);
        this.aam = classname == null ? "" : classname;
    }

    public String getConfigurationName() {
        return this.aai;
    }

    public String toString() {
        return this.aai;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        DataSourceConfigurationManager.a(this, PROPERTY_URL, this.getUrl(), url);
        this.url = url;
    }

    public Properties getProperties() {
        Properties properties = (Properties)this.aaq.clone();
        properties.put(PROPERTY_DRIVER_CLASSNAME, this.aal);
        properties.put(PROPERTY_DATABASE_CLASSNAME, this.aam);
        properties.put(PROPERTY_URL, this.url);
        properties.put(PROPERTY_CATALOG, this.aan);
        properties.put(PROPERTY_SAVE_PASSWORD, this.lm ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_SQL92, this.aap.isUseSQL92syntax() ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_ORDERBY, this.aap.isUseOrderBy() ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_WHERE, this.aap.isUseWhereClause() ? "true" : "false");
        properties.put(PROPERTY_USE_PARENTHESES_FOR_JOIN, this.aap.isUseParenthesiseForJoin() ? "true" : "false");
        properties.put(PROPERTY_QUOTES_LOWER_CASE, this.aap.isUseQuoteLowerCase() ? "true" : "false");
        properties.put(PROPERTY_IDENTIFIER_QUOTE_STRING, this.aap.getIdentifierQuoteString() != null ? this.aap.getIdentifierQuoteString() : "");
        properties.put(PROPERTY_ALIASTOKEN, this.aap.getAliasToken() != null ? this.aap.getAliasToken() : "");
        properties.put(PROPERTY_ESCAPE_EVERYTHING, this.aap.isUseEscapeEverything() ? "true" : "false");
        properties.put(PROPERTY_ALLOWED_USERGROUPS, this.aao);
        return properties;
    }

    public String[] getDriverSpecificProperties() {
        Object[] objectArray = this.aaq.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = objectArray[i2].toString();
        }
        return stringArray;
    }

    @Nonnull
    public String getProperty(String key) {
        String string = this.aaq.getProperty(key);
        if (string != null) {
            return string;
        }
        switch (key) {
            case "driverClassName": {
                return this.aal;
            }
            case "databaseClassName": {
                return this.aam;
            }
            case "url": {
                return this.url;
            }
            case "catalog": {
                return this.aan;
            }
            case "savePassword": {
                return this.lm ? "true" : "false";
            }
            case "supportsSQL92": {
                return this.aap.isUseSQL92syntax() ? "true" : "false";
            }
            case "supportsOrderBy": {
                return this.aap.isUseOrderBy() ? "true" : "false";
            }
            case "supportsWhere": {
                return this.aap.isUseWhereClause() ? "true" : "false";
            }
            case "supportsParenthesesForJoin": {
                return this.aap.isUseParenthesiseForJoin() ? "true" : "false";
            }
            case "quotesLowerCase": {
                return this.aap.isUseQuoteLowerCase() ? "true" : "false";
            }
            case "identifierQuoteString": {
                return this.aap.getIdentifierQuoteString() != null ? this.aap.getIdentifierQuoteString() : "";
            }
            case "aliasToken": {
                return this.aap.getAliasToken() != null ? this.aap.getAliasToken() : "";
            }
            case "escapeEverything": {
                return this.aap.isUseEscapeEverything() ? "true" : "false";
            }
            case "allowedUserGroups": {
                return this.aao;
            }
        }
        return "";
    }

    public String getCatalog() {
        if (!StringFunctions.isEmpty((String)this.aan)) {
            return this.aan;
        }
        String string = this.aaq.getProperty("database");
        if (!StringFunctions.isEmpty((String)string)) {
            return string;
        }
        return "";
    }

    public void setCatalog(String catalog) {
        if (catalog == null) {
            catalog = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_CATALOG, this.getUrl(), this.url);
        this.aan = catalog;
    }

    public String getUser() {
        return this.aaq.getProperty(PROPERTY_USER, "");
    }

    public void setUser(String user) {
        if (user == null) {
            user = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_USER, this.getUser(), user);
        this.aaq.setProperty(PROPERTY_USER, user);
    }

    public String getPassword() {
        return this.aaq.getProperty(PROPERTY_PASSWORD, "");
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_PASSWORD, this.getPassword(), password);
        this.aaq.setProperty(PROPERTY_PASSWORD, password);
    }

    public void setSavePassword(boolean savePassword) {
        this.lm = savePassword;
    }

    public boolean isSavePassword() {
        return this.lm;
    }

    public boolean isNeedPassword() {
        DriverStyleSheet driverStyleSheet = DriverStyleSheetFactory.getInstance(Locale.getDefault()).getDriverStylesheetByDataSourceConfiguration(this);
        if (driverStyleSheet == null) {
            return true;
        }
        for (int i2 = 0; i2 < driverStyleSheet.getPropertyCount(); ++i2) {
            DriverProperty driverProperty = driverStyleSheet.getDriverProperty(i2);
            if (!PROPERTY_PASSWORD.equals(driverProperty.getName())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void save(int scope) throws SecurityException {
        DataSourceConfigurationManager.a(this, scope);
    }

    public void save() {
        this.save(this.aaj);
    }

    public static Driver getDriverObject(Class<?> c2) {
        Driver driver;
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            driver = enumeration.nextElement();
            if (!driver.getClass().getName().equals(c2.getName())) continue;
            return driver;
        }
        try {
            driver = (Driver)c2.newInstance();
            return driver;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Driver getDriverObject(String c2) {
        try {
            return DataSourceConfiguration.getDriverObject(LoaderUtils.getUpdateableClassLoader().loadClass(c2));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public SQLWarning validate() throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException, SQLException, ReportException {
        try {
            return DataSourceValidator.validate(this);
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    private Connection getConnection() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, ReportException {
        String string = this.getDriverClassname();
        Driver driver = null;
        if (string != null && string.trim().length() != 0) {
            driver = (Driver)LoaderUtils.classForName((String)string, (Object)this).newInstance();
            DriverManager.registerDriver(driver);
            Properties properties = (Properties)this.aaq.clone();
            String string2 = DataSourceConfiguration.adaptUrl(this.getUrl(), properties);
            Object object = properties.keySet().toArray(new String[properties.size()]);
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                String string3 = properties.getProperty(object[i2]);
                if (string3 != null && string3.length() != 0) continue;
                properties.remove(object[i2]);
            }
            if (driver != null) {
                object = driver.connect(string2, properties);
                if (object == null) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_InvalidDrvUrl, string2, string);
                }
                return object;
            }
        }
        return null;
    }

    public List<String> getCatalogs() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, ReportException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            if (connection != null) {
                ResultSet resultSet = connection.getMetaData().getCatalogs();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                resultSet.close();
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
        }
        return null;
    }

    public static String adaptUrl(String url, Properties driverProps) {
        int n2 = 0;
        while (((String)url).indexOf(123, n2) != -1) {
            int n3;
            int n4;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. " + (String)url);
            }
            if ((n4 = ((String)url).indexOf(123, n2)) > (n3 = ((String)url).indexOf(125, n2))) break;
            String string = ((String)url).substring(n4 + 1, n3);
            String string2 = driverProps.getProperty(string);
            if (string2 != null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. replace \"{" + string + "}\" with \"" + string2 + "\"");
                }
                driverProps.remove(string);
                url = ((String)url).substring(0, n4) + string2 + ((String)url).substring(n3 + 1, ((String)url).length());
                continue;
            }
            n2 = n3 + 1;
        }
        return url;
    }

    public void setValidationQuery(String validationQuery) {
        this.aaq.put(PROPERTY_VALIDATION_QUERY, validationQuery);
    }

    public String getValidationQuery() {
        return this.aaq.getProperty(PROPERTY_VALIDATION_QUERY);
    }

    public int compareTo(Object o2) {
        return this.aai.compareTo(((DataSourceConfiguration)o2).aai);
    }

    void setQuiet(boolean quiet) {
        this.aap.setQuiet(quiet);
    }

    public boolean isLayoutDataSource() {
        return "LayoutDatasource".endsWith(this.aai);
    }

    public Set<GUID> getAllowedUserGroups() {
        String string2 = this.getProperty(PROPERTY_ALLOWED_USERGROUPS);
        if (string2 == null || string2.length() == 0) {
            return Collections.emptySet();
        }
        List<String> list = Arrays.asList(string2.split(","));
        return list.stream().map(string -> GUID.valueOf((String)string)).collect(Collectors.toSet());
    }

    public void setAllowedUserGroups(Set<GUID> allowedUserGroups) {
        String string = String.join((CharSequence)",", allowedUserGroups.stream().map(GUID::toString).collect(Collectors.toList()));
        if (string == null) {
            string = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_ALLOWED_USERGROUPS, this.getProperty(PROPERTY_ALLOWED_USERGROUPS), string);
        this.addProperty(PROPERTY_ALLOWED_USERGROUPS, string);
    }
}

