/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;

@PublicApi
public class NumberRange
implements Serializable {
    private Double XM;
    private Double XN;
    private boolean vz;

    public NumberRange() {
        this.vz = true;
    }

    public NumberRange(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.vz = false;
        this.XM = new Double(lower);
        this.XN = new Double(upper);
    }

    public boolean isAutoRange() {
        return this.vz;
    }

    public void setAutoRange(boolean autoRange) {
        this.vz = autoRange;
    }

    public Double getLowerBound() {
        if (this.XM == null) {
            return null;
        }
        return this.XM;
    }

    public void setLowerBound(Double lower) {
        if (this.XN != null && lower > this.XN) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.XM = lower;
    }

    public Double getUpperBound() {
        if (this.XN == null) {
            return null;
        }
        return this.XN;
    }

    public void setUpperBound(Double upper) {
        if (this.XM != null && upper < this.XM) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.XN = upper;
    }

    boolean mS() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeNumber");
            buffer.append(' ');
            if (this.XM != null) {
                f.b(buffer, "lowerBound", this.XM.toString());
            }
            if (this.XN != null) {
                f.b(buffer, "upperBound", this.XN.toString());
            }
            buffer.append("/");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element) {
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            this.setLowerBound(new Double(string));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            this.setUpperBound(new Double(string));
        }
    }
}

