/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.ChartTitle;
import com.inet.report.chart.axis.AbstractMarker;
import com.inet.report.chart.axis.AxisPosition;
import com.inet.report.chart.axis.c;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.i;
import com.inet.report.j;
import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@PublicApi
public class BaseAxis
implements Serializable {
    public static final int DEFAULT_TICK_LABEL_COLOR = 0;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_GRIDLINE_COLOR = ColorUtils.toCcColor((Color)Color.lightGray);
    public static final int DEFAULT_AXIS_LINE_COLOR = ColorUtils.toCcColor((Color)new Color(221, 221, 221));
    public static final ChartTitle DEFAULT_TITLE = new ChartTitle(new Font("SansSerif", 1, 14), 0);
    public static final String TOKEN_CATEGORY_AXIS = "CategoryAxis";
    public static final String TOKEN_SERIES_AXIS = "SeriesAxis";
    public static final String TOKEN_DATA_AXIS = "DataAxis";
    private ChartTitle WX;
    private Font WY;
    private int WZ = 0;
    private ChartFormat Xa;
    private boolean Xb = true;
    private int Xc;
    private int Xd;
    private boolean Xe = false;
    private AxisPosition Xf = AxisPosition.ON_MIN;

    public BaseAxis() {
        this.WX = DEFAULT_TITLE.clone();
        this.WY = DEFAULT_TICK_LABEL_FONT;
        this.Xc = DEFAULT_GRIDLINE_COLOR;
        this.Xd = DEFAULT_AXIS_LINE_COLOR;
    }

    public boolean isGridlinesVisible() {
        return this.Xb;
    }

    public void setGridlinesVisible(boolean gridlinesVisible) {
        this.Xb = gridlinesVisible;
    }

    public int getGridlineColor() {
        return this.Xc;
    }

    public void setGridlineColor(int gridlineColor) {
        if (gridlineColor == -1) {
            throw i.e("gridlineColor");
        }
        this.Xc = gridlineColor;
    }

    public int getAxisLineColor() {
        return this.Xd;
    }

    public boolean isInverseOrder() {
        return this.Xe;
    }

    public void setInverseOrder(boolean inverseOrder) {
        this.Xe = inverseOrder;
    }

    public void setAxisLineColor(int axisLineColor) {
        if (axisLineColor == -1) {
            throw i.e("axisLineColor");
        }
        this.Xd = axisLineColor;
    }

    public ChartTitle getTitle() {
        return this.WX;
    }

    public void setTitle(ChartTitle title) {
        if (title == null) {
            throw i.d("title");
        }
        this.WX = title;
    }

    public Font getTickLabelFont() {
        return this.WY;
    }

    public void setTickLabelFont(Font tickLabelFont) {
        if (tickLabelFont == null) {
            throw i.d("tickLabelFont");
        }
        this.WY = tickLabelFont;
    }

    public int getTickLabelColor() {
        return this.WZ;
    }

    public void setTickLabelColor(int tickLabelColor) {
        if (tickLabelColor == -1) {
            throw i.e("tickLabelColor");
        }
        this.WZ = tickLabelColor;
    }

    public ChartFormat getTickLabelFormat() {
        return this.Xa;
    }

    public void setTickLabelFormat(ChartFormat tickLabelFormat) {
        this.Xa = tickLabelFormat;
    }

    public AxisPosition getAxisPosition() {
        return this.Xf;
    }

    public void setAxisPosition(AxisPosition position) {
        if (position == null) {
            throw i.d("axis position");
        }
        this.Xf = position;
    }

    public void copyTo(BaseAxis that) {
        that.setAxisLineColor(this.getAxisLineColor());
        that.setGridlineColor(this.getGridlineColor());
        that.setGridlinesVisible(this.isGridlinesVisible());
        that.setInverseOrder(this.isInverseOrder());
        that.setAxisPosition(this.getAxisPosition());
        that.setTickLabelColor(this.getTickLabelColor());
        that.setTickLabelFont(this.getTickLabelFont());
        that.setTitle(this.getTitle());
    }

    public void saveProperties(PrintWriter out, int depth, String axisType) {
        String string = BaseUtils.getIndent(depth);
        StringBuilder stringBuilder = this.cB(++depth);
        f.a(out, string, axisType, this.getAxisPosition().ms(), false);
        if (stringBuilder.length() > 0) {
            out.print(stringBuilder.toString());
        }
        this.B(out, depth);
        f.a(out, string, axisType, null, true);
    }

    protected StringBuilder cB(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        f.b(stringBuilder, n2, "GridlinesVisible", String.valueOf(this.isGridlinesVisible()));
        if (this.getGridlineColor() != DEFAULT_GRIDLINE_COLOR) {
            f.b(stringBuilder, n2, "GridlineColor", String.valueOf(this.getGridlineColor()));
        }
        if (this.getAxisLineColor() != DEFAULT_AXIS_LINE_COLOR) {
            f.b(stringBuilder, n2, "AxisLineColor", String.valueOf(this.getAxisLineColor()));
        }
        if (!this.WX.isEqualToDefault(DEFAULT_TITLE)) {
            this.WX.saveProperties(stringBuilder, "AxisTitle", n2);
        }
        if (this.getTickLabelFormat() != null) {
            this.getTickLabelFormat().saveProperties(stringBuilder, n2);
        }
        if (!this.getTickLabelFont().equals(DEFAULT_TICK_LABEL_FONT) || this.getTickLabelColor() != 0) {
            f.b(stringBuilder, n2, this.getTickLabelFont(), this.getTickLabelColor());
        }
        if (this.isInverseOrder()) {
            f.b(stringBuilder, n2, "InverseOrder", String.valueOf(this.isInverseOrder()));
        }
        return stringBuilder;
    }

    protected void B(PrintWriter printWriter, int n2) {
    }

    public void readProperties(Element element, Chart2 chart) {
        AxisPosition axisPosition = AxisPosition.d(element);
        if (axisPosition != null) {
            this.setAxisPosition(axisPosition);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("GridlinesVisible")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setGridlinesVisible(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("GridlineColor")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n2 = Integer.parseInt(element2.getAttribute("value"));
                this.setGridlineColor(n2);
                continue;
            }
            if (element2.getNodeName().equals("AxisLineColor")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n3 = Integer.parseInt(element2.getAttribute("value"));
                this.setAxisLineColor(n3);
                continue;
            }
            if (element2.getNodeName().equals("AxisTitle")) {
                this.WX.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("Format")) {
                this.Xa = j.b(element2);
                if (this.Xa == null) continue;
                this.Xa.readProperties(element2);
                continue;
            }
            if (element2.getNodeName().equals("Label")) {
                object = element2.getChildNodes();
                if (object.getLength() > 0) {
                    this.setTickLabelColor(j.b(object.item(0).getChildNodes()));
                    this.setTickLabelFont(j.a(object.item(0).getChildNodes()));
                } else {
                    NamedNodeMap namedNodeMap = element2.getAttributes();
                    for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                        Node node = namedNodeMap.item(i3);
                        if (node.getNodeName().equals("font")) {
                            Font font = f.aK(node.getNodeValue());
                            if (font == null) continue;
                            this.setTickLabelFont(font);
                            continue;
                        }
                        if (!node.getNodeName().equals("color")) continue;
                        int n4 = Integer.parseInt(node.getNodeValue());
                        this.setTickLabelColor(n4);
                    }
                    continue;
                }
            }
            if (!element2.getNodeName().equals("InverseOrder") || ((String)(object = element2.getAttribute("value"))).length() <= 0) continue;
            this.setInverseOrder(Boolean.valueOf((String)object));
        }
    }

    public List<Object> getReferencedObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        if (this.WX != null && this.WX.getTitleFormula() != null) {
            arrayList.add(this.WX.getTitleFormula());
        }
        if (this instanceof c) {
            arrayList.addAll(AbstractMarker.getMarkerReferencesIfExist((c)((Object)this)));
        }
        return arrayList;
    }
}

