/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;

@PublicApi
public class SummaryInfo
implements Serializable {
    private String hv;
    private String Pv;
    private String Pw;
    private String Px;
    private String Py;
    private String Pz;
    private Date PA;
    private Date PB;
    private transient BufferedImage PC;
    private byte[] PD;

    SummaryInfo() {
    }

    public String getAuthor() {
        return this.Pv;
    }

    public void setAuthor(String author) {
        this.Pv = author;
    }

    public String getKeywords() {
        return this.Pw;
    }

    public void setKeywords(String keywords) {
        this.Pw = keywords;
    }

    public String getComments() {
        return this.Pz;
    }

    public void setComments(String comments) {
        this.Pz = comments;
    }

    public String getReportTitle() {
        return this.hv;
    }

    public void setReportTitle(String title) {
        this.hv = title;
    }

    public String getSubject() {
        return this.Px;
    }

    public void setSubject(String subject) {
        this.Px = subject;
    }

    public String getTemplate() {
        return this.Py;
    }

    public void setTemplate(String template) {
        this.Py = template;
    }

    public Date getCreated() {
        return this.PB;
    }

    public void setCreated(Date createTime) {
        this.PB = createTime;
    }

    public Date getLastSaved() {
        return this.PA;
    }

    public void setLastSaved(Date lastSave) {
        this.PA = lastSave;
    }

    public void setThumbnail(Image img) {
        double d2;
        this.PD = null;
        if (img == null) {
            this.PC = null;
            return;
        }
        int n2 = img.getWidth(null);
        int n3 = img.getHeight(null);
        int n4 = n2;
        int n5 = n3;
        if (n2 > n3) {
            d2 = (double)n2 / 96.0;
            n4 = 96;
            n5 = (int)((double)n5 / d2);
        } else {
            d2 = (double)n3 / 96.0;
            n5 = 96;
            n4 = (int)((double)n4 / d2);
        }
        img = img.getScaledInstance(n4, n5, 4);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(img, 0, 0, Color.WHITE, null);
        graphics.dispose();
        this.PC = bufferedImage;
        this.getThumbnailData();
    }

    public Image getThumbnail() {
        if (this.PC == null && this.PD != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.PD);
                this.PC = ImageIO.read(byteArrayInputStream);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
                this.PD = null;
            }
        }
        return this.PC;
    }

    public void setThumbnailData(byte[] data) {
        this.PC = null;
        this.PD = data;
    }

    public byte[] getThumbnailData() {
        if (this.PD == null && this.PC != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.PC, "png", byteArrayOutputStream);
                this.PD = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.PD;
    }
}

