/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.CrossTab;
import com.inet.report.DatabaseTables;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.aj;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bj;
import com.inet.report.cb;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class SummaryField
extends Field
implements ReferenceHolder,
Validatable {
    int ie;
    int OC;
    int Na;
    Object OD;
    Field OE;
    transient int OF;
    Field OG;
    Field OH;
    Group OI;
    private boolean OJ = false;
    transient int tc;
    private boolean OK = false;
    private boolean OL = false;
    public static final int SUM = 0;
    public static final int AVERAGE = 1;
    public static final int SAMPLE_VARIANCE = 2;
    public static final int SAMPLE_STANDARD_DEVIATION = 3;
    public static final int MAXIMUM = 4;
    public static final int MINIMUM = 5;
    public static final int COUNT = 6;
    public static final int POP_VARIANCE = 7;
    public static final int POP_STANDARD_DEVIATION = 8;
    public static final int DISTINCT_COUNT = 9;
    public static final int CORRELATION = 10;
    public static final int COVARIANCE = 11;
    public static final int WEIGHTED_AVERAGE = 12;
    public static final int MEDIAN = 13;
    public static final int PERCENTILE = 14;
    public static final int NTH_LARGEST = 15;
    public static final int NTH_SMALLEST = 16;
    public static final int MODE = 17;
    public static final int NTH_MOST_FREQUENT = 18;
    public static final int PERCENTAGE = 19;
    public static final int NO_SUMMARY_OPERATION = 20;
    public static final int SUMMARY_REPORT = 0;
    public static final int SUMMARY_CROSSTAB = 1;
    public static final int SUMMARY_CHART = 3;
    private static final String[] OM = new String[]{"RESET_NEVER", "RESET_ON_CHANGE_OF_FIELD", "RESET_ON_CHANGE_OF_GROUP", "RESET_USING_FORMULA"};
    private static String[] ON = new String[]{"CHANGE_FOR_EACH_RECORD", "CHANGE_ON_CHANGE_OF_FIELD", "CHANGE_ON_CHANGE_OF_GROUP", "CHANGE_USING_FORMULA"};
    protected r qk = new r(this);

    protected SummaryField(ba ren) {
        this.type = 11;
        this.bB = ren;
        this.valueType = 6;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a sum field cannot be empty.");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.IA, name)) {
            throw y.b("SummaryField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    String km() {
        if (this.OK || this.name == null || this.name.length() == 0) {
            this.OK = true;
            this.setName(this.kn());
        }
        return this.getName();
    }

    String kn() {
        Object object;
        if (this.getField() != null) {
            String string = SummaryField.getOperationName(this.getSummaryOperation()) + " " + this.getField().getName();
            object = this.getGroup();
            if (object != null) {
                string = string + "," + ((Group)object).getField().getName();
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                String string2;
                String string3 = string2 = i2 == 0 ? string : string + " (" + i2 + ")";
                if (Fields.a((Field[])this.bB.IA, string2)) continue;
                return string2;
            }
        }
        for (int i3 = 0; i3 < 50; ++i3) {
            object = "sum Field id " + (this.hashCode() + i3);
            if (Fields.a((Field[])this.bB.IA, (String)object)) continue;
            return object;
        }
        return this.getName();
    }

    public final void setSummaryOperation(int operation) {
        this.Na = operation;
    }

    public int getSummaryOperation() {
        return this.Na;
    }

    public static final String getOperationName(int operation) {
        if (operation < 0 || operation >= b.values().length) {
            return b.Pt.name;
        }
        for (int i2 = 0; i2 < b.values().length; ++i2) {
            b b2 = b.values()[operation];
            if (b2.gH != operation) continue;
            return b2.name;
        }
        return "";
    }

    public static final int getSummaryOperation(String operation) {
        try {
            return b.valueOf((String)operation).gH;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return b.Pt.gH;
        }
    }

    public int getSummaryFieldType() {
        return this.qr;
    }

    public void setSummaryFieldType(int type) {
        this.qr = type;
    }

    private void bS(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            this.ie = this.ie & 0xFF | n2 << 8;
        }
    }

    private int ko() {
        return this.ie >> 8;
    }

    public Field getResetField() {
        int n2 = this.ko();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.OH != null && this.OH.type == 14) {
                    return this.OH;
                }
                return null;
            }
            case 2: {
                if (this.OI != null) {
                    return this.OI.sE;
                }
                return null;
            }
            case 3: {
                if (this.OH != null && this.OH.type == 13) {
                    return this.OH;
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown resetType " + n2);
    }

    public void setResetField(Field rstField) {
        if (rstField == null) {
            this.bS(0);
            this.OH = null;
            this.OI = null;
            this.updateReferences();
            return;
        }
        switch (rstField.type) {
            case 14: {
                this.bS(1);
                break;
            }
            case 12: {
                this.bS(2);
                this.OI = rstField.getGroup();
                break;
            }
            case 13: {
                this.bS(3);
            }
        }
        this.OH = FormulaField.g(rstField);
        this.setChangeField(this.OG);
        this.updateReferences();
    }

    private void bT(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            this.ie = this.ie & 0xFF00 | n2;
        }
    }

    private int kp() {
        return this.ie & 0xFF;
    }

    public Field getChangeField() {
        int n2 = this.kp();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.getRunningTotal()) {
                    if (this.OG != null && this.OG.type == 14) {
                        return this.OG;
                    }
                    return null;
                }
            }
            case 2: {
                if (this.getGroup() != null) {
                    return this.getGroup().sE;
                }
                return null;
            }
            case 3: {
                if (this.OG != null && this.OG.type == 13) {
                    return this.OG;
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown changeType " + n2);
    }

    public void setChangeField(Field changeField) {
        if (changeField == null) {
            this.setGroup(null);
            if (!this.getRunningTotal()) {
                this.kr();
                this.updateReferences();
                return;
            }
            this.bT(0);
            this.kr();
            this.updateReferences();
        } else {
            switch (changeField.type) {
                case 13: {
                    this.bT(3);
                    this.setGroup(null);
                    break;
                }
                case 14: {
                    this.bT(1);
                    this.setGroup(null);
                    break;
                }
                case 12: {
                    this.bT(2);
                    this.setGroup(changeField.getGroup());
                }
            }
        }
        this.OG = FormulaField.g(changeField);
        this.kr();
        this.updateReferences();
    }

    public int getSummaryNth() {
        return this.OC;
    }

    public void setSummaryNth(int summaryNth) {
        this.OC = summaryNth;
    }

    public void setShowPercentVal(boolean newValue) {
        this.OJ = newValue;
    }

    public boolean getShowPercentVal() {
        return this.OJ;
    }

    public boolean getRunningTotal() {
        return this.OG != null || this.ie != 1;
    }

    public void setRunningTotal(boolean isRunningTotal) {
        if (isRunningTotal) {
            if (!this.getRunningTotal()) {
                this.ie = 0;
            }
        } else {
            this.OG = null;
            this.OH = null;
            this.ie = 1;
        }
    }

    @Override
    Field[] K(int n2) {
        return new SummaryField[n2];
    }

    @Override
    public int getValueType() {
        try {
            return this.kq();
        }
        catch (ReportException reportException) {
            return -1;
        }
    }

    private int kq() throws ReportException {
        if (this.getField() == null) {
            return -1;
        }
        switch (this.Na) {
            case 0: 
            case 1: {
                this.valueType = this.getField().getValueType() & 0xF;
                if (this.valueType == 6 || this.valueType == 7) {
                    return this.valueType;
                }
                Object[] objectArray = new Object[]{"NUMBER or CURRENCY", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 2: 
            case 7: 
            case 8: {
                int n2 = this.getField().getValueType() & 0xF;
                if (n2 == 6 || n2 == 7) {
                    this.valueType = 6;
                    return 6;
                }
                Object[] objectArray = new Object[]{"NUMBER", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 19: {
                this.valueType = 6;
                return 6;
            }
            case 10: 
            case 11: 
            case 12: {
                if (this.OE == null) {
                    return -1;
                }
                int n3 = this.getField().getValueType() & 0xF;
                int n4 = this.OE.getValueType() & 0xF;
                if (n3 == 6 && (n4 == 6 || n4 == 7)) {
                    this.valueType = n3;
                    return this.valueType;
                }
                if (n3 == 7 && (n4 == 6 || n4 == 7)) {
                    this.valueType = n3;
                    return this.valueType;
                }
                this.valueType = n3 == 6 ? n4 : n3;
                Object[] objectArray = new Object[]{"NUMBER", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 6: 
            case 9: {
                this.valueType = 6;
                return 6;
            }
            case 3: 
            case 13: 
            case 14: {
                this.valueType = this.getField().getValueType() & 0xF;
                if (this.valueType == 6 || this.valueType == 7) {
                    return this.valueType;
                }
                Object[] objectArray = new Object[]{"NUMBER or CURRENCY", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
        }
        this.valueType = this.getField().getValueType() & 0xF;
        return this.valueType;
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTypeAsString());
        stringBuilder.append(":'").append(this.name).append('\'');
        stringBuilder.append('{');
        if (this.getField() != null) {
            stringBuilder.append(this.getField().getName());
        }
        if (this.getGroup() != null && this.getGroup().getField() != null) {
            stringBuilder.append(',').append(this.getGroup().getField().getName());
        }
        stringBuilder.append("}, ");
        if (this.getRunningTotal()) {
            stringBuilder.append("RT");
        } else {
            stringBuilder.append("SUM");
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.bU(this.ie));
        stringBuilder.append(", ");
        stringBuilder.append("operation: ");
        try {
            stringBuilder.append(this.getSummaryOperation());
        }
        catch (Exception exception) {
            stringBuilder.append("UNK");
        }
        stringBuilder.append(", value type: ").append(this.getValueTypeString());
        return stringBuilder.toString();
    }

    public static String generateName(String field, String group, int sumType) {
        return SummaryField.generateName(field, group, sumType, null);
    }

    public static String generateName(String field, String group, int sumType, String field2) {
        String string = SummaryField.getOperationName(sumType) + " of " + field;
        if (field2 != null) {
            string = string + ", " + field2;
        }
        if (group != null) {
            string = string + ", " + group;
        }
        return string;
    }

    private boolean kr() {
        return true;
    }

    private String bU(int n2) {
        int n3 = 0;
        if ((n2 & 0x300) == 768) {
            n3 = 3;
        } else if ((n2 & 0x200) == 512) {
            n3 = 2;
        } else if ((n2 & 0x100) == 256) {
            n3 = 1;
        }
        return ON[n2 & 0xF] + ", " + OM[n3];
    }

    public Field getField2nd() {
        return this.OE;
    }

    public void setField2nd(Field field2nd) {
        String string;
        if (field2nd instanceof FormulaField && (string = cb.a((FormulaField)field2nd, "the sum field '" + this.getName() + "'")) != null) {
            BaseUtils.warning(string);
        }
        this.OE = field2nd;
        this.updateReferences();
    }

    @Override
    final void a(int n2, String string, at at2) {
        switch (n2) {
            case 18273: {
                break;
            }
            case 203: {
                this.OF = Integer.parseInt(string);
                break;
            }
            case 220: {
                this.OJ = Boolean.valueOf(string);
                break;
            }
            case 202: {
                this.tc = Integer.parseInt(string);
                break;
            }
            case 176: {
                this.Na = Integer.parseInt(string);
                break;
            }
            case 182: {
                this.OC = Integer.parseInt(string);
                break;
            }
            case 178: {
                this.ie = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    public void changeAliasName(String oldAlias, String newAlias) {
        int n2 = 0;
        DatabaseTables databaseTables = this.bB.iY();
        while (n2 < databaseTables.getSqlAliasCount() && !(oldAlias = databaseTables.getSqlAliasNames()[n2++]).equals(newAlias)) {
            if (this.getName().indexOf(oldAlias) == -1) continue;
            this.setName(this.getName().substring(0, this.getName().indexOf(oldAlias)) + newAlias + this.getName().substring(this.getName().indexOf(oldAlias) + oldAlias.length()));
            break;
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qk.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qk.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qk.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qk.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qk.removeReferencedObject(reference);
    }

    @Override
    public void setReferences() {
        if (this.getField() != null) {
            this.getField().addReferenceHolder(this);
        }
        if (this.getGroup() != null) {
            this.getGroup().addReferenceHolder(this);
        }
        try {
            if (this.getChangeField() != null) {
                this.getChangeField().addReferenceHolder(this);
            }
            if (this.getResetField() != null) {
                this.getResetField().addReferenceHolder(this);
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        if (this.OI != null) {
            this.OI.addReferenceHolder(this);
        }
        if (this.OE != null) {
            this.OE.addReferenceHolder(this);
        }
    }

    @Override
    public void resetReferences() {
        this.qk.resetReferences();
    }

    private final void updateReferences() {
        this.resetReferences();
        this.setReferences();
    }

    @Override
    public void setField(Field newField) {
        String string;
        if (newField instanceof GroupField) {
            newField = ((GroupField)newField).getField();
        }
        if (newField instanceof FormulaField && (string = cb.a((FormulaField)newField, "the sum field '" + this.getName() + "'")) != null) {
            BaseUtils.warning(string);
        }
        super.setField(newField);
        this.updateReferences();
    }

    @Override
    public void setGroup(Group group) {
        if (this.getGroup() != null && this.getGroup().getGroupNameField() != null) {
            Fields.a(this.bB, this.getGroup().getGroupNameField(), 2);
        }
        super.setGroup(group);
        this.updateReferences();
        if (group != null && group.getGroupNameField() != null) {
            Fields.a(this.bB, group.getGroupNameField(), 2);
        }
        if (this.OG == this) {
            this.OG = null;
            if (group != null) {
                this.setChangeField(group.getGroupNameField());
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SummaryField) {
            SummaryField summaryField = (SummaryField)obj;
            if (this.Na == summaryField.Na && this.ie == summaryField.ie && this.OC == summaryField.OC && this.tc == summaryField.tc && this.OF == summaryField.OF && this.OJ == summaryField.OJ && (this.name == summaryField.name || this.name != null && this.name.equals(summaryField.name))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            switch (xMLTag) {
                case Reference: {
                    this.e(atts);
                    break;
                }
                default: {
                    this.d(tag, atts);
                    break;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    private void e(Attributes attributes) throws ReportException {
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("value");
        if (string2 == null || string2.isEmpty()) {
            if (string.equals("change_field")) {
                this.OG = this;
            }
            return;
        }
        string2 = this.E(string2);
        if (string.equals("id")) {
            this.setField(this.bB.a(false, string2));
        } else if (string.equals("2ndField")) {
            this.setField2nd(this.bB.a(false, string2));
        } else if (string.equals("change_field")) {
            this.setChangeField(this.bB.a(false, string2));
        } else if (string.equals("reset_field")) {
            this.setResetField(this.bB.a(false, string2));
        }
    }

    @Override
    void d(String string, Attributes attributes) throws ReportException {
        String string2 = attributes.getValue("value");
        if (string2 == null) {
            return;
        }
        a a2 = a.OP;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case OQ: {
                break;
            }
            case OU: {
                this.tc = Integer.parseInt(string2);
                break;
            }
            case OS: {
                this.OF = Integer.parseInt(string2);
                break;
            }
            case OT: {
                this.OJ = Boolean.valueOf(string2);
                break;
            }
            case OV: {
                this.Na = Integer.parseInt(string2);
                break;
            }
            case OW: {
                this.OC = Integer.parseInt(string2);
                break;
            }
            case OX: {
                this.ie = Integer.parseInt(string2);
                break;
            }
            default: {
                super.d(string, attributes);
            }
        }
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, a.OV.name(), k.G(this.Na));
        k.a(stringBuilder, n2, a.OW.name(), k.G(this.OC));
        k.a(stringBuilder, n2, a.OX.name(), k.G(this.ie));
        if (this.OH != null) {
            k.a(stringBuilder, n2, this.OH, "reset_field");
        }
        if (this.OG != null) {
            k.a(stringBuilder, n2, this.OG, "change_field");
        }
        if (this.getGroup() != null) {
            k.a(stringBuilder, n2, a.OU.name(), k.G(this.getGroup().indexOf()));
        }
        if (this.OI != null) {
            k.a(stringBuilder, n2, a.OS.name(), k.G(this.OI.indexOf()));
        }
        if (this.OE != null) {
            k.a(stringBuilder, n2, this.OE, "2ndField");
        }
        k.a(stringBuilder, n2, Field.a.qw.name(), k.G(this.qr));
        k.a(stringBuilder, n2, a.OT.name(), k.h(this.OJ));
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public Field duplicate(String name) {
        try {
            SummaryField summaryField = this.getField2nd() == null ? this.bB.getFields().addSummaryField(this.getField(), this.getSummaryOperation(), name) : this.bB.getFields().addSummaryField(this.getField(), this.getField2nd(), this.getSummaryOperation(), name);
            summaryField.setChangeField(this.getChangeField());
            summaryField.setResetField(this.getResetField());
            summaryField.setRunningTotal(this.getRunningTotal());
            summaryField.setShowPercentVal(this.getShowPercentVal());
            summaryField.setSummaryFieldType(this.getSummaryFieldType());
            summaryField.setSummaryNth(this.getSummaryNth());
            summaryField.setSummaryOperation(this.getSummaryOperation());
            return summaryField;
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("problems duplicating SummaryField " + this.getName(), reportException);
        }
    }

    boolean ks() {
        for (ReferenceHolder referenceHolder : this.getReferenceHolders()) {
            if (referenceHolder instanceof CrossTab) {
                return true;
            }
            if (referenceHolder instanceof Chart2) {
                return true;
            }
            if (!(referenceHolder instanceof aj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Validity validate() {
        Validity validity = null;
        validity = this.getField() == null ? new Validity(Validity.States.ERROR, null) : cb.m(this.getField());
        if (!validity.getState().equals((Object)Validity.States.VALID)) {
            return validity;
        }
        try {
            this.kq();
        }
        catch (ReportException reportException) {
            validity = new Validity(Validity.States.ERROR, reportException);
        }
        if (!validity.getState().equals((Object)Validity.States.VALID)) {
            return validity;
        }
        if (this.getField2nd() != null) {
            validity = cb.m(this.getField2nd());
        }
        return validity;
    }

    @Override
    Object getValue() throws ReportException {
        bj bj2 = this.bB.gF();
        if (this.getField().type != 16 || this.getField2nd() != null && this.getField2nd().type != 16) {
            if (bj2.M() < 1 || bj2.M() > bj2.getRowCount()) {
                return null;
            }
            int n2 = this.indexOf();
            int n3 = bj2.M() - 1;
            return bj2.y(n2, n3);
        }
        PromptField promptField = (PromptField)this.getField();
        if (!promptField.zb) {
            return null;
        }
        Object[] objectArray = (Object[])promptField.value;
        Object[] objectArray2 = null;
        if (this.OE != null) {
            if (this.OE.type == 16) {
                if (!((PromptField)this.OE).zb) {
                    return null;
                }
                objectArray2 = (Object[])((PromptField)this.OE).value;
            } else {
                return null;
            }
        }
        return this.bB.dw().qF().a(this.Na, objectArray, objectArray2, 0, Math.min(objectArray.length, objectArray2.length), this.OC);
    }

    void ao(boolean bl2) {
        this.OL = bl2;
    }

    public boolean isInternalField() {
        ArrayList<SummaryField> arrayList = this.bB.dw().qE();
        return this.OL || arrayList != null && arrayList.contains(this);
    }

    public static enum a {
        OP,
        OQ,
        OS,
        OT,
        OU,
        OV,
        OW,
        OX;

    }

    public static enum b {
        OZ(0, "Sum"),
        Pa(1, "Average"),
        Pb(2, "Variance"),
        Pc(3, "StdDeviation"),
        Pd(4, "Maximum"),
        Pe(5, "Minimum"),
        Pf(6, "Count"),
        Pg(7, "PopVariance"),
        Ph(8, "PopStdVariance"),
        Pi(9, "DistinctCount"),
        Pj(10, "Correlation"),
        Pk(11, "Covariance"),
        Pl(12, "WeightedAverage"),
        Pm(13, "Median"),
        Pn(14, "Percentile"),
        Po(15, "NthLargest"),
        Pp(16, "NthSmallest"),
        Pq(17, "Mode"),
        Pr(18, "NthMostFrequent"),
        Ps(19, "Percentage"),
        Pt(20, "NoSummaryOperation");

        private int gH;
        private String name;

        private b(int n3, String string2) {
            this.gH = n3;
            this.name = string2;
        }
    }
}

