/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.font.FontPool;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.util.ColorUtils;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Group;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.SpecialField;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.cb;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.certificate.a;
import com.inet.report.database.coredata.CoreData;
import com.inet.report.formula.debug.GenericBreakPointProvider;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.parser.RFReader;
import com.inet.report.parser.XMLTag;
import com.inet.report.parser.b;
import com.inet.report.parser.d;
import com.inet.report.translation.e;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Properties;

@PublicApi
public class RDC
implements Serializable {
    private static final URL Ag;
    static final int[] Ah;
    static final int[] Ai;
    public static final int COLOR_AQUA = 0xFFFF00;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_BLUE = 0xFF0000;
    public static final int COLOR_FUCHSIA = 0xFF00FF;
    public static final int COLOR_GRAY = 0x808080;
    public static final int COLOR_GREEN = 32768;
    public static final int COLOR_LIME = 65280;
    public static final int COLOR_MAROON = 128;
    public static final int COLOR_NAVY = 0x800000;
    public static final int COLOR_NO_COLOR = -1;
    public static final int COLOR_OLIVE = 32896;
    public static final int COLOR_PURPLE = 0x800080;
    public static final int COLOR_RED = 255;
    public static final int COLOR_SILVER = 0xC0C0C0;
    public static final int COLOR_TEAL = 0x808000;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_YELLOW = 65535;
    public static final int COLOR_PINK = 13355263;
    public static final int COLOR_BROWN = 0x2A2AA5;
    private static CertificateInfoFactory Aj;
    private static final ConfigValue<Boolean> Ak;

    private RDC() {
    }

    public static Engine createMailingLabel(Engine eng, int labelWidth, int labelHeight, int labelHorizontalDistance, int labelVerticalDistance, boolean acrossThenDown, List<Field> fields) throws ReportException {
        ba ba2 = eng.bB;
        ReportProperties reportProperties = ba2.getReportProperties();
        reportProperties.Kf = acrossThenDown;
        reportProperties.JZ = true;
        reportProperties.Ka = "User-Defined Label";
        reportProperties.Kb = "User-Defined Label";
        reportProperties.Kc = labelHeight;
        reportProperties.AR = labelWidth;
        reportProperties.Kd = labelHorizontalDistance;
        reportProperties.Ke = labelVerticalDistance;
        Area area = ba2.getArea("D");
        Section section = null;
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            Field field = fields.get(i2);
            int n2 = (labelHeight - labelVerticalDistance / 2) / fields.size();
            if (i2 == 0) {
                section = area.getSection(0);
                section.addFieldElement(field, 0, 0, labelWidth, n2);
                section.setWidth(reportProperties.getPaperWidth());
                continue;
            }
            section = area.addSection();
            section.setWidth(reportProperties.getPaperWidth());
            section.addFieldElement(field, 0, 0, labelWidth, n2);
        }
        return eng;
    }

    public static final Font getFont(String name, int style, int size) {
        return FontPool.getFont((String)name, (int)style, (int)size);
    }

    static void c(Engine engine) {
        ba ba2 = engine.bB;
        try {
            int n2 = (Integer)ReportProperties.JR.get();
            int n3 = (Integer)ReportProperties.JQ.get();
            ba2.getReportProperties().setPaperSize(n2, n3);
        }
        catch (Throwable throwable) {
            BaseUtils.info("Could not read default paper size from the i-net Clear Reports configuration.");
        }
        try {
            ba2.getSummaryInfo().setCreated(new Date(System.currentTimeMillis()));
            ba2.Iz = null;
            ba2.a(new Group[3]);
            Group[] groupArray = engine.bB.jc();
            groupArray[0] = new Group(ba2);
            groupArray[0].ak(24);
            groupArray[1] = new Group(ba2);
            groupArray[1].ak(27);
            groupArray[2] = new Group(ba2);
            groupArray[2].ak(33);
            Area area = null;
            ba2.II = new Area(25, ba2);
            ba2.IJ = new Area(26, ba2);
            ba2.IK = new Area(28, ba2);
            ba2.IL = new Area(29, ba2);
            ba2.IM = new Area(34, ba2);
            groupArray[0].sq = ba2.II;
            groupArray[0].sr = ba2.IJ;
            groupArray[1].sq = ba2.IK;
            groupArray[1].sr = ba2.IL;
            groupArray[2].sq = ba2.IM;
            RDC.d(engine);
            for (int i2 = 0; i2 < engine.getAreaCount(); ++i2) {
                area = engine.getArea(i2);
                if (area == null) continue;
                Section section = area.addSection();
                section.jm = ba2.getReportProperties().getMarginLeft();
                section.width = ba2.getReportProperties().getPaperWidth() - ba2.getReportProperties().getMarginRight() - ba2.getReportProperties().getMarginLeft();
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    static void a(Engine engine, ba ba2) {
        try {
            ba ba3 = engine.bU();
            ba3.Iz = null;
            ba3.a(new Group[2]);
            Group[] groupArray = ba3.jc();
            groupArray[0] = new Group(ba3);
            groupArray[0].ak(27);
            groupArray[1] = new Group(ba3);
            groupArray[1].ak(33);
            Area area = null;
            ba3.IK = new Area(28, ba3);
            ba3.IL = new Area(29, ba3);
            ba3.IM = new Area(34, ba3);
            groupArray[0].sq = ba3.IK;
            groupArray[0].sr = ba3.IL;
            groupArray[1].sq = ba3.IM;
            for (int i2 = 0; i2 < engine.getAreaCount() + 2; ++i2) {
                area = engine.getArea(i2);
                if (area == null) continue;
                area.addSection();
            }
            RDC.d(engine);
            if (ba3.IC == null) {
                ba3.IC = new SortField[0];
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    static void d(Engine engine) throws Exception {
        engine.bB.getReportProperties().bD(Engine.getMajorVersion());
        engine.bB.IS = new URL("file://");
        engine.setErrorMsg(null);
        RDC.e(engine);
        engine.bB.IC = new SortField[0];
        engine.bB.getSummaryInfo().setLastSaved(new Date(System.currentTimeMillis()));
        engine.cC();
    }

    static void e(Engine engine) {
        if (engine.bB.Iw != null && engine.bB.Iw.length == Ai.length) {
            return;
        }
        int n2 = Ai.length;
        engine.bB.Iw = new SpecialField[n2];
        SpecialField[] specialFieldArray = engine.bB.Iw;
        for (int i2 = 0; i2 < n2; ++i2) {
            SpecialField specialField = specialFieldArray[i2] = new SpecialField(engine.bB);
            specialField.qq = i2;
            specialField.Na = Ai[i2];
            RDC.a(specialField);
        }
    }

    static void a(SpecialField specialField) {
        switch (specialField.Na) {
            case 0: 
            case 2: 
            case 4: 
            case 16: {
                specialField.valueType = 9;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                specialField.valueType = 10;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                specialField.valueType = 6;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                specialField.valueType = 11;
            }
        }
    }

    public static Engine createEmptyEngine(String export_fmt) {
        try {
            Engine engine = new Engine(export_fmt);
            RDC.c(engine);
            engine.bB.getReportProperties().setSaveDatasource(false);
            engine.bB.gQ().wp();
            return engine;
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
            ErrorCode.throwAny((Throwable)exception);
            return null;
        }
    }

    public static void setEngineParams(Engine engine, Properties props, PropertiesChecker checker, Object req) throws ReportException {
        cb.a(null, engine, props, checker, req, true);
    }

    public static void saveEngine(File file, Engine engine) throws ReportException {
        try {
            if (file.isDirectory()) {
                d.b(engine, file);
            } else {
                d.a(engine, file);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        engine.getReportProperties().ah(true);
        engine.getReportProperties().bF(Engine.getMajorVersion());
    }

    public static void saveEngineToDir(File dir, Engine engine) throws ReportException {
        try {
            d.b(engine, dir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException, (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, dir.getName());
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        engine.getReportProperties().ah(true);
        engine.getReportProperties().bF(Engine.getMajorVersion());
    }

    public static void saveEngine(OutputStream out, Engine engine) throws ReportException, IOException {
        d.a(engine, out, engine.getReportFile());
        engine.getReportProperties().ah(true);
        engine.getReportProperties().bF(Engine.getMajorVersion());
    }

    public static Engine loadEngine(File file) throws ReportException {
        return RDC.a(file, null, null, null);
    }

    private static Engine a(File file, Properties properties, String string) throws IOException, ReportException, IllegalArgumentException {
        Engine engine = RDC.createEmptyEngine(string);
        RDC.a(engine, file, properties);
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(Engine engine, File file, Properties properties) throws IOException, ReportException, IllegalArgumentException {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("parameter 'dir' is null or not a directory file");
        }
        RFReader rFReader = null;
        try {
            rFReader = new RFReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException, ReportErrorCode.FileNotFound, file, fileNotFoundException.getMessage());
        }
        rFReader.initSummaryInfo(engine.getSummaryInfo());
        engine.setMetaProperties(rFReader.readMetaProperties());
        b b2 = b.vD();
        b2.vG().put("KEY_RF_READER", rFReader);
        engine.p(true);
        try {
            b2.a(engine, XMLTag.Report, rFReader.getContent());
        }
        finally {
            engine.p(false);
        }
        byte[] byArray = rFReader.getThumbnail();
        if (byArray != null) {
            engine.getSummaryInfo().setThumbnailData(byArray);
        }
        engine.relocateFile(file.toURI().toURL());
        engine.bB.a(e.b(rFReader));
        GenericBreakPointProvider.checkJson(engine);
        if (properties != null) {
            cb.a(null, engine, properties, null, null, true);
        }
    }

    private static Engine a(File file, BufferedReader bufferedReader, Properties properties, String string) throws ReportException {
        if (file != null) {
            try {
                if (file.isDirectory()) {
                    return RDC.a(file, properties, string);
                }
            }
            catch (IOException iOException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
            }
            try {
                URL uRL = IOFunctions.getFileURL((File)file);
                Engine engine = new Engine(string);
                engine.setReportFile(uRL);
                if (properties != null) {
                    cb.a(null, engine, properties, null, null, true);
                } else if (engine.cE() == 0) {
                    engine.cC();
                }
                return engine;
            }
            catch (MalformedURLException malformedURLException) {
                BaseUtils.printStackTrace(malformedURLException);
            }
        } else if (bufferedReader != null) {
            // empty if block
        }
        return at.a(file, bufferedReader, properties, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Engine loadEngine(URL reportURL, InputStream in, String exportFormat, Properties props) throws ReportException, IOException {
        Engine engine;
        if (reportURL == null) {
            reportURL = Ag;
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        FastBufferedInputStream fastBufferedInputStream = new FastBufferedInputStream(in);
        if (IOFunctions.isZipFile((FastBufferedInputStream)fastBufferedInputStream)) {
            RFReader rFReader = new RFReader((InputStream)fastBufferedInputStream);
            String string = rFReader.getMimetype();
            if (string == null || !"application/crystalclear.report".startsWith(string)) throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidMimeType, string);
            engine = new Engine(exportFormat);
            RDC.c(engine);
            engine.relocateFile(reportURL);
            rFReader.initSummaryInfo(engine.getSummaryInfo());
            engine.setMetaProperties(rFReader.readMetaProperties());
            b b2 = b.vD();
            b2.vG().put("KEY_RF_READER", rFReader);
            engine.p(true);
            try {
                b2.a(engine, XMLTag.Report, rFReader.getContent());
            }
            finally {
                engine.p(false);
            }
            byte[] byArray = rFReader.getThumbnail();
            if (byArray != null) {
                engine.getSummaryInfo().setThumbnailData(byArray);
            }
            engine.bB.a(e.b(rFReader));
            engine.S(0);
            engine.cC();
            if (rFReader.isContainingCoreData()) {
                CoreData.onLoadingReportWithCoreData(engine, rFReader, reportURL);
            }
        } else {
            byte[] byArray = IOFunctions.readBytes((InputStream)fastBufferedInputStream);
            engine = new Engine(exportFormat);
            engine.relocateFile(reportURL);
            engine.a(reportURL, byArray, false);
        }
        if (props != null) {
            cb.a(null, engine, props, null, null, true);
        }
        GenericBreakPointProvider.checkJson(engine);
        engine.bB.gQ().wp();
        return engine;
    }

    public static Engine loadEngine(File file, String export_fmt) throws ReportException {
        return RDC.a(file, null, null, export_fmt);
    }

    public static Engine loadEngine(Properties properties) throws ReportException {
        return RDC.a(null, null, properties, properties.getProperty("export_fmt"));
    }

    public static String encrypt(String value) {
        return Encryption.encrypt((String)value);
    }

    public static Color toJavaColor(int abgr) {
        return ColorUtils.toJavaColor((int)abgr);
    }

    public static int toCcColor(Color color) {
        return ColorUtils.toCcColor((Color)color);
    }

    public static void setCertificateInfoFactory(CertificateInfoFactory factory) {
        Aj = factory;
    }

    public static CertificateInfoFactory getCertificateFactory() {
        return Aj;
    }

    static {
        URL uRL = null;
        try {
            uRL = new URL("file://");
        }
        catch (MalformedURLException malformedURLException) {
            BaseUtils.printStackTrace(malformedURLException);
        }
        finally {
            Ag = uRL;
        }
        Ah = new int[]{0, 1, 2, 3, 4, 5, 13, 17, 14, 15, 6, 7, 8, 9, 10, 11, 12, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26};
        Ai = new int[]{0, 1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 16, 6, 8, 9, 17, 7, 18, 19, 20, 21, 22, 23, 24, 25, 26};
        Ak = new ConfigValue<Boolean>(ConfigKey.SIGN_PDF_ENABLED){

            protected void setValue(String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                if (((Boolean)this.get()).booleanValue()) {
                    if (Aj == null || Aj instanceof a) {
                        try {
                            Aj = new a(ConfigurationManager.getInstance().getCurrent());
                        }
                        catch (Throwable throwable) {
                            BaseUtils.printStackTrace(throwable);
                        }
                    }
                } else if (Aj instanceof a) {
                    Aj = null;
                }
            }
        };
    }

    public static interface MsgListener {
        public static final int YES = 2;
        public static final int NO = 1;
        public static final int CANCEL = 0;

        public int query(String var1);
    }

    public static class FieldsRefreshEvent {
        Field lL;
        int Al;
        Engine lC;
        public static final int ADD = 0;
        public static final int DELETE = 1;
        public static final int UPDATE = 2;
        public static final int UPDATE_ALL = 3;
        private static final String[] Am = new String[]{"ADD", "DEL", "UPD", "ALL"};

        FieldsRefreshEvent(Engine e2, Field f2, int cause) {
            this.lC = e2;
            this.Al = cause;
            this.lL = f2;
        }

        public Engine getEngine() {
            return this.lC;
        }

        public Field getField() {
            return this.lL;
        }

        public int getCause() {
            return this.Al;
        }

        public String paramString() {
            return this.getClass().getName() + "[" + String.valueOf(this.getField()) + "," + Am[this.getCause()] + "]";
        }
    }

    public static interface FieldsRefreshListener
    extends EventListener {
        public void refresh(FieldsRefreshEvent var1);
    }

    public static interface ElementRemoveListener {
        public void remove(Element var1);
    }
}

