/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cb;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

@PublicApi
public class CacheRenderData
implements RenderData {
    private final Cache hq;
    private final Properties hr = new Properties();
    private final PropertiesChecker hs;
    private final Object ht;
    private Properties hu = new Properties();
    private String hv;
    private String url;
    private ReportCacheKey hw;
    private int hx = 1;
    private boolean hy;

    public CacheRenderData(String url, PropertiesChecker checker, Object req) {
        this.hq = Cache.getCache();
        this.setReportLocation(url);
        this.hs = checker;
        this.ht = req;
    }

    public CacheRenderData(Properties props, PropertiesChecker checker, Object req) {
        this.hq = Cache.getCache();
        this.hr.putAll((Map<?, ?>)props);
        this.hs = checker;
        this.ht = req;
    }

    @Override
    public void setReportTitle(String title) {
        this.hv = title;
    }

    @Override
    public String getReportTitle() {
        return this.hv;
    }

    @Override
    public void setReportLocation(String name) {
        this.hr.clear();
        cb.b(name, this.hr, false);
        try {
            ReportKeyFactory.decodeProps(this.hr);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = name;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    private void aw() throws ViewerException {
        this.hr.put("export_fmt", "java");
        try {
            this.hw = this.getKey(this.hr);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
    }

    protected ReportCacheKey getKey(Properties props) throws ReportException {
        return this.hq.getKey(props, this.hs, this.getEngineFactory(), this.ht);
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        this.aw();
        try {
            return this.hq.getPageAndWait(this.hw, page, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        this.aw();
        try {
            return this.hq.getPageCountAndWait(this.hw, 600000);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public boolean isPageLimitExceeded() {
        this.aw();
        try {
            return this.hq.isPageLimitExceeded(this.hw);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string = this.hu.getProperty("export_fmt");
            if (string.equals("svg")) {
                if (this.hx == 0) {
                    ++this.hx;
                    String string2 = this.hu.getProperty("file");
                    string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                    int n2 = SVGUtils.getAutoRefresh(this.hu);
                    return SVGUtils.getSvgViewerPackage(-1, true, string2, n2);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, this.hx + ".svg", this.hq.getPageAndWait(this.hw, this.hx++, 600000));
                return byteArrayOutputStream.toByteArray();
            }
            if (this.hx >= 0) {
                return this.hq.getPageAndWait(this.hw, this.hx++, 600000);
            }
            ++this.hx;
            if (string.startsWith("htm")) {
                String string3 = this.hu.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            BaseUtils.error("Chunk " + this.hx + " out of range...");
            BaseUtils.printStackTrace(pageOutOfRangeException);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            BaseUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IOException iOException) {
            BaseUtils.printStackTrace(iOException);
        }
        return null;
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        this.hu = cb.a(this.hr, expProps);
        try {
            this.hw = this.getKey(this.hu);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        try {
            int n2;
            String string = expProps.getProperty("export_fmt");
            if (string.equals("svg")) {
                this.hx = 0;
                n2 = this.hq.getPageCountAndWait(this.hw, 600000) + 1;
            } else if (string.startsWith("htm")) {
                this.hx = -1;
                n2 = this.hq.getPageCountAndWait(this.hw, 600000) + 2;
            } else {
                this.hx = 1;
                n2 = this.hq.getPageCountAndWait(this.hw, 600000);
            }
            Throwable throwable = this.hq.getFailureCause(this.hw);
            if (throwable != null) {
                throw ViewerException.createViewerException(throwable);
            }
            return n2;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return -1;
    }

    protected EngineFactory getEngineFactory() {
        return Cache.getEngineFactory();
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        this.aw();
        try {
            return this.hq.getGroupTreeAndWait(this.hw, -1, 3, 600000);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        if (this.hy) {
            this.hr.put("promptonrefresh", "1");
        }
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.hr.remove(key);
        } else {
            this.hr.setProperty(key, value);
        }
    }

    @Override
    public String getReportProperty(String propertyKey) {
        return this.hr.getProperty(propertyKey);
    }

    @Override
    public Properties getProperties() {
        return this.hr;
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hy = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hy;
    }

    @Override
    public RenderData getCopy() {
        return new CacheRenderData(this.url, this.hs, this.ht);
    }

    @Override
    public void stop() {
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.hr);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            return this.hq.getPageAndWait(this.hw, -fontID, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = (Properties)this.hr.clone();
        try {
            this.hw = this.hq.createKey(properties, this.hs, this.ht);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        if (!this.hq.exists(this.hw)) {
            throw new ViewerException("report is no longer in the cache. You should not see this error.");
        }
        this.hq.resetCacheTimeout(this.hw);
    }
}

