/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.category;

import com.inet.jfree.data.category.CategoryDataset;
import com.inet.jfree.data.category.InetCategoryDataset;

public class StackedCategoryDataset
extends InetCategoryDataset
implements CategoryDataset {
    private final boolean isPercent;

    public StackedCategoryDataset(boolean isPercent) {
        this.isPercent = isPercent;
    }

    public final boolean isPercent() {
        return this.isPercent;
    }

    @Override
    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getValue(super.getRowIndex(rowKey), super.getColumnIndex(columnKey));
    }

    @Override
    public Number getValue(int row, int column) {
        if (this.isPercent) {
            return this.getPercentStackedValue(row, column);
        }
        return this.getStackedValue(row, column);
    }

    public final Number getStackedValue(int row, int column) {
        return new Double(this.getStackedValueIntern(row, column));
    }

    public final Number getPercentStackedValue(int row, int column) {
        return new Double(this.getStackedValueIntern(row, column) / this.getTotalValueIntern(column));
    }

    public final Number getPercentValue(int row, int column) {
        double result = 0.0;
        if (super.getValue(row, column) != null) {
            result += super.getValue(row, column).doubleValue();
        }
        return new Double(result / this.getTotalValueIntern(column));
    }

    private final double getStackedValueIntern(int row, int column) {
        double result = 0.0;
        for (int i = 0; i <= row; ++i) {
            if (super.getValue(i, column) == null) continue;
            result += super.getValue(i, column).doubleValue();
        }
        return result;
    }

    private final double getTotalValueIntern(int column) {
        double total = 0.0;
        int rowCount = super.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            Number n = super.getValue(r, column);
            if (n == null) continue;
            total += n.doubleValue();
        }
        return total;
    }

    public Number getOriginalValue(int row, int column) {
        return super.getValue(row, column);
    }
}

