/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.entity.PieSectionEntity;
import com.inet.jfree.chart.labels.PieToolTipGenerator;
import com.inet.jfree.chart.plot.InetPiePlot;
import com.inet.jfree.chart.plot.PiePlotState;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.PlotState;
import com.inet.jfree.data.general.DatasetUtilities;
import com.inet.jfree.data.general.PieDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;

public class InetPiePlot3D
extends InetPiePlot {
    private double depthFactor = 0.2;
    private Area frontPie = null;
    private Area backPie = null;
    private Area frontExplode = null;
    private Area backExplode = null;
    private int lastIndex = 0;

    public InetPiePlot3D(PieDataset dataset) {
        super(dataset);
        this.setCircular(false, false);
    }

    public void setDepthFactor(double factor) {
        this.depthFactor = factor;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(Graphics2D g2, Rectangle2D plotArea, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        void var72_92;
        int i;
        int startIndex;
        List sectionKeys;
        RectangleInsets insets = this.getInsets();
        insets.trim(plotArea);
        Rectangle2D originalPlotArea = (Rectangle2D)plotArea.clone();
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        double gapPercent = this.getInteriorGap();
        double labelPercent = 0.0;
        if (this.getLabelGenerator() != null) {
            labelPercent = this.getLabelGap() + this.getMaximumLabelWidth() + this.getLabelLinkMargin();
        }
        double gapHorizontal = plotArea.getWidth() * (gapPercent + labelPercent);
        double gapVertical = plotArea.getHeight() * gapPercent;
        double linkX = plotArea.getX() + gapHorizontal / 2.0;
        double linkY = plotArea.getY() + gapVertical / 2.0;
        double linkW = plotArea.getWidth() - gapHorizontal;
        double linkH = plotArea.getHeight() - gapVertical;
        if (this.isCircular()) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        PiePlotState state = this.initialise(g2, plotArea, this, null, info);
        double hh = linkW * this.getLabelLinkMargin();
        double vv = linkH * this.getLabelLinkMargin();
        Rectangle2D.Double explodeArea = new Rectangle2D.Double(linkX + hh / 2.0, linkY + vv / 2.0, linkW - hh, linkH - vv);
        state.setExplodedPieArea(explodeArea);
        double maximumExplodePercent = this.getMaximumExplodePercent();
        double percent = maximumExplodePercent / (1.0 + maximumExplodePercent);
        double h1 = ((RectangularShape)explodeArea).getWidth() * percent;
        double v1 = ((RectangularShape)explodeArea).getHeight() * percent;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(((RectangularShape)explodeArea).getX() + h1 / 2.0, ((RectangularShape)explodeArea).getY() + v1 / 2.0, ((RectangularShape)explodeArea).getWidth() - h1, ((RectangularShape)explodeArea).getHeight() - v1);
        int depth = (int)(((RectangularShape)pieArea).getHeight() * this.depthFactor);
        Rectangle2D.Double linkArea = new Rectangle2D.Double(linkX, linkY, linkW, linkH - (double)depth);
        state.setLinkArea(linkArea);
        state.setPieArea(pieArea);
        state.setPieCenterX(pieArea.getCenterX());
        state.setPieCenterY(pieArea.getCenterY() - (double)depth / 2.0);
        state.setPieWRadius(((RectangularShape)pieArea).getWidth() / 2.0);
        state.setPieHRadius((((RectangularShape)pieArea).getHeight() - (double)depth) / 2.0);
        this.drawBackground(g2, plotArea);
        PieDataset dataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull(this.getDataset())) {
            this.drawNoDataMessage(g2, plotArea);
            g2.setClip(savedClip);
            this.drawOutline(g2, plotArea);
            return;
        }
        if ((double)dataset.getKeys().size() > plotArea.getWidth()) {
            String text = "Too many elements";
            Font sfont = new Font("dialog", 1, 10);
            g2.setFont(sfont);
            FontMetrics fm = g2.getFontMetrics(sfont);
            int stringWidth = fm.stringWidth(text);
            g2.drawString(text, (int)(plotArea.getX() + (plotArea.getWidth() - (double)stringWidth) / 2.0), (int)(plotArea.getY() + plotArea.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double min = Math.min(plotArea.getWidth(), plotArea.getHeight()) / 2.0;
            plotArea = new Rectangle2D.Double(plotArea.getCenterX() - min, plotArea.getCenterY() - min, 2.0 * min, 2.0 * min);
        }
        if ((sectionKeys = dataset.getKeys()).size() == 0) {
            return;
        }
        double arcX = ((RectangularShape)pieArea).getX();
        double arcY = ((RectangularShape)pieArea).getY();
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double totalValue = DatasetUtilities.calculatePieDatasetTotal(dataset);
        double runningTotal = 0.0;
        if (depth < 0) {
            return;
        }
        Ellipse2D.Double top = new Ellipse2D.Double(((RectangularShape)pieArea).getX(), ((RectangularShape)pieArea).getY(), ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth);
        Ellipse2D.Double bottom = new Ellipse2D.Double(((RectangularShape)pieArea).getX(), ((RectangularShape)pieArea).getY() + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth);
        Rectangle2D.Double lower = new Rectangle2D.Double(((RectangularShape)top).getX(), top.getCenterY(), ((RectangularShape)pieArea).getWidth(), bottom.getMaxY() - top.getCenterY());
        Rectangle2D.Double upper = new Rectangle2D.Double(((RectangularShape)pieArea).getX(), ((RectangularShape)top).getY(), ((RectangularShape)pieArea).getWidth(), bottom.getCenterY() - ((RectangularShape)top).getY());
        Area a = new Area(top);
        a.add(new Area(lower));
        Area b = new Area(bottom);
        b.add(new Area(upper));
        Area pie = new Area(a);
        pie.intersect(b);
        Area front = new Area(pie);
        front.subtract(new Area(top));
        Area back = new Area(pie);
        back.subtract(new Area(bottom));
        this.frontPie = (Area)front.clone();
        this.backPie = (Area)back.clone();
        ArrayList<Arc2D.Double> arcList = new ArrayList<Arc2D.Double>();
        boolean explodeNext = false;
        for (Comparable currentKey : sectionKeys) {
            double angle1;
            double direction;
            Number dataValue = dataset.getValue(currentKey);
            if (dataValue == null) {
                arcList.add(null);
                continue;
            }
            double value = dataValue.doubleValue();
            if (value <= 0.0) {
                arcList.add(null);
                continue;
            }
            double startAngle = this.getStartAngle();
            double angle2 = startAngle + (direction = this.getDirection().getFactor()) * (runningTotal + value) * 360.0 / totalValue;
            if (Math.abs(angle2 - (angle1 = startAngle + direction * (runningTotal * 360.0) / totalValue)) > this.getMinimumArcAngleToDraw()) {
                if (this.getExplodePercent(currentKey) == 0.0) {
                    arcList.add(new Arc2D.Double(arcX, arcY + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, angle1, angle2 - angle1, 2));
                } else {
                    double ep = 0.0;
                    double mep = this.getMaximumExplodePercent();
                    if (mep > 0.0) {
                        ep = this.getExplodePercent(currentKey) / mep;
                    }
                    Rectangle2D arcBounds = this.getArcBounds(pieArea, explodeArea, angle1, angle2 - angle1, ep);
                    arcBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY() + (double)depth, arcBounds.getWidth(), arcBounds.getHeight() - (double)depth);
                    arcList.add(new Arc2D.Double(arcBounds, angle1, angle2 - angle1, 2));
                    Arc2D.Double segment = new Arc2D.Double(arcX, arcY + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, angle1, angle2 - angle1, 2);
                    this.subtractSide(g2, pieArea, segment, front, back, false, true, true);
                    this.subtractSide(g2, pieArea, segment, front, back, true, false, true);
                }
            } else {
                arcList.add(null);
            }
            runningTotal += value;
        }
        Shape oldClip = g2.getClip();
        Arc2D.Double arc = new Arc2D.Double(arcX, arcY + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, 0.0, 360.0, 2);
        int categoryCount = arcList.size();
        for (int categoryIndex = 0; categoryIndex < categoryCount; ++categoryIndex) {
            arc = (Arc2D.Double)arcList.get(categoryIndex);
            if (arc == null) continue;
            Comparable key = this.getSectionKey(categoryIndex);
            this.getPiePainter().paintArc(g2, this, key, arc);
        }
        g2.setPaint(Color.gray);
        if (this.getMaximumExplodePercent() == 0.0) {
            g2.fill(back);
            g2.fill(front);
        } else {
            g2.fill(this.backPie);
            g2.fill(this.frontPie);
        }
        int sIndex = startIndex = this.getStartSegment(arcList);
        int[] arcListIndex = new int[categoryCount];
        if (this.getDirection() == Rotation.ANTICLOCKWISE) {
            for (i = 0; i < categoryCount; ++i) {
                arcListIndex[i] = sIndex--;
                if (sIndex >= 0) continue;
                sIndex = categoryCount - 1;
            }
        } else {
            for (i = 0; i < categoryCount; ++i) {
                arcListIndex[i] = sIndex++;
                if (sIndex < categoryCount) continue;
                sIndex = 0;
            }
        }
        arcListIndex = this.getEndTo270(arcListIndex, arcList);
        block56: for (int currentIndex = 0; currentIndex < categoryCount; ++currentIndex) {
            Area sub;
            GeneralPath polygon3;
            Area sub2;
            Arc2D.Double arcN;
            Comparable keyNext;
            int n = arcListIndex[currentIndex];
            boolean firstSegment = currentIndex == 0;
            boolean lastSegment = this.isLastSegment(n, arcListIndex);
            if (n == -1 || (arc = (Arc2D.Double)arcList.get(n)) == null) continue;
            Comparable key = this.getSectionKey(n);
            explodeNext = false;
            if (this.getMaximumExplodePercent() != 0.0 && this.getExplodePercent(key) == 0.0) {
                if (n + 1 == categoryCount) {
                    for (int cati = 0; cati < n; ++cati) {
                        Arc2D.Double arcN2 = (Arc2D.Double)arcList.get(cati);
                        if (arcN2 == null) continue;
                        keyNext = this.getSectionKey(cati);
                        if (this.getExplodePercent(keyNext) == 0.0) break;
                        explodeNext = true;
                        break;
                    }
                } else {
                    int endi = categoryCount;
                    for (int cati = n + 1; cati < endi; ++cati) {
                        arcN = (Arc2D.Double)arcList.get(cati);
                        if (arcN == null) {
                            if (cati + 1 != categoryCount) continue;
                            cati = -1;
                            endi = n;
                            continue;
                        }
                        keyNext = this.getSectionKey(cati);
                        if (this.getExplodePercent(keyNext) == 0.0) break;
                        explodeNext = true;
                        break;
                    }
                }
            }
            if (n - 1 < 0) {
                for (int cati = categoryCount - 1; cati > 0; --cati) {
                    Arc2D.Double arcN3 = (Arc2D.Double)arcList.get(cati);
                    if (arcN3 == null) continue;
                    keyNext = this.getSectionKey(cati);
                    break;
                }
            } else {
                int endi = 0;
                for (int cati = n - 1; cati >= endi; --cati) {
                    arcN = (Arc2D.Double)arcList.get(cati);
                    if (arcN == null) {
                        if (cati - 1 != -1) continue;
                        cati = categoryCount - 1;
                        endi = n + 1;
                        continue;
                    }
                    keyNext = this.getSectionKey(cati);
                    break;
                }
            }
            Point2D p1 = arc.getStartPoint();
            Point2D p2 = arc.getEndPoint();
            GeneralPath polygon1 = this.getDetachPath(arc, p1, depth);
            GeneralPath polygon2 = this.getDetachPath(arc, p2, depth);
            double ast = arc.getAngleStart();
            double aend = arc.getAngleStart() + arc.getAngleExtent();
            if (this.getMaximumExplodePercent() == 0.0) {
                this.drawSideArea(g2, polygon1, key);
                this.drawSide(g2, pieArea, arc, front, back, key, false);
                this.drawSide(g2, pieArea, arc, front, back, key, true);
                continue;
            }
            int backCode = this.subtractSide(g2, pieArea, arc, front, back, false, true, false);
            int frontCode = this.subtractSide(g2, pieArea, arc, front, back, true, false, false);
            if (this.getExplodePercent(key) == 0.0) {
                GeneralPath polygon32;
                switch (backCode) {
                    case -1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 5: {
                        boolean isNextLast;
                        if (Math.cos(Math.toRadians(aend)) > 0.0) {
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            if (Math.cos(Math.toRadians(ast)) < 0.0) {
                                if (lastSegment) {
                                    polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                                    sub2 = new Area(polygon1);
                                    sub2.subtract(new Area(polygon32));
                                    this.drawSideArea(g2, sub2, key);
                                } else {
                                    this.drawSideArea(g2, polygon1, key);
                                }
                            }
                            if (!explodeNext) break;
                            boolean isNextLast2 = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                            if (isNextLast2) {
                                polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                                sub = new Area(polygon2);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                                break;
                            }
                            if (lastSegment) {
                                polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub = new Area(polygon2);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                                break;
                            }
                            this.drawSideArea(g2, polygon2, key);
                            break;
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        if (explodeNext) {
                            this.drawSideArea(g2, polygon2, key);
                        }
                        if (isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex)) {
                            polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, false);
                            sub = new Area(polygon1);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            break;
                        }
                        if (lastSegment) {
                            polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub = new Area(polygon1);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            if (!(Math.cos(Math.toRadians(ast)) < 0.0)) break;
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                            break;
                        }
                        this.drawSideArea(g2, polygon1, key);
                        break;
                    }
                    case 15: {
                        if (Math.cos(Math.toRadians(aend)) > 0.0) {
                            if (explodeNext) {
                                this.drawSideArea(g2, polygon2, key);
                            }
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            this.drawSideArea(g2, polygon1, key);
                            if (!lastSegment) break;
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                            break;
                        }
                        if (Math.cos(Math.toRadians(ast)) < 0.0) {
                            this.drawSideArea(g2, polygon1, key);
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                            if (isNextLast) {
                                polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                                sub = new Area(polygon2);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                                break;
                            }
                            if (lastSegment && Math.cos(Math.toRadians(ast)) < 0.0) {
                                polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub = new Area(polygon2);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                                break;
                            }
                            this.drawSideArea(g2, polygon2, key);
                            break;
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSideArea(g2, polygon1, key);
                        if (lastSegment && Math.cos(Math.toRadians(ast)) < 0.0) {
                            GeneralPath polygon33 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub2 = new Area(polygon2);
                            sub2.subtract(new Area(polygon33));
                            this.drawSideArea(g2, sub2, key);
                            break;
                        }
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                    case 3: {
                        if (frontCode == 4) {
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            if (!explodeNext) break;
                            if (lastSegment && Math.cos(Math.toRadians(ast)) > 0.0) {
                                GeneralPath polygon34 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub2 = new Area(polygon2);
                                sub2.subtract(new Area(polygon34));
                                this.drawSideArea(g2, sub2, key);
                                break;
                            }
                            this.drawSideArea(g2, polygon2, key);
                            break;
                        }
                    }
                    case 13: {
                        if (frontCode != 14) break;
                        break;
                    }
                    case 12: {
                        if (frontCode != 12) break;
                        break;
                    }
                    case 6: {
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSideArea(g2, polygon1, key);
                        if (explodeNext) {
                            this.drawSideArea(g2, polygon2, key);
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 16: {
                        if (frontCode != 16) break;
                        break;
                    }
                    case 7: {
                        if (frontCode != 8) break;
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        if (lastSegment && Math.cos(Math.toRadians(aend)) > 0.0) break;
                        if (lastSegment && Math.cos(Math.toRadians(ast)) < 0.0) {
                            GeneralPath polygon35 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub2 = new Area(polygon1);
                            sub2.subtract(new Area(polygon35));
                            this.drawSideArea(g2, sub2, key);
                            break;
                        }
                        this.drawSideArea(g2, polygon1, key);
                        break;
                    }
                    case 17: {
                        if (frontCode != 18) break;
                        break;
                    }
                    default: {
                        this.drawSideArea(g2, polygon1, key);
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        this.drawSideArea(g2, polygon2, key);
                    }
                }
                switch (frontCode) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        if (Math.cos(Math.toRadians(aend)) > 0.0) {
                            this.drawSideArea(g2, polygon1, key);
                            if (explodeNext) {
                                this.drawSideArea(g2, polygon2, key);
                                if (lastSegment) {
                                    this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                                }
                            }
                        } else {
                            if (explodeNext && !lastSegment) {
                                this.drawSideArea(g2, polygon2, key);
                            }
                            if (!lastSegment) {
                                this.drawSideArea(g2, polygon1, key);
                            } else {
                                this.drawSideArea(g2, polygon1, key);
                                if (Math.cos(Math.toRadians(ast)) < 0.0) {
                                    this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                }
                            }
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 11: {
                        if (Math.cos(Math.toRadians(ast)) < 0.0) {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        if (Math.cos(Math.toRadians(aend)) > 0.0) {
                            if (explodeNext) {
                                this.drawSideArea(g2, polygon2, key);
                            }
                            this.drawSide(g2, pieArea, arc, front, back, key, true);
                            if (!(Math.cos(Math.toRadians(ast)) > 0.0)) continue block56;
                            if (lastSegment) {
                                polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                                sub2 = new Area(polygon1);
                                sub2.subtract(new Area(polygon32));
                                this.drawSideArea(g2, sub2, key);
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                break;
                            }
                            this.drawSideArea(g2, polygon1, key);
                            break;
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        if (!explodeNext) continue block56;
                        if (lastSegment) {
                            polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub2 = new Area(polygon2);
                            sub2.subtract(new Area(polygon32));
                            this.drawSideArea(g2, sub2, key);
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                            break;
                        }
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                    case 2: {
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSideArea(g2, polygon1, key);
                        if (firstSegment && Math.cos(Math.toRadians(aend)) < 0.0) {
                            this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        if (lastSegment && Math.cos(Math.toRadians(ast)) < 0.0 && Math.sin(Math.toRadians(ast)) < 0.0) {
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                        }
                        if (!explodeNext || !(Math.cos(Math.toRadians(aend)) > 0.0)) continue block56;
                        if (lastSegment && Math.cos(Math.toRadians(ast)) < 0.0) {
                            polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub2 = new Area(polygon2);
                            sub2.subtract(new Area(polygon32));
                            this.drawSideArea(g2, sub2, key);
                            break;
                        }
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                    case 12: {
                        if (backCode != 12) continue block56;
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        if (lastSegment && Math.cos(Math.toRadians(ast)) > 0.0 && Math.sin(Math.toRadians(ast)) < 0.0) {
                            polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub2 = new Area(polygon1);
                            sub2.subtract(new Area(polygon32));
                            this.drawSideArea(g2, sub2, key);
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        if (explodeNext) {
                            if (lastSegment && Math.cos(Math.toRadians(aend)) < 0.0 && Math.sin(Math.toRadians(aend)) < 0.0) {
                                polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub2 = new Area(polygon2);
                                sub2.subtract(new Area(polygon32));
                                this.drawSideArea(g2, sub2, key);
                            } else {
                                this.drawSideArea(g2, polygon2, key);
                            }
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        if (!lastSegment || !(Math.cos(Math.toRadians(ast)) > 0.0)) continue block56;
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                        break;
                    }
                    case 4: {
                        if (firstSegment && Math.cos(Math.toRadians(ast)) > 0.0) {
                            this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                        }
                        if (Math.cos(Math.toRadians(ast)) < 0.0) {
                            boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                            if (isNextLast) {
                                polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, false);
                                sub = new Area(polygon1);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                            } else if (!lastSegment) {
                                this.drawSideArea(g2, polygon1, key);
                            } else {
                                this.drawSideArea(g2, polygon1, key);
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                            }
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 14: {
                        if (firstSegment) {
                            this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                        }
                        if (backCode != 13) continue block56;
                        if (Math.cos(Math.toRadians(aend)) > 0.0) {
                            if (explodeNext) {
                                this.drawSideArea(g2, polygon2, key);
                            }
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                        } else {
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            if (explodeNext) {
                                if (lastSegment && Math.cos(Math.toRadians(aend)) < 0.0) {
                                    polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                    sub2 = new Area(polygon2);
                                    sub2.subtract(new Area(polygon32));
                                    this.drawSideArea(g2, sub2, key);
                                } else if (firstSegment && Math.cos(Math.toRadians(aend)) < 0.0) {
                                    polygon32 = this.getDetachPath(arcListIndex.length - 1, arcListIndex, arcList, depth, true);
                                    sub2 = new Area(polygon2);
                                    sub2.subtract(new Area(polygon32));
                                    this.drawSideArea(g2, sub2, key);
                                } else {
                                    this.drawSideArea(g2, polygon2, key);
                                }
                            }
                        }
                        if (lastSegment && Math.sin(Math.toRadians(ast)) < 0.0 && Math.cos(Math.toRadians(ast)) > 0.0) {
                            polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub2 = new Area(polygon1);
                            sub2.subtract(new Area(polygon32));
                            this.drawSideArea(g2, sub2, key);
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 16: {
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSideArea(g2, polygon1, key);
                        this.drawSideArea(g2, polygon2, key);
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 8: {
                        if (backCode != 7) continue block56;
                        if (firstSegment && (Math.cos(Math.toRadians(aend)) < 0.0 || Math.cos(Math.toRadians(ast)) > 0.0)) {
                            this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                        }
                        if (explodeNext) {
                            if (lastSegment && Math.cos(Math.toRadians(aend)) > 0.0) {
                                GeneralPath polygon322 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                Area sub22 = new Area(polygon2);
                                sub22.subtract(new Area(polygon322));
                                this.drawSideArea(g2, sub22, key);
                            } else {
                                this.drawSideArea(g2, polygon2, key);
                            }
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    case 18: {
                        if (backCode != 17) continue block56;
                        if (!lastSegment || !(Math.cos(Math.toRadians(ast)) > 0.0)) {
                            this.drawSide(g2, pieArea, arc, front, back, key, false);
                            this.drawSideArea(g2, polygon1, key);
                            if (lastSegment) {
                                if (Math.cos(Math.toRadians(aend)) < 0.0) {
                                    this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                                } else {
                                    this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                }
                            }
                        }
                        if (explodeNext) {
                            if (lastSegment) {
                                polygon32 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub2 = new Area(polygon2);
                                sub2.subtract(new Area(polygon32));
                                this.drawSideArea(g2, sub2, key);
                            } else {
                                this.drawSideArea(g2, polygon2, key);
                            }
                        }
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        break;
                    }
                    default: {
                        this.drawSideArea(g2, polygon1, key);
                        this.drawSide(g2, pieArea, arc, front, back, key, false);
                        this.drawSide(g2, pieArea, arc, front, back, key, true);
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                }
                continue;
            }
            this.createExplodeArea(new Rectangle2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight()), depth);
            switch (backCode) {
                case -1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        if (Math.cos(Math.toRadians(ast)) < 0.0) {
                            this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                            this.drawSideArea(g2, polygon1, key);
                        } else {
                            boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                            if (isNextLast) {
                                polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                                sub = new Area(polygon1);
                                sub.subtract(new Area(polygon3));
                                this.drawSideArea(g2, sub, key);
                            } else {
                                this.drawSideArea(g2, polygon1, key);
                            }
                            this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                        }
                        boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                        if (isNextLast) {
                            polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                            sub = new Area(polygon2);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            break;
                        }
                        if (lastSegment) {
                            polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub = new Area(polygon2);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            Area frontExplodeRett = this.frontExplode;
                            Area backExplodeRett = this.backExplode;
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                            this.frontExplode = frontExplodeRett;
                            this.backExplode = backExplodeRett;
                            break;
                        }
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                    boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                    if (isNextLast) {
                        polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, false);
                        sub = new Area(polygon2);
                        sub.subtract(new Area(polygon3));
                        this.drawSideArea(g2, sub, key);
                    } else {
                        this.drawSideArea(g2, polygon2, key);
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    if (isNextLast) {
                        polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, false);
                        sub = new Area(polygon1);
                        sub.subtract(new Area(polygon3));
                        this.drawSideArea(g2, sub, key);
                        break;
                    }
                    if (lastSegment) {
                        polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                        sub = new Area(polygon1);
                        sub.subtract(new Area(polygon3));
                        this.drawSideArea(g2, sub, key);
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                        break;
                    }
                    this.drawSideArea(g2, polygon1, key);
                    break;
                }
                case 15: {
                    if (firstSegment) {
                        this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                    }
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        this.drawSideArea(g2, polygon2, key);
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                        this.drawSideArea(g2, polygon1, key);
                        if (!lastSegment) break;
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                        break;
                    }
                    if (Math.cos(Math.toRadians(ast)) < 0.0) {
                        boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                        if (isNextLast) {
                            polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                            sub = new Area(polygon1);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                        if (isNextLast) {
                            polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, true);
                            sub = new Area(polygon2);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            break;
                        }
                        if (lastSegment) {
                            polygon3 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub = new Area(polygon2);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                            break;
                        }
                        this.drawSideArea(g2, polygon2, key);
                        break;
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSideArea(g2, polygon2, key);
                    break;
                }
                case 12: {
                    break;
                }
                case 3: {
                    if (frontCode != 4) break;
                    break;
                }
                case 13: {
                    if (frontCode != 14) break;
                    break;
                }
                case 6: {
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSideArea(g2, polygon2, key);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    break;
                }
                case 16: {
                    if (frontCode != 16) break;
                    break;
                }
                case 7: {
                    if (frontCode != 8) break;
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    if (lastSegment && Math.cos(Math.toRadians(aend)) > 0.0) break;
                    this.drawSideArea(g2, polygon1, key);
                    break;
                }
                case 17: {
                    if (frontCode != 18) break;
                    break;
                }
                default: {
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    this.drawSideArea(g2, polygon2, key);
                }
            }
            switch (frontCode) {
                case -1: {
                    continue block56;
                }
                case 6: {
                    continue block56;
                }
                case 1: {
                    Area backExplodeRett2;
                    Area frontExplodeRett;
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        this.drawSideArea(g2, polygon1, key);
                        this.drawSideArea(g2, polygon2, key);
                        if (lastSegment) {
                            Area frontExplodeRett2 = this.frontExplode;
                            Area backExplodeRett2 = this.backExplode;
                            this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                            this.frontExplode = frontExplodeRett2;
                            this.backExplode = backExplodeRett2;
                        }
                    } else {
                        if (!lastSegment) {
                            this.drawSideArea(g2, polygon2, key);
                        }
                        if (lastSegment) {
                            GeneralPath polygon36 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub2 = new Area(polygon1);
                            sub2.subtract(new Area(polygon36));
                            this.drawSideArea(g2, sub2, key);
                            if (Math.cos(Math.toRadians(ast)) < 0.0) {
                                frontExplodeRett = this.frontExplode;
                                backExplodeRett2 = this.backExplode;
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                this.frontExplode = frontExplodeRett;
                                this.backExplode = backExplodeRett2;
                            }
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                        }
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 11: {
                    Area backExplodeRett;
                    Area backExplodeRett2;
                    Area frontExplodeRett;
                    if (Math.cos(Math.toRadians(ast)) < 0.0 && !lastSegment) {
                        this.drawSideArea(g2, polygon1, key);
                    }
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        if (lastSegment) {
                            GeneralPath polygon37 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub2 = new Area(polygon2);
                            sub2.subtract(new Area(polygon37));
                            this.drawSideArea(g2, sub2, key);
                        } else {
                            this.drawSideArea(g2, polygon2, key);
                        }
                        if (Math.cos(Math.toRadians(ast)) > 0.0) {
                            if (lastSegment) {
                                GeneralPath polygon38 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                                sub2 = new Area(polygon1);
                                sub2.subtract(new Area(polygon38));
                                this.drawSideArea(g2, sub2, key);
                                frontExplodeRett = this.frontExplode;
                                backExplodeRett2 = this.backExplode;
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                this.frontExplode = frontExplodeRett;
                                this.backExplode = backExplodeRett2;
                            } else {
                                this.drawSideArea(g2, polygon1, key);
                            }
                        }
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                        continue block56;
                    }
                    if (!lastSegment) {
                        this.drawSideArea(g2, polygon2, key);
                    } else {
                        this.drawSideArea(g2, polygon2, key);
                        Area frontExplodeRett3 = this.frontExplode;
                        backExplodeRett = this.backExplode;
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                        this.frontExplode = frontExplodeRett3;
                        this.backExplode = backExplodeRett;
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 2: {
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSideArea(g2, polygon2, key);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 12: {
                    if (backCode != 12) continue block56;
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    if (lastSegment && Math.sin(Math.toRadians(ast)) < 0.0 && Math.cos(Math.toRadians(ast)) > 0.0) {
                        GeneralPath polygon39 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                        sub2 = new Area(polygon1);
                        sub2.subtract(new Area(polygon39));
                        this.drawSideArea(g2, sub2, key);
                    } else {
                        this.drawSideArea(g2, polygon1, key);
                    }
                    if (lastSegment && Math.sin(Math.toRadians(aend)) < 0.0 && Math.cos(Math.toRadians(aend)) < 0.0) {
                        GeneralPath polygon310 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                        sub2 = new Area(polygon2);
                        sub2.subtract(new Area(polygon310));
                        this.drawSideArea(g2, sub2, key);
                    } else {
                        this.drawSideArea(g2, polygon2, key);
                    }
                    if (lastSegment && Math.sin(Math.toRadians(ast)) < 0.0 && Math.cos(Math.toRadians(ast)) > 0.0) {
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                    }
                    if (lastSegment && Math.sin(Math.toRadians(aend)) < 0.0 && Math.cos(Math.toRadians(aend)) < 0.0) {
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 4: {
                    if (!lastSegment) {
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    }
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        this.drawSideArea(g2, polygon2, key);
                    }
                    if (firstSegment && Math.cos(Math.toRadians(ast)) > 0.0) {
                        this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                    }
                    if (Math.cos(Math.toRadians(ast)) < 0.0) {
                        boolean isNextLast = this.isNextLastSegment(currentIndex + 1, arcListIndex);
                        if (isNextLast) {
                            polygon3 = this.getDetachPath(currentIndex + 1, arcListIndex, arcList, depth, false);
                            sub = new Area(polygon1);
                            sub.subtract(new Area(polygon3));
                            this.drawSideArea(g2, sub, key);
                        } else {
                            this.drawSideArea(g2, polygon1, key);
                            if (lastSegment) {
                                Area frontExplodeRett = this.frontExplode;
                                Area backExplodeRett = this.backExplode;
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                                this.frontExplode = frontExplodeRett;
                                this.backExplode = backExplodeRett;
                            }
                        }
                    } else {
                        this.drawSideArea(g2, polygon1, key);
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 14: {
                    Area backExplodeRett2;
                    Area frontExplodeRett;
                    if (backCode != 13) continue block56;
                    if (firstSegment) {
                        this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                    }
                    if (Math.cos(Math.toRadians(aend)) > 0.0) {
                        this.drawSideArea(g2, polygon2, key);
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    } else {
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                        if (lastSegment && Math.sin(Math.toRadians(aend)) > 0.0) {
                            GeneralPath polygon311 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                            sub2 = new Area(polygon2);
                            sub2.subtract(new Area(polygon311));
                            this.drawSideArea(g2, sub2, key);
                        } else {
                            this.drawSideArea(g2, polygon2, key);
                        }
                    }
                    if (lastSegment && Math.cos(Math.toRadians(ast)) > 0.0) {
                        GeneralPath polygon312 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                        sub2 = new Area(polygon1);
                        sub2.subtract(new Area(polygon312));
                        this.drawSideArea(g2, sub2, key);
                        frontExplodeRett = this.frontExplode;
                        backExplodeRett2 = this.backExplode;
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, true);
                        this.frontExplode = frontExplodeRett;
                        this.backExplode = backExplodeRett2;
                    } else {
                        this.drawSideArea(g2, polygon1, key);
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 16: {
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSideArea(g2, polygon2, key);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                case 8: {
                    Area backExplodeRett2;
                    Area frontExplodeRett;
                    if (backCode == 7) {
                        if (firstSegment && Math.cos(Math.toRadians(aend)) < 0.0) {
                            this.drawLastSegStartSide(g2, arcListIndex, arcList, pieArea, depth, front, back);
                        }
                        if (lastSegment && Math.cos(Math.toRadians(aend)) > 0.0) {
                            if (Math.sin(Math.toRadians(aend)) < 0.0) {
                                GeneralPath polygon313 = this.getDetachPath(0, arcListIndex, arcList, depth, true);
                                sub2 = new Area(polygon2);
                                sub2.subtract(new Area(polygon313));
                                this.drawSideArea(g2, sub2, key);
                                frontExplodeRett = this.frontExplode;
                                backExplodeRett2 = this.backExplode;
                                this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                                this.frontExplode = frontExplodeRett;
                                this.backExplode = backExplodeRett2;
                            }
                        } else {
                            this.drawSideArea(g2, polygon2, key);
                        }
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    }
                }
                case 18: {
                    Area backExplodeRett;
                    if (backCode != 17) continue block56;
                    if (!firstSegment || Math.cos(Math.toRadians(ast)) < 0.0) {
                        // empty if block
                    }
                    if (Math.cos(Math.toRadians(ast)) > 0.0) {
                        if (!lastSegment) {
                            this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                            this.drawSideArea(g2, polygon1, key);
                        }
                        if (lastSegment) {
                            GeneralPath polygon314 = this.getDetachPath(0, arcListIndex, arcList, depth, false);
                            sub2 = new Area(polygon1);
                            sub2.subtract(new Area(polygon314));
                            this.drawSideArea(g2, sub2, key);
                        }
                    } else {
                        if (!lastSegment) {
                            this.drawSideArea(g2, polygon1, key);
                        }
                        this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    }
                    if (lastSegment && Math.sin(Math.toRadians(aend)) < 0.0 && Math.cos(Math.toRadians(aend)) < 0.0) {
                        this.drawSideArea(g2, polygon2, key);
                        Area frontExplodeRett = this.frontExplode;
                        backExplodeRett = this.backExplode;
                        this.drawSegmentSide(g2, startIndex, arcListIndex, arcList, state, depth, front, back, true, false);
                        this.frontExplode = frontExplodeRett;
                        this.backExplode = backExplodeRett;
                    } else {
                        this.drawSideArea(g2, polygon2, key);
                    }
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    continue block56;
                }
                default: {
                    this.drawSideArea(g2, polygon1, key);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, false);
                    this.drawSide(g2, explodeArea, arc, this.frontExplode, this.backExplode, key, true);
                    this.drawSideArea(g2, polygon2, key);
                }
            }
        }
        if (this.getMaximumExplodePercent() == 0.0) {
            int cat = 0;
            for (Arc2D arc2D : arcList) {
                if (arc2D != null) {
                    Comparable key = this.getSectionKey(cat);
                    this.drawSide(g2, pieArea, arc2D, front, back, key, false);
                }
                ++cat;
            }
            cat = 0;
            for (Arc2D arc2D : arcList) {
                if (arc2D != null) {
                    Comparable key = this.getSectionKey(cat);
                    this.drawSide(g2, pieArea, arc2D, front, back, key, true);
                }
                ++cat;
            }
        }
        g2.setClip(oldClip);
        boolean bl = false;
        while (var72_92 < categoryCount) {
            int sectionIndex = arcListIndex[var72_92];
            if (sectionIndex != -1 && (arc = (Arc2D.Double)arcList.get(sectionIndex)) != null) {
                EntityCollection entities;
                Comparable currentKey = (Comparable)sectionKeys.get(sectionIndex);
                Arc2D.Double upperArc = this.getExplodePercent(currentKey) == 0.0 ? new Arc2D.Double(arcX, arcY, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, arc.getAngleStart(), arc.getAngleExtent(), 2) : new Arc2D.Double(arc.getX(), arc.getY() - (double)depth, arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), 2);
                this.getPiePainter().paintArc(g2, this, currentKey, upperArc);
                if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
                    String tip = null;
                    PieToolTipGenerator tipster = this.getToolTipGenerator();
                    if (tipster != null) {
                        tip = tipster.generateToolTip(dataset, currentKey);
                    }
                    String url = null;
                    if (this.getURLGenerator() != null) {
                        url = this.getURLGenerator().generateURL(dataset, currentKey, this.getPieIndex());
                    }
                    PieSectionEntity entity = new PieSectionEntity(upperArc, dataset, this.getPieIndex(), sectionIndex, currentKey, tip, url);
                    entities.add(entity);
                }
                List keys = dataset.getKeys();
                Rectangle2D.Double adjustedPlotArea = new Rectangle2D.Double(originalPlotArea.getX(), originalPlotArea.getY(), originalPlotArea.getWidth(), originalPlotArea.getHeight() - (double)depth);
                this.drawLabels(g2, keys, totalValue, adjustedPlotArea, linkArea, state);
            }
            ++var72_92;
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, originalPlotArea);
    }

    private int getStartSegment(ArrayList arcList) {
        int categoryCount = arcList.size();
        int segmentCount = 0;
        int minCount = 4;
        for (int i = 0; i < categoryCount; ++i) {
            Arc2D.Double arc = (Arc2D.Double)arcList.get(i);
            if (arc == null) continue;
            ++segmentCount;
        }
        if (segmentCount < 2) {
            return 0;
        }
        int beg = 0;
        double cosAlt = 1.0;
        for (int categoryIndex = 0; categoryIndex < categoryCount; ++categoryIndex) {
            Arc2D.Double arcAlt;
            Arc2D.Double arc = (Arc2D.Double)arcList.get(categoryIndex);
            if (arc == null) continue;
            double start = arc.getAngleStart();
            double extent = arc.getAngleExtent();
            double endAng = start + extent;
            double sinAngS = Math.sin(Math.toRadians(start));
            double cosAngS = Math.cos(Math.toRadians(start));
            double sinAngE = Math.sin(Math.toRadians(endAng));
            double cosAngE = Math.cos(Math.toRadians(endAng));
            if (this.isAngleAtFront(start) && !this.isAngleAtBack(endAng) && (extent >= 180.0 || extent <= -180.0)) {
                beg = categoryIndex;
                break;
            }
            if (this.getDirection() == Rotation.CLOCKWISE && this.isAngleAtBack(start) && cosAngS < 0.0 && (cosAngE > 0.0 || sinAngE < 0.0 && cosAngE < 0.0)) {
                beg = categoryIndex;
                break;
            }
            if (this.isAngleAtBack(start) && this.isAngleAtBack(endAng)) {
                if (this.getDirection() == Rotation.ANTICLOCKWISE) {
                    if (extent > 180.0 && cosAngS > 0.0 && cosAngE > 0.0) {
                        beg = categoryIndex;
                        break;
                    }
                    if (extent > 180.0 && cosAngE < 0.0 && segmentCount < minCount) {
                        beg = categoryIndex;
                        break;
                    }
                    if (extent > 180.0 && cosAngE > 0.0 && segmentCount < minCount) {
                        beg = categoryIndex;
                        break;
                    }
                } else {
                    if (extent < -180.0 && cosAngE > 0.0 && segmentCount < minCount) {
                        beg = categoryIndex;
                        break;
                    }
                    if (extent < -180.0 && cosAngE < 0.0 && segmentCount < minCount) {
                        beg = categoryIndex;
                        break;
                    }
                }
            }
            if (this.isAngleAtBack(start) && this.isAngleAtFront(endAng)) {
                if (this.getDirection() == Rotation.ANTICLOCKWISE) {
                    if (cosAngS > 0.0) {
                        if (!(sinAngE < 0.0)) continue;
                        beg = categoryIndex;
                        break;
                    }
                } else if (cosAngE < 0.0) continue;
            }
            if (this.isAngleAtFront(start) && this.isAngleAtBack(endAng) && this.getDirection() == Rotation.ANTICLOCKWISE && cosAngE < 0.0) {
                beg = categoryIndex;
                break;
            }
            if (sinAngS < 0.0 && sinAngE < 0.0 || cosAngS < 0.0 && cosAngE < 0.0 && (this.isAngleAtFront(start) && this.isAngleAtBack(endAng) && extent > 0.0 || !this.isAngleAtBack(start) || !this.isAngleAtBack(endAng) || !(extent < 0.0))) continue;
            if (this.isAngleAtFront(start) && this.isAngleAtBack(endAng) && extent < 0.0) {
                if (cosAngS > 0.0) {
                    // empty if block
                }
                if (cosAngE > 0.0) {
                    beg = categoryIndex;
                    break;
                }
            }
            if ((arcAlt = (Arc2D.Double)arcList.get(beg)) == null) {
                beg = categoryIndex;
                if (Math.abs(cosAngS) < Math.abs(cosAngE)) {
                    cosAlt = Math.abs(cosAngS);
                    continue;
                }
                cosAlt = Math.abs(cosAngE);
                continue;
            }
            if (sinAngS > 0.0) {
                double startAlt = arcAlt.getAngleStart();
                double cosStartAlt = Math.cos(Math.toRadians(startAlt));
                if (this.getDirection() == Rotation.CLOCKWISE) {
                    if (cosAngS < 0.0) {
                        if (cosStartAlt > 0.0) {
                            beg = categoryIndex;
                            cosAlt = Math.abs(cosAngS);
                            continue;
                        }
                        if (cosAngE > 0.0) {
                            beg = categoryIndex;
                            break;
                        }
                    }
                    if (cosAngS > 0.0 && cosStartAlt < 0.0) continue;
                }
                if (Math.abs(cosAngS) <= cosAlt) {
                    beg = categoryIndex;
                    cosAlt = Math.abs(cosAngS);
                    if (this.getDirection() == Rotation.CLOCKWISE && cosAlt == 0.0) break;
                }
            }
            if (this.getDirection() == Rotation.CLOCKWISE && sinAngS < 0.0 && sinAngE > 0.0 && cosAngS > 0.0 || !(sinAngE > 0.0)) continue;
            double endAlt = arcAlt.getAngleStart() + arcAlt.getAngleExtent();
            double cosEndAlt = Math.cos(Math.toRadians(endAlt));
            if (this.getDirection() == Rotation.ANTICLOCKWISE) {
                if (cosAngE < 0.0 && cosEndAlt > 0.0 && Math.abs(cosAngE) < cosEndAlt) {
                    beg = categoryIndex;
                    cosAlt = Math.abs(cosAngE);
                    continue;
                }
                if (cosAngE > 0.0 && cosEndAlt < 0.0) continue;
            }
            if (!(Math.abs(cosAngE) < cosAlt)) continue;
            beg = categoryIndex;
            cosAlt = Math.abs(cosAngE);
            if (this.getDirection() == Rotation.ANTICLOCKWISE && cosAlt == 0.0) break;
        }
        return beg;
    }

    private int[] getEndTo270(int[] arcListIndex, ArrayList arcList) {
        int i;
        int categoryCount = arcList.size();
        int[] arcListIndex270 = new int[categoryCount];
        for (i = 0; i < categoryCount; ++i) {
            arcListIndex270[i] = -1;
        }
        int iend = categoryCount;
        for (i = 0; i < categoryCount; ++i) {
            Arc2D.Double arc = (Arc2D.Double)arcList.get(arcListIndex[i]);
            if (arc == null) continue;
            double startAng = arc.getAngleStart();
            double cosAngS = Math.cos(Math.toRadians(startAng));
            double endAng = startAng + arc.getAngleExtent();
            double cosAngE = Math.cos(Math.toRadians(endAng));
            if (i == 0) {
                arcListIndex270[i] = arcListIndex[i];
                continue;
            }
            if (this.getDirection() == Rotation.CLOCKWISE && cosAngE > 0.0 || this.getDirection() == Rotation.ANTICLOCKWISE && cosAngS > 0.0) {
                arcListIndex270[i] = arcListIndex[i];
                continue;
            }
            iend = i;
            break;
        }
        for (int j = categoryCount - 1; j >= iend; --j) {
            if ((Arc2D.Double)arcList.get(arcListIndex[j]) == null) continue;
            arcListIndex270[i++] = arcListIndex[j];
        }
        return arcListIndex270;
    }

    private GeneralPath getDetachPath(int index, int[] arcListIndex, ArrayList arcList, int depth, boolean startSide) {
        while (index < arcListIndex.length) {
            if (arcListIndex[index] != -1) {
                index = arcListIndex[index];
                break;
            }
            ++index;
        }
        Arc2D.Double arc = (Arc2D.Double)arcList.get(index);
        Point2D p3 = arc.getStartPoint();
        if (!startSide) {
            p3 = arc.getEndPoint();
        }
        GeneralPath polygon3 = this.getDetachPath(arc, p3, depth);
        return polygon3;
    }

    private GeneralPath getDetachPath(Arc2D arc, Point2D p, int depth) {
        GeneralPath polygon = new GeneralPath();
        polygon.moveTo((float)arc.getCenterX(), (float)arc.getCenterY());
        polygon.lineTo((float)arc.getCenterX(), (float)arc.getCenterY() - (float)depth);
        polygon.lineTo((float)p.getX(), (float)p.getY() - (float)depth);
        polygon.lineTo((float)p.getX(), (float)p.getY());
        polygon.closePath();
        return polygon;
    }

    private boolean isLastSegment(int index, int[] arcListIndex) {
        boolean isLast = false;
        for (int i = arcListIndex.length - 1; i >= index; --i) {
            if (arcListIndex[i] == -1) continue;
            if (arcListIndex[i] != index) break;
            isLast = true;
            break;
        }
        return isLast;
    }

    private boolean isNextLastSegment(int currentIndex, int[] arcListIndex) {
        boolean isNextLast = false;
        if (currentIndex < arcListIndex.length) {
            isNextLast = this.isLastSegment(arcListIndex[currentIndex], arcListIndex);
        }
        return isNextLast;
    }

    private void drawSegmentSide(Graphics2D g2, int startIndex, int[] arcListIndex, ArrayList arcList, PiePlotState state, int depth, Area frontU, Area backU, boolean isFront, boolean toEnd) {
        Arc2D.Double segment = (Arc2D.Double)arcList.get(startIndex);
        Comparable keyS = this.getSectionKey(startIndex);
        Rectangle2D pieArea = state.getPieArea();
        Area front = frontU;
        Area back = backU;
        if (this.getExplodePercent(keyS) != 0.0) {
            this.createExplodeArea(new Rectangle2D.Double(segment.getX(), segment.getY(), segment.getWidth(), segment.getHeight()), depth);
            pieArea = state.getExplodedPieArea();
            front = this.frontExplode;
            back = this.backExplode;
        }
        Arc2D.Double segment1 = (Arc2D.Double)segment.clone();
        if (toEnd) {
            segment1.setAngleStart(segment.getAngleStart() + segment.getAngleExtent() / 2.0);
            segment1.setAngleExtent(segment.getAngleExtent() / 2.0);
        } else {
            segment1.setAngleExtent(segment.getAngleExtent() / 2.0);
        }
        if (isFront) {
            this.drawSide(g2, pieArea, segment1, front, back, keyS, true);
        } else {
            this.drawSide(g2, pieArea, segment1, front, back, keyS, false);
        }
    }

    private void drawLastSegStartSide(Graphics2D g2, int[] arcListIndex, ArrayList arcList, Rectangle2D pieArea, int depth, Area frontU, Area backU) {
        GeneralPath polygon2;
        Point2D p2;
        GeneralPath polygon1;
        Point2D p1;
        this.lastIndex = 0;
        for (int i = arcListIndex.length - 1; i >= 0; --i) {
            if (arcListIndex[i] == -1) continue;
            this.lastIndex = i;
            break;
        }
        if (this.lastIndex == 0) {
            return;
        }
        this.lastIndex = arcListIndex[this.lastIndex];
        Arc2D.Double segment = (Arc2D.Double)arcList.get(this.lastIndex);
        if (segment == null) {
            return;
        }
        double startAng = segment.getAngleStart();
        double sinAngS = Math.sin(Math.toRadians(startAng));
        double cosAngS = Math.cos(Math.toRadians(startAng));
        double endAng = startAng + segment.getAngleExtent();
        double sinAngE = Math.sin(Math.toRadians(endAng));
        double cosAngE = Math.cos(Math.toRadians(endAng));
        Comparable key = this.getSectionKey(this.lastIndex);
        if (this.getDirection() == Rotation.ANTICLOCKWISE) {
            if (sinAngS > 0.0 && cosAngS > 0.0) {
                Area front = frontU;
                Area back = backU;
                if (this.getExplodePercent(key) != 0.0) {
                    this.createExplodeArea(new Rectangle2D.Double(segment.getX(), segment.getY(), segment.getWidth(), segment.getHeight()), depth);
                    front = this.frontExplode;
                    back = this.backExplode;
                }
                this.drawSide(g2, pieArea, segment, front, back, key, false);
                Point2D p12 = segment.getStartPoint();
                GeneralPath polygon12 = this.getDetachPath(segment, p12, depth);
                this.drawSideArea(g2, polygon12, key);
            }
            if (cosAngS < 0.0) {
                p1 = segment.getStartPoint();
                polygon1 = this.getDetachPath(segment, p1, depth);
                this.drawSideArea(g2, polygon1, key);
            }
            if (sinAngE < 0.0 && cosAngE < 0.0) {
                p2 = segment.getEndPoint();
                polygon2 = this.getDetachPath(segment, p2, depth);
                this.drawSideArea(g2, polygon2, key);
            }
        }
        if (this.getDirection() == Rotation.CLOCKWISE) {
            if (cosAngS < 0.0) {
                p1 = segment.getEndPoint();
                polygon1 = this.getDetachPath(segment, p1, depth);
                this.drawSideArea(g2, polygon1, key);
            }
            if (sinAngS < 0.0 && cosAngS < 0.0) {
                p2 = segment.getStartPoint();
                polygon2 = this.getDetachPath(segment, p2, depth);
                this.drawSideArea(g2, polygon2, key);
            }
            if (sinAngE < 0.0 && cosAngE > 0.0) {
                p1 = segment.getStartPoint();
                polygon1 = this.getDetachPath(segment, p1, depth);
                this.drawSideArea(g2, polygon1, key);
                Point2D p22 = segment.getEndPoint();
                GeneralPath polygon22 = this.getDetachPath(segment, p22, depth);
                this.drawSideArea(g2, polygon22, key);
            }
        }
    }

    private void drawSide(Graphics2D g2, Rectangle2D plotArea, Arc2D arc, Area front, Area back, Comparable key, boolean frontOrBack) {
        double start = arc.getAngleStart();
        double extent = arc.getAngleExtent();
        double end = start + extent;
        Paint paint = this.lookupSectionPaint(key);
        Paint outlinePaint = this.lookupSectionOutlinePaint(key);
        Stroke outlineStroke = this.lookupSectionOutlineStroke(key);
        g2.setStroke(outlineStroke);
        if (extent < 0.0) {
            if (this.isAngleAtFront(start)) {
                if (!this.isAngleAtBack(end)) {
                    if (extent > -180.0) {
                        if (frontOrBack) {
                            Area side = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                            this.drawAreaWithIntersect(g2, side, front, key);
                        }
                    } else if (frontOrBack) {
                        Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        side1.intersect(front);
                        Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        side2.intersect(front);
                        g2.setPaint(paint);
                        g2.fill(side1);
                        g2.fill(side2);
                        if (this.getSectionOutlinesVisible()) {
                            g2.setPaint(outlinePaint);
                            g2.draw(side1);
                            g2.draw(side2);
                        }
                    } else {
                        this.drawArea(g2, back, key);
                    }
                } else if (!frontOrBack) {
                    Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    this.drawAreaWithIntersect(g2, side2, back, key);
                } else {
                    Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    this.drawAreaWithIntersect(g2, side1, front, key);
                }
            } else if (!this.isAngleAtFront(end)) {
                if (extent > -180.0) {
                    if (!frontOrBack) {
                        Area side = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                        this.drawAreaWithIntersect(g2, side, back, key);
                    }
                } else if (!frontOrBack) {
                    Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    side1.intersect(back);
                    Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    side2.intersect(back);
                    g2.setPaint(paint);
                    g2.fill(side1);
                    g2.fill(side2);
                    if (this.getSectionOutlinesVisible()) {
                        g2.setPaint(outlinePaint);
                        g2.draw(side1);
                        g2.draw(side2);
                    }
                } else {
                    this.drawArea(g2, front, key);
                }
            } else if (!frontOrBack) {
                Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                this.drawAreaWithIntersect(g2, side1, back, key);
            } else {
                Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                this.drawAreaWithIntersect(g2, side2, front, key);
            }
        } else if (extent > 0.0) {
            if (this.isAngleAtFront(start)) {
                if (!this.isAngleAtBack(end)) {
                    if (extent < 180.0) {
                        if (frontOrBack) {
                            Area side = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                            this.drawAreaWithIntersect(g2, side, front, key);
                        }
                    } else if (frontOrBack) {
                        Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                        side1.intersect(front);
                        Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        side2.intersect(front);
                        g2.setPaint(paint);
                        g2.fill(side1);
                        g2.fill(side2);
                        if (this.getSectionOutlinesVisible()) {
                            g2.setPaint(outlinePaint);
                            g2.draw(side1);
                            g2.draw(side2);
                        }
                    } else {
                        this.drawArea(g2, back, key);
                    }
                } else if (!frontOrBack) {
                    Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                    this.drawAreaWithIntersect(g2, side2, back, key);
                } else {
                    Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    this.drawAreaWithIntersect(g2, side1, front, key);
                }
            } else if (!this.isAngleAtFront(end)) {
                if (extent < 180.0) {
                    if (!frontOrBack) {
                        Area side = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        this.drawAreaWithIntersect(g2, side, back, key);
                    }
                } else if (!frontOrBack) {
                    Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    side1.intersect(back);
                    Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                    side2.intersect(back);
                    g2.setPaint(paint);
                    g2.fill(side1);
                    g2.fill(side2);
                    if (this.getSectionOutlinesVisible()) {
                        g2.setPaint(outlinePaint);
                        g2.draw(side1);
                        g2.draw(side2);
                    }
                } else {
                    this.drawArea(g2, front, key);
                }
            } else if (!frontOrBack) {
                Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                this.drawAreaWithIntersect(g2, side1, back, key);
            } else {
                Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                this.drawAreaWithIntersect(g2, side2, front, key);
            }
        }
    }

    private void drawAreaWithIntersect(Graphics2D g2, Area area, Area intersect, Comparable key) {
        if (intersect != null) {
            area.intersect(intersect);
        }
        this.drawArea(g2, area, key);
    }

    private void drawSideArea(Graphics2D g2, Shape shape, Comparable key) {
        this.getPiePainter().paintShape(g2, this, key, shape, true);
    }

    private void drawArea(Graphics2D g2, Shape shape, Comparable key) {
        this.getPiePainter().paintShape(g2, this, key, shape, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int subtractSide(Graphics2D g2, Rectangle2D plotArea, Arc2D arc, Area front, Area back, boolean drawFront, boolean drawBack, boolean cutSide) {
        double start = arc.getAngleStart();
        double extent = arc.getAngleExtent();
        double end = start + extent;
        if (extent < 0.0) {
            if (this.isAngleAtFront(start)) {
                if (!this.isAngleAtBack(end)) {
                    if (extent > -180.0) {
                        if (!drawFront) return -1;
                        Area side = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        if (!cutSide) return 1;
                        side.intersect(front);
                        this.frontPie.subtract(side);
                        return 1;
                    }
                    Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    if (cutSide) {
                        side1.intersect(front);
                        this.frontPie.subtract(side1);
                    }
                    Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                    if (cutSide) {
                        side2.intersect(front);
                        this.frontPie.subtract(side2);
                    }
                    if (!cutSide) return 2;
                    this.backPie.subtract(back);
                    return 2;
                }
                if (drawBack) {
                    Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    if (!cutSide) return 3;
                    side2.intersect(back);
                    this.backPie.subtract(side2);
                    return 3;
                }
                if (!drawFront) return -1;
                Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                if (!cutSide) return 4;
                side1.intersect(front);
                this.frontPie.subtract(side1);
                return 4;
            }
            if (!this.isAngleAtFront(end)) {
                if (extent > -180.0) {
                    if (!drawBack) return -1;
                    Area side = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    if (!cutSide) return 5;
                    side.intersect(back);
                    this.backPie.subtract(side);
                    return 5;
                }
                Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                if (cutSide) {
                    side1.intersect(back);
                    this.backPie.subtract(side1);
                }
                Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                if (cutSide) {
                    side2.intersect(back);
                    this.backPie.subtract(side2);
                }
                if (!cutSide) return 6;
                this.frontPie.subtract(front);
                return 6;
            }
            if (drawBack) {
                Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                if (!cutSide) return 7;
                side1.intersect(back);
                this.backPie.subtract(side1);
                return 7;
            }
            if (!drawFront) return -1;
            Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
            if (!cutSide) return 8;
            side2.intersect(front);
            this.frontPie.subtract(side2);
            return 8;
        }
        if (!(extent > 0.0)) return -1;
        if (this.isAngleAtFront(start)) {
            if (!this.isAngleAtBack(end)) {
                if (extent < 180.0) {
                    if (!drawFront) return -1;
                    Area side = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    if (!cutSide) return 11;
                    side.intersect(front);
                    this.frontPie.subtract(side);
                    return 11;
                }
                Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                if (cutSide) {
                    side1.intersect(front);
                    this.frontPie.subtract(side1);
                }
                Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                if (cutSide) {
                    side2.intersect(front);
                    this.frontPie.subtract(side2);
                }
                if (!cutSide) return 12;
                this.backPie.subtract(back);
                return 12;
            }
            if (drawBack) {
                Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                if (!cutSide) return 13;
                side2.intersect(back);
                this.backPie.subtract(side2);
                return 13;
            }
            if (!drawFront) return -1;
            Area side1 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
            if (!cutSide) return 14;
            side1.intersect(front);
            this.frontPie.subtract(side1);
            return 14;
        }
        if (!this.isAngleAtFront(end)) {
            if (extent < 180.0) {
                if (!drawBack) return -1;
                Area side = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                if (!cutSide) return 15;
                side.intersect(back);
                this.backPie.subtract(side);
                return 15;
            }
            Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
            if (cutSide) {
                side1.intersect(back);
                this.backPie.subtract(side1);
            }
            Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
            if (cutSide) {
                side2.intersect(back);
                this.backPie.subtract(side2);
            }
            if (!cutSide) return 16;
            this.frontPie.subtract(front);
            return 16;
        }
        if (drawBack) {
            Area side1 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
            if (!cutSide) return 17;
            side1.intersect(back);
            this.backPie.subtract(side1);
            return 17;
        }
        if (!drawFront) return -1;
        Area side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
        if (!cutSide) return 18;
        side2.intersect(front);
        this.frontPie.subtract(side2);
        return 18;
    }

    private void createExplodeArea(Rectangle2D pieArea, int depth) {
        Ellipse2D.Double top = new Ellipse2D.Double(pieArea.getX(), pieArea.getY() - (double)depth, pieArea.getWidth(), pieArea.getHeight());
        Ellipse2D.Double bottom = new Ellipse2D.Double(pieArea.getX(), pieArea.getY(), pieArea.getWidth(), pieArea.getHeight());
        Rectangle2D.Double lower = new Rectangle2D.Double(((RectangularShape)top).getX(), top.getCenterY(), pieArea.getWidth(), bottom.getMaxY() - top.getCenterY());
        Rectangle2D.Double upper = new Rectangle2D.Double(pieArea.getX(), ((RectangularShape)top).getY(), pieArea.getWidth(), bottom.getCenterY() - ((RectangularShape)top).getY());
        Area a = new Area(top);
        a.add(new Area(lower));
        Area b = new Area(bottom);
        b.add(new Area(upper));
        Area pie = new Area(a);
        pie.intersect(b);
        this.frontExplode = new Area(pie);
        this.frontExplode.subtract(new Area(top));
        this.backExplode = new Area(pie);
        this.backExplode.subtract(new Area(bottom));
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double angle) {
        return Math.sin(Math.toRadians(angle)) < 0.0;
    }

    private boolean isAngleAtBack(double angle) {
        return Math.sin(Math.toRadians(angle)) > 0.0;
    }
}

