/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportViewer;
import com.inet.viewer.g;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.prefs.Preferences;
import javax.annotation.SuppressFBWarnings;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

@InternalApi
public class ViewerUtils {
    public static final int LINUX = 0;
    public static final int WINDOWS = 1;
    public static final int MAC = 2;
    public static final int MAX_URL_LENGTH = 2048;
    private static boolean d;
    private static final char[] e;
    static int a;
    static int b;
    private static String f;
    private static String g;
    private static ArrayList<Font> h;
    private static final Hashtable i;
    private static boolean j;
    private static final SimpleDateFormat k;
    static Frame c;
    private static String l;
    private static boolean m;
    private static PrintStream n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageIcon getImageIcon(String name) {
        String string = name.intern();
        synchronized (string) {
            ImageIcon imageIcon = (ImageIcon)i.get(name);
            if (imageIcon != null) {
                return imageIcon;
            }
            String string2 = name.indexOf(47) >= 0 ? name : "images/" + name;
            InputStream inputStream = ViewerUtils.class.getResourceAsStream(string2);
            if (inputStream == null) {
                ViewerUtils.error("Image '" + name + "' can't load.");
                return new ImageIcon(new BufferedImage(16, 16, 2));
            }
            try {
                int n2;
                int n3 = Math.max(128, inputStream.available());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
                byte[] byArray = new byte[n3];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                inputStream.close();
                imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
                i.put(name, imageIcon);
                return imageIcon;
            }
            catch (IOException iOException) {
                ViewerUtils.printStackTrace(iOException);
                return new ImageIcon(new BufferedImage(16, 16, 2));
            }
        }
    }

    public static String checkRange(Object l2, Object r2, int type) {
        if (l2 != null && r2 != null) {
            switch (type) {
                case 8: 
                case 14: {
                    return null;
                }
                case 6: 
                case 7: {
                    if (((Double)l2).compareTo((Double)r2) > 0) break;
                    return null;
                }
                case 9: 
                case 15: {
                    Calendar calendar = null;
                    if (l2 instanceof Calendar) {
                        calendar = (Calendar)l2;
                    } else if (l2 instanceof Date) {
                        calendar = Calendar.getInstance();
                        calendar.setTime((Date)l2);
                        if (r2 instanceof Date) {
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.setTime((Date)r2);
                            r2 = calendar2;
                        }
                    } else {
                        return com.inet.viewer.i18n.a.a("prompt.invalid_value", l2);
                    }
                    if (!calendar.before(r2) && !l2.equals(r2)) break;
                    return null;
                }
                case 10: {
                    if (!((Time)l2).before((Time)r2) && !l2.equals(r2)) break;
                    return null;
                }
                case 11: {
                    if (((String)l2).compareTo((String)r2) > 0) break;
                    return null;
                }
            }
        } else if (l2 == null && r2 == null) {
            return null;
        }
        return com.inet.viewer.i18n.a.a("prompt.upperMustBeHigher");
    }

    public static String encode(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = str.length();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case ' ': {
                    stringBuffer.append('+');
                    continue block4;
                }
                case '*': 
                case '-': 
                case '.': 
                case '_': {
                    stringBuffer.append(c2);
                    continue block4;
                }
                default: {
                    if ('0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z') {
                        stringBuffer.append(c2);
                        continue block4;
                    }
                    if (c2 < '\u0080' && c2 != '&') {
                        stringBuffer.append('%');
                        stringBuffer.append(e[c2 >> 4 & 0xF]);
                        stringBuffer.append(e[c2 & 0xF]);
                        continue block4;
                    }
                    stringBuffer.append("%26%23");
                    stringBuffer.append((int)c2);
                    stringBuffer.append("%3B");
                }
            }
        }
        return stringBuffer.toString();
    }

    static String a(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case '<': {
                    stringBuffer.append("&#60;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&#62;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&#38;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&#34;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(string.charAt(i2));
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String s2) {
        PrintStream printStream = n;
        if (printStream != null) {
            SimpleDateFormat simpleDateFormat = k;
            synchronized (simpleDateFormat) {
                printStream.println("[Viewer,INFO," + k.format(new Date()) + "] " + s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String s2) {
        PrintStream printStream;
        if (j && (printStream = n) != null) {
            SimpleDateFormat simpleDateFormat = k;
            synchronized (simpleDateFormat) {
                printStream.println("[Viewer,DEBUG," + k.format(new Date()) + "] " + s2);
            }
        }
    }

    public static void error(String s2) {
        PrintStream printStream = n;
        if (printStream != null) {
            printStream.println("[Viewer,ERROR] " + s2);
        }
    }

    public static void logClientData(String s2) {
        if (n != null) {
            ViewerUtils.log("i-net Clear Reports client version: " + s2);
            try {
                ViewerUtils.log("Java vendor: " + System.getProperty("java.vendor"));
                ViewerUtils.log("Java version: " + System.getProperty("java.version"));
                ViewerUtils.log("Operating System: " + System.getProperty("os.name"));
                ViewerUtils.log("OS architecture: " + System.getProperty("os.arch"));
                ViewerUtils.log("OS version: " + System.getProperty("os.version"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void logServerVersion(String s2) {
        PrintStream printStream = n;
        if (!m && printStream != null) {
            m = true;
            printStream.println(l + s2);
        }
    }

    public static void setLogStream(PrintStream out) {
        n = out;
    }

    public static PrintStream getLogStream() {
        return n;
    }

    public static void setDebug(boolean debug) {
        j = debug;
    }

    public static void printStackTrace(Throwable t2) {
        PrintStream printStream = n;
        if (printStream != null) {
            t2.printStackTrace(printStream);
        }
    }

    private static Preferences a() {
        return Preferences.userNodeForPackage(ReportViewer.class);
    }

    private static Preferences b(String string) {
        return ViewerUtils.a().node(string);
    }

    public static String getStringPref(String node, String prop, String def) {
        try {
            return ViewerUtils.b(node).get(prop, def);
        }
        catch (AccessControlException accessControlException) {
            n.println("Cannot access preferences");
            return def;
        }
    }

    public static void setStringPref(String node, String prop, String value) {
        try {
            Preferences preferences = ViewerUtils.b(node);
            if (value == null) {
                if (preferences.get(prop, null) != null) {
                    preferences.remove(prop);
                }
            } else {
                preferences.put(prop, value);
            }
        }
        catch (AccessControlException accessControlException) {
            n.println("Cannot access preferences");
        }
    }

    public static String getCCVersion() {
        return f;
    }

    public static String getProtocolVersion() {
        return g;
    }

    public static void setVersionInfo(String protocolVersion, String ccVersion) {
        if (ccVersion != null) {
            f = ccVersion;
        }
        if (protocolVersion != null) {
            g = protocolVersion;
        }
    }

    static Frame b() {
        if (c == null) {
            c = new Frame();
            c.addNotify();
            c.setBackground(Color.white);
        }
        return c;
    }

    static void a(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    static int c() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    static boolean d() {
        return d;
    }

    static void a(boolean bl) {
        if (bl && !d) {
            ViewerUtils.debug("Viewer could be outdated - report comes from a later protocol version: " + ViewerUtils.getProtocolVersion());
        }
        d = bl;
    }

    public static boolean useDesktopMethod(String methodName, Object argument) throws Throwable {
        if (argument.toString().startsWith("mailto:")) {
            Desktop.getDesktop().mail((URI)argument);
            return true;
        }
        if (ViewerUtils.getOperatingSystem() != 1) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("getDesktop", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = clazz.getMethod(methodName, argument.getClass());
                method2.invoke(object, argument);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getOperatingSystem() {
        int n2 = 0;
        try {
            String string = System.getProperty("os.name");
            if (string.indexOf("Win") != -1) {
                n2 = 1;
            } else if (string.indexOf("Mac") != -1) {
                n2 = 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="use on client side only")
    public static void showDocumentOldMethod(Object url) throws RuntimeException {
        block14: {
            int n2 = ViewerUtils.getOperatingSystem();
            String string = url.toString();
            try {
                if (string.length() > 2048) {
                    int n3 = string.lastIndexOf("%", 2048);
                    if (n3 <= 2045) {
                        n3 = 2048;
                    }
                    string = string.substring(0, n3);
                }
                block3 : switch (n2) {
                    case 1: {
                        String string2 = "cmd.exe /C start \"Open file\" \"" + string + "\"";
                        Runtime.getRuntime().exec(string2);
                        break;
                    }
                    case 2: {
                        Process process = Runtime.getRuntime().exec(new String[]{"open", string});
                        int n4 = process.waitFor();
                        if (n4 != 0) {
                            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                            Method method = clazz.getDeclaredMethod("openURL", String.class);
                            method.invoke(null, url);
                            break;
                        }
                        break block14;
                    }
                    default: {
                        String[] stringArray = new String[]{"gnome-open", "kfmclient exec", "sensible-browser", "x-www-browser", "firefox", "google-chrome", "opera", "konqueror", "epiphany", "netscape", "mozilla"};
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            try {
                                String[] stringArray2 = stringArray[i2].split("\\s+");
                                String[] stringArray3 = new String[stringArray2.length + 1];
                                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                                stringArray3[stringArray3.length - 1] = string;
                                Process process = Runtime.getRuntime().exec(stringArray3);
                                if (process.waitFor() != 0) continue;
                                break block3;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break block14;
                    }
                }
                {
                    break block14;
                    break;
                }
            }
            catch (Exception exception) {
                try {
                    Runtime.getRuntime().exec(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new RuntimeException("The using the os specific fallback failed: ", exception);
            }
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="use on client side only")
    public static void showMailOldMethod(URL url) {
        block12: {
            int n2 = ViewerUtils.getOperatingSystem();
            try {
                block3 : switch (n2) {
                    case 1: {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url.toString());
                        break;
                    }
                    case 2: {
                        Process process = Runtime.getRuntime().exec("open " + url.toString());
                        if (process.waitFor() != 0) {
                            Runtime.getRuntime().exec("open /Applications/Mail.app " + url.toString());
                            break;
                        }
                        break block12;
                    }
                    default: {
                        String[] stringArray = new String[]{"gnome-open " + url.toString(), "kfmclient exec " + url.toString(), "thunderbird " + url.toString(), "evolution " + url.toString()};
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            try {
                                Process process = Runtime.getRuntime().exec(stringArray[i2]);
                                if (process.waitFor() != 0) continue;
                                break block3;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break block12;
                    }
                }
                {
                    break block12;
                    break;
                }
            }
            catch (Exception exception) {
                try {
                    Runtime.getRuntime().exec(url.toString());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new RuntimeException("The using the os specific fallback failed: ", exception);
            }
        }
    }

    public static String keyStrokeToString(KeyStroke ks) {
        String string = "";
        if (ks != null) {
            int n2;
            int n3 = ks.getModifiers();
            if (n3 > 0) {
                string = KeyEvent.getKeyModifiersText(n3);
                string = string + "+";
            }
            string = (n2 = ks.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n2) : string + ks.getKeyChar();
        }
        return string;
    }

    static Font a(ArrayList arrayList, int n2, int n3, RenderData renderData) {
        g g2 = null;
        if (arrayList.size() >= n2) {
            g2 = (g)arrayList.get(n2 - 1);
        }
        if (g2 == null || g2.b < n3) {
            byte[] byArray = renderData.getFontData(n2);
            if (byArray != null) {
                g g3 = new h().a(byArray);
                if (g2 == null) {
                    arrayList.add(g3);
                } else {
                    arrayList.remove(g2);
                    arrayList.add(n2 - 1, g3);
                    ViewerUtils.debug("replacing font " + g2.c.getName() + g2.c.getStyle() + " with " + g3.c.getName() + g3.c.getStyle());
                }
                return g3.c;
            }
            ViewerUtils.debug("Problems reading Font " + n2);
            return new Font("SansSerif", 0, 150);
        }
        return g2.c;
    }

    public static Font getFontFor(String characters) {
        String[] stringArray;
        if (h.size() > 0) {
            stringArray = h.iterator();
            while (stringArray.hasNext()) {
                Font font = (Font)stringArray.next();
                int n2 = font.canDisplayUpTo(characters);
                if (n2 >= 0) continue;
                return font;
            }
        }
        if ((stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) != null) {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                Font font = new Font(stringArray[i2], 0, 1);
                if (font.canDisplayUpTo(characters) >= 0) continue;
                h.add(font);
                return font;
            }
        }
        return null;
    }

    static {
        e = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        a = 0x3000000;
        b = 0x1000000;
        f = null;
        g = null;
        h = new ArrayList();
        i = new Hashtable();
        j = true;
        k = new SimpleDateFormat("M/d H:mm:ss");
        l = "i-net Clear Reports server version: ";
        m = false;
        n = System.out;
    }
}

