/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer.client;

import com.inet.annotations.InternalApi;
import com.inet.viewer.ViewerUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class InetCookieHandler
extends CookieHandler {
    private static List<a> bKt;
    private List<a> bKu = new LinkedList<a>();

    public InetCookieHandler() {
        this(bKt);
    }

    private InetCookieHandler(@Nullable List<a> initial) {
        if (initial != null) {
            this.bKu.addAll(initial);
        }
    }

    @Nonnull
    public static InetCookieHandler create(@Nonnull URL url, String cookies) {
        ArrayList<a> arrayList;
        try {
            URI uRI = url.toURI();
            arrayList = InetCookieHandler.a(uRI, cookies);
        }
        catch (URISyntaxException uRISyntaxException) {
            ViewerUtils.error("Invalid url: " + String.valueOf(url) + "\n" + String.valueOf(uRISyntaxException));
            arrayList = null;
        }
        return new InetCookieHandler(arrayList);
    }

    public static void setInitialCookie(URI uri, String cookies) {
        bKt = InetCookieHandler.a(uri, cookies);
    }

    @Nonnull
    private static ArrayList<a> a(URI uRI, String string) {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (string != null) {
            for (String string2 : string.split(";")) {
                string2 = string2.trim();
                try {
                    arrayList.add(new a(uRI, string2));
                }
                catch (RuntimeException runtimeException) {
                    ViewerUtils.error("Invalid cookie: " + string2 + "\n" + String.valueOf(runtimeException));
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<a> list = this.bKu;
        synchronized (list) {
            this.bKu.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<a> list;
        List list2 = null;
        if (responseHeaders != null) {
            for (Map.Entry object : responseHeaders.entrySet()) {
                if (!"Set-Cookie".equalsIgnoreCase((String)object.getKey())) continue;
                list2 = (List)object.getValue();
                break;
            }
        } else {
            list = this.bKu;
            synchronized (list) {
                Iterator<a> iterator = this.bKu.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!uri.getHost().equals(((a)object).RC().getHost()) || !uri.getScheme().equals(((a)object).RC().getScheme())) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        if (list2 != null) {
            list = this.bKu;
            synchronized (list) {
                for (Object object : list2) {
                    a a2;
                    try {
                        a2 = new a(uri, (String)object);
                    }
                    catch (RuntimeException runtimeException) {
                        ViewerUtils.error("Invalid cookie: " + (String)object + "\n" + String.valueOf(runtimeException));
                        continue;
                    }
                    Iterator<a> iterator = this.bKu.iterator();
                    while (iterator.hasNext()) {
                        a a3 = iterator.next();
                        if (!a2.getPath().equals(a3.getPath()) || !a2.getName().equals(a3.getName()) || !a2.RC().getHost().equals(a3.RC().getHost()) || !a2.RC().getScheme().equals(a3.RC().getScheme()) || a2.RC().getPort() != a3.RC().getPort()) continue;
                        iterator.remove();
                        break;
                    }
                    this.bKu.add(a2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        Collection<Object> collection;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.bKu;
        synchronized (object) {
            collection = new HashSet();
            Iterator<a> iterator = this.bKu.iterator();
            while (iterator.hasNext()) {
                String string;
                a a2 = iterator.next();
                if (a2 == null) continue;
                if (a2.RB()) {
                    iterator.remove();
                    continue;
                }
                if (!a2.b(uri) || ((HashSet)collection).contains(string = a2.toString())) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
                ((HashSet)collection).add(string);
            }
        }
        object = new HashMap<String, List<String>>(requestHeaders);
        if (stringBuilder.length() > 0) {
            collection = Collections.singletonList(stringBuilder.toString());
            object.put("Cookie", collection);
        }
        return Collections.unmodifiableMap(object);
    }

    static {
        try {
            URI uRI = new URI("http://localhost/");
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            new a(uRI, "a=b;path=b").toString();
            InetCookieHandler inetCookieHandler = new InetCookieHandler();
            inetCookieHandler.get(uRI, hashMap);
            inetCookieHandler.put(uRI, hashMap);
        }
        catch (Exception exception) {
            ViewerUtils.printStackTrace(exception);
        }
    }

    private static class a {
        private String name;
        private String value;
        private URI bKv;
        private Date bKw;
        private String aJg;
        private static DateFormat bKx = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);
        private static DateFormat bKy = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);

        public a(URI uRI, String string) {
            String[] stringArray = string.split(";");
            String string2 = stringArray[0].trim();
            this.bKv = uRI;
            int n2 = string2.indexOf(61);
            this.name = string2.substring(0, n2);
            this.value = string2.substring(n2 + 1);
            this.aJg = "/";
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                string2 = stringArray[i2].trim();
                int n3 = string2.indexOf(61);
                if (n3 == -1) continue;
                String string3 = string2.substring(0, n3);
                Object object = string2.substring(n3 + 1);
                if (string3.equalsIgnoreCase("domain")) {
                    String string4 = uRI.getHost();
                    if (string4.equals(object)) continue;
                    if (!((String)object).startsWith(".")) {
                        object = "." + (String)object;
                    }
                    if ((string4 = string4.substring(string4.indexOf(46))).equals(object)) continue;
                    throw new IllegalArgumentException("Trying to set foreign cookie");
                }
                if (string3.equalsIgnoreCase("path")) {
                    this.aJg = object;
                    continue;
                }
                if (!string3.equalsIgnoreCase("expires")) continue;
                try {
                    this.bKw = bKx.parse((String)object);
                    continue;
                }
                catch (ParseException parseException) {
                    try {
                        this.bKw = bKy.parse((String)object);
                        continue;
                    }
                    catch (ParseException parseException2) {
                        throw new IllegalArgumentException("Bad date format in header: " + (String)object);
                    }
                }
            }
        }

        public boolean RB() {
            if (this.bKw == null) {
                return false;
            }
            Date date = new Date();
            return date.after(this.bKw);
        }

        public String getName() {
            return this.name;
        }

        public URI RC() {
            return this.bKv;
        }

        public String getPath() {
            return this.aJg;
        }

        public boolean b(URI uRI) {
            int n2;
            if (this.RB()) {
                return false;
            }
            String string = uRI.getHost();
            if (string == null ? this.bKv.getHost() != null : !string.equals(this.bKv.getHost())) {
                return false;
            }
            int n3 = this.c(this.bKv);
            if (n3 != (n2 = this.c(uRI))) {
                return false;
            }
            String string2 = uRI.getPath();
            if (string2 == null) {
                string2 = "/";
            }
            return string2.startsWith(this.aJg);
        }

        private int c(URI uRI) {
            int n2 = uRI.getPort();
            if (n2 == -1) {
                if ("https".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 443;
                } else if ("http".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 80;
                }
            }
            return n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.name);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }
}

