/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int buD = -1;
    protected final PropertyChangeSupport bAt = new PropertyChangeSupport(this);
    private int type;
    private int bAu;
    private int progress;
    private boolean bAv = false;
    private String afU;
    private ReportView bAw;
    private ViewerContext bwM;
    private Component byN;
    Thread bAx;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bAw = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.byN = reportView.getComponent();
            this.bwM = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.bwM = viewerContext;
        this.byN = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bAx != null && this.bAx.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bAx = new Thread((Runnable)this, this.getName());
        this.bAx.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bAv) {
            this.bAx.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bAx.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bAv;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bAv;
        this.bAv = indeterminate;
        this.bAt.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.buD;
        this.buD = status;
        this.bAt.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.buD);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.buD == 3 || this.buD == 2 || this.buD == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.buD == 3;
    }

    public boolean isErrored() {
        return this.buD == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bAu;
        this.bAu = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bAt.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bAu;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bAt.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bAw;
    }

    public int getStatus() {
        return this.buD;
    }

    public String getErrorMessage() {
        return this.afU;
    }

    public void setErrorMessage(String msg) {
        this.afU = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.bwM == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.bwM.showError(th, this.byN);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bAt.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bAt.removePropertyChangeListener(l2);
    }

    protected void Ox() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bAt.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bAt.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

