/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.http.utils.MimeTypes;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.u;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.e;
import com.inet.report.renderer.pdf.h;
import com.inet.report.renderer.pdf.i;
import com.inet.report.renderer.pdf.k;
import com.inet.report.renderer.pdf.model.ai;
import com.inet.report.renderer.pdf.model.al;
import com.inet.report.renderer.pdf.model.ar;
import com.inet.report.renderer.pdf.model.m;
import com.inet.report.renderer.pdf.model.o;
import com.inet.report.renderer.pdf.model.r;
import com.inet.report.renderer.pdf.model.structure.g;
import com.inet.report.renderer.pdf.sec.a;
import com.inet.report.renderer.pdf.sec.b;
import com.inet.report.renderer.pdf.sec.f;
import com.inet.shared.utils.MemoryStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

public class PDFDocumentWriter
extends com.inet.report.renderer.doc.a {
    public static final String NAVIGATION = "navview";
    public static final String NAVIGATION_OUTLINES = "bookmarks";
    public static final String NAVIGATION_THUMBNAILS = "pages";
    public static final String OWNER_PASS = "opass";
    public static final String USER_PASS = "upass";
    public static final String ALG_TYPE = "algtype";
    public static final String ENCRYPT_METADATA = "encryptmeta";
    public static final String USERPROP_PDFA = "pdfa";
    public static final String USERPROP_PDFFASTWEBVIEW = "fastwebview";
    public static final String PDF_STRUCTURE_TREE = "pdftags";
    private boolean aTr = false;
    private b aTs;
    private boolean aTt;
    private boolean aTu;
    private Date IW;
    private boolean aTv;
    private MemoryStream CW = null;
    private e aTw;
    private m aSs;
    private i aTx;
    private k aTy;
    private int aTz;
    private h aTA;
    private Properties JO;
    private al aTB;

    public PDFDocumentWriter(PDFConfig config) {
        this.aTw = new e(config);
        this.aSs = this.aTw.Gn();
        this.aTx = new i(this.aTw, this.aSs);
        this.aTy = new k(this.aSs.Hr(), this.aTx, this.aSs.Hu().isReplaceMissingChars());
    }

    @Override
    public Layout getLayout() {
        return this.aTx;
    }

    @Override
    public u getCapabilities() {
        return this.aTy;
    }

    @Override
    public void setUserProperties(Properties props) {
        super.setUserProperties(props);
        this.JO = props;
        boolean bl2 = this.aSs.Hu().isCreateStructure();
        this.k(props);
        if (props != null) {
            String string;
            boolean bl3 = "true".equalsIgnoreCase(props.getProperty(USERPROP_PDFFASTWEBVIEW, "false"));
            this.aSs.Hu().setLinear(bl3);
            if (bl3) {
                this.aTA = new h(this.aSs);
            }
            if ("true".equals(string = props.getProperty(PDF_STRUCTURE_TREE))) {
                bl2 = true;
            } else if ("false".equals(string)) {
                bl2 = false;
            }
        }
        if (bl2) {
            g g2 = new g(this.aSs);
            this.aSs.a(g2);
            this.aTx.a(g2);
        }
    }

    @Override
    public void setMetaData(DocumentMetaData metaData) {
        super.setMetaData(metaData);
        this.aTw.setMetaData(metaData);
        this.aTt = metaData.isClipboardEnabled();
        this.aTv = metaData.isGroupTreeVisible();
        this.aTu = metaData.isPrintingEnabled();
        this.IW = metaData.getPrintTime();
        this.Gr();
        if (this.JO == null) {
            return;
        }
        if (metaData.getProperty("facturx-level") != null) {
            this.aSs.Hu().setPdfa3(true);
        } else {
            String string = this.JO.getProperty(USERPROP_PDFA, "false");
            if ("true".equalsIgnoreCase(string)) {
                if (this.aTr) {
                    BaseUtils.error("Documents which are encrypted or constraint the access to their content can not be exported in PDF/A format");
                } else {
                    this.aSs.Hu().setPDFA(true);
                }
            }
        }
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aTw.D(width, height, topMargin, leftMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        super.startDocument();
        this.aTw.start();
        this.aTz = 0;
        g g2 = this.aSs.Hv();
        if (g2 != null) {
            this.aTw.Go().a(g2.IT());
            DocumentMetaData documentMetaData = this.yJ();
            if (documentMetaData != null) {
                Locale locale = documentMetaData.getResourceLocale();
                String string = locale.toString();
                this.aTw.Go().da(string);
            }
        }
    }

    @Override
    public void startPage() throws ReportException {
        boolean bl2;
        super.startPage();
        boolean bl3 = bl2 = this.CW == null;
        if (!bl2) {
            this.cp(false);
        }
        this.aTB = this.aTx.GB();
        this.CW = new MemoryStream();
        if (this.aTA != null) {
            this.aTA.a(this.aTB);
        } else if (bl2) {
            this.aTw.ab(this.CW);
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
    }

    private void cp(boolean bl2) throws ReportException {
        if (bl2) {
            this.aTx.GE();
        }
        this.aTx.endPage();
        if (this.aTA == null) {
            this.aTw.c(this.CW, this.ga().getPageCount() + 1, this.aTz);
            byte[] byArray = this.CW.toByteArray();
            this.ga().addPage(byArray);
            this.aTz += byArray.length;
            this.aTB.dispose();
        }
        this.CW = null;
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        int n2;
        super.endDocument();
        if (this.CW != null) {
            this.cp(true);
        }
        if (this.aTA != null) {
            n2 = this.aTA.a(this.aTw, this.ga());
        } else {
            object = new MemoryStream();
            this.aTw.ac((MemoryStream)object);
            byte[] byArray = object.toByteArray();
            this.ga().addPage(byArray);
            n2 = this.aTz + byArray.length;
        }
        object = this.aTx.GD();
        if (object != null) {
            ((ar)object).a(this.ga(), n2);
        }
    }

    private void Gr() {
        String string;
        boolean bl2 = true;
        if (this.JO != null && (string = this.JO.getProperty(ENCRYPT_METADATA, "true")) != null && string.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        int n2 = a.k(this.aTt, this.aTu);
        String[] stringArray = a.l(this.JO);
        if (stringArray[0] == null) {
            if (!this.aTt || !this.aTu) {
                this.aTr = true;
                stringArray[0] = "DEFAULT_ALG";
            }
        } else {
            this.aTr = true;
        }
        byte[] byArray = null;
        if (this.aTr) {
            byArray = a.f(this.IW.getTime());
        }
        if (this.aTr) {
            this.aTs = f.a(stringArray[0], stringArray[1], stringArray[2], n2, bl2, this.IW, byArray);
        }
        this.aTw.a(this.aTs, byArray);
    }

    private void k(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty(NAVIGATION, "");
            if (NAVIGATION_OUTLINES.equals(string) || NAVIGATION_THUMBNAILS.equals(string)) {
                BaseUtils.info("PDF Export navigation type: " + string);
                this.aTw.cQ(string);
            }
        } else if (BaseUtils.isDebug()) {
            BaseUtils.debug("pdf export: user properties not defined");
        }
    }

    @Override
    public void addAttchment(@Nonnull String fileName, @Nonnull byte[] data) {
        if (!this.aTw.Gn().Hu().isPDFA()) {
            com.inet.report.renderer.pdf.model.k k2 = this.aTw.Go();
            ai ai2 = k2.Hp();
            if (ai2 == null) {
                ai2 = new ai(this.aSs);
            }
            String string = MimeTypes.getMimeType((String)fileName).split(";")[0];
            o o2 = new o(this.aSs, data, string, this.IW);
            r r2 = new r(this.aSs, o2, fileName, null);
            ai2.a(r2);
            k2.a(ai2);
        }
    }
}

