/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.parser;

import com.inet.classloader.LoaderUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.SummaryInfo;
import com.inet.report.parser.c;
import com.inet.report.translation.Translations;
import com.inet.report.translation.e;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RFReader
implements c {
    private DateFormat eW = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a", Locale.US);
    private Hashtable<String, byte[]> avU = new Hashtable();
    private URL wR;
    private boolean avV;

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="url is used to read a report file")
    public RFReader(URL url) throws IOException {
        this.c(url.openStream());
        this.wR = url;
    }

    public RFReader(InputStream in) throws IOException {
        this.c(in);
    }

    public RFReader(File dir) throws IOException {
        this.e(dir);
    }

    public URL getURL() {
        return this.wR;
    }

    public void clear() {
        this.avU.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(InputStream inputStream) throws IOException {
        try (ZipInputStream zipInputStream = null;){
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            block16: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                if (zipEntry.isDirectory()) continue;
                String string = zipEntry.getName().replace('\\', '/');
                if (string.startsWith("CoreData/")) {
                    this.avV = true;
                    if (!string.endsWith(".properties")) {
                        continue;
                    }
                } else if (!(string.startsWith("Pictures") || string.startsWith("Resources") || string.startsWith("Sub"))) {
                    switch (object = (Object)string.substring(string.lastIndexOf(47) + 1)) {
                        case "content.xml": 
                        case "mimetype": 
                        case "meta.xml": 
                        case "metaproperties.xml": 
                        case "manifest.xml": 
                        case "thumbnail.png": {
                            break;
                        }
                        case "i-net mark": {
                            continue block16;
                        }
                        default: {
                            BaseUtils.warning("Unknown rpt content file is ignored: " + (String)object);
                            continue block16;
                        }
                    }
                }
                object = RFReader.a(zipInputStream, false);
                this.avU.put(string, (byte[])object);
            }
        }
    }

    private void e(File file) throws IOException, FileNotFoundException {
        File[] fileArray = file.listFiles(avT);
        boolean bl2 = false;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File[] fileArray2;
                Object object;
                Object object2;
                Object object3;
                String string = file2.getName();
                if (file2.isFile()) {
                    this.a(string, file2);
                    if (!"content.xml".equals(string)) continue;
                    bl2 = true;
                    continue;
                }
                if (!file2.isDirectory()) continue;
                String string2 = "Sub_";
                if ("Thumbnails".equals(string)) {
                    object3 = new File(file2, "thumbnail.png");
                    if (!((File)object3).exists()) continue;
                    this.a("Thumbnails/thumbnail.png", (File)object3);
                    continue;
                }
                if ("META-INF".equals(string)) {
                    object3 = new File(file2, "manifest.xml");
                    if (!((File)object3).exists()) continue;
                    this.a("Thumbnails/manifest.xml", (File)object3);
                    continue;
                }
                if (string.startsWith(string2)) {
                    File file3;
                    object3 = new File(file2, "content.xml");
                    if (((File)object3).exists()) {
                        this.a(string + "/content.xml", (File)object3);
                    }
                    if (((File)(object2 = new File(file2, "meta.xml"))).exists()) {
                        this.a(string + "/meta.xml", (File)object2);
                    }
                    if (((File)(object = new File(file2, "metaproperties.xml"))).exists()) {
                        this.a(string + "/metaproperties.xml", (File)object);
                    }
                    if (!(file3 = new File(file2, "Pictures")).exists() || (fileArray2 = file3.listFiles()) == null) continue;
                    for (File file4 : fileArray2) {
                        if (!file4.isFile()) continue;
                        this.a(string + "/Pictures/" + file4.getName(), file4);
                    }
                    continue;
                }
                if (string.startsWith("Pictures")) {
                    object3 = file2.listFiles();
                    if (object3 == null) continue;
                    object2 = object3;
                    int n2 = ((File[])object2).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fileArray2 = object2[i2];
                        if (!fileArray2.isFile()) continue;
                        this.a("Pictures/" + fileArray2.getName(), (File)fileArray2);
                    }
                    continue;
                }
                if (!"Resources".equals(string)) continue;
                object3 = new File(file2, "options.xml");
                if (((File)object3).exists()) {
                    this.a("Resources/options.xml", (File)object3);
                }
                if ((object2 = file2.listFiles()) == null) continue;
                object = object2;
                int n3 = ((Object)object).length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    File[] fileArray3 = object[i3];
                    String string3 = fileArray3.getName();
                    if (!fileArray3.isFile() || !string3.startsWith("translation") || !string3.endsWith(".properties")) continue;
                    this.a("Resources/" + string3, (File)fileArray3);
                }
            }
        }
        if (!bl2) {
            if (BaseUtils.isError()) {
                BaseUtils.error("No content.xml file found in directory: " + file.getAbsolutePath());
            }
            throw new FileNotFoundException(file.getAbsolutePath() + File.separator + "content.xml");
        }
    }

    private void a(String string, File file) throws IOException {
        this.avU.put(string.replace('\\', '/'), RFReader.toByteArray(new FileInputStream(file)));
    }

    public byte[] getEntryBuffer(String name) {
        return this.avU.get(name);
    }

    public byte[] getManifest() {
        return this.getEntryBuffer("META-INF/manifest.xml");
    }

    public byte[] getThumbnail() {
        return this.getEntryBuffer("Thumbnails/thumbnail.png");
    }

    public byte[] getContent() {
        return this.getEntryBuffer("content.xml");
    }

    public byte[] getContent(int sub_ID) {
        return this.getEntryBuffer("Sub_" + sub_ID + "/content.xml");
    }

    public Hashtable<String, String> getSummaryMetaInfo() throws IOException {
        return RFReader.aC(this.getEntryBuffer("meta.xml"));
    }

    public Hashtable<String, String> getSummaryMetaInfo(int sub_ID) throws IOException {
        return RFReader.aC(this.getEntryBuffer("Sub_" + sub_ID + "/meta.xml"));
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="parse an internal stream")
    private static Hashtable<String, String> aC(byte[] byArray) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (byArray != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DocumentBuilder documentBuilder = LoaderUtils.newDocumentBuilderFactory().newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                NodeList nodeList = document.getDocumentElement().getChildNodes();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Node node = nodeList.item(i2);
                    if (node.getNodeType() != 1) continue;
                    String string = node.getNodeName();
                    String string2 = node.getTextContent();
                    if ("Keyword".equals(string)) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string2);
                        continue;
                    }
                    hashtable.put(string, string2);
                }
                if (stringBuilder.length() > 0) {
                    hashtable.put("Keyword", stringBuilder.toString());
                }
                byteArrayInputStream = null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
        }
        return hashtable;
    }

    public void initSummaryInfo(SummaryInfo summaryInfo) throws IOException {
        this.a(this.getSummaryMetaInfo(), summaryInfo);
    }

    public void initSummaryInfo(SummaryInfo summaryInfo, int sub_ID) throws IOException {
        this.a(this.getSummaryMetaInfo(sub_ID), summaryInfo);
    }

    private void a(Hashtable<String, String> hashtable, SummaryInfo summaryInfo) {
        summaryInfo.setAuthor(hashtable.get("Author"));
        summaryInfo.setKeywords(hashtable.get("Keyword"));
        summaryInfo.setComments(hashtable.get("Comments"));
        summaryInfo.setReportTitle(hashtable.get("Title"));
        summaryInfo.setSubject(hashtable.get("Subject"));
        summaryInfo.setTemplate(hashtable.get("Template"));
        Date date = null;
        String string = hashtable.get("Created");
        if (string != null && string.length() > 0) {
            try {
                date = this.eW.parse(string);
            }
            catch (ParseException parseException) {
                BaseUtils.printStackTrace(parseException);
            }
            summaryInfo.setCreated(date);
        }
        date = null;
        string = hashtable.get("LastSaved");
        if (string != null && string.length() > 0) {
            try {
                date = this.eW.parse(string);
            }
            catch (ParseException parseException) {
                BaseUtils.printStackTrace(parseException);
            }
            summaryInfo.setLastSaved(date);
        }
    }

    public byte[] getImage(String name) {
        return this.getEntryBuffer("Pictures/" + name);
    }

    public byte[] getImage(String name, int sub_ID) {
        return this.getEntryBuffer("Sub_" + sub_ID + "/Pictures/" + name);
    }

    public byte[] getTranslation(String locale) {
        return this.getEntryBuffer("Resources/translation" + locale + ".properties");
    }

    public byte[] getTranslationOptions() {
        return this.getEntryBuffer("Resources/options.xml");
    }

    public String getMimetype() {
        byte[] byArray = this.getEntryBuffer("mimetype");
        return byArray == null ? null : new String(byArray);
    }

    public Hashtable<String, byte[]> getNameToData() {
        return this.avU;
    }

    private static byte[] a(InputStream inputStream, boolean bl2) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = IOFunctions.readBytes((InputStream)inputStream);
            return byArray;
        }
        finally {
            if (bl2) {
                inputStream.close();
            }
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        return RFReader.a(is, true);
    }

    public Properties readMetaProperties() throws IOException {
        byte[] byArray = this.getEntryBuffer("metaproperties.xml");
        Properties properties = new Properties();
        if (byArray != null) {
            properties.loadFromXML(new ByteArrayInputStream(byArray));
        }
        return properties;
    }

    public Properties readMetaProperties(int subID) throws IOException {
        byte[] byArray = this.getEntryBuffer("Sub_" + subID + "/metaproperties.xml");
        Properties properties = new Properties();
        if (byArray != null) {
            properties.loadFromXML(new ByteArrayInputStream(byArray));
        }
        return properties;
    }

    public Translations getTranslations() {
        return e.b(this);
    }

    public boolean isContainingCoreData() {
        return this.avV;
    }
}

