/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.jfree.chart.labels.CategoryItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.axis.GroupAxis;
import com.inet.report.chart.f;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.StandardPlot;
import com.inet.report.i;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class BarPlot
extends StandardPlot {
    public static final BarStyle DEFAULT_STYLE = BarStyle.BAR2D;
    public static final int ITEM_LABEL_ALIGNMENT_AUTO = 0;
    public static final int ITEM_LABEL_ALIGNMENT_VERTICAL = 1;
    public static final int ITEM_LABEL_ALIGNMENT_HORIZONTAL = 2;
    public static final double DEFAULT_BAR_MARGIN_PERCENT = 0.2;
    public static final double DEFAULT_BAR_WIDTH = 1.0;
    private BarStyle YZ;
    private int Za;
    private boolean Zb;
    private double Zc;
    private double Zd;

    public BarPlot() {
        this(DEFAULT_STYLE);
    }

    public BarPlot(BarStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.YZ = style;
        super.setCategoryAxis(new GroupAxis());
        super.setDataAxis(new ContinuousNumberAxis());
        this.Za = 0;
        this.Zb = false;
        this.Zc = 0.2;
        this.Zd = 1.0;
    }

    public void setCategoryAxis(GroupAxis categoryAxis) {
        super.setCategoryAxis(categoryAxis);
    }

    public void setDataAxis(ContinuousNumberAxis dataAxis) {
        super.setDataAxis(dataAxis);
    }

    @Override
    public ChartStyle getStyle() {
        return this.YZ;
    }

    public void setStyle(BarStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.YZ = style;
    }

    public int getItemLabelAlignment() {
        return this.Za;
    }

    public void setItemLabelAlignment(int itemLabelAlignment) {
        i.A(itemLabelAlignment);
        this.Za = itemLabelAlignment;
    }

    public boolean isShowTotal() {
        return this.Zb;
    }

    public void setShowTotal(boolean showTotal) {
        this.Zb = showTotal;
    }

    public double getBarMarginPercent() {
        return this.Zc;
    }

    public void setBarMarginPercent(double barMarginPercent) {
        this.Zc = barMarginPercent;
    }

    public double getBarWidth() {
        return this.Zd;
    }

    public void setBarWidth(double barWidth) {
        this.Zd = barWidth;
    }

    @Override
    CategoryItemLabelGenerator b(FormatingProperties formatingProperties) {
        Locale locale = formatingProperties.getLocale();
        BarStyle barStyle = (BarStyle)this.getStyle();
        if (barStyle.isSimpleBar()) {
            return i.a((AbstractPlot)this, locale);
        }
        return i.a(this, barStyle.isPercentBar(), this.isShowCumulativeValues(), locale);
    }

    @Override
    protected StringBuilder cB(int n2) {
        StringBuilder stringBuilder = super.cB(n2);
        if (this.getBarMarginPercent() != 0.2) {
            f.b(stringBuilder, n2, "BarMarginPercent", String.valueOf(this.getBarMarginPercent()));
        }
        if (this.getBarWidth() != 1.0) {
            f.b(stringBuilder, n2, "BarWidth", String.valueOf(this.getBarWidth()));
        }
        if (this.getItemLabelAlignment() != 0) {
            f.b(stringBuilder, n2, "ItemLabelAlignment", String.valueOf(this.getItemLabelAlignment()));
        }
        if (this.isShowTotal()) {
            f.b(stringBuilder, n2, "ShowTotal", String.valueOf(this.isShowTotal()));
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("BarMarginPercent")) {
                double d2;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d2 = Double.parseDouble(string)) >= 0.0)) continue;
                this.setBarMarginPercent(d2);
                continue;
            }
            if (element2.getNodeName().equals("BarWidth")) {
                double d3;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d3 = Double.parseDouble(string)) >= 0.0)) continue;
                this.setBarWidth(d3);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelAlignment")) {
                int n2;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || (n2 = Integer.parseInt(string)) != 0 && n2 != 2 && n2 != 1) continue;
                this.setItemLabelAlignment(n2);
                continue;
            }
            if (!element2.getNodeName().equals("ShowTotal") || (string = element2.getAttribute("value")).length() <= 0) continue;
            this.setShowTotal(Boolean.valueOf(string));
        }
    }
}

