/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import com.inet.report.i;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;

@PublicApi
public class DateRange
implements Serializable {
    private Date Xo;
    private Date Xp;
    private boolean vz;

    public DateRange() {
        this.vz = true;
    }

    public DateRange(Date lower, Date upper) {
        if (lower == null) {
            throw i.d("lower");
        }
        if (upper == null) {
            throw i.d("upper");
        }
        if (lower.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.vz = false;
        this.Xo = (Date)lower.clone();
        this.Xp = (Date)upper.clone();
    }

    public boolean isAutoRange() {
        return this.vz;
    }

    public void setAutoRange(boolean autoRange) {
        this.vz = autoRange;
    }

    public Date getLowerBound() {
        if (this.Xo != null) {
            return (Date)this.Xo.clone();
        }
        return null;
    }

    public void setLowerBound(Date lower) {
        if (this.Xp != null && this.Xp.before(lower)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.Xo = lower != null ? (Date)lower.clone() : null;
    }

    public Date getUpperBound() {
        if (this.Xp != null) {
            return (Date)this.Xp.clone();
        }
        return null;
    }

    public void setUpperBound(Date upper) {
        if (this.Xo != null && this.Xo.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.Xp = upper != null ? (Date)upper.clone() : null;
    }

    boolean mS() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange() && this.mS()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeDate");
            buffer.append(' ');
            if (this.Xo != null) {
                f.b(buffer, "lowerBound", Long.toString(this.Xo.getTime()));
            }
            if (this.Xp != null) {
                f.b(buffer, "upperBound", Long.toString(this.Xp.getTime()));
            }
            buffer.append("/");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element) {
        long l2;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            l2 = Long.valueOf(string);
            this.setUpperBound(new Date(l2));
        }
    }
}

