/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.ParameterList;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.SimpleResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DatabaseSybase
extends Database {
    @Override
    protected String getSqlIdentifier(Datasource ds, String identifier, boolean escapeEverything) {
        return identifier;
    }

    @Override
    protected boolean scanSourceTypeParameter(ResultSet rs, ParameterList parameters) throws SQLException {
        parameters.clear();
        boolean bl2 = false;
        while (rs.next()) {
            bl2 = true;
            String string = rs.getString(4);
            int n2 = rs.getInt(5);
            int n3 = rs.getInt(6);
            int n4 = rs.getInt(10);
            if (n2 == 0) {
                n2 = string.equals("RETURN_VALUE") ? 5 : 1;
            }
            parameters.a(string, n2, n3, n4, this.isCursor(n3));
        }
        return bl2;
    }

    @Override
    public int getMaxAliasNameLength() {
        return 200;
    }

    @Override
    protected ResultSet getTables(Datasource ds, String catalog) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            ResultSet resultSet = connection.getMetaData().getTables(catalog, null, "%", null);
            return resultSet;
        }
    }

    @Override
    protected ResultSet getProcedureColumns(Datasource ds, String catalog, String schema, String procedure) throws SQLException, ReportException {
        ResultSet resultSet = super.getProcedureColumns(ds, catalog, schema, procedure);
        if (resultSet == null) {
            return null;
        }
        SimpleResultSet simpleResultSet = new SimpleResultSet(resultSet);
        List<Object[]> list = simpleResultSet.getAllRows();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            Object[] objectArray = list.get(i2);
            Object object = objectArray[4];
            int n3 = n2 = object != null ? Integer.parseInt(object.toString()) : 0;
            if (n2 != 0) continue;
            String string = (String)objectArray[3];
            objectArray[4] = string != null && string.equalsIgnoreCase("RETURN_VALUE") ? Integer.valueOf(5) : Integer.valueOf(1);
        }
        return simpleResultSet;
    }

    @Override
    protected boolean needQuote(String identifier) {
        if ("message".equals(identifier)) {
            return true;
        }
        return super.needQuote(identifier);
    }

    @Override
    protected void findColumnLabels(TableSource ts) {
        block14: {
            try (Connection connection = ts.getDatasource().getConnection();){
                if (ts.getType() != 1) {
                    return;
                }
                String string = ts.getDatabaseIdentifier();
                if (string.indexOf(46) != -1) {
                    string = string.substring(string.lastIndexOf(46) + 1, string.length());
                }
                ResultSet resultSet = DatabaseUtils.executeQuery(connection.createStatement(), "SELECT column_name,table_name, C.remarks FROM SYS.SYSCOLUMN C,SYS.SYSTABLE T WHERE C.table_id=t.table_id AND NOT c.remarks is null and table_name ='" + string + "'", null);
                SimpleResultSet simpleResultSet = new SimpleResultSet(resultSet);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("search column labels COLUMN_NAME\t\tTABLE_NAME\t\tCOMMENTS");
                }
                while (simpleResultSet.next()) {
                    DatabaseField databaseField;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(simpleResultSet.getString(1) + "\t\t" + simpleResultSet.getString(2) + "\t\t" + simpleResultSet.getString(3));
                    }
                    if ((databaseField = ts.getDatabaseField(simpleResultSet.getString(1))) == null) continue;
                    databaseField.setColumnLabel(simpleResultSet.getString(3));
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block14;
                BaseUtils.debug(exception);
            }
        }
    }
}

