/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.ParameterList;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.metadata.a;
import com.inet.report.database.metadata.b;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class DatabaseOracle
extends Database {
    public static final int TYPE_TIMESTAMP_WITH_TIME_ZONE = -101;
    public static final int TYPE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = -102;

    @Override
    protected String getSqlIdentifier(Datasource ds, String identifer, boolean isNotQualified) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            return super.getSqlIdentifier(ds, identifer, isNotQualified);
        }
        return super.getSqlIdentifier(ds, this.o(identifer), isNotQualified);
    }

    @Override
    public String convertIdentifier(Datasource ds, String identifer) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            return super.convertIdentifier(ds, identifer);
        }
        return super.convertIdentifier(ds, this.o(identifer));
    }

    @Override
    public String getAddOp() {
        return "||";
    }

    @Override
    public String sqlConcat(Object leftOperant, Object rightOperant) {
        if (leftOperant instanceof String || rightOperant instanceof String) {
            return String.valueOf(leftOperant) + "||" + String.valueOf(rightOperant);
        }
        return super.sqlConcat(leftOperant, rightOperant);
    }

    @Override
    protected String getSourceNameWithChange(TableSource ts, boolean escapeEverything) {
        Datasource datasource = ts.getDatasource();
        String string = ts.getDatabaseIdentifier();
        String[] stringArray = this.parseSourceName(string);
        StringBuilder stringBuilder = new StringBuilder();
        if (datasource.ce()) {
            stringArray[1] = datasource.getSchema();
        }
        if (datasource.cf()) {
            stringArray[0] = datasource.getCatalog();
        }
        if (stringArray[1] != null && stringArray[1].trim().length() != 0) {
            stringBuilder.append(stringArray[1]);
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
        }
        if (stringArray[0] != null && stringArray[0].trim().length() != 0) {
            stringBuilder.append(stringArray[0]);
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
        }
        stringBuilder.append(stringArray[2]);
        string = stringBuilder.toString();
        return this.getSqlIdentifier(datasource, string, escapeEverything);
    }

    @Override
    protected String[] parseSourceName(String sqlSource) {
        String[] stringArray = super.parseSourceName(sqlSource);
        if (!this.getConfiguration().isUseQuoteLowerCase()) {
            stringArray[0] = this.o(stringArray[0]);
            stringArray[1] = this.o(stringArray[1]);
            stringArray[2] = this.o(stringArray[2]);
        }
        return stringArray;
    }

    @Override
    protected boolean scanSourceType(TableSource ts, ParameterList dataTypeScale, boolean useMetaDataCache) throws SQLException, ReportException {
        b b2;
        a a2;
        boolean bl2;
        block28: {
            String string;
            bl2 = false;
            Datasource datasource = ts.getDatasource();
            DatabaseTables databaseTables = datasource.getEngine().getDatabaseTables();
            String[] stringArray = null;
            stringArray = this.parseSourceName(ts.getDatabaseIdentifier());
            if (datasource.ce()) {
                stringArray[1] = datasource.getSchema();
            }
            String string2 = stringArray[0] == null ? "" : stringArray[0];
            String string3 = string = stringArray[1] == null ? "" : stringArray[1];
            if (BaseUtils.isInfo()) {
                BaseUtils.info("catalog, schema, proc:" + string2 + ", " + string + ", " + stringArray[2] + "  " + String.valueOf(this.getClass()));
            }
            a2 = null;
            b2 = null;
            if (((Boolean)km.get()).booleanValue() && (b2 = Database.ko.get(a2 = a.a(ts.getDatasource(), stringArray[0], stringArray[1], stringArray[2]))) != null && useMetaDataCache) {
                dataTypeScale.load(b2.oD());
                return b2.oC();
            }
            dataTypeScale.clear();
            try (Connection connection = datasource.getConnection();){
                ResultSet resultSet;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                int n2 = 4;
                if (string2.isEmpty()) {
                    try {
                        resultSet = databaseMetaData.getTables(string2, string, stringArray[2], null);
                        if (resultSet.next()) {
                            String string4 = resultSet.getString(4);
                            n2 = string4 == null ? 1 : (string4.equals("TABLE") ? 1 : (string4.equals("VIEW") ? 2 : (string4.equals("SYSTEM TABLE") ? 1 : 1)));
                        }
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        databaseTables.bT().getEngine().setErrorMsg(sQLException.getMessage());
                        BaseUtils.printStackTrace(sQLException);
                    }
                }
                if (n2 <= 1) break block28;
                try {
                    resultSet = databaseMetaData.getProcedureColumns(string2, string, stringArray[2], null);
                    boolean bl3 = this.scanSourceTypeParameter(resultSet, dataTypeScale);
                    resultSet.close();
                    if (n2 == 4 && bl3 || n2 == 2 && dataTypeScale.getInputCount() > 0) {
                        bl2 = true;
                        ++n2;
                    } else if (!bl3 && n2 == 4) {
                        try {
                            resultSet = databaseMetaData.getProcedures(string2, string, stringArray[2]);
                            if (!resultSet.next()) {
                                bl2 = false;
                            }
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            BaseUtils.printStackTrace(throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (n2 == 4) {
                        bl2 = false;
                    }
                    databaseTables.bT().getEngine().setErrorMsg(throwable.getMessage());
                    BaseUtils.printStackTrace(throwable);
                }
                if (n2 == 4 && !bl2) {
                    boolean bl4 = true;
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String string5 = stringArray[i2];
                        if (string5 != null && string5.length() != 0) continue;
                        bl4 = false;
                        break;
                    }
                    if (bl4) {
                        bl2 = true;
                    } else if (string2.trim().length() > 0) {
                        bl2 = true;
                    }
                }
            }
        }
        if (((Boolean)km.get()).booleanValue() && b2 == null) {
            b2 = new b(bl2, dataTypeScale.clone());
            Database.ko.put(a2, b2);
        }
        return bl2;
    }

    @Override
    protected ResultSet getTables(Datasource ds, String catalog) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            ResultSet resultSet = connection.getMetaData().getTables(null, "%", "%", null);
            return resultSet;
        }
    }

    @Override
    protected ResultSet getProcedures(Datasource ds, String catalog) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            ResultSet resultSet = connection.getMetaData().getProcedures(null, "%", "%");
            return resultSet;
        }
    }

    @Override
    protected ResultSet getProcedureColumns(Datasource ds, String catalog, String schema, String procedure) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            if (catalog == null) {
                catalog = "";
            }
            ResultSet resultSet = connection.getMetaData().getProcedureColumns(catalog, this.n(schema), this.n(procedure), "%");
            return resultSet;
        }
    }

    private String n(String string) {
        if (string == null) {
            return "%";
        }
        return string;
    }

    @Override
    public boolean isCursor(int sqlType) {
        return sqlType == -10 || sqlType == 1111;
    }

    @Override
    protected int getCursorType(int dataType) {
        return -10;
    }

    private String o(String string) {
        int n2 = 61;
        if (string != null) {
            if (string.indexOf(61) < 0) {
                string = string.replace('\u00df', '=');
                string = string.toUpperCase(Locale.US);
                string = string.replace('=', '\u00df');
            } else {
                string = string.toUpperCase(Locale.US);
            }
        }
        return string;
    }

    @Override
    public int getMaxAliasNameLength() {
        return 30;
    }

    @Override
    public String convertToDate(String year, String month, String day) {
        return "to_date(" + year + "||'/'||" + month + "||'/'||" + day + ",'YYYY/mm/dd')";
    }

    @Override
    public String convertToDate(String date) throws ReportException {
        throw new ReportException("Not Executable on Database.", -150);
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) {
        return "to_date('1970-01-01 '||" + hour + "||'/'||" + minute + "||'/'||" + sec + ",'yyyy-mm-dd HH24/MI/SS')";
    }

    @Override
    public String convertToTime(String time) throws ReportException {
        return "to_date('1970-01-01 '||" + time + ",'yyyy-mm-dd HH24/MI/SS')";
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) {
        return "to_date(" + year + "||'/'||" + month + "||'/'||" + day + "|| ' ' || " + hour + "||'/'||" + minute + "||'/'||" + sec + ",'YYYY/mm/dd HH24/MI/SS')";
    }

    @Override
    public String convertToString(String parameter) throws ReportException {
        return "to_char(" + parameter + ")";
    }

    @Override
    public String convertModOperation(String dividend, String divisor) {
        return "mod(" + dividend + "," + divisor + ")";
    }

    @Override
    protected void findColumnLabels(TableSource ts) {
    }

    @Override
    public String getColumnName(String colName, String alias, int driverVersion, TableSource ts, int colIdx) {
        return super.getColumnName(colName, alias, driverVersion, ts, colIdx);
    }
}

