/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBodyCell;
import com.inet.report.CrossTabHeader;
import com.inet.report.CrossTabHeaderList;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SummaryField;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.parser.NodeParser;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class CrossTabBody
implements Serializable {
    private final CrossTab jg;
    private final List<CrossTabBodyCell> jh;
    private final List<SummaryField> ji;

    CrossTabBody(@Nonnull CrossTab crossTab) {
        this.jg = crossTab;
        this.jh = new ArrayList<CrossTabBodyCell>();
        this.ji = new ArrayList<SummaryField>();
    }

    public int getCellCount() {
        return this.jh.size();
    }

    public void removeSummaryField(int index) throws ReportException {
        if (index >= this.ji.size()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.elementNotFound, new Object[0]);
        }
        if (index < 0) {
            throw y.a("index", index, null);
        }
        SummaryField summaryField = this.ji.remove(index);
        for (int i2 = 0; i2 < this.jh.size(); ++i2) {
            this.jh.get(i2).remove(index);
        }
        summaryField.getField().removeReferenceHolder(this.jg);
        this.jg.bc().bl();
        this.jg.bc().bm();
    }

    public void moveSummaryField(int from, int to) {
        if (from >= this.ji.size()) {
            throw y.a(from, "from", null);
        }
        if (to >= this.ji.size()) {
            throw y.a(to, "to", null);
        }
        if (from < 0) {
            throw y.a("from", from, null);
        }
        if (to < 0) {
            throw y.a("to", to, null);
        }
        this.ji.add(to, this.ji.remove(from));
        for (int i2 = 0; i2 < this.jh.size(); ++i2) {
            this.jh.get(i2).move(from, to);
        }
        this.jg.bc().bl();
        this.jg.bc().bm();
    }

    @Nonnull
    public SummaryField getSummaryField(int index) {
        return this.ji.get(index);
    }

    public int getSummaryFieldsCount() {
        return this.ji.size();
    }

    public SummaryField addSummaryField(@Nonnull Field field, int operation) {
        SummaryField summaryField = new SummaryField(this.jg.bB);
        summaryField.setName(field.getName());
        summaryField.setField(field);
        summaryField.setSummaryOperation(operation);
        summaryField.setSummaryFieldType(1);
        this.addSummaryField(summaryField);
        return summaryField;
    }

    void addSummaryField(@Nonnull SummaryField summaryField) {
        this.ji.add(summaryField);
        for (int i2 = 0; i2 < this.jh.size(); ++i2) {
            this.jh.get(i2).b(summaryField);
        }
        this.jg.bc().bl();
        this.jg.bc().bm();
        Field field = summaryField.getField();
        if (field != null) {
            field.removeReferenceHolder(summaryField);
            field.addReferenceHolder(this.jg);
        }
    }

    void bg() {
        if (this.jh.size() > 0) {
            CrossTabBodyCell crossTabBodyCell = this.jh.get(0);
            for (int i2 = this.ji.size(); i2 < crossTabBodyCell.getFieldElementCount(); ++i2) {
                this.ji.add((SummaryField)crossTabBodyCell.getFieldElement(i2).getField());
            }
        }
    }

    void setReferences() {
        NodeParser nodeParser;
        int n2;
        this.bg();
        for (n2 = 0; n2 < this.ji.size(); ++n2) {
            nodeParser = this.ji.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().addReferenceHolder(this.jg);
            }
            if (((SummaryField)nodeParser).getField2nd() == null) continue;
            ((SummaryField)nodeParser).getField2nd().addReferenceHolder(this.jg);
        }
        for (n2 = 0; n2 < this.jh.size(); ++n2) {
            nodeParser = this.jh.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).setReferences();
            }
        }
    }

    void resetReferences() {
        NodeParser nodeParser;
        int n2;
        for (n2 = 0; n2 < this.ji.size(); ++n2) {
            nodeParser = this.ji.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().removeReferenceHolder(this.jg);
            }
            ((SummaryField)nodeParser).resetReferences();
        }
        for (n2 = 0; n2 < this.jh.size(); ++n2) {
            nodeParser = this.jh.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).resetReferences();
            }
        }
    }

    public CrossTabBodyCell getCell(int idx) {
        return this.jh.get(idx);
    }

    @Nonnull
    public CrossTabBodyCell getCell(int rowIdx, int columnIdx) {
        CrossTabHeader crossTabHeader = this.jg.getRows().get(rowIdx);
        CrossTabHeader crossTabHeader2 = this.jg.getColumns().get(columnIdx);
        int n2 = this.jh.size() - rowIdx - columnIdx * this.jg.getRows().size() - 1;
        CrossTabBodyCell crossTabBodyCell = this.jh.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        Collections.sort(this.jh, new a(this.jg));
        crossTabBodyCell = this.jh.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        throw new IllegalStateException("Cell not found: " + rowIdx + ", " + columnIdx);
    }

    @Nonnull
    CrossTabBodyCell bh() {
        return this.a(this.jh.size(), null, null);
    }

    void a(@Nullable CrossTabHeader crossTabHeader) {
        for (int i2 = 0; i2 < this.jh.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jh.get(i2);
            if (crossTabBodyCell.getRow() != crossTabHeader && crossTabBodyCell.getColumn() != crossTabHeader) continue;
            this.jh.remove(i2);
            --i2;
        }
    }

    void b(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.jg.getColumns();
        int n2 = crossTabHeaderList.size();
        int n3 = this.jg.getRows().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a((i2 + 1) * n3 - 1, crossTabHeader, crossTabHeader2);
        }
    }

    void c(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.jg.getRows();
        int n2 = crossTabHeaderList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a(this.jh.size(), crossTabHeader2, crossTabHeader);
        }
    }

    @Nonnull
    private CrossTabBodyCell a(int n2, @Nullable CrossTabHeader crossTabHeader, @Nullable CrossTabHeader crossTabHeader2) {
        CrossTabBodyCell crossTabBodyCell = new CrossTabBodyCell(this.jg, crossTabHeader, crossTabHeader2);
        this.jh.add(n2, crossTabBodyCell);
        if (crossTabHeader != null && crossTabHeader2 != null) {
            int n3 = this.ji.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                crossTabBodyCell.b(this.ji.get(i2));
            }
        }
        return crossTabBodyCell;
    }

    int b(@Nullable Element element) {
        for (int i2 = this.jh.size() - 1; i2 >= 0; --i2) {
            CrossTabBodyCell crossTabBodyCell = this.jh.get(i2);
            for (int i3 = crossTabBodyCell.getFieldElementCount() - 1; i3 >= 0; --i3) {
                if (element != crossTabBodyCell.getFieldElement(i3)) continue;
                return i2;
            }
        }
        return -1;
    }

    void bi() {
        m m2 = this.jg.bc();
        for (int i2 = 0; i2 < this.jh.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jh.get(i2);
            int n2 = crossTabBodyCell.getFieldElementCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                crossTabBodyCell.getFieldElement(i3).addPropertyChangeListener(m2);
            }
        }
    }

    private static class a
    implements Comparator<CrossTabBodyCell> {
        private final CrossTabHeaderList ip;
        private final CrossTabHeaderList io;

        private a(@Nonnull CrossTab crossTab) {
            this.ip = crossTab.getRows();
            this.io = crossTab.getColumns();
        }

        public int a(CrossTabBodyCell crossTabBodyCell, CrossTabBodyCell crossTabBodyCell2) {
            int n2;
            int n3 = this.io.g(crossTabBodyCell.getColumn());
            if (n3 == (n2 = this.io.g(crossTabBodyCell2.getColumn()))) {
                int n4;
                int n5 = this.ip.g(crossTabBodyCell.getRow());
                return n5 < (n4 = this.ip.g(crossTabBodyCell2.getRow())) ? 1 : (n5 == n4 ? 0 : -1);
            }
            return n3 < n2 ? 1 : -1;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((CrossTabBodyCell)object, (CrossTabBodyCell)object2);
        }
    }
}

