/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File awI;
    private static Hashtable<String, Object> brA;
    private static long brB;
    private static long brC;
    private static int brD;
    private static int brE;
    private static int brF;
    private static volatile int brG;
    private static volatile int brH;
    private static Set<Integer> brI;
    private static Set<String> brJ;
    private static Set<String> brK;
    private static double brL;
    private static int brM;
    private static int brN;
    private static double brO;
    private static double brP;
    private static int brQ;
    private static int brR;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.MV();
        ++brD;
    }

    public static void incReportRequest() {
        ++brE;
    }

    public static void incRenderedReports() {
        ++brF;
        brH = Math.max(brH, ++brG);
    }

    public static void decRenderedReports() {
        --brG;
    }

    public static int getCurrentRenderingReports() {
        return brG;
    }

    public static int getMaxRenderingReports() {
        return brH;
    }

    public static void countReportTemplates(URL reportUrl) {
        brI.add(new Integer(reportUrl.hashCode()));
    }

    public static void countClientLanguages(Locale locale) {
        brJ.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        brK.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        brL += (double)pages;
        ++brM;
        brN = Math.max(brN, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        brO += (double)fetchedRecord;
        brP += (double)discardedRecords;
        brQ = Math.max(brQ, fetchedRecord);
        brR = Math.max(brR, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = brA.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void MV() {
        long l2 = System.currentTimeMillis();
        if (l2 > brB) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= brB) return;
                Accumulator.a(brA, "");
                Accumulator.save();
                brD = 0;
                brE = 0;
                brF = 0;
                brL = 0.0;
                brN = 0;
                brM = 0;
                brO = 0.0;
                brQ = 0;
                brP = 0.0;
                brR = 0;
                brI.clear();
                brJ.clear();
                brK.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= brC) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= brC) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (awI == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        brA.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(brD, hashtable, "Total Requests" + string);
        Accumulator.a(brE, hashtable, "Report Requests" + string);
        Accumulator.a(brF, hashtable, "Rendered Reports" + string);
        Accumulator.a(brL, hashtable, "Total Page Count" + string);
        Accumulator.a(brN, hashtable, "Maximal Page Count" + string);
        Accumulator.a(brO, hashtable, "Total fetched Records" + string);
        Accumulator.a(brQ, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(brP, hashtable, "Total discarded Records" + string);
        Accumulator.a(brR, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(brI.size(), hashtable, "Report Templates");
            Accumulator.a(brJ.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", brJ);
            Accumulator.a(brK.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", brK);
            Accumulator.a(brL / (double)brM, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, brI);
            hashtable.put("Client Languages" + string, brJ);
            hashtable.put("Report Formats" + string, brK);
            hashtable.put("Average Page Count" + string, new Double(brM));
        }
        hashtable.put("Next Day", new Long(brB));
    }

    private static Hashtable<String, Object> MW() {
        Hashtable<String, Object> hashtable = brA = new Hashtable<String, Object>();
        try {
            awI = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(awI));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    brA = hashtable;
                } else {
                    hashtable = brA;
                }
                brD = (int)Accumulator.dH("Total Requests");
                brE = (int)Accumulator.dH("Report Requests");
                brF = (int)Accumulator.dH("Rendered Reports");
                brL = Accumulator.dH("Total Page Count");
                brN = (int)Accumulator.dH("Maximal Page Count");
                brM = (int)Accumulator.dH("Average Page Count");
                brO = Accumulator.dH("Total fetched Records");
                brQ = (int)Accumulator.dH("Maximal fetched Records");
                brP = Accumulator.dH("Total discarded Records");
                brR = (int)Accumulator.dH("Maximal discarded Records");
                brI = Accumulator.dI("Report Templates");
                brJ = Accumulator.dI("Client Languages");
                brK = Accumulator.dI("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.MX();
                    brB = l2;
                    Accumulator.MV();
                }
            }
            catch (Throwable throwable) {
                brA = hashtable;
                brI = Collections.synchronizedSet(new HashSet());
                brJ = Collections.synchronizedSet(new HashSet());
                brK = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.MX();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            brI = Collections.synchronizedSet(new HashSet());
            brJ = Collections.synchronizedSet(new HashSet());
            brK = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void MX() {
        Date date = new Date();
        brC = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        brB = date.getTime();
    }

    private static synchronized void save() {
        if (awI == null) {
            return;
        }
        Accumulator.MX();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(awI));
            objectOutputStream.writeObject(brA);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dH(String string) {
        Number number = (Number)brA.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dI(String string) {
        Set set = (Set)brA.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, new Double(d2));
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, new Double(d4));
        }
    }

    static {
        brA = Accumulator.MW();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

