/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class PDFConfig {
    protected static final int DEFAULT_CODEPAGE = 932;
    private boolean aSX;
    private boolean aSY;
    private boolean aSZ;
    private boolean aTa;

    public void setPDFA(boolean pdfa) {
        this.aSX = pdfa;
    }

    public boolean isPDFA() {
        return this.aSX;
    }

    public void setPdfa3(boolean pdfa3) {
        this.aSY = pdfa3;
    }

    public boolean isPdfa3() {
        return this.aSY;
    }

    public void setLinear(boolean linear) {
        this.aSZ = linear;
    }

    public boolean isLinear() {
        return this.aSZ;
    }

    public boolean isSignatureEnabled() {
        return false;
    }

    public boolean isReplaceMissingChars() {
        return true;
    }

    public boolean isCompression() {
        return false;
    }

    public boolean isMapAdobeFonts() {
        return true;
    }

    public int getAsianEncodingCodePage() {
        return 932;
    }

    public void setCreateStructure(boolean setStructure) {
        this.aTa = setStructure;
    }

    public boolean isCreateStructure() {
        return this.aTa;
    }

    public boolean isReplaceNotEmbeddedFonts() {
        return Boolean.parseBoolean(ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS.getKey(), ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS.getDefault()));
    }

    @Nullable
    public List<String> getListOfPreferredSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SERIF_FONT_LIST.getKey(), ConfigKey.PDF_SERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredSansSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SANSSERIF_FONT_LIST.getKey(), ConfigKey.PDF_SANSSERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredMonospacedFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_MONOSPACED_FONT_LIST.getKey(), ConfigKey.PDF_MONOSPACED_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }
}

