/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.debug;

import com.inet.annotations.InternalApi;
import com.inet.report.Engine;
import com.inet.report.FormulaField;
import com.inet.report.bi;
import com.inet.report.cb;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.d;
import com.inet.report.formula.k;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class ReferenceFinder {
    private d Is;
    private Engine anh;

    public ReferenceFinder(@Nonnull Engine e2) {
        this.anh = e2;
        this.Is = bi.g(e2);
    }

    @Nonnull
    public List<VariableReference> getVariables(@Nonnull FormulaField field) {
        k k2 = this.Is.qa();
        HashSet<VariableReference> hashSet = new HashSet<VariableReference>();
        for (y y2 : k2.qR().values()) {
            if (!y2.sl().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.global, y2));
        }
        for (y y2 : k2.qS().values()) {
            if (!y2.sl().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.shared, y2));
        }
        for (y y2 : k2.qT().values()) {
            if (!y2.sl().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.store, y2));
        }
        return new ArrayList<VariableReference>(hashSet);
    }

    public Set<FormulaField> getReferences(String variable, SCOPE scope) {
        k k2 = this.Is.qa();
        HashSet<FormulaField> hashSet = new HashSet<FormulaField>();
        y y2 = null;
        if ((scope == SCOPE.global || scope == null) && (y2 = (y)k2.qR().get(variable)) != null) {
            hashSet.addAll(y2.sl());
        }
        if ((scope == SCOPE.shared || scope == null) && (y2 = (y)k2.qS().get(variable)) != null) {
            for (FormulaField formulaField : y2.sl()) {
                if (cb.getEngineForField(formulaField) != this.anh) continue;
                hashSet.add(formulaField);
            }
        }
        if ((scope == SCOPE.store || scope == null) && (y2 = (y)k2.qT().get(variable)) != null) {
            for (FormulaField formulaField : y2.sl()) {
                if (cb.getEngineForField(formulaField) != this.anh) continue;
                hashSet.add(formulaField);
            }
        }
        return hashSet;
    }

    public static class VariableReference {
        private SCOPE anQ;
        private int valueType;
        private String name;

        private VariableReference(@Nonnull SCOPE scope, @Nonnull y var) {
            this.anQ = scope;
            this.valueType = var.getValueType(null);
            this.name = var.getName();
        }

        @Nonnull
        public SCOPE getScope() {
            return this.anQ;
        }

        public int getValueType() {
            return this.valueType;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + "#" + this.valueType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VariableReference)) {
                return false;
            }
            VariableReference variableReference = (VariableReference)obj;
            return this.anQ == variableReference.anQ && this.valueType == variableReference.valueType && this.name.equals(variableReference.name);
        }

        public int hashCode() {
            return this.name.hashCode() * (this.anQ.ordinal() + 1);
        }
    }

    public static enum SCOPE {
        local,
        global,
        shared,
        store;

    }
}

