/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.AreaStyle;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.ChartPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.ContinuousStyle;
import com.inet.report.chart.plot.LineStyle;
import com.inet.report.chart.plot.XYStyle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class CombinedPlot
implements ChartPlot {
    public static final String TOKEN_COMBINED_PLOT = "CombinedPlot";
    public static final int COMBINE_ONE_PLOT_WITH_COMMON_GROUP_AXIS = 0;
    public static final int COMBINE_ONE_PLOT_WITH_COMMON_DATA_AXIS = 1;
    public static final int COMBINE_MULTIPLE_PLOTS_WITH_COMMON_GROUP_AXIS = 2;
    public static final int COMBINE_MULTIPLE_PLOTS_WITH_COMMON_DATA_AXIS = 3;
    private ArrayList<AbstractPlot> Zh;
    private int Zi;

    public CombinedPlot() {
        this(0);
    }

    public CombinedPlot(int combineType) {
        if (combineType != 2 && combineType != 3 && combineType != 0 && combineType != 1) {
            throw new IllegalArgumentException("Unknown combination type.");
        }
        this.Zh = new ArrayList();
        this.Zi = combineType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPlot(AbstractPlot plot) {
        if (this.Zh.isEmpty()) {
            if (!CombinedPlot.e(plot) && !CombinedPlot.f(plot)) throw new IllegalArgumentException("This is a not combinable plot");
            this.Zh.add(plot);
            return;
        } else {
            AbstractPlot abstractPlot = this.Zh.get(0);
            if (CombinedPlot.e(abstractPlot) && CombinedPlot.e(plot)) {
                this.Zh.add(plot);
                return;
            } else {
                if (!CombinedPlot.f(abstractPlot) || !CombinedPlot.f(plot)) throw new IllegalArgumentException("Cannot combine this plot with the other plots in the list.");
                this.Zh.add(plot);
            }
        }
    }

    private static boolean e(AbstractPlot abstractPlot) {
        ChartStyle chartStyle = abstractPlot.getStyle();
        if (chartStyle.equals(BarStyle.BAR2D) || chartStyle.equals(BarStyle.BAR2D_PERCENT) || chartStyle.equals(BarStyle.BAR2D_STACKED)) {
            return true;
        }
        if (chartStyle instanceof LineStyle) {
            return true;
        }
        return chartStyle.equals(AreaStyle.AREA2D_PERCENT) || chartStyle.equals(AreaStyle.AREA2D_STACKED);
    }

    private static boolean f(AbstractPlot abstractPlot) {
        ChartStyle chartStyle = abstractPlot.getStyle();
        return chartStyle instanceof ContinuousStyle || chartStyle instanceof XYStyle;
    }

    public AbstractPlot removePlot(int index) {
        return this.Zh.remove(index);
    }

    public AbstractPlot getPlot(int index) {
        return this.Zh.get(index);
    }

    public int size() {
        return this.Zh.size();
    }

    public int getCombineType() {
        return this.Zi;
    }

    public void setCombineType(int combineType) {
        if (combineType != 3 && combineType != 2 && combineType != 1 && combineType != 0) {
            throw new IllegalArgumentException("Unknown value of 'combineType': " + combineType);
        }
        this.Zi = combineType;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getPlot(i2).refreshAutoTitles(chart);
        }
        a.setAutoTitle(chart.getHeaderTitle(), "");
    }

    @Override
    public void saveProperties(PrintWriter out, int depth) {
        String string = BaseUtils.getIndent(depth);
        ++depth;
        StringBuilder stringBuilder = new StringBuilder();
        f.b(stringBuilder, "type", String.valueOf(this.getCombineType()));
        f.a(out, string, TOKEN_COMBINED_PLOT, stringBuilder, false);
        for (int i2 = 0; i2 < this.Zh.size(); ++i2) {
            this.Zh.get(i2).saveProperties(out, depth);
        }
        f.a(out, string, TOKEN_COMBINED_PLOT, null, true);
    }

    @Override
    public List getReferencedObject() {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getPlot(i2) == null) continue;
            arrayList.addAll(this.getPlot(i2).getReferencedObject());
        }
        return arrayList;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        String string = element.getAttribute("type");
        if (string.length() > 0) {
            this.setCombineType(Integer.parseInt(string));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            try {
                if (!element2.getNodeName().equals("Plot")) continue;
                String string2 = element2.getAttribute("style");
                AbstractPlot abstractPlot = null;
                if (string2.length() <= 0) {
                    throw new IllegalArgumentException("Chart style name missing.");
                }
                abstractPlot = f.aL(string2).getDefaultPlot();
                this.addPlot(abstractPlot);
                if (abstractPlot != null) {
                    abstractPlot.readProperties(element2, chart);
                    continue;
                }
                throw new IllegalArgumentException("Reading sub plot failed.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BaseUtils.error("Parsing Chart2 failed!");
                BaseUtils.error(illegalArgumentException);
            }
        }
    }

    @Override
    public BaseDataset getDataset() {
        return null;
    }
}

