/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.chart3d.geom.ViewParams;
import com.inet.lib.util.ColorUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.axis.DiscreteNumberAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.Chart3DStyle;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.StandardPlot;
import com.inet.report.i;
import java.awt.Color;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class Chart3DPlot
extends StandardPlot {
    public static final Chart3DStyle DEFAULT_STYLE = Chart3DStyle.BAR;
    public static final int DEFAULT_WALL_COLOR = ColorUtils.toCcColor((Color)new Color(230, 230, 230));
    public static final int DEFAULT_BASE_COLOR = ColorUtils.toCcColor((Color)new Color(180, 180, 180));
    private Chart3DStyle Ze;
    private BaseAxis Zf;
    private int Zg;
    private ViewParams at;

    public Chart3DPlot() {
        this(DEFAULT_STYLE);
    }

    public Chart3DPlot(Chart3DStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.Ze = style;
        this.setCategoryAxis(new BaseAxis());
        this.setSeriesAxis(new BaseAxis());
        this.setDataAxis(new DiscreteNumberAxis());
        this.setBackColor(DEFAULT_BASE_COLOR);
        this.setWallBackColor(DEFAULT_WALL_COLOR);
        this.at = ViewParams.createDefault();
    }

    public int getWallBackColor() {
        return this.Zg;
    }

    public void setWallBackColor(int wallBackgroundColor) {
        this.Zg = wallBackgroundColor;
    }

    public BaseAxis getSeriesAxis() {
        return this.Zf;
    }

    public void setSeriesAxis(BaseAxis seriesAxis) {
        if (seriesAxis == null) {
            throw i.d("seriesAxis");
        }
        this.Zf = seriesAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.Ze;
    }

    public void setStyle(Chart3DStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.Ze = style;
    }

    public ViewParams getViewParams() {
        return this.at;
    }

    public void setViewParams(ViewParams viewParams) {
        if (viewParams == null) {
            throw i.d("viewParams");
        }
        this.at = viewParams;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        if (this.getDataset() != null) {
            LabelProvider labelProvider = this.getDataset().getLabelProvider();
            a.setAutoTitle(chart.getHeaderTitle(), labelProvider.getLabel(0));
            a.setAutoTitle(this.getCategoryAxis().getTitle(), labelProvider.getLabel(2));
            a.setAutoTitle(this.getSeriesAxis().getTitle(), labelProvider.getLabel(3));
            a.setAutoTitle(this.getDataAxis().getTitle(), labelProvider.getLabel(4));
        }
    }

    @Override
    protected StringBuilder cB(int n2) {
        StringBuilder stringBuilder = super.cB(n2);
        if (this.getWallBackColor() != DEFAULT_WALL_COLOR) {
            f.b(stringBuilder, n2, "WallBackground", "color", String.valueOf(this.getWallBackColor()));
        }
        if (!this.getViewParams().equals(ViewParams.createDefault())) {
            this.getViewParams().saveProperties(stringBuilder, n2);
        }
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        this.Zf.saveProperties(printWriter, ++n2, "SeriesAxis");
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("SeriesAxis")) {
                this.Zf.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("WallBackground")) {
                String string = element2.getAttribute("color");
                if (string.length() <= 0) continue;
                int n2 = Integer.parseInt(string);
                this.setWallBackColor(n2);
                continue;
            }
            if (!element2.getNodeName().equals("ViewParam")) continue;
            this.getViewParams().readProperties(element2);
        }
    }
}

