/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.dataset;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.DChartUtilities;
import com.inet.report.Field;
import com.inet.report.Group;
import com.inet.report.ReferencedObject;
import com.inet.report.SummaryField;
import com.inet.report.chart.dataset.AbstractDataset;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.StandardDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.i;
import com.inet.report.j;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class TwoGroupsDataset
extends AbstractDataset
implements StandardDataset {
    private Chart2 hV;
    private Group XR;
    private Group XS;
    private SummaryField XW;
    private LabelProvider XL = new a();

    public TwoGroupsDataset(Chart2 chart) {
        if (chart == null) {
            throw i.d("chart");
        }
        this.hV = chart;
    }

    @Override
    public Chart2 getChart() {
        return this.hV;
    }

    public Group getCategoryGroup() {
        return this.XR;
    }

    public void setCategoryGroup(Field field) {
        this.XR = i.a(field, this.hV);
        this.updateReferences();
    }

    public void removeCategoryGroup() {
        this.XR = null;
        this.updateReferences();
    }

    public Group getSeriesGroup() {
        return this.XS;
    }

    public void setSeriesGroup(Field field) {
        this.XS = i.a(field, this.hV);
        if (this.XW != null) {
            this.XW.setGroup(this.XS);
        }
        this.updateReferences();
    }

    public void removeSeriesGroup() {
        this.XS = null;
        if (this.XW != null) {
            this.XW.setGroup(null);
        }
        this.updateReferences();
    }

    public SummaryField getDataField() {
        return this.XW;
    }

    @Override
    public SummaryField getDataField(String name) {
        if (name == null) {
            throw i.d("name");
        }
        if (this.getDataField() != null && this.getDataField().getName() != null && this.getDataField().getName().equals(name)) {
            return this.getDataField();
        }
        return null;
    }

    @Override
    public List getDataFields() {
        return Arrays.asList(this.XW);
    }

    public void setDataField(int summaryOperation, Field field, Field field2nd, int nth) {
        SummaryField summaryField = i.a(this, summaryOperation, field, field2nd, nth, false);
        i.a(this, summaryField);
        summaryField.setGroup(this.getSeriesGroup());
        this.XW = summaryField;
        this.updateReferences();
    }

    public void removeDataField() {
        this.XW = null;
        this.updateReferences();
    }

    @Override
    public String verify(ChartStyle style) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.XW == null) {
            stringBuilder.append("Data field is null. ");
        }
        if (this.XR == null) {
            stringBuilder.append(' ');
            stringBuilder.append("Fist group is null. ");
        }
        if (this.XS == null) {
            stringBuilder.append(' ');
            stringBuilder.append("Second group is null. ");
        }
        return stringBuilder.toString();
    }

    @Override
    public List getReferencedObject() {
        ArrayList<ReferencedObject> arrayList = new ArrayList<ReferencedObject>();
        if (this.getCategoryGroup() != null) {
            arrayList.add(this.getCategoryGroup());
        }
        if (this.getSeriesGroup() != null) {
            arrayList.add(this.getSeriesGroup());
        }
        if (this.getDataField() != null) {
            arrayList.add(this.getDataField());
        }
        return arrayList;
    }

    @Override
    public void updateReferences() {
        this.hV.updateReferences();
    }

    @Override
    protected void saveGroups(PrintWriter out, int depth) {
        String string = BaseUtils.getIndent(depth);
        f.a(out, string, "Groups", null, false);
        j.a(out, ++depth, this.getCategoryGroup(), true);
        j.a(out, depth, this.getSeriesGroup(), false);
        f.a(out, string, "Groups", null, true);
    }

    @Override
    void c(NodeList nodeList) {
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i2);
            if (element.getNodeName().equals("Sums")) {
                j.a(element, this, this.hV);
                continue;
            }
            if (!element.getNodeName().equals("Groups")) continue;
            j.b(element, this, this.hV);
        }
    }

    @Override
    protected String getName() {
        return "TwoGroupsDataset";
    }

    @Override
    public LabelProvider getLabelProvider() {
        return this.XL;
    }

    private class a
    implements LabelProvider {
        private a() {
        }

        @Override
        public String getLabel(int labelType) {
            String string = null;
            if (TwoGroupsDataset.this.getCategoryGroup() != null) {
                string = DChartUtilities.getFieldName(TwoGroupsDataset.this.getCategoryGroup().getField());
            }
            String string2 = null;
            if (TwoGroupsDataset.this.getSeriesGroup() != null) {
                string2 = DChartUtilities.getFieldName(TwoGroupsDataset.this.getSeriesGroup().getField());
            }
            String string3 = null;
            if (TwoGroupsDataset.this.getDataField() != null) {
                string3 = TwoGroupsDataset.this.getDataField().getName();
            }
            return this.getLabel(labelType, string, string2, string3, null);
        }

        @Override
        public String getLabel(int labelType, String category, String series, String data, String footnote) {
            String string = i.f(category);
            String string2 = i.f(series);
            String string3 = i.f(data);
            switch (labelType) {
                case 0: {
                    if (string.length() > 0 && string2.length() > 0 && string3.length() > 0) {
                        return string3 + " " + i.getMsg("Title_Separator", TwoGroupsDataset.this.getChart().getLocalizationResources()) + " " + string + " " + i.getMsg("Group_Separator", TwoGroupsDataset.this.getChart().getLocalizationResources()) + " " + string2;
                    }
                }
                case 3: {
                    return string2;
                }
                case 2: {
                    return string;
                }
                case 4: {
                    return string3;
                }
            }
            return "";
        }
    }
}

