/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.remoteprinting;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.report.remoteprinting.RemotePrintingPlugin;
import com.inet.viewer.ViewerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;

@InternalApi
public class PrinterDescription {
    private static final boolean g;
    private static final I18nMessages h;
    private final PrintService i;
    private final boolean j;
    private final List<MediaTray> trays;

    public PrinterDescription(@Nonnull PrintService service) {
        Object object;
        Cloneable cloneable;
        this.i = service;
        boolean bl = false;
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)service.getDefaultAttributeValue(MediaPrintableArea.class);
        if (mediaPrintableArea != null && mediaPrintableArea.getX(1) == 0.0f && mediaPrintableArea.getY(1) == 0.0f && (cloneable = (Media)service.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName && (object = MediaSize.getMediaSizeForName((MediaSizeName)cloneable)) != null && mediaPrintableArea.getWidth(1) + 352.77777f >= ((Size2DSyntax)object).getX(1) && mediaPrintableArea.getHeight(1) + 352.77777f >= ((Size2DSyntax)object).getY(1)) {
            bl = true;
        }
        cloneable = null;
        if (g && (object = service.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) instanceof Media[]) {
            Media[] mediaArray = (Media[])object;
            for (int i = 0; i < mediaArray.length; ++i) {
                Media media = mediaArray[i];
                if (!(media instanceof MediaTray)) continue;
                if (cloneable == null) {
                    cloneable = new ArrayList();
                }
                cloneable.add((MediaTray)media);
            }
        }
        this.j = bl;
        this.trays = cloneable;
    }

    public PrintService getService() {
        return this.i;
    }

    boolean g() {
        return this.j;
    }

    @Nullable
    List<LocalizedKey> h() {
        if (this.trays == null) {
            return null;
        }
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        arrayList.add(new LocalizedKey("auto-select", h.getMsg("auto-select", new Object[0])));
        for (MediaTray mediaTray : this.trays) {
            String string;
            String string2 = mediaTray.toString();
            try {
                string = h.getBundle().getString(string2.replace(' ', '-'));
            }
            catch (MissingResourceException missingResourceException) {
                string = string2;
            }
            arrayList.add(new LocalizedKey(string2, string));
        }
        return arrayList;
    }

    public List<MediaTray> getTrays() {
        return this.trays;
    }

    static {
        boolean bl;
        try {
            ViewerUtils.createSunAlternateMedia((MediaTray)MediaTray.BOTTOM);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
            RemotePrintingPlugin.LOGGER.warn((Object)"If you need printer tray selection then add command line parameter: --add-exports=java.desktop/sun.print=ALL-UNNAMED");
            RemotePrintingPlugin.LOGGER.debug((Object)throwable);
        }
        g = bl;
        h = new I18nMessages("com.inet.viewer.print.LanguageResources", ViewerUtils.class);
    }
}

