/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.angular.filechooser;

import com.inet.classloader.BaseLocator;
import com.inet.lib.core.OS;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.filechooser.FSFile;
import com.inet.remote.gui.angular.filechooser.FileSystemService;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class a
implements FileSystemService {
    private static final HashMap<String, String> aj = new HashMap();
    private static JFileChooser ak;
    private static boolean al;
    private static FileSystemView am;

    public a() {
        ForkJoinPool.commonPool().execute(() -> a.f());
    }

    private static FileSystemView f() {
        if (!al) {
            al = true;
            try {
                am = FileSystemView.getFileSystemView();
                Path path = null;
                try {
                    path = Files.createTempDirectory(".inetTempFolder", new FileAttribute[0]);
                    am.getSystemIcon(path.toFile());
                }
                finally {
                    if (path != null) {
                        Files.delete(path);
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger((String)"Remotegui").warn((Object)"Cannot access fileSystem-view: icons and labels in filechooser may be missing or wrong");
                LogManager.getLogger((String)"Remotegui").warn((Object)throwable);
            }
        }
        return am;
    }

    @Nonnull
    public String getExtensionName() {
        return "file";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Access is secured by login and permission. Pathes are controlled by code.")
    public @Nullable List<@Nonnull FSFile> getRoots() {
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            return null;
        }
        var1_1 = new ArrayList<FSFile>();
        var2_2 = FileSystemView.getFileSystemView();
        var3_3 = new ArrayList<Object>();
        var4_4 = new TreeSet<Object>();
        try {
            var5_5 = new File(System.getProperty("user.home") + File.separator + "Desktop");
            if (!OS.isWindows() && var5_5.exists() && !var4_4.contains(var5_5)) {
                var4_4.add(var5_5);
            }
            if ((var5_5 = new File(System.getProperty("user.home"))).exists() && !var4_4.contains(var5_5)) {
                var4_4.add(var5_5);
            }
        }
        catch (SecurityException var5_6) {
            // empty catch block
        }
        if (OS.isMac()) {
            try {
                var5_5 = String.valueOf(File.separatorChar);
                var6_9 = new File((String)var5_5 + "Volumes" + (String)var5_5);
                var7_11 = var6_9.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                var4_4.add(new File((String)var5_5 + "Applications" + (String)var5_5));
                if (var7_11 == null) ** GOTO lbl97
                for (Object var11_27 : var7_11) {
                    if (var4_4.contains(var11_27)) continue;
                    var4_4.add(var11_27);
                }
            }
            catch (SecurityException var5_7) {}
        } else {
            if (OS.isUnix()) {
                try {
                    var5_5 = String.valueOf(File.separatorChar);
                    var6_9 = new File((String)var5_5 + "media" + (String)var5_5);
                    var7_11 = var6_9.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    if (var7_11 != null) {
                        var8_15 = var7_11;
                        var9_20 = var8_15.length;
                        for (var10_24 = 0; var10_24 < var9_20; ++var10_24) {
                            var11_27 = var8_15[var10_24];
                            if (var4_4.contains(var11_27)) continue;
                            var4_4.add(var11_27);
                        }
                    }
                }
                catch (SecurityException var5_8) {
                    // empty catch block
                }
            }
            var5_5 = null;
            try {
                var5_5 = var2_2.getRoots();
            }
            catch (Throwable var6_10) {
                // empty catch block
            }
            var6_9 = null;
            try {
                var6_9 = File.listRoots();
            }
            catch (Throwable var7_12) {
                // empty catch block
            }
            if (var5_5 != null) {
                for (File var10_25 : var5_5) {
                    if (OS.isWindows()) {
                        try {
                            if (var2_2.isDrive(var10_25) || var4_4.contains(var10_25)) continue;
                            var4_4.add(var10_25);
                        }
                        catch (Throwable var11_28) {
                            if (var4_4.contains(var10_25)) continue;
                            var4_4.add(var10_25);
                        }
                        continue;
                    }
                    if (var4_4.contains(var10_25)) continue;
                    var4_4.add(var10_25);
                }
            }
            if (var6_9 != null) {
                for (File var10_26 : var6_9) {
                    if (OS.isWindows()) {
                        try {
                            if (!var2_2.isDrive(var10_26) || var4_4.contains(var10_26)) continue;
                            var4_4.add(var10_26);
                        }
                        catch (Throwable var11_29) {
                            if (var4_4.contains(var10_26)) continue;
                            var4_4.add(var10_26);
                        }
                        continue;
                    }
                    if (var4_4.contains(var10_26)) continue;
                    var4_4.add(var10_26);
                }
            }
        }
lbl97:
        // 11 sources

        for (Object var6_9 : var4_4) {
            var7_13 = true;
            try {
                var7_13 = var2_2.isTraversable((File)var6_9);
            }
            catch (Throwable var8_18) {
                // empty catch block
            }
            if (!var7_13 || !var6_9.exists() || !var6_9.canRead()) continue;
            if (OS.isWindows()) {
                var3_3.add(var6_9);
                continue;
            }
            try {
                if (var2_2.isFloppyDrive((File)var6_9)) continue;
                var3_3.add(var6_9);
            }
            catch (Throwable var8_19) {
                var3_3.add(var6_9);
            }
        }
        Collections.sort(var3_3);
        for (Object var6_9 : var3_3) {
            if (!var6_9.canRead()) continue;
            var7_11 = var6_9.getAbsolutePath();
            var8_14 = null;
            try {
                var8_14 = new String(Base64.getEncoder().encode(var7_11.getBytes("UTF-8")), "UTF-8");
            }
            catch (UnsupportedEncodingException var9_21) {
                // empty catch block
            }
            var9_22 = new FSFile(this.getExtensionName(), (String)var7_11, this.a((File)var6_9), (String)var8_14, this.b((File)var6_9), var6_9.isDirectory(), var6_9.isHidden());
            var1_1.add(var9_22);
        }
        return var1_1;
    }

    private String a(File file) {
        String string = "";
        try {
            if (OS.isMac() && this.g() != null) {
                string = this.g().getName(file);
            } else {
                FileSystemView fileSystemView = a.f();
                if (fileSystemView != null) {
                    string = fileSystemView.getSystemDisplayName(file);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = file.getName();
        }
        if (string.length() == 0) {
            string = file.toString();
        }
        return string;
    }

    private JFileChooser g() {
        if (ak == null) {
            try {
                ak = new JFileChooser();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b(File file) {
        String string = this.c(file);
        HashMap<String, String> hashMap = aj;
        synchronized (hashMap) {
            if (!aj.containsKey(string)) {
                aj.put(string, file.getAbsolutePath());
            }
        }
        return string;
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="just for checksum, legacy code")
    private String c(File file) {
        byte[] byArray = this.d(file);
        if (byArray != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.reset();
                byte[] byArray2 = messageDigest.digest(byArray);
                return String.format("%1$042x", new BigInteger(1, byArray2));
            }
            catch (Throwable throwable) {
                LogManager.getLogger((String)"Remotegui").warn((Object)"Could not calculate image hash.");
                LogManager.getLogger((String)"Remotegui").warn((Object)throwable);
            }
        }
        return null;
    }

    @Override
    public byte[] getFileImage(@Nonnull String iconid) {
        String string = aj.get(iconid);
        return this.d(new File(string));
    }

    byte[] d(File file) {
        Object object;
        if (file == null) {
            return null;
        }
        Icon icon = null;
        try {
            if (OS.isMac() && this.g() != null) {
                icon = this.g().getIcon(file);
            } else {
                object = a.f();
                if (object != null) {
                    icon = ((FileSystemView)object).getSystemIcon(file);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (icon != null && (icon.getIconWidth() < 0 || icon.getIconHeight() < 0)) {
            icon = null;
        }
        if (icon == null) {
            try {
                icon = UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (icon == null || icon.getIconWidth() < 0 || icon.getIconHeight() < 0) {
                return null;
            }
        }
        object = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        icon.paintIcon(this.g(), graphics2D, 0, 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)object, "PNG", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            LogManager.getLogger((String)"Remotegui").error((Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Access is secured by login and permission. Path traversal is allowed for administrators.")
    public List<FSFile> getFileSystemFiles(@Nonnull String folderpath, final boolean directoriesOnly) {
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            return null;
        }
        folderpath = folderpath.replace('/', File.separatorChar);
        ArrayList<FSFile> arrayList = new ArrayList<FSFile>();
        File file = new File(folderpath);
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file == null) {
            return arrayList;
        }
        if (!file.exists() || !file.canRead()) {
            return arrayList;
        }
        Object[] objectArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isHidden() && !pathname.isDirectory()) {
                    return false;
                }
                return !directoriesOnly || pathname.isDirectory();
            }
        });
        if (objectArray == null) {
            return null;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string = ((File)object).getAbsolutePath();
            String string2 = null;
            try {
                string2 = new String(Base64.getEncoder().encode(string.getBytes("UTF-8")), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            FSFile fSFile = new FSFile(this.getExtensionName(), string, this.a((File)object), string2, this.b((File)object), ((File)object).isDirectory(), ((File)object).isHidden());
            arrayList.add(fSFile);
        }
        Collections.sort(arrayList, new Comparator<FSFile>(){

            public int a(FSFile fSFile, FSFile fSFile2) {
                if (fSFile.isDir() == fSFile2.isDir()) {
                    return fSFile.getLabel().compareToIgnoreCase(fSFile2.getLabel());
                }
                if (fSFile.isDir() && !fSFile2.isDir()) {
                    return -1;
                }
                if (!fSFile.isDir() && fSFile2.isDir()) {
                    return 1;
                }
                return 0;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((FSFile)object, (FSFile)object2);
            }
        });
        return arrayList;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Access is secured by login and permission. Path traversal is allowed for administrators.")
    public FSFile getFile(@Nonnull String path) {
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            return null;
        }
        File file = new File(path = path.replace('/', File.separatorChar));
        if (file.exists() && file.isAbsolute()) {
            path = file.getAbsolutePath();
        }
        String string = null;
        try {
            string = new String(Base64.getEncoder().encode(path.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        FSFile fSFile = new FSFile(this.getExtensionName(), path, this.a(file), string, this.b(file), this.a(path, file), file.isHidden());
        return fSFile;
    }

    private boolean a(String string, File file) {
        return file.isDirectory() || string.endsWith(File.separator);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Access is secured by login and permission. Path traversal is allowed for administrators.")
    public FSFile getParent(@Nonnull String path) {
        File file;
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            return null;
        }
        if (!this.a(path = path.replace('/', File.separatorChar), file = new File(path))) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        Object object = file.getAbsolutePath();
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return this.getFile((String)object);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Access is secured by login and permission. Path traversal is allowed for administrators.")
    public FSFile getFolder(@Nonnull String path) {
        File file;
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            return null;
        }
        if (!this.a(path = path.replace('/', File.separatorChar), file = new File(new File(path).getAbsolutePath()))) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        Object object = file.getAbsolutePath();
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return this.getFile((String)object);
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Pathes and access are checked by caller")
    public String normalizePath(@Nullable String basePath, @Nonnull String folderPath) {
        try {
            URL uRL = new URL(folderPath);
            if ("file".equalsIgnoreCase(uRL.getProtocol())) {
                folderPath = IOFunctions.getFile((URL)uRL).getPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (basePath != null) {
            try {
                folderPath = Paths.get(basePath, new String[0]).resolve(folderPath).toString();
            }
            catch (InvalidPathException invalidPathException) {
                try {
                    folderPath = Paths.get(basePath, new String[0]).toString();
                }
                catch (InvalidPathException invalidPathException2) {
                    folderPath = Paths.get("", new String[0]).toString();
                }
            }
        }
        return folderPath;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File path is used for protocol check. No file access possible.")
    public boolean isResponsible(@Nonnull String path) {
        try {
            URI uRI = URI.create(path);
            String string = uRI.getScheme();
            if (string != null) {
                return "file".equalsIgnoreCase(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Paths.get(path, new String[0]);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    @Override
    @Nonnull
    public Permission getRequiredPermission() {
        return Permission.CONFIGURATION;
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(URL saveTarget) throws IOException, AccessDeniedException {
        if (!SystemPermissionChecker.checkHostingAccess((Permission)this.getRequiredPermission())) {
            throw new AccessDeniedException(this.getRequiredPermission());
        }
        File file = IOFunctions.getFile((URL)saveTarget);
        if (BaseLocator.isRestrictedPath((Path)file.toPath())) {
            throw new AccessDeniedException(saveTarget);
        }
        return new FastBufferedOutputStream((OutputStream)new FileOutputStream(file));
    }
}

