'use strict';clearreportsApp.service("websocketdataservice",function($timeout,$interval,$rootScope,$websocket,dataservice,errorservice,windowdatarestore){this.isWebSocketAvailable=function(){return webSocketsAvailable||!connectionTested};this.isWebSocketOpen=function(){return webSocketOpen};this.isOffline=function(){return reconnecting};this.connectWebsocket=function(){_connectWebsocket()};this.registerErrorHandler=function(handler){errorHandler=handler};this.registerReconnectingHandler=function(handler){reconnectingHandler=
handler};this.registerReconnectHandler=function(handler){reconnectHandler=handler;dataservice.reloadsWhenReconnected(handler==undefined)};this.registerReconnectedHandler=function(handler){reconnectedHandler=handler};this.onEvent=function(eventName,callback,allowsMultipleHandler){var listeners=messageCallbacks[eventName];if(listeners==undefined||allowsMultipleHandler!==true){listeners=[];messageCallbacks[eventName]=listeners}listeners.push(callback)};this.unregisterEvent=function(eventName,callback){if(callback==
undefined)delete messageCallbacks[eventName];else{var listeners=messageCallbacks[eventName];if(listeners!=undefined){var index=listeners.indexOf(callback);if(index>=0)listeners.splice(index,1);if(listeners.length<=0)delete messageCallbacks[eventName]}}};this.sendEvent=function(eventName,dataObject){_sendEvent(eventName,dataObject)};this.setPollingInterval=function(seconds){pollingInterval=seconds*4;if(nextPollingIn>pollingInterval)nextPollingIn=pollingInterval};this.pollNow=function(){nextPollingIn=
0};this.getPollingID=function(){return appPrefix+pollingid};var messageCallbacks={};var eventQueue=[];var errorHandler=undefined;var reconnectHandler=undefined;var reconnectingHandler=$.noop;var reconnectedHandler=$.noop;var pollingInterval=4;var nextPollingIn=4;var keepAliveWorker=undefined;var keepAliveInterval=undefined;var serverStartTime=undefined;var appPrefix=($("html").attr("modulepath")||"inet").replace(/\//g,"")+"-";var generatePollingID=function(){var newID="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,
function(c){var r=Math.random()*16|0,v=c=="x"?r:r&3|8;return v.toString(16)});windowdatarestore.setDataToRestore("pollingID",newID);return newID};var previousPollingID=windowdatarestore.getRestoredData("pollingID");var pollingid=previousPollingID!=undefined&&previousPollingID.length>0?previousPollingID:generatePollingID();console.info("Current client ID: "+appPrefix+pollingid);var startKeepAliveTimer=function(){try{keepAliveWorker=new Worker("weblib/websocketkeepaliveworker.js");keepAliveWorker.addEventListener("message",
function(e){if("ping request"==e.data)sendKeepAlivePingRequest();if("polling function"==e.data)pollingFunction()},false);keepAliveWorker.postMessage("start interval")}catch(error){keepAliveWorker=undefined;keepAliveInterval=$interval(function(){sendKeepAlivePingRequest()},6E4)}};startKeepAliveTimer();var onServiceWorkerMessage=function(e){if("ping request"==e.data)sendKeepAlivePingRequest();if("polling function"==e.data)pollingFunction()};var stopKeepAliveTimer=function(){if(keepAliveWorker!=undefined){keepAliveWorker.postMessage("stop interval");
keepAliveWorker.removeEventListener("message",onServiceWorkerMessage);keepAliveWorker.terminate();keepAliveWorker=undefined}$interval.cancel(keepAliveInterval)};var restartKeepAliveTimer=function(){if(keepAliveWorker!=undefined){keepAliveWorker.postMessage("restart interval");return}$interval.cancel(keepAliveInterval);keepAliveInterval=$interval(function(){sendKeepAlivePingRequest()},6E4)};var executePollingIn=function(time){if(keepAliveWorker!=undefined){keepAliveWorker.postMessage("start polling "+
time);return}$timeout(pollingFunction,time)};var createWebSocketURL=function(){return baseWSURL+"websocket?id\x3d"+appPrefix+pollingid+"\x26currentlocale\x3d"+$("html").attr("locale")+(timezone!=undefined?"\x26timezone\x3d"+encodeURIComponent(timezone):"")};var timezone=moment.tz.guess();var baseWSURL="ws"+$("base").attr("roothref").substring(4);var webSocketURL=createWebSocketURL();var ws=undefined;var webSocketPingTimer;var connectionTested=false;var webSocketOpen=false;var webSocketsAvailable=
false;var reconnecting=false;var restartTimeout=undefined;var restartRequestTimestamp=undefined;var startPingVerificationTimer=function(){window.clearTimeout(webSocketPingTimer);webSocketPingTimer=window.setTimeout(function(){if(!connectionTested){webSocketOpen=false;connectionEstablished();return}console.info("Did not receive an answer for the ping event from server (timeout: 5s)");startReconnect()},5E3)};var _onOpen=function(event){if(ws!=undefined&&ws.socket!=event.target){console.info("Received open event for older websocket ... ignoring.");
return}console.info("WebSocket session opened");webSocketOpen=true;startPingVerificationTimer();var data="ping\n"+encrypt(JSON.stringify({}));var utf8Bytes=toUTF8Array(data);var arrayBuffer=arrayToArrayBuffer(utf8Bytes);ws.send(arrayBuffer)};var _onClose=function(event){if(ws!=undefined&&ws.socket!=event.target){console.info("Received close event for older websocket ... ignoring.");return}if(connectionTested&&!webSocketsAvailable)return;console.info("WebSocket session closed");window.clearTimeout(webSocketPingTimer);
webSocketOpen=false;if(!connectionTested){console.info("WebSocket not available (closed before sending first frame).");connectionEstablished();return}console.info("closed with code "+event.code);startReconnect()};var _onError=function(event){if(ws!=undefined&&ws.socket!=event.target){console.info("Received error event for older websocket ... ignoring.");return}if(!connectionTested){if(webSocketOpen){console.error("Received error before connection could be tested. Ignoring error ...");return}window.clearTimeout(webSocketPingTimer);
webSocketOpen=false;console.info("WebSocket not available (error occurred while opening connection).");connectionEstablished();return}if(ws.socket.readyState==1)sendError(event,ws)};var _onMessage=function(message){if(message instanceof ArrayBuffer){let event=extractJsonBytes(message);handleMessageEvent(event)}else{let event=extractJson(message);handleMessageEvent(event)}};var _onMessageList=function(message){var eventResponses=extractJson(message);var events=eventResponses.events;if(events!=undefined)for(var i=
0,len=events.length;i<len;i++)_onMessage(events[i])};var _connectWebsocket=function(){connectionTested=false;webSocketsAvailable=false;ws=$websocket(webSocketURL,undefined,{maxTimeout:30*60*1E3,binaryType:"arraybuffer"});ws.onOpen(_onOpen);ws.onClose(_onClose);ws.onError(_onError);ws.onMessage(function(messageEvent){_onMessage(messageEvent.data)})};var connectionEstablished=function(){console.info("Connection established");connectionTested=true;if(webSocketOpen){webSocketsAvailable=true;console.info("WebSocket connection opened and tested")}else{webSocketsAvailable=
false;console.info("Starting polling fallback");if(!reconnecting){pollingid=generatePollingID();console.info("Current client ID: "+appPrefix+pollingid);webSocketURL=createWebSocketURL()}sendKeepAlivePingRequest();executePollingIn(1E3)}if(reconnecting){reconnecting=false;if(reconnectHandler!=undefined&&typeof reconnectHandler=="function")reconnectHandler();if(reconnectedHandler!=undefined&&typeof reconnectedHandler=="function")reconnectedHandler()}sendQueuedEvents()};var handleMessageEvent=function(event){var eventName=
event.event;if("pong"==eventName){window.clearTimeout(webSocketPingTimer);if(!connectionTested)connectionEstablished();return}if("error"==eventName){sendError(event,ws);return}if("authenticationrequired"==eventName){window.location.reload();return}var handlers=messageCallbacks[eventName];if(handlers!=undefined){for(var h=0;h<handlers.length;h++){var handler=handlers[h];handler(event.data)}return}else console.warn("No handler found for event '"+eventName+"'")};var sendError=function(event,ws){if(errorHandler==
undefined)errorservice.showerror(event.data,event.status||"",event.headers);else errorHandler(event,ws)};var _sendEventInternal=function(eventName,dataObject){if(webSocketsAvailable){var payload=JSON.stringify(dataObject==undefined?null:dataObject);var data=eventName+"\n"+encrypt(payload);var utf8Bytes=toUTF8Array(data);var arrayBuffer=arrayToArrayBuffer(utf8Bytes);ws.send(arrayBuffer);return}dataservice.execute("polling_sendevent",{url:$("base").attr("roothref")+"websocket/"+appPrefix+pollingid+
"/",data:JSON.stringify({event:eventName,data:dataObject}),handleSuccess:function(response){_onMessageList(response)}})};var sendQueuedEvents=function(){while(eventQueue.length>0){var evt=eventQueue.splice(0,1)[0];_sendEventInternal(evt.eventName,evt.dataObject)}};var _sendEvent=function(eventName,dataObject){if(!connectionTested||webSocketOpen&&!webSocketsAvailable){eventQueue.push({eventName:eventName,dataObject:dataObject});return}sendQueuedEvents();_sendEventInternal(eventName,dataObject)};var sendKeepAlivePingRequest=
function(){if(reconnecting){if(restartTimeout==undefined||restartRequestTimestamp!=undefined&&restartRequestTimestamp<(new Date).getTime()-1E4){console.info("Tried to keep connection alive. Recognized an active reconnect but no active reconnect request. Triggering reconnect again ...");reconnecting=false;startReconnect()}return}dataservice.execute("polling_sendevent",{url:$("base").attr("roothref")+"websocket/"+appPrefix+pollingid+"/",data:JSON.stringify({event:"ping",data:{}}),handleError:function(){console.info("Got error in 'polling_sendevent' request. Will restart connection.");
startReconnect()},handleSuccess:function(response){_onMessageList(response);if(webSocketsAvailable&&!reconnecting){startPingVerificationTimer();_sendEvent("ping",{})}if(webSocketsAvailable&&reconnecting&&(restartTimeout==undefined||restartRequestTimestamp!=undefined&&restartRequestTimestamp<(new Date).getTime()-1E4)){console.info("Got ping answer. Recognized an active reconnect but no active reconnect request. Triggering reconnect again ...");reconnecting=false;startReconnect()}},beforeExecute:function(){},
afterExecute:function(){}})};var pollingFunction=function(){if(reconnecting)return;if(nextPollingIn<=0){nextPollingIn=pollingInterval;dataservice.execute("polling_getevents",{url:$("base").attr("roothref")+"websocket/"+appPrefix+pollingid+"/",data:{},handleSuccess:function(response,status,headers,config){_onMessageList(response);var newServerStartTime=headers()["x-server-start"];if(newServerStartTime!=undefined){if(serverStartTime!=undefined&&serverStartTime!=newServerStartTime){console.info("Polling recognized a new server start. So we need to reconnect ...");
startReconnect()}serverStartTime=newServerStartTime}},beforeExecute:function(){},afterExecute:function(){executePollingIn(250)},handleError:function(data,status,headers,config){if(status<=0||status>=500){console.info("Polling request returned with gateway error or timeout. Connection seems to be lost. Trying to reconnect ...");startReconnect();return}sendError({data:data,status:status,headers:headers},undefined)}});return}else{nextPollingIn--;executePollingIn(250)}};var startReconnect=function(){if(reconnecting)return;
console.info("Starting to reconnect  ...");reconnecting=true;serverStartTime=undefined;restartRequestTimestamp=undefined;restartKeepAliveTimer();if(reconnectingHandler!=undefined&&typeof reconnectingHandler=="function")reconnectingHandler();checkForReconnectPossible(0)};var checkForReconnectPossible=function(waitTime){if(restartTimeout==undefined)restartTimeout=$timeout(function(){restartRequestTimestamp=(new Date).getTime();restartTimeout=undefined;dataservice.execute("polling_getevents?reconnect",
{url:$("base").attr("roothref")+"websocket/"+appPrefix+pollingid+"/",data:{},timeout:5E3,handleSuccess:function(response){restartRequestTimestamp=undefined;console.info("Waiting for final application startup ...");checkWhetherApplicationIsReadyToConnect(15)},handleError:function(data,status,headers,config){restartRequestTimestamp=undefined;checkForReconnectPossible(5E3)},beforeExecute:$.noop,afterExecute:$.noop})},waitTime)};var checkWhetherApplicationIsReadyToConnect=function(graceCounter){if(restartTimeout==
undefined)restartTimeout=$timeout(function(){restartRequestTimestamp=(new Date).getTime();restartTimeout=undefined;dataservice.execute("applicationready\x26modulepath\x3d"+$("html").attr("modulepath"),{url:$("base").attr("roothref")+"start/?method\x3d",data:"{}",timeout:5E3,handleSuccess:function(response){if(response!=undefined&&response.banners!=undefined)$rootScope.globalBanners=response.banners;restartRequestTimestamp=undefined;if(typeof reconnectHandler=="function"){console.info("Application startup succeeded");
_connectWebsocket()}else{var reloadPageNow=function(){reconnecting=false;$rootScope.$apply();window.location.reload(true)};var iframe=$("\x3ciframe\x3e\x3c/iframe\x3e");iframe.appendTo("body");iframe.on("load",reloadPageNow);iframe.on("error",reloadPageNow);iframe.attr("src",$rootScope.rootPath+"start/?method\x3dclearcache\x26themetimestamp\x3d"+(new Date).getTime())}},handleError:function(data,status,headers,config){if(data!=undefined&&data.banners!=undefined)$rootScope.globalBanners=data.banners;
restartRequestTimestamp=undefined;if(typeof reconnectHandler=="function")checkWhetherApplicationIsReadyToConnect(graceCounter);else if(graceCounter>0)checkWhetherApplicationIsReadyToConnect(graceCounter-1);else{reconnecting=false;window.location.reload()}},beforeExecute:$.noop,afterExecute:$.noop})},1E3)};$(document).on("visibilitychange",function(event){if(!connectionTested)return;if(document.visibilityState==="visible")sendKeepAlivePingRequest()});$(document).on("freeze",function(event){console.info("Application freezing, stopping keep alive timer");
stopKeepAliveTimer()});$(document).on("resume",function(event){console.info("Application resumed, restarting keep alive timer");startKeepAliveTimer()})});