/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.takeout;

import com.inet.authentication.AccessForbiddenException;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.takeout.TakeoutDataDescription;
import com.inet.remote.gui.takeout.TakeoutDataRequestData;
import com.inet.remote.gui.takeout.TakeoutDataResponseData;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.takeout.TakeoutData;
import com.inet.usersandgroups.api.takeout.TakeoutDataEntry;
import com.inet.usersandgroups.api.takeout.TakeoutDataProvider;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class b
extends ServiceMethod<TakeoutDataRequestData, TakeoutDataResponseData> {
    @Override
    public String getMethodName() {
        return "takeoutdata";
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    public TakeoutDataResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, TakeoutDataRequestData takeoutDataRequestData) throws IOException {
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            throw new AccessForbiddenException();
        }
        GUID gUID2 = new GUID(takeoutDataRequestData.getUserid());
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN) && !Objects.equals(gUID, gUID2)) {
            throw new ClientMessageException("User could not be found or you don't have the permisson to see user's data.");
        }
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        UserAccount userAccount = userManager.getUserAccount(gUID2);
        if (userAccount == null) {
            throw new ClientMessageException("User could not be found or you don't have the permisson to see user's data.");
        }
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        TakeoutDataResponseData takeoutDataResponseData = new TakeoutDataResponseData(userAccount.getDisplayName());
        List list = serverPluginManager.get(TakeoutDataProvider.class);
        list.sort(Comparator.comparingInt(TakeoutDataProvider::getPriority));
        for (TakeoutDataProvider takeoutDataProvider : list) {
            List list2 = takeoutDataProvider.getTakeoutData(userAccount);
            if (list2 == null || list2.isEmpty()) continue;
            list2.sort(Comparator.comparingInt(TakeoutData::getPriority));
            for (TakeoutData takeoutData : list2) {
                TakeoutDataDescription takeoutDataDescription = new TakeoutDataDescription(takeoutData.getDisplayName());
                for (TakeoutDataEntry takeoutDataEntry : takeoutData.getSummary()) {
                    takeoutDataDescription.addSummaryEntry(takeoutDataEntry.getLabel(), takeoutDataEntry.getData(), takeoutDataEntry.getType().name());
                }
                takeoutDataResponseData.addDataDescription(takeoutDataDescription);
            }
        }
        return takeoutDataResponseData;
    }

    @Override
    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (TakeoutDataRequestData)object);
    }
}

